/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.prc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.ws.mdl.EOrdStat;
import org.beigesoft.ws.mdlp.CuOr;
import org.beigesoft.ws.srv.ICncOrd;

public class CuOrSv
implements IPrcEnt<CuOr, Long> {
    private IOrm orm;
    private ICncOrd cncOrd;

    public final CuOr process(Map<String, Object> pRvs, CuOr pEnt, IReqDt pRqDt) throws Exception {
        String orAct = pRqDt.getParam("orAct");
        if (!("cnc".equals(orAct) || "pyd".equals(orAct) || "cls".equals(orAct))) {
            throw new ExcCode(100, "Wrong action CO! " + orAct);
        }
        if (pEnt.getIsNew().booleanValue()) {
            throw new ExcCode(100, "Attempt creating CO!");
        }
        HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
        CuOr oco = (CuOr)this.orm.retEnt(pRvs, vs, (IHasId)pEnt);
        vs.clear();
        oco.setDscr(pEnt.getDscr());
        boolean isNdUp = true;
        if ("cnc".equals(orAct)) {
            if (!(oco.getStas().equals((Object)EOrdStat.BOOKED) || oco.getStas().equals((Object)EOrdStat.PAYED) || oco.getStas().equals((Object)EOrdStat.CLOSED))) {
                throw new ExcCode(100, "Wrong action CO for status ! " + orAct + "/" + (Object)((Object)oco.getStas()));
            }
            this.cncOrd.cancel(pRvs, oco, EOrdStat.CANCELED);
            isNdUp = false;
        } else if ("pyd".equals(orAct)) {
            if (!oco.getStas().equals((Object)EOrdStat.BOOKED)) {
                throw new ExcCode(100, "Wrong action CO for status ! " + orAct + "/" + (Object)((Object)oco.getStas()));
            }
            oco.setStas(EOrdStat.PAYED);
        } else if ("cls".equals(orAct)) {
            if (!oco.getStas().equals((Object)EOrdStat.BOOKED) && !oco.getStas().equals((Object)EOrdStat.PAYED)) {
                throw new ExcCode(100, "Wrong action CO for status ! " + orAct + "/" + (Object)((Object)oco.getStas()));
            }
            oco.setStas(EOrdStat.CLOSED);
        }
        if (isNdUp) {
            Object[] ndFds = new String[]{"ver", "stas", "dscr"};
            Arrays.sort(ndFds);
            vs.put("ndFds", ndFds);
            this.orm.update(pRvs, vs, (IHasId)oco);
        }
        return oco;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ICncOrd getCncOrd() {
        return this.cncOrd;
    }

    public final void setCncOrd(ICncOrd pCncOrd) {
        this.cncOrd = pCncOrd;
    }
}

