/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.prc;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.Curr;
import org.beigesoft.acc.mdlp.Itm;
import org.beigesoft.acc.mdlp.Srv;
import org.beigesoft.acc.mdlp.TxDst;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdlp.UsPrf;
import org.beigesoft.prc.IPrc;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.ws.mdl.EItmSpTy;
import org.beigesoft.ws.mdl.EItmTy;
import org.beigesoft.ws.mdlb.AItmPri;
import org.beigesoft.ws.mdlb.AItmSpf;
import org.beigesoft.ws.mdlp.Buyer;
import org.beigesoft.ws.mdlp.Cart;
import org.beigesoft.ws.mdlp.CartLn;
import org.beigesoft.ws.mdlp.CurrRt;
import org.beigesoft.ws.mdlp.ItmPlc;
import org.beigesoft.ws.mdlp.ItmSpf;
import org.beigesoft.ws.mdlp.SeItm;
import org.beigesoft.ws.mdlp.SeItmPlc;
import org.beigesoft.ws.mdlp.SeItmSpf;
import org.beigesoft.ws.mdlp.SeSrv;
import org.beigesoft.ws.mdlp.SeSrvPlc;
import org.beigesoft.ws.mdlp.SeSrvSpf;
import org.beigesoft.ws.mdlp.SrvPlc;
import org.beigesoft.ws.mdlp.SrvSpf;
import org.beigesoft.ws.mdlp.TrdStg;
import org.beigesoft.ws.srv.IBuySr;
import org.beigesoft.ws.srv.ISrCart;

public class ItmPg<RS>
implements IPrc {
    private ILog log;
    private IOrm orm;
    private ISrCart srCart;
    private IBuySr buySr;
    private IRdb<RS> rdb;
    private Integer trIsl;
    private String quItSpDeIn;

    public final void process(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        try {
            Buyer buyr;
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(this.trIsl.intValue());
            this.rdb.begin();
            TrdStg ts = (TrdStg)((Object)pRvs.get("tstg"));
            String itTyStr = pRqDt.getParam("itTy");
            Long itId = Long.valueOf(pRqDt.getParam("itId"));
            Cart cart = this.srCart.getCart(pRvs, pRqDt, false, false);
            if (cart != null) {
                buyr = cart.getBuyr();
                if (cart.getTot().compareTo(BigDecimal.ZERO) == 0) {
                    pRvs.put("cart", null);
                } else {
                    AcStg as = (AcStg)((Object)pRvs.get("astg"));
                    Curr curr = (Curr)((Object)pRvs.get("wscurr"));
                    if (!cart.getCurr().getIid().equals(curr.getIid())) {
                        cart.setCurr(curr);
                        List currRts = (List)pRvs.get("currRts");
                        for (CurrRt cr : currRts) {
                            if (!cr.getCurr().getIid().equals(cart.getCurr().getIid())) continue;
                            cart.setExRt(cr.getExRt());
                            break;
                        }
                        this.srCart.hndCurrChg(pRvs, cart, as, ts);
                    }
                    if (pRvs.get("txRules") == null) {
                        TxDst txRules = this.srCart.revTxRules(pRvs, cart, as);
                        pRvs.put("txRules", (Object)txRules);
                    }
                    for (CartLn ci : cart.getItems()) {
                        if (ci.getDisab().booleanValue() || !ci.getItId().equals(itId) || !ci.getItTyp().toString().equals(itTyStr)) continue;
                        pRvs.put("cartItm", ci);
                        break;
                    }
                }
            } else {
                buyr = this.buySr.getBuyr(pRvs, pRqDt);
                if (buyr == null) {
                    buyr = this.buySr.createBuyr(pRvs, pRqDt);
                }
            }
            if (EItmTy.GOODS.toString().equals(itTyStr)) {
                this.processGoods(pRvs, pRqDt, ts, buyr, itId);
                pRvs.put("itTy", (Object)EItmTy.GOODS);
            } else if (EItmTy.SERVICE.toString().equals(itTyStr)) {
                this.processService(pRvs, pRqDt, ts, buyr, itId);
                pRvs.put("itTy", (Object)EItmTy.SERVICE);
            } else if (EItmTy.SEGOODS.toString().equals(itTyStr)) {
                this.processSeItm(pRvs, pRqDt, ts, buyr, itId);
                pRvs.put("itTy", (Object)EItmTy.SEGOODS);
            } else if (EItmTy.SESERVICE.toString().equals(itTyStr)) {
                pRvs.put("itTy", (Object)EItmTy.SESERVICE);
                this.procSeSrv(pRvs, pRqDt, ts, buyr, itId);
            } else {
                throw new Exception("Detail page not yet implemented for item type: " + itTyStr);
            }
            this.rdb.commit();
            pRqDt.setAttr("rnd", (Object)(itTyStr + pRqDt.getParam("detMt")));
        }
        catch (Exception ex) {
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
    }

    public final void processGoods(Map<String, Object> pRvs, IReqDt pRqDt, TrdStg pTs, Buyer pBuyer, Long pItId) throws Exception {
        HashMap vs = new HashMap();
        List<ItmSpf> itmSpecLs = this.retItmSpfLs(pRvs, pTs, pItId, ItmSpf.class, Itm.class.getSimpleName());
        int miIdx = -1;
        for (int i = 0; i < itmSpecLs.size(); ++i) {
            if (!itmSpecLs.get(i).getSpec().getTyp().equals((Object)EItmSpTy.IMAGE)) continue;
            pRvs.put("itmImg", (Object)itmSpecLs.get(i));
            miIdx = i;
            break;
        }
        if (miIdx != -1) {
            itmSpecLs.remove(miIdx);
        }
        AItmPri<?, ?> itmPri = this.getSrCart().revItmPri(pRvs, pTs, pBuyer, EItmTy.GOODS, pItId);
        List itmPlcLs = this.getOrm().retLstCnd(pRvs, vs, ItmPlc.class, "where ITM=" + pItId);
        pRvs.put("itmSpecLs", itmSpecLs);
        pRvs.put("itmPlcLs", itmPlcLs);
        pRvs.put("itmPri", itmPri);
    }

    public final void procSeSrv(Map<String, Object> pRvs, IReqDt pRqDt, TrdStg pTs, Buyer pBuyer, Long pItId) throws Exception {
        HashMap vs = new HashMap();
        List<SeSrvSpf> itmSpecLs = this.retItmSpfLs(pRvs, pTs, pItId, SeSrvSpf.class, SeSrv.class.getSimpleName());
        int miIdx = -1;
        for (int i = 0; i < itmSpecLs.size(); ++i) {
            if (!itmSpecLs.get(i).getSpec().getTyp().equals((Object)EItmSpTy.IMAGE)) continue;
            pRvs.put("itmImg", itmSpecLs.get(i));
            miIdx = i;
            break;
        }
        if (miIdx != -1) {
            itmSpecLs.remove(miIdx);
        }
        AItmPri<?, ?> itmPri = this.getSrCart().revItmPri(pRvs, pTs, pBuyer, EItmTy.SESERVICE, pItId);
        List itmPlcLs = this.getOrm().retLstCnd(pRvs, vs, SeSrvPlc.class, "where ITM=" + pItId);
        pRvs.put("itmSpecLs", itmSpecLs);
        pRvs.put("itmPlcLs", itmPlcLs);
        pRvs.put("itmPri", itmPri);
    }

    public final void processSeItm(Map<String, Object> pRvs, IReqDt pRqDt, TrdStg pTs, Buyer pBuyer, Long pItId) throws Exception {
        HashMap vs = new HashMap();
        List<SeItmSpf> itmSpecLs = this.retItmSpfLs(pRvs, pTs, pItId, SeItmSpf.class, SeItm.class.getSimpleName());
        int miIdx = -1;
        for (int i = 0; i < itmSpecLs.size(); ++i) {
            if (!itmSpecLs.get(i).getSpec().getTyp().equals((Object)EItmSpTy.IMAGE)) continue;
            pRvs.put("itmImg", itmSpecLs.get(i));
            miIdx = i;
            break;
        }
        if (miIdx != -1) {
            itmSpecLs.remove(miIdx);
        }
        AItmPri<?, ?> itmPri = this.getSrCart().revItmPri(pRvs, pTs, pBuyer, EItmTy.SEGOODS, pItId);
        List itmPlcLs = this.getOrm().retLstCnd(pRvs, vs, SeItmPlc.class, "where ITM=" + pItId);
        pRvs.put("itmSpecLs", itmSpecLs);
        pRvs.put("itmPlcLs", itmPlcLs);
        pRvs.put("itmPri", itmPri);
    }

    public final void processService(Map<String, Object> pRvs, IReqDt pRqDt, TrdStg pTs, Buyer pBuyer, Long pItId) throws Exception {
        HashMap vs = new HashMap();
        List<SrvSpf> itmSpecLs = this.retItmSpfLs(pRvs, pTs, pItId, SrvSpf.class, Srv.class.getSimpleName());
        int miIdx = -1;
        for (int i = 0; i < itmSpecLs.size(); ++i) {
            if (!itmSpecLs.get(i).getSpec().getTyp().equals((Object)EItmSpTy.IMAGE)) continue;
            pRvs.put("itmImg", (Object)itmSpecLs.get(i));
            miIdx = i;
            break;
        }
        if (miIdx != -1) {
            itmSpecLs.remove(miIdx);
        }
        AItmPri<?, ?> itmPri = this.getSrCart().revItmPri(pRvs, pTs, pBuyer, EItmTy.SERVICE, pItId);
        List itmPlcLs = this.getOrm().retLstCnd(pRvs, vs, SrvPlc.class, "where ITM=" + pItId);
        pRvs.put("itmSpecLs", itmSpecLs);
        pRvs.put("itmPlcLs", itmPlcLs);
        pRvs.put("itmPri", itmPri);
    }

    public final <T extends AItmSpf<?, ?>> List<T> retItmSpfLs(Map<String, Object> pRvs, TrdStg pTs, Long pItId, Class<T> pItmSpfCl, String pItemSn) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        vs.put("ItmSpdpLv", 3);
        vs.put(pItemSn + "ndFds", new String[]{"nme"});
        Object[] soiFldNms = new String[]{"nme", "inLst", "typ", "grp", "htmt"};
        Arrays.sort(soiFldNms);
        vs.put("ItmSpndFds", soiFldNms);
        Object[] soigFldNms = new String[]{"nme", "tmpls", "tmple", "tmpld"};
        Arrays.sort(soigFldNms);
        vs.put("ItmSpGrndFds", soigFldNms);
        vs.put("HtmltndFds", new String[]{"val"});
        List result = null;
        if (pTs.getAi18n().booleanValue()) {
            String langDef;
            UsPrf upf = (UsPrf)pRvs.get("upf");
            CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
            String lang = upf.getLng().getIid();
            if (!lang.equals(langDef = cpf.getLngDef().getIid())) {
                String qd;
                if (pItmSpfCl == ItmSpf.class) {
                    qd = this.lazyGetQuItSpDeIn().replace(":TITSPEC", "ITMSPF").replace(":TITM", "ITM").replace(":T18NIT", "I18ITM").replace(":ITMID", pItId.toString()).replace(":LNG", lang);
                } else if (pItmSpfCl == SrvSpf.class) {
                    qd = this.lazyGetQuItSpDeIn().replace(":TITSPEC", "SRVSPF").replace(":TITM", "SRV").replace(":T18NIT", "I18SRV").replace(":ITMID", pItId.toString()).replace(":LNG", lang);
                } else if (pItmSpfCl == SeItmSpf.class) {
                    qd = this.lazyGetQuItSpDeIn().replace(":TITSPEC", "SEITMSPF").replace(":TITM", "SEITM").replace(":T18NIT", "I18SEITM").replace(":ITMID", pItId.toString()).replace(":LNG", lang);
                } else if (pItmSpfCl == SeSrvSpf.class) {
                    qd = this.lazyGetQuItSpDeIn().replace(":TITSPEC", "SESRVSPF").replace(":TITM", "SESRV").replace(":T18NIT", "I18SESRV").replace(":ITMID", pItId.toString()).replace(":LNG", lang);
                } else {
                    throw new Exception("NYI for " + pItmSpfCl);
                }
                result = this.getOrm().retLstQu(pRvs, vs, pItmSpfCl, qd);
            }
        }
        if (result == null) {
            result = this.getOrm().retLstCnd(pRvs, vs, pItmSpfCl, "where " + pItmSpfCl.getSimpleName().toUpperCase() + ".ITM=" + pItId + " order by SPEC11.IDX");
        }
        return result;
    }

    public final String lazyGetQuItSpDeIn() throws Exception {
        if (this.quItSpDeIn == null) {
            this.quItSpDeIn = this.loadStr("/ws/itSpDeIn.sql");
        }
        return this.quItSpDeIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadStr(String pFiNm) throws IOException {
        URL urlFile = ItmPg.class.getResource(pFiNm);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = ItmPg.class.getResourceAsStream(pFiNm);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrCart getSrCart() {
        return this.srCart;
    }

    public final void setSrCart(ISrCart pSrCart) {
        this.srCart = pSrCart;
    }

    public final IBuySr getBuySr() {
        return this.buySr;
    }

    public final void setBuySr(IBuySr pBuySr) {
        this.buySr = pBuySr;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final Integer getTrIsl() {
        return this.trIsl;
    }

    public final void setTrIsl(Integer pTrIsl) {
        this.trIsl = pTrIsl;
    }
}

