/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.prc;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.TxDst;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.ColVals;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrc;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.ws.fct.FcPrWs;
import org.beigesoft.ws.mdlp.Buyer;
import org.beigesoft.ws.mdlp.Cart;
import org.beigesoft.ws.mdlp.CartLn;
import org.beigesoft.ws.mdlp.CartTot;
import org.beigesoft.ws.mdlp.CartTxLn;
import org.beigesoft.ws.mdlp.TrdStg;
import org.beigesoft.ws.srv.IBuySr;
import org.beigesoft.ws.srv.ISrCart;

public class PrLog<RS>
implements IPrc {
    private ILog log;
    private IOrm orm;
    private IRdb<RS> rdb;
    private FcPrWs<RS> fcPrWs;
    private ISrCart srvCart;
    private IBuySr buySr;
    private Integer trIsl;

    public final void process(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(this.trIsl.intValue());
            this.rdb.begin();
            Buyer buyer = this.buySr.getBuyr(pRvs, pRqDt);
            if (buyer == null) {
                buyer = this.buySr.createBuyr(pRvs, pRqDt);
            }
            String nme = pRqDt.getParam("nme");
            String eml = pRqDt.getParam("eml");
            String pwd = pRqDt.getParam("pwd");
            String pwdc = pRqDt.getParam("pwdc");
            long now = new Date().getTime();
            pRvs.put("buyr", (Object)buyer);
            HashMap<String, Integer> vs = new HashMap<String, Integer>();
            if (buyer.getEml() == null) {
                if (nme != null && pwd != null && pwdc != null && eml != null) {
                    if (nme.length() > 2 && pwd.length() > 7 && pwd.equals(pwdc) && eml.length() > 5) {
                        vs.put("BuyerdpLv", 0);
                        List brs = this.getOrm().retLstCnd(pRvs, vs, Buyer.class, "where BUYER.EML='" + eml + "'");
                        vs.clear();
                        if (brs.size() == 0) {
                            buyer.setNme(nme);
                            buyer.setPwd(pwd);
                            buyer.setEml(eml);
                            buyer.setLsTm(now);
                            UUID buseid = UUID.randomUUID();
                            String buSeIdSt = buseid.toString().replace("-", "");
                            buyer.setBuSeId(buSeIdSt);
                            if (buyer.getIsNew().booleanValue()) {
                                this.orm.insIdLn(pRvs, vs, (IHasId)buyer);
                            } else {
                                this.orm.update(pRvs, vs, (IHasId)buyer);
                            }
                            pRqDt.setCookVl("cBuyerId", buyer.getIid().toString());
                            pRqDt.setCookVl("buSeId", buSeIdSt);
                            this.getLog().info(pRvs, PrLog.class, "Buyer registered: " + nme + "/" + eml);
                        } else if (brs.size() == 1) {
                            pRvs.put("errMsg", "emBusy");
                        } else {
                            this.getLog().error(pRvs, PrLog.class, "Several users with same email!: " + eml);
                        }
                    } else {
                        pRvs.put("errMsg", "buyCrRul");
                    }
                } else if (pwd != null && eml != null) {
                    vs.put("BuyerdpLv", 1);
                    List brs = this.getOrm().retLstCnd(pRvs, vs, Buyer.class, "where PWD='" + pwd + "' and EML='" + eml + "'");
                    vs.clear();
                    if (brs.size() == 1) {
                        this.mkFreBuyr(pRvs, pRqDt, buyer, (Buyer)((Object)brs.get(0)));
                    } else if (brs.size() == 0) {
                        pRvs.put("errMsg", "wrong_em_password");
                    } else {
                        this.getLog().error(pRvs, PrLog.class, "Several users with same password and email!: " + eml);
                    }
                } else {
                    this.spam(pRvs, pRqDt);
                }
            } else if (now - buyer.getLsTm() < 1800000L && buyer.getBuSeId() != null) {
                String buSeId = pRqDt.getCookVl("buSeId");
                if (buyer.getBuSeId().equals(buSeId)) {
                    String zip = pRqDt.getParam("zip");
                    String addr1 = pRqDt.getParam("addr1");
                    if (nme != null && zip != null && addr1 != null) {
                        String cntr = pRqDt.getParam("cntr");
                        String city = pRqDt.getParam("city");
                        String addr2 = pRqDt.getParam("addr2");
                        String phon = pRqDt.getParam("phon");
                        if (nme.length() > 2 && zip.length() > 2 && addr1.length() > 2) {
                            buyer.setNme(nme);
                            buyer.setZip(zip);
                            buyer.setAddr1(addr1);
                            buyer.setAddr2(addr2);
                            buyer.setCntr(cntr);
                            buyer.setCity(city);
                            buyer.setPhon(phon);
                            buyer.setLsTm(now);
                            this.orm.update(pRvs, vs, (IHasId)buyer);
                            this.getLog().info(pRvs, PrLog.class, "Buyer's info changed : " + nme + "/" + eml + "/" + zip + "/" + city + "/" + cntr + "/" + phon + "/" + addr1 + "/" + addr2);
                        } else {
                            pRvs.put("errMsg", "buyEmRul");
                        }
                    } else if (pwd != null && pwdc != null) {
                        if (pwd.length() > 7 && pwd.equals(pwdc)) {
                            buyer.setPwd(pwd);
                            buyer.setLsTm(now);
                            this.orm.update(pRvs, vs, (IHasId)buyer);
                            this.getLog().info(pRvs, PrLog.class, "Buyer's password changed : " + nme + "/" + eml);
                        } else {
                            pRvs.put("errMsg", "buyPwdRul");
                        }
                    } else {
                        buyer.setLsTm(0L);
                        this.orm.update(pRvs, vs, (IHasId)buyer);
                    }
                } else {
                    this.spam(pRvs, pRqDt);
                }
            } else if (pwd != null) {
                if (pwd.equals(buyer.getPwd())) {
                    buyer.setLsTm(now);
                    UUID buseid = UUID.randomUUID();
                    String buSeIdSt = buseid.toString().replace("-", "");
                    buyer.setBuSeId(buSeIdSt);
                    pRqDt.setCookVl("buSeId", buSeIdSt);
                    this.orm.update(pRvs, vs, (IHasId)buyer);
                } else {
                    pRvs.put("errMsg", "wrong_password");
                }
            } else {
                this.spam(pRvs, pRqDt);
            }
            this.rdb.commit();
        }
        catch (Exception ex) {
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
        String procNm = pRqDt.getParam("prcRed");
        if (this.getClass().getSimpleName().equals(procNm)) {
            throw new ExcCode(100, "Danger! stupid scam!!!");
        }
        IPrc proc = this.fcPrWs.laz(pRvs, procNm);
        proc.process(pRvs, pRqDt);
    }

    public final void spam(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
    }

    public final void mkFreBuyr(Map<String, Object> pRvs, IReqDt pRqDt, Buyer pBuTmp, Buyer pBuyr) throws Exception {
        HashMap vs = new HashMap();
        long now = new Date().getTime();
        if (!pBuTmp.getIsNew().booleanValue()) {
            pBuTmp.setFre(true);
            pBuTmp.setEml(null);
            pBuTmp.setPwd(null);
            pBuTmp.setLsTm(0L);
            this.orm.update(pRvs, vs, (IHasId)pBuTmp);
        }
        pBuyr.setLsTm(now);
        UUID buseid = UUID.randomUUID();
        String buSeIdSt = buseid.toString().replace("-", "");
        pBuyr.setBuSeId(buSeIdSt);
        this.orm.update(pRvs, vs, (IHasId)pBuyr);
        pRqDt.setCookVl("buSeId", buSeIdSt);
        pRqDt.setCookVl("cBuyerId", pBuyr.getIid().toString());
        pRvs.put("buyr", (Object)pBuyr);
        if (!pBuTmp.getIsNew().booleanValue()) {
            Cart oldCrt = new Cart();
            oldCrt.setIid(pBuTmp);
            oldCrt = (Cart)this.orm.retEnt(pRvs, vs, (IHasId)oldCrt);
            if (oldCrt != null && oldCrt.getTot().compareTo(BigDecimal.ZERO) == 1) {
                Cart newCrt = new Cart();
                newCrt.setIid(pBuyr);
                this.orm.refrEnt(pRvs, vs, (IHasId)newCrt);
                if (newCrt.getIid() == null) {
                    newCrt = oldCrt;
                    newCrt.setIid(pBuyr);
                    this.orm.insIdNln(pRvs, vs, (IHasId)newCrt);
                }
                ColVals cvs = new ColVals();
                cvs.setLongs(new HashMap());
                cvs.getLongs().put("ownr", pBuyr.getIid());
                this.rdb.update(CartLn.class, cvs, "OWNR=" + pBuTmp.getIid());
                this.rdb.update(CartTxLn.class, cvs, "OWNR=" + pBuTmp.getIid());
                this.rdb.update(CartTot.class, cvs, "OWNR=" + pBuTmp.getIid());
                Cart cart = this.srvCart.getCart(pRvs, pRqDt, true, false);
                TrdStg ts = (TrdStg)((Object)pRvs.get("tstg"));
                AcStg as = (AcStg)((Object)pRvs.get("astg"));
                TxDst txRules = this.srvCart.revTxRules(pRvs, cart, as);
                if (txRules != null) {
                    pRvs.put("txRules", (Object)txRules);
                }
                cart.setDelv(oldCrt.getDelv());
                cart.setPaym(oldCrt.getPaym());
                CartLn frCl = null;
                for (CartLn cl : cart.getItems()) {
                    if (cl.getDisab().booleanValue()) continue;
                    if (cl.getForc().booleanValue()) {
                        frCl = cl;
                        this.srvCart.delLine(pRvs, cl, txRules);
                        continue;
                    }
                    this.srvCart.mkLine(pRvs, cl, as, ts, txRules, true, true);
                    this.srvCart.mkCartTots(pRvs, ts, cl, as, txRules);
                }
                if (frCl != null) {
                    this.srvCart.hndCartChg(pRvs, cart, txRules);
                }
            }
        }
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final Integer getTrIsl() {
        return this.trIsl;
    }

    public final void setTrIsl(Integer pTrIsl) {
        this.trIsl = pTrIsl;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final FcPrWs<RS> getFcPrWs() {
        return this.fcPrWs;
    }

    public final void setFcPrWs(FcPrWs<RS> pFcPrWs) {
        this.fcPrWs = pFcPrWs;
    }

    public final ISrCart getSrvCart() {
        return this.srvCart;
    }

    public final void setSrvCart(ISrCart pSrvCart) {
        this.srvCart = pSrvCart;
    }

    public final IBuySr getBuySr() {
        return this.buySr;
    }

    public final void setBuySr(IBuySr pBuySr) {
        this.buySr = pBuySr;
    }
}

