/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.prc;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrc;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.ws.fct.FcPrWs;
import org.beigesoft.ws.mdl.EPaymMth;
import org.beigesoft.ws.mdl.Purch;
import org.beigesoft.ws.mdlp.AddStg;
import org.beigesoft.ws.mdlp.Buyer;
import org.beigesoft.ws.mdlp.CuOr;
import org.beigesoft.ws.mdlp.CuOrSe;
import org.beigesoft.ws.mdlp.CuOrSeTxLn;
import org.beigesoft.ws.mdlp.CuOrTxLn;
import org.beigesoft.ws.srv.IAcpOrd;
import org.beigesoft.ws.srv.IBuySr;
import org.beigesoft.ws.srv.ISrCart;

public class PrPur<RS>
implements IPrc {
    private ILog log;
    private ILog secLog;
    private IRdb<RS> rdb;
    private IOrm orm;
    private ISrCart srCart;
    private IAcpOrd acpOrd;
    private IBuySr buySr;
    private FcPrWs<RS> fcPrWs;

    public final void process(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        if (!pRqDt.getReqUrl().toString().toLowerCase().startsWith("https")) {
            throw new Exception("HTTP not supported!!!");
        }
        Buyer buyer = this.buySr.getAuthBuyr(pRvs, pRqDt);
        if (buyer == null) {
            this.log.warn(pRvs, this.getClass(), "Trying to accept purchase without buyer!");
            this.redir(pRvs, pRqDt);
            return;
        }
        HashMap<String, Integer> vs = new HashMap<String, Integer>();
        AddStg setAdd = (AddStg)((Object)pRvs.get("tastg"));
        try {
            List tls;
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(setAdd.getBkTr().intValue());
            this.rdb.begin();
            Purch pur = this.acpOrd.accept(pRvs, pRqDt, buyer);
            this.srCart.emptyCart(pRvs, buyer);
            if (pur.getOrds() != null && pur.getOrds().size() > 0) {
                vs.put("CuOrdpLv", 0);
                for (CuOr cuOr : pur.getOrds()) {
                    if (cuOr.getPaym().equals((Object)EPaymMth.PAYPAL) || cuOr.getPaym().equals((Object)EPaymMth.PAYPAL_ANY) || cuOr.getPaym().equals((Object)EPaymMth.PARTIAL_ONLINE) || cuOr.getPaym().equals((Object)EPaymMth.ONLINE)) {
                        throw new Exception("It must be offline payment!!");
                    }
                    if (cuOr.getToTx().compareTo(BigDecimal.ZERO) != 1) continue;
                    tls = this.getOrm().retLstCnd(pRvs, vs, CuOrTxLn.class, "where OWNR=" + cuOr.getIid());
                    cuOr.setTaxes(tls);
                }
                vs.clear();
            }
            if (pur.getSords() != null && pur.getSords().size() > 0) {
                vs.put("CuOrSedpLv", 0);
                for (CuOrSe cuOrSe : pur.getSords()) {
                    if (cuOrSe.getPaym().equals((Object)EPaymMth.PAYPAL) || cuOrSe.getPaym().equals((Object)EPaymMth.PAYPAL_ANY) || cuOrSe.getPaym().equals((Object)EPaymMth.PARTIAL_ONLINE) || cuOrSe.getPaym().equals((Object)EPaymMth.ONLINE)) {
                        throw new Exception("It must be offline payment!!");
                    }
                    if (cuOrSe.getToTx().compareTo(BigDecimal.ZERO) == 1) {
                        tls = this.getOrm().retLstCnd(pRvs, vs, CuOrSeTxLn.class, "where OWNR=" + cuOrSe.getIid());
                        cuOrSe.setTaxes(tls);
                    }
                    vs.clear();
                }
            }
            pRvs.put("pur", pur);
            pRqDt.setAttr("rnd", (Object)"waor");
            this.rdb.commit();
        }
        catch (Exception ex) {
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
    }

    public final void redir(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        String procNm = pRqDt.getParam("prcRed");
        if (this.getClass().getSimpleName().equals(procNm)) {
            throw new ExcCode(100, "Danger! Stupid scam!!!");
        }
        IPrc proc = this.fcPrWs.laz(pRvs, procNm);
        proc.process(pRvs, pRqDt);
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final ILog getSecLog() {
        return this.secLog;
    }

    public final void setSecLog(ILog pSecLog) {
        this.secLog = pSecLog;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrCart getSrCart() {
        return this.srCart;
    }

    public final void setSrCart(ISrCart pSrCart) {
        this.srCart = pSrCart;
    }

    public final IAcpOrd getAcpOrd() {
        return this.acpOrd;
    }

    public final void setAcpOrd(IAcpOrd pAcpOrd) {
        this.acpOrd = pAcpOrd;
    }

    public final IBuySr getBuySr() {
        return this.buySr;
    }

    public final void setBuySr(IBuySr pBuySr) {
        this.buySr = pBuySr;
    }

    public final FcPrWs<RS> getFcPrWs() {
        return this.fcPrWs;
    }

    public final void setFcPrWs(FcPrWs<RS> pFcPrWs) {
        this.fcPrWs = pFcPrWs;
    }
}

