/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.prc;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.Curr;
import org.beigesoft.acc.mdlp.TxDst;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.flt.AFlt;
import org.beigesoft.flt.EFltOpr;
import org.beigesoft.flt.FltBgd;
import org.beigesoft.flt.FltInt;
import org.beigesoft.flt.FltItms;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdlp.UsPrf;
import org.beigesoft.prc.IPrc;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.ISrvPg;
import org.beigesoft.ws.mdl.CmpTrCatl;
import org.beigesoft.ws.mdl.EItmSpTy;
import org.beigesoft.ws.mdl.EItmTy;
import org.beigesoft.ws.mdl.FltSpf;
import org.beigesoft.ws.mdl.FltsSpfWhe;
import org.beigesoft.ws.mdl.TrCatl;
import org.beigesoft.ws.mdlp.BurPric;
import org.beigesoft.ws.mdlp.Cart;
import org.beigesoft.ws.mdlp.CartLn;
import org.beigesoft.ws.mdlp.CatGs;
import org.beigesoft.ws.mdlp.CatSp;
import org.beigesoft.ws.mdlp.ChoSp;
import org.beigesoft.ws.mdlp.ChoSpTy;
import org.beigesoft.ws.mdlp.Itlist;
import org.beigesoft.ws.mdlp.PriItm;
import org.beigesoft.ws.mdlp.SubCat;
import org.beigesoft.ws.mdlp.TrdStg;
import org.beigesoft.ws.srv.ILsCatlChg;
import org.beigesoft.ws.srv.ISrCart;

public class WsPg<RS>
implements IPrc,
ILsCatlChg {
    private IRdb<RS> rdb;
    private IOrm orm;
    private ISrvPg srvPg;
    private ISrCart srCart;
    private ILog log;
    private CmpTrCatl cmpCatls = new CmpTrCatl();
    private Integer trIsl;
    private List<TrCatl> catls;
    private String quItSpFlt;
    private String quItInLstCa;
    private String quItInLstCaTo;
    private String quItInLstCaIn;

    @Override
    public final synchronized void hndCatlChg() throws Exception {
        this.catls = null;
    }

    public final void process(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        try {
            Cart cart;
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(this.trIsl.intValue());
            this.rdb.begin();
            HashMap<String, Object> vs = new HashMap<String, Object>();
            pRvs.put("catls", this.lazCatls(pRvs));
            TrdStg ts = (TrdStg)((Object)pRvs.get("tstg"));
            String catlIdStr = pRqDt.getParam("catlId");
            Long catId = null;
            if (catlIdStr != null) {
                catId = Long.valueOf(catlIdStr);
            }
            if (catId == null && ts.getCatl() != null) {
                catId = ts.getCatl().getIid();
            }
            if ((cart = (Cart)((Object)pRvs.get("cart"))) == null) {
                cart = this.srCart.getCart(pRvs, pRqDt, false, false);
            }
            AcStg as = (AcStg)((Object)pRvs.get("astg"));
            Curr curr = (Curr)((Object)pRvs.get("wscurr"));
            List currRts = (List)pRvs.get("currRts");
            BigDecimal cuRt = BigDecimal.ONE;
            for (Object cr : currRts) {
                if (!cr.getCurr().getIid().equals(curr.getIid())) continue;
                cuRt = cr.getExRt();
                break;
            }
            if (cart != null) {
                if (cart.getTot().compareTo(BigDecimal.ZERO) == 0) {
                    pRvs.put("cart", null);
                } else {
                    if (!cart.getCurr().getIid().equals(curr.getIid())) {
                        cart.setCurr(curr);
                        cart.setExRt(cuRt);
                        this.srCart.hndCurrChg(pRvs, cart, as, ts);
                    }
                    if (pRvs.get("txRules") == null) {
                        TxDst txRules = this.srCart.revTxRules(pRvs, cart, as);
                        pRvs.put("txRules", (Object)txRules);
                    }
                    HashMap<EItmTy, HashMap<Long, CartLn>> cartMap = new HashMap<EItmTy, HashMap<Long, CartLn>>();
                    for (CartLn ci : cart.getItems()) {
                        if (ci.getDisab().booleanValue()) continue;
                        HashMap<Long, CartLn> typedMap = (HashMap<Long, CartLn>)cartMap.get((Object)ci.getItTyp());
                        if (typedMap == null) {
                            typedMap = new HashMap<Long, CartLn>();
                            cartMap.put(ci.getItTyp(), typedMap);
                        }
                        typedMap.put(ci.getItId(), ci);
                    }
                    pRvs.put("cartMap", cartMap);
                }
            }
            if (catId != null) {
                TrCatl tcat = this.findTrCatlById(this.catls, catId);
                if (tcat == null) {
                    this.log.warn(pRvs, WsPg.class, "Can't find catl #" + catId);
                } else {
                    String ordb = pRqDt.getParam("ordb");
                    pRvs.put("ordb", ordb);
                    String orderBy = null;
                    if (ordb != null) {
                        if (ordb.equals("pa")) {
                            orderBy = " order by PRI asc";
                        } else if (ordb.equals("pd")) {
                            orderBy = " order by PRI desc";
                        }
                    }
                    FltInt fltPri = this.revFltPri(tcat, pRvs, pRqDt);
                    FltItms<CatGs> fltCatl = this.revFltCatl(tcat, pRvs, pRqDt);
                    List<FltSpf> fltSpfs = this.revFltsSpec(tcat, pRvs, pRqDt);
                    String whereAdd = this.revWhePri(fltPri, cuRt);
                    String whereCatl = this.revealWhereCatl(tcat, fltCatl);
                    String queryg = null;
                    String querys = null;
                    String queryseg = null;
                    String queryses = null;
                    if (ts.getAi18n().booleanValue()) {
                        String langDef;
                        UsPrf upf = (UsPrf)pRvs.get("upf");
                        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
                        String lang = upf.getLng().getIid();
                        if (!lang.equals(langDef = cpf.getLngDef().getIid())) {
                            if (tcat.getCatl().getHsGds().booleanValue()) {
                                queryg = this.lazyGetQuItInLstCaIn().replace(":ITTYP", "0").replace(":TITCAT", "ITMCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd).replace(":LNG", lang);
                            }
                            if (tcat.getCatl().getHsSrv().booleanValue()) {
                                querys = this.lazyGetQuItInLstCaIn().replace(":ITTYP", "1").replace(":TITCAT", "SRVCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd).replace(":LNG", lang);
                            }
                            if (tcat.getCatl().getHsSgo().booleanValue()) {
                                queryseg = this.lazyGetQuItInLstCaIn().replace(":ITTYP", "2").replace(":TITCAT", "SEITMCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd).replace(":LNG", lang);
                            }
                            if (tcat.getCatl().getHsSse().booleanValue()) {
                                queryses = this.lazyGetQuItInLstCaIn().replace(":ITTYP", "3").replace(":TITCAT", "SESRVCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd).replace(":LNG", lang);
                            }
                        }
                    }
                    if (tcat.getCatl().getHsGds().booleanValue() && queryg == null) {
                        queryg = this.lazyGetQuItInLstCa().replace(":ITTYP", "0").replace(":TITCAT", "ITMCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd);
                    }
                    if (tcat.getCatl().getHsSrv().booleanValue() && querys == null) {
                        querys = this.lazyGetQuItInLstCa().replace(":ITTYP", "1").replace(":TITCAT", "SRVCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd);
                    }
                    if (tcat.getCatl().getHsSgo().booleanValue() && queryseg == null) {
                        queryseg = this.lazyGetQuItInLstCa().replace(":ITTYP", "2").replace(":TITCAT", "SEITMCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd);
                    }
                    if (tcat.getCatl().getHsSse().booleanValue() && queryses == null) {
                        queryses = this.lazyGetQuItInLstCa().replace(":ITTYP", "3").replace(":TITCAT", "SESRVCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd);
                    }
                    String querygRc = null;
                    if (tcat.getCatl().getHsGds().booleanValue()) {
                        querygRc = this.lazyGetQuItInLstCaTo().replace(":ITTYP", "0").replace(":TITCAT", "ITMCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd);
                    }
                    String querysRc = null;
                    if (tcat.getCatl().getHsSrv().booleanValue()) {
                        querysRc = this.lazyGetQuItInLstCaTo().replace(":ITTYP", "1").replace(":TITCAT", "SRVCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd);
                    }
                    String querysegRc = null;
                    if (tcat.getCatl().getHsSgo().booleanValue()) {
                        querysegRc = this.lazyGetQuItInLstCaTo().replace(":ITTYP", "2").replace(":TITCAT", "SEITMCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd);
                    }
                    String querysesRc = null;
                    if (tcat.getCatl().getHsSse().booleanValue()) {
                        querysesRc = this.lazyGetQuItInLstCaTo().replace(":ITTYP", "3").replace(":TITCAT", "SESRVCTL").replace(":FLTCAT", whereCatl).replace(":WHEREADD", whereAdd);
                    }
                    boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 13100);
                    if (fltSpfs != null) {
                        FltsSpfWhe whereSpec;
                        if (dbgSh) {
                            this.getLog().debug(pRvs, WsPg.class, "filters apecifics: size: " + fltSpfs.size());
                        }
                        if ((whereSpec = this.revWheSpec(fltSpfs)) != null) {
                            String querySpec;
                            if (queryg != null) {
                                querySpec = this.lazyGetQuItSpFlt().replace(":TITSPEC", "ITMSPF").replace(":WHESPITFLR", whereSpec.getWhere()).replace(":SPITFLTCO", whereSpec.getWhereCount().toString());
                                queryg = queryg + querySpec;
                                querygRc = querygRc + querySpec;
                            }
                            if (querys != null) {
                                querySpec = this.lazyGetQuItSpFlt().replace(":TITSPEC", "SRVSPF").replace(":WHESPITFLR", whereSpec.getWhere()).replace(":SPITFLTCO", whereSpec.getWhereCount().toString());
                                querys = querys + querySpec;
                                querysRc = querysRc + querySpec;
                            }
                            if (queryseg != null) {
                                querySpec = this.lazyGetQuItSpFlt().replace(":TITSPEC", "SEITMSPF").replace(":WHESPITFLR", whereSpec.getWhere()).replace(":SPITFLTCO", whereSpec.getWhereCount().toString());
                                queryseg = queryseg + querySpec;
                                querysegRc = querysegRc + querySpec;
                            }
                            if (queryses != null) {
                                querySpec = this.lazyGetQuItSpFlt().replace(":TITSPEC", "SESRVSPF").replace(":WHESPITFLR", whereSpec.getWhere()).replace(":SPITFLTCO", whereSpec.getWhereCount().toString());
                                queryses = queryses + querySpec;
                                querysesRc = querysesRc + querySpec;
                            }
                        }
                    }
                    if (queryg != null || querys != null || queryseg != null || queryses != null) {
                        String query = null;
                        String queryRc = null;
                        if (queryg != null) {
                            query = queryg;
                            queryRc = querygRc;
                        }
                        if (querys != null) {
                            if (query == null) {
                                query = querys;
                                queryRc = querysRc;
                            } else {
                                query = query + "\n union all \n" + querys;
                                queryRc = queryRc + "\n union all \n" + querysRc;
                            }
                        }
                        if (queryseg != null) {
                            if (query == null) {
                                query = queryseg;
                                queryRc = querysegRc;
                            } else {
                                query = query + "\n union all \n" + queryseg;
                                queryRc = queryRc + "\n union all \n" + querysegRc;
                            }
                        }
                        if (queryses != null) {
                            if (query == null) {
                                query = queryses;
                                queryRc = querysesRc;
                            } else {
                                query = query + "\n union all \n" + queryses;
                                queryRc = queryRc + "\n union all \n" + querysesRc;
                            }
                        }
                        queryRc = "select count(*) as TROWS from (" + queryRc + ") as ALLTOT";
                        if (orderBy != null) {
                            query = query + orderBy;
                        }
                        queryRc = queryRc + ";";
                        Integer rowCount = this.rdb.evInt(queryRc, "TROWS");
                        Object[] ndFds = new String[]{"typ", "itId", "nme", "img", "specs", "pri", "priPr", "quan", "detMt"};
                        Arrays.sort(ndFds);
                        vs.put("ItlistndFds", ndFds);
                        String pageStr = pRqDt.getParam("page");
                        Integer page = pageStr != null ? Integer.valueOf(pageStr) : Integer.valueOf(1);
                        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
                        int totalPages = this.srvPg.evPgCnt(rowCount.intValue(), cpf.getPgSz().intValue());
                        if (page > totalPages) {
                            page = totalPages;
                        }
                        int firstResult = (page - 1) * cpf.getPgSz();
                        List itList = this.getOrm().retPgQu(pRvs, vs, Itlist.class, query, Integer.valueOf(firstResult), cpf.getPgSz());
                        vs.clear();
                        if (ts.getPriCus().booleanValue() && cart != null && cart.getBuyr().getEml() != null) {
                            List burPrics = this.getOrm().retLstCnd(pRvs, vs, BurPric.class, "where BUYR=" + cart.getBuyr().getIid());
                            if (burPrics.size() > 1) {
                                this.log.error(pRvs, WsPg.class, "Several price category for same buyer! buyer ID=" + cart.getBuyr().getIid());
                                throw new ExcCode(1002, "several_price_category_for_same_buyer");
                            }
                            if (burPrics.size() == 1) {
                                StringBuffer sbg = null;
                                StringBuffer sbs = null;
                                StringBuffer sbsg = null;
                                StringBuffer sbss = null;
                                for (Itlist iil : itList) {
                                    if (iil.getTyp().equals((Object)EItmTy.GOODS)) {
                                        if (sbg == null) {
                                            sbg = new StringBuffer();
                                            sbg.append("(" + iil.getItId());
                                            continue;
                                        }
                                        sbg.append("," + iil.getItId());
                                        continue;
                                    }
                                    if (iil.getTyp().equals((Object)EItmTy.SERVICE)) {
                                        if (sbs == null) {
                                            sbs = new StringBuffer();
                                            sbs.append("(" + iil.getItId());
                                            continue;
                                        }
                                        sbs.append("," + iil.getItId());
                                        continue;
                                    }
                                    if (iil.getTyp().equals((Object)EItmTy.SEGOODS)) {
                                        if (sbsg == null) {
                                            sbsg = new StringBuffer();
                                            sbsg.append("(" + iil.getItId());
                                            continue;
                                        }
                                        sbsg.append("," + iil.getItId());
                                        continue;
                                    }
                                    if (!iil.getTyp().equals((Object)EItmTy.SESERVICE)) continue;
                                    if (sbss == null) {
                                        sbss = new StringBuffer();
                                        sbss.append("(" + iil.getItId());
                                        continue;
                                    }
                                    sbss.append("," + iil.getItId());
                                }
                                StringBuffer sbq = null;
                                if (sbg != null) {
                                    sbq = new StringBuffer();
                                    sbq.append("select 0 as VER, ITM, PRICT, PRI from PRIITM where ITM in " + sbg + ")");
                                }
                                if (sbs != null) {
                                    if (sbq == null) {
                                        sbq = new StringBuffer();
                                    } else {
                                        sbq.append("\n union all \n");
                                    }
                                    sbq.append("select 1 as VER, ITM, PRICT, PRI from PRISRV where ITM in " + sbs + ")");
                                }
                                if (sbsg != null) {
                                    if (sbq == null) {
                                        sbq = new StringBuffer();
                                    } else {
                                        sbq.append("\n union all \n");
                                    }
                                    sbq.append("select 2 as VER, ITM, PRICT, PRI from SEITMPRI where ITM in " + sbsg + ")");
                                }
                                if (sbss != null) {
                                    if (sbq == null) {
                                        sbq = new StringBuffer();
                                    } else {
                                        sbq.append("\n union all \n");
                                    }
                                    sbq.append("select 3 as VER, ITM, PRICT, PRI from SESRVPRI where ITM in " + sbss + ")");
                                }
                                if (sbq != null) {
                                    sbq.append(";");
                                    Object[] ndFlPr = new String[]{"pri", "ver"};
                                    Arrays.sort(ndFlPr);
                                    vs.put("PriItmndFds", ndFlPr);
                                    vs.put("PriItmdpLv", 1);
                                    List prcs = this.orm.retLstQu(pRvs, vs, PriItm.class, sbq.toString());
                                    vs.clear();
                                    block8: for (PriItm pri : prcs) {
                                        for (Itlist iil : itList) {
                                            long itTyp = iil.getTyp().ordinal();
                                            if (!iil.getItId().equals(pri.getItm().getIid()) || itTyp != pri.getVer()) continue;
                                            iil.setPri(pri.getPri());
                                            continue block8;
                                        }
                                    }
                                }
                            }
                        }
                        List pages = this.srvPg.evPgs(page.intValue(), totalPages, cpf.getPgTl().intValue());
                        pRvs.put("pages", pages);
                        pRvs.put("itList", itList);
                        pRvs.put("totalItems", rowCount);
                    }
                    if (fltPri != null) {
                        pRvs.put("fltPri", fltPri);
                    }
                    if (fltCatl != null && fltCatl.getAll().size() > 0) {
                        pRvs.put("fltCatl", fltCatl);
                    }
                    if (fltSpfs != null) {
                        pRvs.put("fltSpfs", fltSpfs);
                    }
                    pRvs.put("catl", (Object)tcat.getCatl());
                }
            }
            pRqDt.setAttr("rnd", (Object)"webstore");
            this.rdb.commit();
        }
        catch (Exception ex) {
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<TrCatl> lazCatls(Map<String, Object> pRvs) throws Exception {
        if (this.catls == null) {
            WsPg wsPg = this;
            synchronized (wsPg) {
                if (this.catls == null) {
                    HashMap<String, Integer> vs = new HashMap<String, Integer>();
                    List catlsGs = this.getOrm().retLstCnd(pRvs, vs, CatGs.class, "order by IDX");
                    vs.put("CatGsdpLv", 0);
                    for (CatGs cat : catlsGs) {
                        cat.setUsedSpecs(this.getOrm().retLstCnd(pRvs, vs, CatSp.class, "where OWNR=" + cat.getIid() + " order by IDX"));
                    }
                    vs.clear();
                    vs.put("SubCatdpLv", 1);
                    List scList = this.getOrm().retLst(pRvs, vs, SubCat.class);
                    vs.clear();
                    ArrayList<TrCatl> result = new ArrayList<TrCatl>();
                    HashSet<Long> firstLevel = new HashSet<Long>();
                    HashSet<Long> allLevels = new HashSet<Long>();
                    for (SubCat catSubc : scList) {
                        firstLevel.add(catSubc.getCatl().getIid());
                        allLevels.add(catSubc.getCatl().getIid());
                        allLevels.add(catSubc.getSucat().getIid());
                    }
                    for (SubCat catSubc : scList) {
                        firstLevel.remove(catSubc.getSucat().getIid());
                    }
                    for (Long id : firstLevel) {
                        TrCatl tc = new TrCatl();
                        tc.setCatl(this.findCatGsById(catlsGs, id));
                        result.add(tc);
                    }
                    for (CatGs cat : catlsGs) {
                        boolean inTree = false;
                        for (Long id : allLevels) {
                            if (!cat.getIid().equals(id)) continue;
                            inTree = true;
                            break;
                        }
                        if (inTree) continue;
                        TrCatl tc = new TrCatl();
                        tc.setCatl(this.findCatGsById(catlsGs, cat.getIid()));
                        result.add(tc);
                    }
                    this.retSubcatls(result, catlsGs, scList);
                    this.sortCatls(result);
                    this.refrCatlsFlts(pRvs, result);
                    this.catls = result;
                }
            }
        }
        return this.catls;
    }

    public final void refrCatlsFlts(Map<String, Object> pRvs, List<TrCatl> pCurLst) throws Exception {
        HashMap<String, Integer> vs = new HashMap<String, Integer>();
        vs.put("CatGsdpLv", 0);
        for (TrCatl tc : pCurLst) {
            if (tc.getCatl().getFlAvl().booleanValue() || tc.getCatl().getFlSpe().booleanValue() || tc.getCatl().getFlSub().booleanValue() || tc.getCatl().getFlPi().booleanValue()) {
                if (tc.getCatl().getFlSpe().booleanValue()) {
                    tc.getCatl().setUsedSpecs(this.getOrm().retLstCnd(pRvs, vs, CatSp.class, "where OWNR=" + tc.getCatl().getIid() + " order by IDX"));
                }
                this.prpgCatlStg(tc);
                continue;
            }
            if (tc.getSubcatls().size() > 0) {
                tc.getCatl().setUsedSpecs(null);
                this.refrCatlsFlts(pRvs, tc.getSubcatls());
                continue;
            }
            tc.getCatl().setUsedSpecs(null);
        }
    }

    public final void sortCatls(List<TrCatl> pCurLst) {
        Collections.sort(pCurLst, this.cmpCatls);
        for (TrCatl tc : pCurLst) {
            if (tc.getSubcatls().size() <= 0) continue;
            this.sortCatls(tc.getSubcatls());
        }
    }

    public final FltInt revFltPri(TrCatl pTcat, Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        if (pTcat.getCatl().getFlSpe().booleanValue() || pTcat.getCatl().getFlSub().booleanValue() || pTcat.getCatl().getFlAvl().booleanValue() || pTcat.getCatl().getFlPi().booleanValue()) {
            FltInt res = new FltInt();
            String operStr = pRqDt.getParam("fltPriOp");
            String val1Str = pRqDt.getParam("fltPriVal1");
            CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
            String dgsep = cpf.getDcGrSpv();
            if (operStr != null && !"".equals(operStr) && val1Str != null && !"".equals(val1Str)) {
                res.setOpr(Enum.valueOf(EFltOpr.class, operStr));
                if (dgsep != null) {
                    val1Str = val1Str.replace(dgsep, "");
                }
                res.setVal1((Object)Integer.valueOf(val1Str));
                String val2Str = pRqDt.getParam("fltPriVal2");
                if (val2Str != null && !"".equals(val2Str)) {
                    if (dgsep != null) {
                        val2Str = val2Str.replace(dgsep, "");
                    }
                    res.setVal2((Object)Integer.valueOf(val2Str));
                }
            }
            return res;
        }
        return null;
    }

    public final List<FltSpf> revFltsSpec(TrCatl pTcat, Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        if (pTcat.getCatl().getUsedSpecs() != null && pTcat.getCatl().getUsedSpecs().size() > 0) {
            ArrayList<FltSpf> res = new ArrayList<FltSpf>();
            CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
            String dsep = cpf.getDcSpv();
            String dgsep = cpf.getDcGrSpv();
            for (CatSp cs : pTcat.getCatl().getUsedSpecs()) {
                String val2Str;
                String val1Str;
                FltInt flt;
                FltSpf spf;
                String operStr = pRqDt.getParam("fltSp" + cs.getSpec().getIid() + "Op");
                if (cs.getSpec().getChSpTy() != null && cs.getSpec().getChSpTy().getIid() != null) {
                    FltItms fltItms = new FltItms();
                    spf = new FltSpf();
                    spf.setFlt((AFlt)fltItms);
                    spf.setCatSpf(cs);
                    res.add(spf);
                    fltItms.setAll(this.retAllChSpec(pRvs, cs.getSpec().getChSpTy()));
                    String[] valStrs = pRqDt.getParamVls("fltSp" + cs.getSpec().getIid() + "Val");
                    if (operStr == null || "".equals(operStr) || valStrs == null || valStrs.length <= 0) continue;
                    fltItms.setOpr(Enum.valueOf(EFltOpr.class, operStr));
                    for (String idStr : valStrs) {
                        Long id = Long.valueOf(idStr);
                        ChoSp chs = this.fndChoSpById(fltItms.getAll(), id);
                        if (chs == null) {
                            this.log.warn(pRvs, WsPg.class, "Can't find chspecifics #: " + id);
                            continue;
                        }
                        fltItms.getItms().add(chs);
                    }
                    continue;
                }
                if (EItmSpTy.INTEGER.equals((Object)cs.getSpec().getTyp())) {
                    flt = new FltInt();
                    spf = new FltSpf();
                    spf.setFlt((AFlt)flt);
                    spf.setCatSpf(cs);
                    res.add(spf);
                    val1Str = pRqDt.getParam("fltSp" + cs.getSpec().getIid() + "Val1");
                    if (operStr == null || "".equals(operStr) || val1Str == null || val1Str.length() <= 0) continue;
                    flt.setOpr(Enum.valueOf(EFltOpr.class, operStr));
                    if (dgsep != null) {
                        val1Str = val1Str.replace(dgsep, "");
                    }
                    flt.setVal1((Object)Integer.valueOf(val1Str));
                    val2Str = pRqDt.getParam("fltSp" + cs.getSpec().getIid() + "Val2");
                    if (val2Str == null || val2Str.length() <= 0) continue;
                    if (dgsep != null) {
                        val2Str = val2Str.replace(dgsep, "");
                    }
                    flt.setVal2((Object)Integer.valueOf(val2Str));
                    continue;
                }
                if (EItmSpTy.BIGDECIMAL.equals((Object)cs.getSpec().getTyp())) {
                    flt = new FltBgd();
                    spf = new FltSpf();
                    spf.setFlt((AFlt)flt);
                    spf.setCatSpf(cs);
                    res.add(spf);
                    val1Str = pRqDt.getParam("fltSp" + cs.getSpec().getIid() + "Val1");
                    if (operStr == null || "".equals(operStr) || val1Str == null || val1Str.length() <= 0) continue;
                    flt.setOpr(Enum.valueOf(EFltOpr.class, operStr));
                    if (dgsep != null) {
                        val1Str = val1Str.replace(dgsep, "");
                    }
                    if (dsep != null) {
                        val1Str = val1Str.replace(dsep, ".");
                    }
                    flt.setVal1((Object)new BigDecimal(val1Str));
                    val2Str = pRqDt.getParam("fltSp" + cs.getSpec().getIid() + "Val2");
                    if (val2Str == null || val2Str.length() <= 0) continue;
                    if (dgsep != null) {
                        val2Str = val2Str.replace(dgsep, "");
                    }
                    if (dsep != null) {
                        val2Str = val2Str.replace(dsep, ".");
                    }
                    flt.setVal2((Object)new BigDecimal(val2Str));
                    continue;
                }
                this.log.error(pRvs, WsPg.class, "Flt specifics not implemented yet, for - " + cs.getSpec().getNme());
            }
            return res;
        }
        return null;
    }

    public final List<ChoSp> retAllChSpec(Map<String, Object> pRvs, ChoSpTy pChoSpTy) throws Exception {
        HashMap<String, Integer> vs = new HashMap<String, Integer>();
        vs.put("ChoSpdpLv", 1);
        return this.getOrm().retLstCnd(pRvs, vs, ChoSp.class, "where CHOTY=" + pChoSpTy.getIid());
    }

    public final ChoSp fndChoSpById(List<ChoSp> pChoSps, Long pId) {
        for (ChoSp chs : pChoSps) {
            if (!chs.getIid().equals(pId)) continue;
            return chs;
        }
        return null;
    }

    public final FltItms<CatGs> revFltCatl(TrCatl pTcat, Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        if (pTcat.getCatl().getFlSub().booleanValue()) {
            FltItms res = new FltItms();
            this.copSubcats(pTcat, res.getAll());
            String operStr = pRqDt.getParam("fltCtOp");
            String[] valStrs = pRqDt.getParamVls("fltCtVal");
            if (operStr != null && !"".equals(operStr) && valStrs != null && valStrs.length > 0) {
                res.setOpr(Enum.valueOf(EFltOpr.class, operStr));
                for (String idStr : valStrs) {
                    Long id = Long.valueOf(idStr);
                    CatGs cgs = this.findSubcatByIdInTc(pTcat, id);
                    if (cgs == null) {
                        throw new Exception("Algorithm error! Can't find subcatl #/in: " + id + "/" + pTcat.getCatl().getNme());
                    }
                    res.getItms().add(cgs);
                }
            }
            return res;
        }
        return null;
    }

    public final String revWhePri(FltInt pFltPri, BigDecimal pCuRt) throws Exception {
        if (pFltPri == null || pFltPri.getOpr() == null || pFltPri.getVal1() == null) {
            return "";
        }
        BigDecimal exchRate = pCuRt;
        if (exchRate.compareTo(BigDecimal.ZERO) == -1) {
            exchRate = BigDecimal.ONE.divide(exchRate.negate(), 15, RoundingMode.HALF_UP);
        }
        int val1 = (Integer)pFltPri.getVal1();
        if (exchRate.compareTo(BigDecimal.ONE) != 0) {
            BigDecimal bd = new BigDecimal(val1);
            bd = bd.divide(exchRate, 0, RoundingMode.HALF_UP);
            val1 = bd.intValue();
        }
        if (EFltOpr.LESS_THAN.equals((Object)pFltPri.getOpr()) || EFltOpr.LESS_THAN_EQUAL.equals((Object)pFltPri.getOpr()) || EFltOpr.GREATER_THAN.equals((Object)pFltPri.getOpr()) || EFltOpr.GREATER_THAN_EQUAL.equals((Object)pFltPri.getOpr())) {
            return " and PRI" + this.toSqlOpr(pFltPri.getOpr()) + val1;
        }
        if (pFltPri.getVal2() != null) {
            int val2 = (Integer)pFltPri.getVal2();
            if (exchRate.compareTo(BigDecimal.ONE) != 0) {
                BigDecimal bd = new BigDecimal(val2);
                bd = bd.divide(exchRate, 0, RoundingMode.HALF_UP);
                val2 = bd.intValue();
            }
            if (EFltOpr.BETWEEN.equals((Object)pFltPri.getOpr())) {
                return " and PRI>" + val1 + " and PRI<" + val2;
            }
            if (EFltOpr.BETWEEN_INCLUDE.equals((Object)pFltPri.getOpr())) {
                return " and PRI>=" + val1 + " and PRI<=" + val2;
            }
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final FltsSpfWhe revWheSpec(List<FltSpf> pFltsSpf) throws Exception {
        FltsSpfWhe result = null;
        StringBuffer sb = new StringBuffer();
        boolean isFst = true;
        for (FltSpf sf : pFltsSpf) {
            FltInt flt;
            if (sf.getFlt().getOpr() == null) continue;
            if (isFst) {
                sb.append("(SPEC=" + sf.getCatSpf().getSpec().getIid() + " and ");
                isFst = false;
            } else {
                sb.append(" or (SPEC=" + sf.getCatSpf().getSpec().getIid() + " and ");
            }
            if (sf.getFlt().getClass() == FltItms.class) {
                FltItms fltItms = (FltItms)sf.getFlt();
                sb.append("LNG1");
                if (EFltOpr.IN.equals((Object)fltItms.getOpr()) && fltItms.getItms().size() == 1) {
                    sb.append("=" + ((ChoSp)((Object)fltItms.getItms().get(0))).getIid());
                } else if (EFltOpr.NOT_IN.equals((Object)fltItms.getOpr()) && fltItms.getItms().size() == 1) {
                    sb.append("!=" + ((ChoSp)((Object)fltItms.getItms().get(0))).getIid());
                } else {
                    if (EFltOpr.IN.equals((Object)fltItms.getOpr())) {
                        sb.append(" in (");
                    } else {
                        sb.append(" not in (");
                    }
                    boolean isFstItm = true;
                    for (ChoSp chs : fltItms.getItms()) {
                        if (isFstItm) {
                            isFstItm = false;
                        } else {
                            sb.append(",");
                        }
                        sb.append(chs.getIid());
                    }
                    sb.append(")");
                }
            } else if (sf.getFlt().getClass() == FltInt.class) {
                flt = (FltInt)sf.getFlt();
                sb.append("LNG1");
                if (EFltOpr.LESS_THAN.equals((Object)flt.getOpr()) || EFltOpr.LESS_THAN_EQUAL.equals((Object)flt.getOpr()) || EFltOpr.GREATER_THAN.equals((Object)flt.getOpr()) || EFltOpr.GREATER_THAN_EQUAL.equals((Object)flt.getOpr())) {
                    sb.append(this.toSqlOpr(flt.getOpr()) + flt.getVal1());
                } else if (EFltOpr.BETWEEN.equals((Object)flt.getOpr())) {
                    sb.append(">" + flt.getVal1() + " and LNG1<" + flt.getVal2());
                } else {
                    if (!EFltOpr.BETWEEN_INCLUDE.equals((Object)flt.getOpr())) throw new Exception("Algorithm error for where integer specifics/operator: " + sf.getCatSpf().getSpec().getNme() + "/" + flt.getOpr());
                    sb.append(">=" + flt.getVal1() + " and LNG1<=" + flt.getVal2());
                }
            } else {
                if (sf.getFlt().getClass() != FltBgd.class) throw new Exception("Making WHERE not implemented for specifics/filter: " + sf.getCatSpf().getSpec().getNme() + "/" + sf.getFlt().getClass());
                flt = (FltBgd)sf.getFlt();
                sb.append("NUM1");
                if (EFltOpr.LESS_THAN.equals((Object)flt.getOpr()) || EFltOpr.LESS_THAN_EQUAL.equals((Object)flt.getOpr()) || EFltOpr.GREATER_THAN.equals((Object)flt.getOpr()) || EFltOpr.GREATER_THAN_EQUAL.equals((Object)flt.getOpr())) {
                    sb.append(this.toSqlOpr(flt.getOpr()) + flt.getVal1());
                } else if (EFltOpr.BETWEEN.equals((Object)flt.getOpr())) {
                    sb.append(">" + flt.getVal1() + " and NUM1<" + flt.getVal2());
                } else {
                    if (!EFltOpr.BETWEEN_INCLUDE.equals((Object)flt.getOpr())) throw new Exception("Algorithm error for where integer specifics/operator: " + sf.getCatSpf().getSpec().getNme() + "/" + flt.getOpr());
                    sb.append(">=" + flt.getVal1() + " and NUM1<=" + flt.getVal2());
                }
            }
            sb.append(")");
            if (result == null) {
                result = new FltsSpfWhe();
            }
            result.setWhereCount(result.getWhereCount() + 1);
        }
        if (result == null) return result;
        result.setWhere(sb.toString());
        return result;
    }

    public final String revealWhereCatl(TrCatl pTcat, FltItms<CatGs> pFltCatl) throws Exception {
        ArrayList<CatGs> subcgsAll = new ArrayList<CatGs>();
        subcgsAll.add(pTcat.getCatl());
        if (pFltCatl != null && pFltCatl.getOpr() != null && pFltCatl.getItms().size() > 0) {
            for (Object cgs : pFltCatl.getItms()) {
                TrCatl tcat = this.findTrCatlById(this.catls, cgs.getIid());
                subcgsAll.add((CatGs)((Object)cgs));
                this.copSubcats(tcat, subcgsAll);
            }
        } else {
            this.copSubcats(pTcat, subcgsAll);
        }
        HashSet<CatGs> subcgs = new HashSet<CatGs>();
        for (CatGs cgs : subcgsAll) {
            if (cgs.getHsSub().booleanValue()) continue;
            subcgs.add(cgs);
        }
        if (subcgs.size() > 1) {
            StringBuffer sb = new StringBuffer(" in (" + pTcat.getCatl().getIid());
            for (CatGs cgs : subcgs) {
                sb.append("," + cgs.getIid());
            }
            sb.append(")");
            return sb.toString();
        }
        return "=" + ((CatGs)((Object)subcgs.iterator().next())).getIid();
    }

    public final String toSqlOpr(EFltOpr pFltOpr) throws Exception {
        if (EFltOpr.LESS_THAN.equals((Object)pFltOpr)) {
            return "<";
        }
        if (EFltOpr.LESS_THAN_EQUAL.equals((Object)pFltOpr)) {
            return "<=";
        }
        if (EFltOpr.GREATER_THAN.equals((Object)pFltOpr)) {
            return ">";
        }
        if (EFltOpr.GREATER_THAN_EQUAL.equals((Object)pFltOpr)) {
            return ">=";
        }
        throw new ExcCode(1001, "Algorithm error! Cant match SQL operator to EFltOpr: " + pFltOpr);
    }

    public final void prpgCatlStg(TrCatl pMainCatl) throws Exception {
        for (TrCatl tc : pMainCatl.getSubcatls()) {
            tc.getCatl().setFlAvl(pMainCatl.getCatl().getFlAvl());
            tc.getCatl().setFlSpe(pMainCatl.getCatl().getFlSpe());
            tc.getCatl().setFlSub(pMainCatl.getCatl().getFlSub());
            tc.getCatl().setFlPi(pMainCatl.getCatl().getFlPi());
            tc.getCatl().setUsedSpecs(pMainCatl.getCatl().getUsedSpecs());
            tc.getCatl().setHsGds(pMainCatl.getCatl().getHsGds());
            tc.getCatl().setHsSrv(pMainCatl.getCatl().getHsSrv());
            tc.getCatl().setHsSgo(pMainCatl.getCatl().getHsSgo());
            tc.getCatl().setHsSse(pMainCatl.getCatl().getHsSse());
            if (tc.getSubcatls().size() <= 0) continue;
            this.prpgCatlStg(tc);
        }
    }

    public final void retSubcatls(List<TrCatl> pCurLst, List<CatGs> pCatls, List<SubCat> pSubCats) throws Exception {
        for (TrCatl tc : pCurLst) {
            for (SubCat catSubc : pSubCats) {
                if (!tc.getCatl().getIid().equals(catSubc.getCatl().getIid())) continue;
                TrCatl tci = new TrCatl();
                tci.setCatl(this.findCatGsById(pCatls, catSubc.getSucat().getIid()));
                tc.getSubcatls().add(tci);
            }
            if (tc.getSubcatls().size() <= 0) continue;
            this.retSubcatls(tc.getSubcatls(), pCatls, pSubCats);
        }
    }

    public final CatGs findCatGsById(List<CatGs> pCatls, Long pId) throws Exception {
        for (CatGs cat : pCatls) {
            if (!cat.getIid().equals(pId)) continue;
            return cat;
        }
        throw new Exception("Algorithm error! Can't find catl #" + pId);
    }

    public final TrCatl findTrCatlById(List<TrCatl> pCatls, Long pId) {
        for (TrCatl cat : pCatls) {
            TrCatl tc;
            if (cat.getCatl().getIid().equals(pId)) {
                return cat;
            }
            if (cat.getSubcatls().size() <= 0 || (tc = this.findTrCatlById(cat.getSubcatls(), pId)) == null) continue;
            return tc;
        }
        return null;
    }

    public final void copSubcats(TrCatl pCatl, List<CatGs> pCatlsGs) {
        for (TrCatl cat : pCatl.getSubcatls()) {
            pCatlsGs.add(cat.getCatl());
            for (TrCatl cati : cat.getSubcatls()) {
                pCatlsGs.add(cati.getCatl());
                this.copSubcats(cati, pCatlsGs);
            }
        }
    }

    public final CatGs findSubcatByIdInTc(TrCatl pCatl, Long pId) {
        for (TrCatl cat : pCatl.getSubcatls()) {
            if (cat.getCatl().getIid().equals(pId)) {
                return cat.getCatl();
            }
            for (TrCatl cati : cat.getSubcatls()) {
                if (cati.getCatl().getIid().equals(pId)) {
                    return cati.getCatl();
                }
                CatGs cgs = this.findSubcatByIdInTc(cati, pId);
                if (cgs == null) continue;
                return cgs;
            }
        }
        return null;
    }

    public final String lazyGetQuItSpFlt() throws Exception {
        if (this.quItSpFlt == null) {
            this.quItSpFlt = this.loadStr("/ws/itSpFlt.sql");
        }
        return this.quItSpFlt;
    }

    public final String lazyGetQuItInLstCaIn() throws Exception {
        if (this.quItInLstCaIn == null) {
            this.quItInLstCaIn = this.loadStr("/ws/itInLstCaIn.sql");
        }
        return this.quItInLstCaIn;
    }

    public final String lazyGetQuItInLstCaTo() throws Exception {
        if (this.quItInLstCaTo == null) {
            this.quItInLstCaTo = this.loadStr("/ws/itInLstCaTo.sql");
        }
        return this.quItInLstCaTo;
    }

    public final String lazyGetQuItInLstCa() throws Exception {
        if (this.quItInLstCa == null) {
            this.quItInLstCa = this.loadStr("/ws/itInLstCa.sql");
        }
        return this.quItInLstCa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadStr(String pFiNm) throws IOException {
        URL urlFile = WsPg.class.getResource(pFiNm);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = WsPg.class.getResourceAsStream(pFiNm);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final Integer getTrIsl() {
        return this.trIsl;
    }

    public final void setTrIsl(Integer pTrIsl) {
        this.trIsl = pTrIsl;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrvPg getSrvPg() {
        return this.srvPg;
    }

    public final void setSrvPg(ISrvPg pSrvPg) {
        this.srvPg = pSrvPg;
    }

    public final ISrCart getSrCart() {
        return this.srCart;
    }

    public final void setSrCart(ISrCart pSrCart) {
        this.srCart = pSrCart;
    }

    public final CmpTrCatl getCmpCatls() {
        return this.cmpCatls;
    }

    public final void setCmpCatls(CmpTrCatl pCmpCatls) {
        this.cmpCatls = pCmpCatls;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }
}

