/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.srv;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.hnd.IHndSpam;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.ws.mdlp.Buyer;
import org.beigesoft.ws.srv.IBuySr;

public class BuySr
implements IBuySr {
    private IOrm orm;
    private IHndSpam spamHnd;

    @Override
    public final Buyer getAuthBuyr(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        String buyerIdStr = pRqDt.getCookVl("cBuyerId");
        if (buyerIdStr == null) {
            this.spamHnd.handle(pRvs, pRqDt, 1, "Buyer. has no cBuyerId!");
            return null;
        }
        HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
        Long buyerId = Long.valueOf(buyerIdStr);
        Buyer buyer = new Buyer();
        buyer.setIid(buyerId);
        this.getOrm().refrEnt(pRvs, vs, (IHasId)buyer);
        if (buyer.getIid() == null) {
            this.spamHnd.handle(pRvs, pRqDt, 1, "Buyer. DB has no cBuyerId: " + buyerIdStr);
            return null;
        }
        if (buyer.getEml() == null || buyer.getBuSeId() == null) {
            this.spamHnd.handle(pRvs, pRqDt, 1, "Buyer. Unauthorized cBuyerId: " + buyerIdStr);
            return null;
        }
        String buSeId = pRqDt.getCookVl("buSeId");
        if (buSeId != null && !buyer.getBuSeId().equals(buSeId)) {
            this.spamHnd.handle(pRvs, pRqDt, 1000, "Buyer. Authorized invasion? cBuyerId: " + buyerIdStr);
            return null;
        }
        long now = new Date().getTime();
        if (now - buyer.getLsTm() > 1800000L) {
            this.spamHnd.handle(pRvs, pRqDt, 0, "Buyer. Authorized exceed cBuyerId/ms: " + buyerIdStr + "/" + (now - buyer.getLsTm()));
            return null;
        }
        buyer.setLsTm(now);
        Object[] fieldsNames = new String[]{"iid", "ver", "lsTm"};
        Arrays.sort(fieldsNames);
        vs.put("fdNms", fieldsNames);
        buyer.setLsTm(now);
        this.orm.update(pRvs, vs, (IHasId)buyer);
        pRvs.put("buyr", (Object)buyer);
        return buyer;
    }

    @Override
    public final Buyer getBuyr(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        Long buyerId = null;
        String buyerIdStr = pRqDt.getCookVl("cBuyerId");
        if (buyerIdStr != null && buyerIdStr.length() > 0) {
            buyerId = Long.valueOf(buyerIdStr);
        }
        Buyer buyer = null;
        if (buyerId != null) {
            HashMap vs = new HashMap();
            buyer = new Buyer();
            buyer.setIid(buyerId);
            this.getOrm().refrEnt(pRvs, vs, (IHasId)buyer);
            if (buyer.getIid() == null) {
                buyer = null;
            }
        }
        if (buyer != null && buyer.getEml() != null && buyer.getBuSeId() != null) {
            String buSeId = pRqDt.getCookVl("buSeId");
            if (!buyer.getBuSeId().equals(buSeId)) {
                this.spamHnd.handle(pRvs, pRqDt, 100, "Buyer. Authorized invasion? cBuyerId: " + buyerIdStr);
                buyer = null;
            }
        }
        return buyer;
    }

    @Override
    public final Buyer createBuyr(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        HashMap<String, Integer> vs = new HashMap<String, Integer>();
        Buyer buyer = null;
        vs.put("DbCrdpLv", 1);
        vs.put("TxDstdpLv", 1);
        List brs = this.getOrm().retLstCnd(pRvs, vs, Buyer.class, "where FRE=1 and PWD is null");
        vs.clear();
        if (brs.size() > 0) {
            double rd = Math.random();
            buyer = rd > 0.5 ? (Buyer)((Object)brs.get(brs.size() - 1)) : (Buyer)((Object)brs.get(0));
            buyer.setPwd(null);
            buyer.setEml(null);
            buyer.setFre(false);
        }
        if (buyer == null) {
            buyer = new Buyer();
            buyer.setIsNew(true);
            buyer.setNme("newbe" + new Date().getTime());
        }
        return buyer;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final IHndSpam getSpamHnd() {
        return this.spamHnd;
    }

    public final void setSpamHnd(IHndSpam pSpamHnd) {
        this.spamHnd = pSpamHnd;
    }
}

