/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.srv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdl.TaxWr;
import org.beigesoft.acc.mdl.TxCtWr;
import org.beigesoft.acc.mdlb.ATxLn;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.Tax;
import org.beigesoft.acc.mdlp.TxCt;
import org.beigesoft.acc.mdlp.TxCtLn;
import org.beigesoft.acc.mdlp.WrhItm;
import org.beigesoft.acc.mdlp.WrhPl;
import org.beigesoft.cmp.CmpHasIdLn;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdl.Node;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.srv.I18n;
import org.beigesoft.srv.ICsvDtRet;
import org.beigesoft.ws.mdlp.PriItm;

public class GdPriLstRet
implements ICsvDtRet {
    private I18n i18n;
    private IOrm orm;

    public final List<List<Object>> retData(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        Long priCtId = Long.parseLong(pRqDt.getParam("priCt"));
        BigDecimal unAvPri = null;
        String unAvPris = pRqDt.getParam("unAvPri");
        CmnPrf cmnPrf = (CmnPrf)pRvs.get("cpf");
        if (unAvPris != null) {
            if (!"".equals(cmnPrf.getDcGrSpv())) {
                unAvPris = unAvPris.replace(cmnPrf.getDcGrSpv(), "");
            }
            if (!"".equals(cmnPrf.getDcSpv()) && !".".equals(cmnPrf.getDcSpv())) {
                unAvPris = unAvPris.replace(cmnPrf.getDcSpv(), ".");
            }
            unAvPri = new BigDecimal(unAvPris);
        }
        BigDecimal optmQuan = null;
        String optmQuans = pRqDt.getParam("optmQuan");
        if (optmQuans != null) {
            if (!"".equals(cmnPrf.getDcGrSpv())) {
                optmQuans = optmQuans.replace(cmnPrf.getDcGrSpv(), "");
            }
            if (!"".equals(cmnPrf.getDcSpv()) && !".".equals(cmnPrf.getDcSpv())) {
                optmQuans = optmQuans.replace(cmnPrf.getDcSpv(), ".");
            }
            optmQuan = new BigDecimal(optmQuans);
        }
        Object[] ndFlPg = new String[]{"itm", "pri"};
        Arrays.sort(ndFlPg);
        String[] ndFdNm = new String[]{"nme"};
        vs.put("PriItmdpLv", 3);
        vs.put("PriItmndFds", ndFlPg);
        vs.put("ItmCtndFds", ndFdNm);
        vs.put("UomndFds", ndFdNm);
        List gpl = this.getOrm().retLstCnd(pRvs, vs, PriItm.class, "where PRICT=" + priCtId);
        vs.clear();
        vs.put("WrhPldpLv", 1);
        List wrhps = this.getOrm().retLst(pRvs, vs, WrhPl.class);
        vs.clear();
        String[] ndFdr = new String[]{"rate"};
        pRvs.put("TxCtLnndFds", ndFdr);
        pRvs.put("TaxndFds", ndFdNm);
        List allTaxCatsLns = this.getOrm().retLst(pRvs, vs, TxCtLn.class);
        vs.clear();
        ArrayList<Tax> usedTaxes = new ArrayList<Tax>();
        ArrayList<TxCt> usedTaxCats = new ArrayList<TxCt>();
        for (Object tcl : allTaxCatsLns) {
            boolean txListed = false;
            for (Tax tax : usedTaxes) {
                if (!tax.getIid().equals(((ATxLn)((Object)tcl)).getTax().getIid())) continue;
                txListed = true;
                break;
            }
            if (!txListed) {
                usedTaxes.add(((ATxLn)((Object)tcl)).getTax());
            }
            int tci = -1;
            for (TxCt tc : usedTaxCats) {
                if (!tc.getIid().equals(((TxCtLn)((Object)tcl)).getOwnr().getIid())) continue;
                tci = usedTaxCats.indexOf((Object)tc);
                break;
            }
            if (tci == -1) {
                usedTaxCats.add(((TxCtLn)((Object)tcl)).getOwnr());
                ((TxCtLn)((Object)tcl)).getOwnr().setTxs(new ArrayList<TxCtLn>());
                ((TxCtLn)((Object)tcl)).getOwnr().getTxs().add((TxCtLn)((Object)tcl));
                continue;
            }
            ((TxCt)((Object)usedTaxCats.get(tci))).getTxs().add((TxCtLn)((Object)tcl));
        }
        Collections.sort(usedTaxes, new CmpHasIdLn());
        Collections.sort(usedTaxCats, new CmpHasIdLn());
        boolean isOnlyTax = true;
        for (TxCt txc : usedTaxCats) {
            if (txc.getTxs().size() <= 1) continue;
            isOnlyTax = false;
            break;
        }
        String[] fdsItLf = new String[]{"itLf"};
        vs.put("WrhItmndFds", fdsItLf);
        vs.put("WrhItmdpLv", 1);
        String qur = "select 1 as UOM, ITM , sum(ITLF) as ITLF, min(WRHP) as WRHP from WRHITM group by UOM, ITM";
        List whRests = this.getOrm().retLstQu(pRvs, vs, WrhItm.class, qur);
        vs.clear();
        BigDecimal bigDecimal = new BigDecimal("1.2");
        BigDecimal bd100 = new BigDecimal("100");
        for (PriItm pg : gpl) {
            Boolean avlb;
            BigDecimal quantity;
            ArrayList<Object> row = new ArrayList<Object>();
            result.add(row);
            row.add(pg.getItm());
            row.add(pg.getPri());
            row.add(pg.getPri().divide(bigDecimal, 2, RoundingMode.HALF_UP));
            WrhPl ws = null;
            if (unAvPri != null && pg.getPri().compareTo(unAvPri) == 0) {
                quantity = BigDecimal.ZERO;
                avlb = Boolean.FALSE;
            } else {
                Object wr = this.findRest(pg.getItm().getIid(), whRests);
                if (wr != null) {
                    quantity = wr.getItLf();
                    avlb = Boolean.TRUE;
                    ws = this.findWphp(wr.getWrhp().getIid(), wrhps);
                } else if (optmQuan == null) {
                    quantity = BigDecimal.ZERO;
                    avlb = Boolean.FALSE;
                } else {
                    quantity = optmQuan;
                    avlb = Boolean.TRUE;
                }
            }
            row.add(quantity);
            row.add(avlb);
            row.add((Object)ws);
            if (pg.getItm().getTxCt() != null) {
                for (TxCt txc : usedTaxCats) {
                    if (!txc.getIid().equals(pg.getItm().getTxCt().getIid())) continue;
                    pg.getItm().setTxCt(txc);
                    break;
                }
            }
            if (isOnlyTax) {
                TaxWr onlyTax = new TaxWr();
                if (pg.getItm().getTxCt() != null) {
                    onlyTax.setTax(pg.getItm().getTxCt().getTxs().get(0).getTax());
                    onlyTax.setUsed(true);
                    onlyTax.setRate(pg.getItm().getTxCt().getTxs().get(0).getRate().divide(bd100, as.getTxDp() + 2, RoundingMode.HALF_UP));
                }
                row.add(onlyTax);
                continue;
            }
            TxCtWr taxCat = new TxCtWr();
            if (pg.getItm().getTxCt() != null) {
                taxCat.setTxCt(pg.getItm().getTxCt());
                taxCat.setUsed(true);
                for (TxCtLn tl : taxCat.getTxCt().getTxs()) {
                    taxCat.setAggrPercent(taxCat.getAggrPercent().add(tl.getRate()));
                }
                taxCat.setAggrRate(taxCat.getAggrPercent().divide(bd100, as.getTxDp() + 2, RoundingMode.HALF_UP));
            }
            row.add(taxCat);
            for (Tax tx : usedTaxes) {
                TaxWr txWr = new TaxWr();
                if (pg.getItm().getTxCt() != null) {
                    for (TxCtLn tl : pg.getItm().getTxCt().getTxs()) {
                        if (!tl.getTax().getIid().equals(tx.getIid())) continue;
                        txWr.setTax(tl.getTax());
                        txWr.setUsed(true);
                        txWr.setRate(tl.getRate().divide(bd100, as.getTxDp() + 2, RoundingMode.HALF_UP));
                        break;
                    }
                }
                row.add(txWr);
            }
            for (TxCt txc : usedTaxCats) {
                TxCtWr txCtWr = new TxCtWr();
                if (pg.getItm().getTxCt() != null && txc.getIid().equals(pg.getItm().getTxCt().getIid())) {
                    txCtWr.setTxCt(txc);
                    txCtWr.setUsed(true);
                    for (TxCtLn tl : txCtWr.getTxCt().getTxs()) {
                        txCtWr.setAggrPercent(txCtWr.getAggrPercent().add(tl.getRate()));
                    }
                    txCtWr.setAggrRate(txCtWr.getAggrPercent().divide(bd100, as.getTxDp() + 2, RoundingMode.HALF_UP));
                }
                row.add(txCtWr);
            }
        }
        return result;
    }

    public final List<Node<String>> getSmpDtRow(Map<String, Object> pRvs) throws Exception {
        Iterator iterator;
        HashMap vs = new HashMap();
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        String lang = cpf.getLngDef().getIid();
        ArrayList<Node<String>> result = new ArrayList<Node<String>>();
        Integer idx = 1;
        Node nodeGoods = new Node();
        result.add(nodeGoods);
        nodeGoods.setNme(this.getI18n().getMsg("itm", lang));
        nodeGoods.setNodes(new ArrayList());
        Node nodeGoodsName = new Node();
        nodeGoods.getNodes().add(nodeGoodsName);
        nodeGoodsName.setNme(this.getI18n().getMsg("nme", lang));
        nodeGoodsName.setVal((Object)(idx.toString() + ";nme"));
        Node nodeGoodsId = new Node();
        nodeGoods.getNodes().add(nodeGoodsId);
        nodeGoodsId.setNme(this.getI18n().getMsg("iid", lang));
        nodeGoodsId.setVal((Object)(idx.toString() + ";iid"));
        Node nodeGoodsItsCategory = new Node();
        nodeGoods.getNodes().add(nodeGoodsItsCategory);
        nodeGoodsItsCategory.setNme(this.getI18n().getMsg("cat", lang));
        nodeGoodsItsCategory.setNodes(new ArrayList());
        Node nodeGoodsItsCategoryName = new Node();
        nodeGoodsItsCategory.getNodes().add(nodeGoodsItsCategoryName);
        nodeGoodsItsCategoryName.setNme(this.getI18n().getMsg("nme", lang));
        nodeGoodsItsCategoryName.setVal((Object)(idx.toString() + ";cat,nme"));
        Node nodeGoodsItsCategoryId = new Node();
        nodeGoodsItsCategory.getNodes().add(nodeGoodsItsCategoryId);
        nodeGoodsItsCategoryId.setNme(this.getI18n().getMsg("iid", lang));
        nodeGoodsItsCategoryId.setVal((Object)(idx.toString() + ";cat,iid"));
        Node nodeGoodsDefUom = new Node();
        nodeGoods.getNodes().add(nodeGoodsDefUom);
        nodeGoodsDefUom.setNme(this.getI18n().getMsg("duom", lang));
        nodeGoodsDefUom.setNodes(new ArrayList());
        Node nodeGoodsDefUomName = new Node();
        nodeGoodsDefUom.getNodes().add(nodeGoodsDefUomName);
        nodeGoodsDefUomName.setNme(this.getI18n().getMsg("nme", lang));
        nodeGoodsDefUomName.setVal((Object)(idx.toString() + ";duom,nme"));
        Node nodeGoodsDefUomId = new Node();
        nodeGoodsDefUom.getNodes().add(nodeGoodsDefUomId);
        nodeGoodsDefUomId.setNme(this.getI18n().getMsg("iid", lang));
        nodeGoodsDefUomId.setVal((Object)(idx.toString() + ";duom,iid"));
        Integer n = idx;
        Integer n2 = idx = Integer.valueOf(idx + 1);
        Node nodePrice = new Node();
        result.add(nodePrice);
        nodePrice.setNme(this.getI18n().getMsg("pri", lang));
        nodePrice.setVal((Object)idx.toString());
        n2 = idx;
        Integer n3 = idx = Integer.valueOf(idx + 1);
        Node nodeCost = new Node();
        result.add(nodeCost);
        nodeCost.setNme(this.getI18n().getMsg("cost", lang));
        nodeCost.setVal((Object)idx.toString());
        n3 = idx;
        Integer n4 = idx = Integer.valueOf(idx + 1);
        Node nodeQuantity = new Node();
        result.add(nodeQuantity);
        nodeQuantity.setNme(this.getI18n().getMsg("quan", lang));
        nodeQuantity.setVal((Object)idx.toString());
        n4 = idx;
        Integer n5 = idx = Integer.valueOf(idx + 1);
        Node nodeIsAvailable = new Node();
        result.add(nodeIsAvailable);
        nodeIsAvailable.setNme(this.getI18n().getMsg("avlb", lang));
        nodeIsAvailable.setVal((Object)idx.toString());
        n5 = idx;
        Integer n6 = idx = Integer.valueOf(idx + 1);
        Node nodeWrhPl = new Node();
        result.add(nodeWrhPl);
        nodeWrhPl.setNme(this.getI18n().getMsg("WrhPl", lang));
        nodeWrhPl.setNodes(new ArrayList());
        Node nodeWrhPlName = new Node();
        nodeWrhPl.getNodes().add(nodeWrhPlName);
        nodeWrhPlName.setNme(this.getI18n().getMsg("nme", lang));
        nodeWrhPlName.setVal((Object)(idx.toString() + ";nme"));
        Node nodeWrhPlId = new Node();
        nodeWrhPl.getNodes().add(nodeWrhPlId);
        nodeWrhPlId.setNme(this.getI18n().getMsg("iid", lang));
        nodeWrhPlId.setVal((Object)(idx.toString() + ";iid"));
        Node nodeWrhPlWrh = new Node();
        nodeWrhPl.getNodes().add(nodeWrhPlWrh);
        nodeWrhPlWrh.setNme(this.getI18n().getMsg("wrh", lang));
        nodeWrhPlWrh.setNodes(new ArrayList());
        Node nodeWrhPlWrhName = new Node();
        nodeWrhPlWrh.getNodes().add(nodeWrhPlWrhName);
        nodeWrhPlWrhName.setNme(this.getI18n().getMsg("nme", lang));
        nodeWrhPlWrhName.setVal((Object)(idx.toString() + ";wrh,nme"));
        Node nodeWrhPlWrhId = new Node();
        nodeWrhPlWrh.getNodes().add(nodeWrhPlWrhId);
        nodeWrhPlWrhId.setNme(this.getI18n().getMsg("iid", lang));
        nodeWrhPlWrhId.setVal((Object)(idx.toString() + ";wrh,iid"));
        HashSet<String> ndFdNm = new HashSet<String>();
        ndFdNm.add("iid");
        ndFdNm.add("nme");
        pRvs.put("TxCtndFds", ndFdNm);
        pRvs.put("TaxndFds", ndFdNm);
        List allTaxCatsLns = this.getOrm().retLst(pRvs, vs, TxCtLn.class);
        vs.clear();
        ArrayList<Tax> usedTaxes = new ArrayList<Tax>();
        ArrayList<TxCt> usedTaxCats = new ArrayList<TxCt>();
        for (TxCtLn tcl : allTaxCatsLns) {
            boolean bl = false;
            for (Tax tx : usedTaxes) {
                if (!tx.getIid().equals(tcl.getTax().getIid())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                usedTaxes.add(tcl.getTax());
            }
            int tci = -1;
            for (TxCt tc : usedTaxCats) {
                if (!tc.getIid().equals(tcl.getOwnr().getIid())) continue;
                tci = usedTaxCats.indexOf((Object)tc);
                break;
            }
            if (tci == -1) {
                usedTaxCats.add(tcl.getOwnr());
                tcl.getOwnr().setTxs(new ArrayList<TxCtLn>());
                tcl.getOwnr().getTxs().add(tcl);
                continue;
            }
            ((TxCt)((Object)usedTaxCats.get(tci))).getTxs().add(tcl);
        }
        boolean isOnlyTax = true;
        for (TxCt txCt : usedTaxCats) {
            if (txCt.getTxs().size() <= 1) continue;
            isOnlyTax = false;
            break;
        }
        if (isOnlyTax) {
            iterator = idx;
            Integer n7 = idx = Integer.valueOf(idx + 1);
            this.addTaxWr(result, idx.toString(), this.getI18n().getMsg("OnlyTax", lang), lang);
        } else {
            Object object;
            iterator = idx;
            Integer n8 = idx = Integer.valueOf(idx + 1);
            this.addTaxCatWr(result, idx.toString(), this.getI18n().getMsg("txCt", lang), lang);
            Collections.sort(usedTaxes, new CmpHasIdLn());
            for (Tax tax : usedTaxes) {
                Integer n9 = idx;
                idx = idx + 1;
                object = idx;
                this.addTaxWr(result, idx.toString(), tax.getNme(), lang);
            }
            Collections.sort(usedTaxCats, new CmpHasIdLn());
            for (TxCt txCt : usedTaxCats) {
                Integer n10 = idx;
                idx = idx + 1;
                object = idx;
                this.addTaxCatWr(result, idx.toString(), txCt.getNme(), lang);
            }
        }
        return result;
    }

    public final void addTaxWr(List<Node<String>> pTree, String pIndex, String pName, String pLang) {
        Node nodeTaxWr = new Node();
        pTree.add((Node<String>)nodeTaxWr);
        nodeTaxWr.setNme(pName);
        nodeTaxWr.setNodes(new ArrayList());
        Node nodeTaxWrUsed = new Node();
        nodeTaxWr.getNodes().add(nodeTaxWrUsed);
        nodeTaxWrUsed.setNme(this.getI18n().getMsg("used", pLang));
        nodeTaxWrUsed.setVal((Object)(pIndex + ";used"));
        Node nodeTaxWrRate = new Node();
        nodeTaxWr.getNodes().add(nodeTaxWrRate);
        nodeTaxWrRate.setNme(this.getI18n().getMsg("rate", pLang));
        nodeTaxWrRate.setVal((Object)(pIndex + ";rate"));
        Node nodeTaxWrTax = new Node();
        nodeTaxWr.getNodes().add(nodeTaxWrTax);
        nodeTaxWrTax.setNme(this.getI18n().getMsg("tax", pLang));
        nodeTaxWrTax.setNodes(new ArrayList());
        Node nodeTaxWrTaxName = new Node();
        nodeTaxWrTax.getNodes().add(nodeTaxWrTaxName);
        nodeTaxWrTaxName.setNme(this.getI18n().getMsg("nme", pLang));
        nodeTaxWrTaxName.setVal((Object)(pIndex + ";tax,nme"));
        Node nodeTaxWrTaxId = new Node();
        nodeTaxWrTax.getNodes().add(nodeTaxWrTaxId);
        nodeTaxWrTaxId.setNme(this.getI18n().getMsg("iid", pLang));
        nodeTaxWrTaxId.setVal((Object)(pIndex + ";tax,iid"));
        Node nodeTaxWrTaxPercentage = new Node();
        nodeTaxWrTax.getNodes().add(nodeTaxWrTaxPercentage);
        nodeTaxWrTaxPercentage.setNme(this.getI18n().getMsg("rate", pLang));
        nodeTaxWrTaxPercentage.setVal((Object)(pIndex + ";tax,rate"));
    }

    public final void addTaxCatWr(List<Node<String>> pTree, String pIndex, String pName, String pLang) {
        Node nodeTaxCatWr = new Node();
        pTree.add((Node<String>)nodeTaxCatWr);
        nodeTaxCatWr.setNme(pName);
        nodeTaxCatWr.setNodes(new ArrayList());
        Node nodeTaxCatWrUsed = new Node();
        nodeTaxCatWr.getNodes().add(nodeTaxCatWrUsed);
        nodeTaxCatWrUsed.setNme(this.getI18n().getMsg("used", pLang));
        nodeTaxCatWrUsed.setVal((Object)(pIndex + ";used"));
        Node nodeTaxCatWrPercent = new Node();
        nodeTaxCatWr.getNodes().add(nodeTaxCatWrPercent);
        nodeTaxCatWrPercent.setNme(this.getI18n().getMsg("aggrPercent", pLang));
        nodeTaxCatWrPercent.setVal((Object)(pIndex + ";aggrPercent"));
        Node nodeTaxCatWrRate = new Node();
        nodeTaxCatWr.getNodes().add(nodeTaxCatWrRate);
        nodeTaxCatWrRate.setNme(this.getI18n().getMsg("aggrRate", pLang));
        nodeTaxCatWrRate.setVal((Object)(pIndex + ";aggrRate"));
        Node nodeTaxCatWrTaxCat = new Node();
        nodeTaxCatWr.getNodes().add(nodeTaxCatWrTaxCat);
        nodeTaxCatWrTaxCat.setNme(this.getI18n().getMsg("txCt", pLang));
        nodeTaxCatWrTaxCat.setNodes(new ArrayList());
        Node nodeTaxCatWrTaxCatName = new Node();
        nodeTaxCatWrTaxCat.getNodes().add(nodeTaxCatWrTaxCatName);
        nodeTaxCatWrTaxCatName.setNme(this.getI18n().getMsg("nme", pLang));
        nodeTaxCatWrTaxCatName.setVal((Object)(pIndex + ";txCt,nme"));
        Node nodeTaxCatWrTaxCatId = new Node();
        nodeTaxCatWrTaxCat.getNodes().add(nodeTaxCatWrTaxCatId);
        nodeTaxCatWrTaxCatId.setNme(this.getI18n().getMsg("iid", pLang));
        nodeTaxCatWrTaxCatId.setVal((Object)(pIndex + ";txCt,iid"));
    }

    public final WrhItm findRest(Long pItmId, List<WrhItm> pRestList) {
        for (WrhItm wr : pRestList) {
            if (!wr.getItm().getIid().equals(pItmId)) continue;
            return wr;
        }
        return null;
    }

    public final WrhPl findWphp(Long pId, List<WrhPl> pWrhpls) {
        for (WrhPl wp : pWrhpls) {
            if (!wp.getIid().equals(pId)) continue;
            return wp;
        }
        throw new RuntimeException("Place not found - " + pId);
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final I18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(I18n pI18n) {
        this.i18n = pI18n;
    }
}

