/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.srv;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdl.CmprTxCtLnRt;
import org.beigesoft.acc.mdl.ETxTy;
import org.beigesoft.acc.mdlb.AItm;
import org.beigesoft.acc.mdlb.ATxDsLn;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.Curr;
import org.beigesoft.acc.mdlp.DbCr;
import org.beigesoft.acc.mdlp.I18Itm;
import org.beigesoft.acc.mdlp.I18Srv;
import org.beigesoft.acc.mdlp.ItTxDl;
import org.beigesoft.acc.mdlp.Itm;
import org.beigesoft.acc.mdlp.SrTxDl;
import org.beigesoft.acc.mdlp.Srv;
import org.beigesoft.acc.mdlp.Tax;
import org.beigesoft.acc.mdlp.TxCt;
import org.beigesoft.acc.mdlp.TxCtLn;
import org.beigesoft.acc.mdlp.TxDst;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IRecSet;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdlp.UsPrf;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.INumStr;
import org.beigesoft.ws.mdl.EItmTy;
import org.beigesoft.ws.mdl.EPaymMth;
import org.beigesoft.ws.mdlb.AItmPri;
import org.beigesoft.ws.mdlb.ATxLn;
import org.beigesoft.ws.mdlb.IHsSeSel;
import org.beigesoft.ws.mdlp.BurPric;
import org.beigesoft.ws.mdlp.Buyer;
import org.beigesoft.ws.mdlp.Cart;
import org.beigesoft.ws.mdlp.CartItTxLn;
import org.beigesoft.ws.mdlp.CartLn;
import org.beigesoft.ws.mdlp.CartTot;
import org.beigesoft.ws.mdlp.CartTxLn;
import org.beigesoft.ws.mdlp.Deliv;
import org.beigesoft.ws.mdlp.I18SeItm;
import org.beigesoft.ws.mdlp.I18SeSrv;
import org.beigesoft.ws.mdlp.PriItm;
import org.beigesoft.ws.mdlp.PriSrv;
import org.beigesoft.ws.mdlp.SeItm;
import org.beigesoft.ws.mdlp.SeItmPri;
import org.beigesoft.ws.mdlp.SeSel;
import org.beigesoft.ws.mdlp.SeSrv;
import org.beigesoft.ws.mdlp.SeSrvPri;
import org.beigesoft.ws.mdlp.SerTxDl;
import org.beigesoft.ws.mdlp.SitTxDl;
import org.beigesoft.ws.mdlp.TrdStg;
import org.beigesoft.ws.srv.IBuySr;
import org.beigesoft.ws.srv.ISrCart;
import org.beigesoft.ws.srv.ISrTrStg;

public class SrCart<RS>
implements ISrCart {
    private ILog log;
    private IRdb<RS> rdb;
    private IOrm orm;
    private ISrTrStg srTrStg;
    private INumStr numStr;
    private Class<?> pplCl;
    private IBuySr buySr;
    private String quTxInvBas;
    private String quTxInvBasAggr;
    private String quTxItBas;
    private String quTxItBasAggr;
    private String quItemPrice;
    private String quItemSePrice;
    private String quItemPriceCat;
    private String quItemSePriceCat;

    @Override
    public final Cart getCart(Map<String, Object> pRvs, IReqDt pRqDt, boolean pIsNeedToCreate, boolean pIsBuAuth) throws Exception {
        Buyer buyer = null;
        boolean burNew = false;
        HashMap vs = new HashMap();
        if (pIsBuAuth) {
            buyer = this.buySr.getAuthBuyr(pRvs, pRqDt);
        } else {
            buyer = (Buyer)((Object)pRvs.get("buyr"));
            if (buyer == null) {
                buyer = this.buySr.getBuyr(pRvs, pRqDt);
            }
            if (buyer == null && pIsNeedToCreate) {
                buyer = this.buySr.createBuyr(pRvs, pRqDt);
                if (buyer.getIsNew().booleanValue()) {
                    this.getOrm().insIdLn(pRvs, vs, (IHasId)buyer);
                } else {
                    this.getOrm().update(pRvs, vs, (IHasId)buyer);
                }
                pRqDt.setCookVl("cBuyerId", buyer.getIid().toString());
                burNew = true;
            }
        }
        TrdStg ts = this.srTrStg.lazTrStg(pRvs);
        pRvs.put("buyr", (Object)buyer);
        Cart cart = (Cart)((Object)pRvs.get("cart"));
        if (cart == null && buyer != null && !buyer.getIsNew().booleanValue()) {
            cart = this.retrCart(pRvs, buyer, false);
            if (cart == null && pIsNeedToCreate) {
                cart = new Cart();
                Curr curr = (Curr)((Object)pRvs.get("wscurr"));
                cart.setPaym(ts.getPaym());
                cart.setCurr(curr);
                cart.setItems(new ArrayList<CartLn>());
                cart.setTaxes(new ArrayList<CartTxLn>());
                cart.setTotals(new ArrayList<CartTot>());
                cart.setIid(buyer);
                this.getOrm().insIdNln(pRvs, vs, (IHasId)cart);
            } else if (cart != null && burNew) {
                this.emptyCart(pRvs, cart);
            }
            if (cart != null) {
                pRvs.put("cart", (Object)cart);
            }
        }
        if (cart != null) {
            if (EPaymMth.ANY.equals((Object)cart.getPaym()) || EPaymMth.PARTIAL_ONLINE.equals((Object)cart.getPaym()) || EPaymMth.ONLINE.equals((Object)cart.getPaym())) {
                cart.setPaym(EPaymMth.PAY_CASH);
            }
            ArrayList<EPaymMth> payMts = new ArrayList<EPaymMth>();
            pRvs.put("payMts", payMts);
            payMts.add(EPaymMth.PAY_CASH);
            payMts.add(EPaymMth.BANK_TRANSFER);
            payMts.add(EPaymMth.BANK_CHEQUE);
            if (this.pplCl != null) {
                payMts.add(EPaymMth.PAYPAL);
            }
        }
        return cart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mkCartTots(Map<String, Object> pRvs, TrdStg pTs, CartLn pCaLn, AcStg pAs, TxDst pTxRls) throws Exception {
        BigDecimal toTx = BigDecimal.ZERO;
        BigDecimal toTxSe = BigDecimal.ZERO;
        String descr = null;
        HashMap vs = new HashMap();
        if (pTxRls != null) {
            String query;
            descr = "Tax rules: aggregate/invoice basis/zip/RM = " + pTxRls.getStAg() + "/" + pTxRls.getStIb() + "/" + pTxRls.getZip() + "/" + (Object)((Object)pTxRls.getStRm());
            boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 13000);
            if (dbgSh) {
                String txCat = pCaLn.getTxCt() != null ? pCaLn.getTxCt().getNme() : "-";
                this.getLog().debug(pRvs, SrCart.class, "Item: name/tax category/disabled = " + pCaLn.getNme() + "/" + (String)txCat + "/" + pCaLn.getDisab());
            }
            for (CartTxLn ctl : pCaLn.getOwnr().getTaxes()) {
                if (ctl.getDisab().booleanValue() || (ctl.getSelr() != null || pCaLn.getSelr() != null) && (ctl.getSelr() == null || pCaLn.getSelr() == null || !pCaLn.getSelr().getIid().getIid().equals(ctl.getSelr().getIid().getIid()))) continue;
                ctl.setDisab(true);
            }
            ArrayList<CartLn> txdLns = null;
            Object txs = null;
            ArrayList<Double> toTxTaxb = null;
            ArrayList<Double> txPerc = null;
            if (!(pTxRls.getStAg().booleanValue() || pTxRls.getStIb().booleanValue() && !pTs.getTxExcl().booleanValue())) {
                txs = new ArrayList();
                toTxTaxb = new ArrayList<Double>();
                if (!pTxRls.getStIb().booleanValue()) {
                    query = this.lazQuTxItBas();
                } else {
                    txPerc = new ArrayList<Double>();
                    query = this.lazQuTxInvBas();
                }
            } else {
                txdLns = new ArrayList<CartLn>();
                query = pTxRls.getStIb() == false ? this.lazQuTxItBasAggr() : this.lazQuTxInvBasAggr();
            }
            String condSel = pCaLn.getSelr() == null ? " is null" : "=" + pCaLn.getSelr().getIid().getIid();
            query = query.replace(":CARTID", pCaLn.getOwnr().getBuyr().getIid().toString()).replace(":CONDSEL", condSel);
            try (IRecSet rs = null;){
                rs = this.getRdb().retRs(query);
                if (rs.first()) {
                    do {
                        Long txId = rs.getLong("TAXID");
                        String txNm = rs.getStr("TAXNAME");
                        Tax tax = new Tax();
                        tax.setIid(txId);
                        tax.setNme(txNm);
                        if (!(pTxRls.getStAg().booleanValue() || pTxRls.getStIb().booleanValue() && !pTs.getTxExcl().booleanValue())) {
                            txs.add(tax);
                            if (!pTxRls.getStIb().booleanValue()) {
                                toTxTaxb.add(rs.getDouble("TOTALTAX"));
                                continue;
                            }
                            txPerc.add(rs.getDouble("RATE"));
                            toTxTaxb.add(rs.getDouble("SUBT"));
                            continue;
                        }
                        Double percent = rs.getDouble("RATE");
                        Long tcId = rs.getLong("TAXCATID");
                        if (!pTxRls.getStIb().booleanValue()) {
                            Long clId = rs.getLong("CLID");
                            CartLn txdLn = this.mkTxdLn(txdLns, clId, tcId, tax, percent, pAs);
                            txdLn.setToTx(BigDecimal.valueOf(rs.getDouble("TOTX")).setScale((int)pAs.getPrDp(), RoundingMode.HALF_UP));
                            continue;
                        }
                        CartLn txdLn = this.mkTxdLn(txdLns, tcId, tcId, tax, percent, pAs);
                        txdLn.setTot(BigDecimal.valueOf(rs.getDouble("TOT")).setScale((int)pAs.getPrDp(), RoundingMode.HALF_UP));
                        txdLn.setSubt(BigDecimal.valueOf(rs.getDouble("SUBT")).setScale((int)pAs.getPrDp(), RoundingMode.HALF_UP));
                    } while (rs.next());
                }
            }
            if (!(pTxRls.getStAg().booleanValue() || pTxRls.getStIb().booleanValue() && !pTs.getTxExcl().booleanValue())) {
                for (int i = 0; i < txs.size(); ++i) {
                    Double toTxd;
                    CartTxLn ctl = this.fndCreTxLn(pRvs, pCaLn.getOwnr(), (Tax)txs.get(i), pCaLn.getSelr(), false);
                    if (!pTxRls.getStIb().booleanValue()) {
                        toTxd = (Double)toTxTaxb.get(i);
                    } else {
                        toTxd = (Double)toTxTaxb.get(i) * (Double)txPerc.get(i) / 100.0;
                        ctl.setTxb(BigDecimal.valueOf((Double)toTxTaxb.get(i)));
                    }
                    ctl.setTot(BigDecimal.valueOf(toTxd).setScale((int)pAs.getPrDp(), pTxRls.getStRm()));
                    if (ctl.getIsNew().booleanValue()) {
                        this.getOrm().insIdLn(pRvs, vs, (IHasId)ctl);
                        continue;
                    }
                    this.getOrm().update(pRvs, vs, (IHasId)ctl);
                }
            } else {
                BigDecimal bd100 = new BigDecimal("100.00");
                Comparator<TxCtLn> cmpr = Collections.reverseOrder(new CmprTxCtLnRt());
                for (CartLn txdLn : txdLns) {
                    int ti = 0;
                    BigDecimal txAgr = null;
                    BigDecimal txAgrAcm = BigDecimal.ZERO;
                    Collections.sort(txdLn.getTxCt().getTxs(), cmpr);
                    for (TxCtLn itcl : txdLn.getTxCt().getTxs()) {
                        ++ti;
                        if (txAgr == null) {
                            txAgr = pTxRls.getStIb().booleanValue() ? (!pTs.getTxExcl().booleanValue() ? txdLn.getTot().subtract(txdLn.getTot().divide(BigDecimal.ONE.add(txdLn.getTxCt().getAgRt().divide(bd100, 15, RoundingMode.HALF_UP)), (int)pAs.getPrDp(), pTxRls.getStRm())) : txdLn.getSubt().multiply(txdLn.getTxCt().getAgRt()).divide(bd100, (int)pAs.getPrDp(), pTxRls.getStRm())) : txdLn.getToTx();
                        }
                        if (ti < txdLn.getTxCt().getTxs().size()) {
                            txdLn.setToTx(txAgr.multiply(itcl.getRate()).divide(txdLn.getTxCt().getAgRt(), (int)pAs.getPrDp(), pTxRls.getStRm()));
                            txAgrAcm = txAgrAcm.add(txdLn.getToTx());
                        } else {
                            txdLn.setToTx(txAgr.subtract(txAgrAcm));
                        }
                        CartTxLn ctl = this.fndCreTxLn(pRvs, pCaLn.getOwnr(), itcl.getTax(), pCaLn.getSelr(), true);
                        ctl.setTot(ctl.getTot().add(txdLn.getToTx()));
                        if (pTxRls.getStIb().booleanValue()) {
                            if (pTs.getTxExcl().booleanValue()) {
                                ctl.setTxb(ctl.getTxb().add(txdLn.getSubt()));
                            } else {
                                ctl.setTxb(ctl.getTxb().add(txdLn.getTot()));
                            }
                        }
                        if (ctl.getIsNew().booleanValue()) {
                            this.getOrm().insIdLn(pRvs, vs, (IHasId)ctl);
                            continue;
                        }
                        this.getOrm().update(pRvs, vs, (IHasId)ctl);
                    }
                }
            }
            for (CartTxLn ctl : pCaLn.getOwnr().getTaxes()) {
                if (!ctl.getDisab().booleanValue()) {
                    if (ctl.getSelr() == null && pCaLn.getSelr() == null || ctl.getSelr() != null && pCaLn.getSelr() != null && pCaLn.getSelr().getIid().getIid().equals(ctl.getSelr().getIid().getIid())) {
                        toTxSe = toTxSe.add(ctl.getTot());
                    }
                    toTx = toTx.add(ctl.getTot());
                    continue;
                }
                if ((ctl.getSelr() != null || pCaLn.getSelr() != null) && (ctl.getSelr() == null || pCaLn.getSelr() == null || !pCaLn.getSelr().getIid().getIid().equals(ctl.getSelr().getIid().getIid()))) continue;
                this.getOrm().update(pRvs, vs, (IHasId)ctl);
            }
        }
        BigDecimal tot = BigDecimal.ZERO;
        BigDecimal totSe = BigDecimal.ZERO;
        for (CartLn cl : pCaLn.getOwnr().getItems()) {
            if (cl.getDisab().booleanValue()) continue;
            if (cl.getSelr() == null && pCaLn.getSelr() == null || cl.getSelr() != null && pCaLn.getSelr() != null && pCaLn.getSelr().getIid().getIid().equals(cl.getSelr().getIid().getIid())) {
                totSe = totSe.add(cl.getTot());
            }
            tot = tot.add(cl.getTot());
        }
        pCaLn.getOwnr().setToTx(toTx);
        pCaLn.getOwnr().setSubt(tot.subtract(toTx));
        pCaLn.getOwnr().setTot(tot);
        pCaLn.getOwnr().setDscr(descr);
        this.getOrm().update(pRvs, vs, (IHasId)pCaLn.getOwnr());
        CartTot cartTot = null;
        for (CartTot ct : pCaLn.getOwnr().getTotals()) {
            if (ct.getDisab().booleanValue() || (ct.getSelr() != null || pCaLn.getSelr() != null) && (ct.getSelr() == null || pCaLn.getSelr() == null || !pCaLn.getSelr().getIid().getIid().equals(ct.getSelr().getIid().getIid()))) continue;
            cartTot = ct;
            break;
        }
        if (totSe.compareTo(BigDecimal.ZERO) == 0 && cartTot != null) {
            cartTot.setDisab(true);
            this.getOrm().update(pRvs, vs, (IHasId)cartTot);
        } else if (totSe.compareTo(BigDecimal.ZERO) == 1) {
            if (cartTot == null) {
                for (CartTot ct : pCaLn.getOwnr().getTotals()) {
                    if (!ct.getDisab().booleanValue()) continue;
                    cartTot = ct;
                    cartTot.setDisab(false);
                    break;
                }
            }
            if (cartTot == null) {
                cartTot = new CartTot();
                cartTot.setOwnr(pCaLn.getOwnr());
                cartTot.setIsNew(true);
            }
            cartTot.setSelr(pCaLn.getSelr());
            cartTot.setToTx(toTxSe);
            cartTot.setSubt(totSe.subtract(toTxSe));
            cartTot.setTot(totSe);
            if (cartTot.getIsNew().booleanValue()) {
                this.getOrm().insIdLn(pRvs, vs, (IHasId)cartTot);
            } else {
                this.getOrm().update(pRvs, vs, (IHasId)cartTot);
            }
        }
    }

    @Override
    public final TxDst revTxRules(Map<String, Object> pRvs, Cart pCart, AcStg pAs) throws Exception {
        if (pCart.getBuyr().getCust() == null) {
            pCart.getBuyr().setCust(new DbCr());
            pCart.getBuyr().getCust().setZip(pCart.getBuyr().getZip());
            pCart.getBuyr().getCust().setTxDs(pCart.getBuyr().getTxDs());
        }
        TxDst txRules = null;
        if (pAs.getStExs().booleanValue() && !pCart.getBuyr().getFrgn().booleanValue()) {
            if (pCart.getBuyr().getCust().getTxDs() != null) {
                txRules = pCart.getBuyr().getCust().getTxDs();
            } else {
                txRules = new TxDst();
                txRules.setStIb(pAs.getStIb());
                txRules.setStAg(pAs.getStAg());
                txRules.setStRm(pAs.getStRm());
            }
        }
        return txRules;
    }

    @Override
    public final void hndCurrChg(Map<String, Object> pRvs, Cart pCart, AcStg pAs, TrdStg pTs) throws Exception {
        TxDst txRules = this.revTxRules(pRvs, pCart, pAs);
        CartLn clf = null;
        for (CartLn cl : pCart.getItems()) {
            if (cl.getDisab().booleanValue()) continue;
            if (cl.getForc().booleanValue()) {
                clf = cl;
                this.delLine(pRvs, cl, txRules);
                continue;
            }
            this.mkLine(pRvs, cl, pAs, pTs, txRules, true, true);
            this.mkCartTots(pRvs, pTs, cl, pAs, txRules);
        }
        if (clf != null) {
            this.hndCartChg(pRvs, pCart, txRules);
        }
    }

    @Override
    public final void delLine(Map<String, Object> pRvs, CartLn pCaLn, TxDst pTxRls) throws Exception {
        Object[] ndFds = new String[]{"ver", "disab"};
        Arrays.sort(ndFds);
        HashMap<String, Object> vs = new HashMap<String, Object>();
        vs.put("ndFds", ndFds);
        pCaLn.setDisab(true);
        this.getOrm().update(pRvs, vs, (IHasId)pCaLn);
        if (pTxRls != null && pCaLn.getTxCt() != null && !pTxRls.getStIb().booleanValue() && !pTxRls.getStAg().booleanValue()) {
            vs.put("CartLndpLv", 0);
            List itls = this.getOrm().retLstCnd(pRvs, vs, CartItTxLn.class, "where DISAB=0 and OWNR=" + pCaLn.getIid());
            for (CartItTxLn itl : itls) {
                if (itl.getDisab().booleanValue() || !itl.getOwnr().getIid().equals(pCaLn.getIid())) continue;
                itl.setDisab(true);
                this.getOrm().update(pRvs, vs, (IHasId)itl);
            }
        }
        vs.clear();
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        TrdStg ts = (TrdStg)((Object)pRvs.get("tstg"));
        this.mkCartTots(pRvs, ts, pCaLn, as, pTxRls);
    }

    @Override
    public final void hndCartChg(Map<String, Object> pRvs, Cart pCart, TxDst pTxRls) throws Exception {
        int cartTot;
        List dlvMts = (List)pRvs.get("dlvMts");
        Deliv cdl = null;
        for (Deliv dl : dlvMts) {
            if (!dl.getIid().equals((Object)pCart.getDelv())) continue;
            cdl = dl;
            break;
        }
        if (cdl == null) {
            throw new Exception("wrong delivering!");
        }
        boolean crtEmpty = true;
        CartLn clFrc = null;
        CartLn clEm = null;
        for (CartLn cl : pCart.getItems()) {
            if (cl.getDisab().booleanValue()) {
                clEm = cl;
                continue;
            }
            if (!cl.getDisab().booleanValue() && cl.getForc().booleanValue()) {
                clFrc = cl;
                continue;
            }
            if (cl.getDisab().booleanValue() || cl.getForc().booleanValue()) continue;
            crtEmpty = false;
        }
        if (clFrc == null && cdl.getFrcSr() == null || cdl.getApMt() == null) {
            return;
        }
        if (crtEmpty) {
            if (clFrc != null) {
                this.delLine(pRvs, clFrc, pTxRls);
            }
            return;
        }
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        TrdStg ts = (TrdStg)((Object)pRvs.get("tstg"));
        BigDecimal ct = pCart.getTot();
        if (clFrc != null && clFrc.getTot().compareTo(BigDecimal.ZERO) == 1) {
            ct = ct.subtract(clFrc.getTot());
        }
        if ((cartTot = pCart.getExRt().compareTo(BigDecimal.ONE) == 0 ? ct.intValue() : ct.divide(pCart.getExRt(), (int)as.getPrDp(), as.getRndm()).intValue()) >= cdl.getApMt()) {
            if (clFrc != null && clFrc.getTot().compareTo(BigDecimal.ZERO) == 1) {
                clFrc.setPri(BigDecimal.ZERO);
                clFrc.setTot(BigDecimal.ZERO);
                clFrc.setToTx(BigDecimal.ZERO);
                clFrc.setSubt(BigDecimal.ZERO);
                clFrc.setTdsc(null);
                clFrc.setTxCt(null);
                HashMap vs = new HashMap();
                this.orm.update(pRvs, vs, (IHasId)clFrc);
                this.mkCartTots(pRvs, ts, clFrc, as, pTxRls);
            }
        } else if (clFrc == null) {
            if (clEm == null) {
                clFrc = new CartLn();
                clFrc.setIsNew(true);
                clFrc.setOwnr(pCart);
                pCart.getItems().add(clFrc);
            } else {
                clFrc = clEm;
            }
            clFrc.setSelr(null);
            clFrc.setForc(true);
            clFrc.setDisab(false);
            clFrc.setItTyp(EItmTy.SERVICE);
            clFrc.setItId(cdl.getFrcSr().getIid());
            clFrc.setNme(cdl.getFrcSr().getNme());
            clFrc.setUom(cdl.getFrcSr().getDuom());
            clFrc.setAvQuan(BigDecimal.ONE);
            clFrc.setQuan(BigDecimal.ONE);
            clFrc.setUnSt(BigDecimal.ONE);
            this.mkLine(pRvs, clFrc, as, ts, pTxRls, true, true);
            this.mkCartTots(pRvs, ts, clFrc, as, pTxRls);
        } else if (clFrc.getTot().compareTo(BigDecimal.ZERO) == 0) {
            this.mkLine(pRvs, clFrc, as, ts, pTxRls, true, true);
            this.mkCartTots(pRvs, ts, clFrc, as, pTxRls);
        }
    }

    @Override
    public final void mkLine(Map<String, Object> pRvs, CartLn pCaLn, AcStg pAs, TrdStg pTs, TxDst pTxRls, boolean pRedoPr, boolean pRedoTxc) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        AItmPri<?, ?> itPri = null;
        if (pRedoPr || pRedoTxc) {
            itPri = this.revItmPri(pRvs, pTs, pCaLn.getOwnr().getBuyr(), pCaLn.getItTyp(), pCaLn.getItId());
            if (pCaLn.getItTyp().equals((Object)EItmTy.SESERVICE) || pCaLn.getItTyp().equals((Object)EItmTy.SEGOODS)) {
                IHsSeSel seItPr = (IHsSeSel)((Object)itPri);
                pCaLn.setSelr(seItPr.getSelr());
            }
            pCaLn.setPri(itPri.getPri());
            pCaLn.setNme(itPri.getItm().getNme());
            BigDecimal qosr = pCaLn.getQuan().remainder(itPri.getUnSt());
            if (qosr.compareTo(BigDecimal.ZERO) != 0) {
                pCaLn.setQuan(pCaLn.getQuan().subtract(qosr));
            }
            List currRts = (List)pRvs.get("currRts");
            for (Object cr : currRts) {
                if (!cr.getCurr().getIid().equals(pCaLn.getOwnr().getCurr().getIid())) continue;
                BigDecimal exchRate = cr.getExRt();
                if (exchRate.compareTo(BigDecimal.ZERO) == -1) {
                    exchRate = BigDecimal.ONE.divide(exchRate.negate(), 15, RoundingMode.HALF_UP);
                }
                pCaLn.getOwnr().setExRt(exchRate);
                pCaLn.setPri(pCaLn.getPri().multiply(exchRate).setScale((int)pAs.getPrDp(), pAs.getRndm()));
                break;
            }
            BigDecimal amount = pCaLn.getPri().multiply(pCaLn.getQuan()).setScale((int)pAs.getPrDp(), pAs.getRndm());
            if (pTs.getTxExcl().booleanValue()) {
                pCaLn.setSubt(amount);
            } else {
                pCaLn.setTot(amount);
            }
        }
        if (pRedoTxc && pTxRls != null) {
            AItm item = (AItm)((Object)itPri.getItm());
            pCaLn.setTxCt(item.getTxCt());
            if (pTs.getUtxds().booleanValue() && pCaLn.getOwnr().getBuyr().getCust().getTxDs() != null) {
                Class dstTxItLnCl = pCaLn.getItTyp().equals((Object)EItmTy.GOODS) ? ItTxDl.class : (pCaLn.getItTyp().equals((Object)EItmTy.SERVICE) ? SrTxDl.class : (pCaLn.getItTyp().equals((Object)EItmTy.SESERVICE) ? SerTxDl.class : SitTxDl.class));
                vs.put(((Object)((Object)item)).getClass().getSimpleName() + "dpLv", 1);
                List dtls = this.getOrm().retLstCnd(pRvs, vs, dstTxItLnCl, "where OWNR=" + pCaLn.getItId());
                vs.clear();
                for (ATxDsLn dtl : dtls) {
                    if (!dtl.getTxDs().getIid().equals(pCaLn.getOwnr().getBuyr().getCust().getTxDs().getIid())) continue;
                    pCaLn.setTxCt(dtl.getTxCt());
                    break;
                }
            }
        }
        BigDecimal toTxs = BigDecimal.ZERO;
        ArrayList<CartItTxLn> itls = null;
        UsPrf upf = (UsPrf)pRvs.get("upf");
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        if (pTxRls != null && pCaLn.getTxCt() != null) {
            if (!pTxRls.getStIb().booleanValue()) {
                BigDecimal bd100 = new BigDecimal("100.00");
                if (!pTxRls.getStAg().booleanValue()) {
                    itls = new ArrayList<CartItTxLn>();
                    vs.put("TxCtdpLv", 1);
                    Iterator itcls = this.getOrm().retLstCnd(pRvs, vs, TxCtLn.class, "where OWNR=" + pCaLn.getTxCt().getIid() + " order by TXCTLN.RATE");
                    vs.clear();
                    BigDecimal taxTot = null;
                    BigDecimal taxRest = null;
                    if (!pTs.getTxExcl().booleanValue()) {
                        taxRest = taxTot = pCaLn.getTot().subtract(pCaLn.getTot().divide(BigDecimal.ONE.add(pCaLn.getTxCt().getAgRt().divide(bd100, 15, RoundingMode.HALF_UP)), (int)pAs.getPrDp(), pTxRls.getStRm()));
                    }
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    Iterator iterator = itcls.iterator();
                    while (iterator.hasNext()) {
                        BigDecimal addTx;
                        TxCtLn itcl = (TxCtLn)((Object)iterator.next());
                        if (!ETxTy.TSALES.equals((Object)itcl.getTax().getTyp())) continue;
                        if (i++ > 0) {
                            sb.append(", ");
                        }
                        CartItTxLn itl = new CartItTxLn();
                        itl.setIsNew(true);
                        itl.setTax(itcl.getTax());
                        itls.add(itl);
                        if (!pTs.getTxExcl().booleanValue()) {
                            if (i < itcls.size()) {
                                addTx = taxTot.multiply(itcl.getRate()).divide(pCaLn.getTxCt().getAgRt(), (int)pAs.getPrDp(), pTxRls.getStRm());
                                taxRest = taxRest.subtract(addTx);
                            } else {
                                addTx = taxRest;
                            }
                        } else {
                            addTx = pCaLn.getSubt().multiply(itcl.getRate()).divide(bd100, (int)pAs.getPrDp(), pTxRls.getStRm());
                        }
                        toTxs = toTxs.add(addTx);
                        itl.setTot(addTx);
                        sb.append(itl.getTax().getNme() + " " + this.prn(pAs, cpf, upf, addTx));
                    }
                    pCaLn.setTdsc(sb.toString());
                } else {
                    toTxs = pTs.getTxExcl() == false ? pCaLn.getTot().subtract(pCaLn.getTot().divide(BigDecimal.ONE.add(pCaLn.getTxCt().getAgRt().divide(bd100, 15, RoundingMode.HALF_UP)), (int)pAs.getPrDp(), pTxRls.getStRm())) : pCaLn.getSubt().multiply(pCaLn.getTxCt().getAgRt()).divide(bd100, (int)pAs.getPrDp(), pTxRls.getStRm());
                    pCaLn.setTdsc(pCaLn.getTxCt().getNme());
                }
            } else {
                pCaLn.setTdsc(pCaLn.getTxCt().getNme());
            }
        }
        pCaLn.setToTx(toTxs);
        if (pTs.getTxExcl().booleanValue()) {
            pCaLn.setTot(pCaLn.getSubt().add(pCaLn.getToTx()));
        } else {
            pCaLn.setSubt(pCaLn.getTot().subtract(pCaLn.getToTx()));
        }
        if (pCaLn.getIsNew().booleanValue()) {
            this.getOrm().insIdLn(pRvs, vs, (IHasId)pCaLn);
        } else {
            this.getOrm().update(pRvs, vs, (IHasId)pCaLn);
        }
        if (itls != null) {
            vs.put("CartLndpLv", 0);
            List itlsr = this.getOrm().retLstCnd(pRvs, vs, CartItTxLn.class, "where CARTID=" + pCaLn.getOwnr().getBuyr().getIid());
            vs.clear();
            for (CartItTxLn itlrt : itlsr) {
                if (itlrt.getDisab().booleanValue() || !itlrt.getOwnr().getIid().equals(pCaLn.getIid())) continue;
                itlrt.setDisab(true);
            }
            for (CartItTxLn itl : itls) {
                ATxLn itlr = null;
                for (CartItTxLn itlrt : itlsr) {
                    if (!itlrt.getDisab().booleanValue()) continue;
                    itlr = itlrt;
                    ((CartItTxLn)itlr).setDisab(false);
                    break;
                }
                if (itlr == null) {
                    itl.setOwnr(pCaLn);
                    if (pCaLn.getSelr() != null) {
                        itl.setSelId(pCaLn.getSelr().getIid().getIid());
                    }
                    itl.setCartId(pCaLn.getOwnr().getBuyr().getIid());
                    itl.setOwnr(pCaLn);
                    this.getOrm().insIdLn(pRvs, vs, (IHasId)itl);
                    continue;
                }
                itlr.setTax(itl.getTax());
                itlr.setTot(itl.getTot());
                ((CartItTxLn)itlr).setOwnr(pCaLn);
                if (pCaLn.getSelr() == null) {
                    ((CartItTxLn)itlr).setSelId(null);
                } else {
                    ((CartItTxLn)itlr).setSelId(pCaLn.getSelr().getIid().getIid());
                }
                ((CartItTxLn)itlr).setCartId(pCaLn.getOwnr().getBuyr().getIid());
                this.getOrm().update(pRvs, vs, (IHasId)itlr);
            }
            Object[] ndFds = new String[]{"ver", "disab"};
            Arrays.sort(ndFds);
            vs.put("ndFds", ndFds);
            for (CartItTxLn itlrt : itlsr) {
                if (!itlrt.getDisab().booleanValue() || !itlrt.getOwnr().getIid().equals(pCaLn.getIid())) continue;
                this.getOrm().update(pRvs, vs, (IHasId)itlrt);
            }
        }
    }

    @Override
    public final AItmPri<?, ?> revItmPri(Map<String, Object> pRvs, TrdStg pTs, Buyer pBuyr, EItmTy pItType, Long pItId) throws Exception {
        String query;
        Object[] ndFlIt;
        Class itPriCl;
        Class itemI18Cl;
        Class itemCl;
        UsPrf upf = (UsPrf)pRvs.get("upf");
        String lang = upf.getLng().getIid();
        AItmPri itPri = null;
        if (pItType.equals((Object)EItmTy.GOODS)) {
            itemCl = Itm.class;
            itemI18Cl = I18Itm.class;
            itPriCl = PriItm.class;
        } else if (pItType.equals((Object)EItmTy.SERVICE)) {
            itemCl = Srv.class;
            itemI18Cl = I18Srv.class;
            itPriCl = PriSrv.class;
        } else if (pItType.equals((Object)EItmTy.SESERVICE)) {
            itemCl = SeSrv.class;
            itemI18Cl = I18SeSrv.class;
            itPriCl = SeSrvPri.class;
        } else {
            itemCl = SeItm.class;
            itemI18Cl = I18SeItm.class;
            itPriCl = SeItmPri.class;
        }
        HashMap<String, Object> vs = new HashMap<String, Object>();
        Object[] ndFlItPr = new String[]{"pri", "unSt"};
        Arrays.sort(ndFlItPr);
        vs.put(itPriCl.getSimpleName() + "ndFds", ndFlItPr);
        vs.put("PriCtdpLv", 0);
        if (pItType.equals((Object)EItmTy.SEGOODS) || pItType.equals((Object)EItmTy.SESERVICE)) {
            ndFlIt = new String[]{"nme", "txCt", "selr"};
            vs.put("SeSelndFds", new String[]{"dbcr"});
            vs.put("DbCrndFds", new String[]{"nme"});
            vs.put("SeSeldpLv", 3);
        } else {
            ndFlIt = new String[]{"nme", "txCt"};
        }
        Arrays.sort(ndFlIt);
        vs.put(itemCl.getSimpleName() + "ndFds", ndFlIt);
        Object[] ndFlTc = new String[]{"nme", "agRt"};
        Arrays.sort(ndFlTc);
        vs.put("TxCtndFds", ndFlTc);
        vs.put(itemCl.getSimpleName() + "dpLv", 3);
        if (pTs.getPriCus().booleanValue() && pBuyr != null && !pBuyr.getIsNew().booleanValue()) {
            List buyerPrCats = this.getOrm().retLstCnd(pRvs, vs, BurPric.class, "where BUYR=" + pBuyr.getIid());
            if (buyerPrCats.size() > 1) {
                this.log.error(pRvs, SrCart.class, "Several price category for same buyer! buyer ID=" + pBuyr.getIid());
                throw new ExcCode(1002, "several_price_category_for_same_buyer");
            }
            if (buyerPrCats.size() == 1) {
                if (pTs.getAi18n().booleanValue()) {
                    if (pItType.equals((Object)EItmTy.GOODS) || pItType.equals((Object)EItmTy.SERVICE)) {
                        query = this.lazQuItemPriceCat();
                        query = pItType.equals((Object)EItmTy.GOODS) ? query.replace(":TXCTAL", "TXCT27") : query.replace(":TXCTAL", "TXCT24");
                    } else {
                        query = this.lazQuItemSePriceCat();
                    }
                    query = query.replace(":ITMID", pItId.toString());
                    query = query.replace(":LNG", lang);
                    query = query.replace(":TITMPRI", itPriCl.getSimpleName().toUpperCase());
                    query = query.replace(":TITM", itemCl.getSimpleName().toUpperCase());
                    query = query.replace(":TI18ITM", itemI18Cl.getSimpleName().toUpperCase());
                    StringBuffer pccnd = new StringBuffer("");
                    pccnd.append("=" + ((BurPric)((Object)buyerPrCats.get(0))).getPriCt().getIid());
                    query = query.replace(":PRCATIDCOND", pccnd);
                    itPri = (AItmPri)this.getOrm().retEntQu(pRvs, vs, itPriCl, query);
                }
                itPri = (AItmPri)this.getOrm().retEntCnd(pRvs, vs, itPriCl, "PRICT=" + ((BurPric)((Object)buyerPrCats.get(0))).getPriCt().getIid() + " and ITM=" + pItId);
            }
        }
        if (itPri == null) {
            List itPris;
            if (pTs.getAi18n().booleanValue()) {
                if (pItType.equals((Object)EItmTy.GOODS) || pItType.equals((Object)EItmTy.SERVICE)) {
                    query = this.lazQuItemPrice();
                    query = pItType.equals((Object)EItmTy.GOODS) ? query.replace(":TXCTAL", "TXCT27") : query.replace(":TXCTAL", "TXCT24");
                } else {
                    query = this.lazQuItemSePrice();
                }
                query = query.replace(":ITMID", pItId.toString());
                query = query.replace(":PRICTID", pTs.getPrCtb().getIid().toString());
                query = query.replace(":LNG", lang);
                query = query.replace(":TITMPRI", itPriCl.getSimpleName().toUpperCase());
                query = query.replace(":TITM", itemCl.getSimpleName().toUpperCase());
                query = query.replace(":TI18ITM", itemI18Cl.getSimpleName().toUpperCase());
                itPris = this.getOrm().retLstQu(pRvs, vs, itPriCl, query);
            } else {
                itPris = this.getOrm().retLstCnd(pRvs, vs, itPriCl, "where ITM=" + pItId + " and PRICT=" + pTs.getPrCtb().getIid());
            }
            if (itPris.size() == 0) {
                throw new ExcCode(1001, "requested item has no price");
            }
            if (itPris.size() > 1) {
                throw new ExcCode(1001, "requested item has several prices");
            }
            itPri = (AItmPri)((Object)itPris.get(0));
        }
        return itPri;
    }

    @Override
    public final void emptyCart(Map<String, Object> pRvs, Buyer pBuyr) throws Exception {
        Cart cart = this.retrCart(pRvs, pBuyr, true);
        if (cart != null) {
            this.emptyCart(pRvs, cart);
        }
    }

    public final void emptyCart(Map<String, Object> pRvs, Cart pCart) throws Exception {
        HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
        Object[] ndFds = new String[]{"ver", "disab"};
        Arrays.sort(ndFds);
        vs.put("ndFds", ndFds);
        for (CartLn cartLn : pCart.getItems()) {
            if (cartLn.getDisab().booleanValue()) continue;
            cartLn.setDisab(true);
            this.getOrm().update(pRvs, vs, (IHasId)cartLn);
        }
        for (CartTxLn cartTxLn : pCart.getTaxes()) {
            if (cartTxLn.getDisab().booleanValue()) continue;
            cartTxLn.setDisab(true);
            this.getOrm().update(pRvs, vs, (IHasId)cartTxLn);
        }
        for (CartTot cartTot : pCart.getTotals()) {
            if (cartTot.getDisab().booleanValue()) continue;
            cartTot.setDisab(true);
            this.getOrm().update(pRvs, vs, (IHasId)cartTot);
        }
        if (pCart.getTot().compareTo(BigDecimal.ZERO) == 1) {
            vs.clear();
            ndFds = new String[]{"ver", "tot"};
            Arrays.sort(ndFds);
            vs.put("ndFds", ndFds);
            pCart.setTot(BigDecimal.ZERO);
            this.getOrm().update(pRvs, vs, (IHasId)pCart);
        }
    }

    public final Cart retrCart(Map<String, Object> pRvs, Buyer pBuyr, boolean pForEmpty) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        Cart cart = new Cart();
        cart.setIid(pBuyr);
        this.getOrm().refrEnt(pRvs, vs, (IHasId)cart);
        if (cart.getIid() != null) {
            String[] ndFlDe = new String[]{"ver"};
            String[] ndFlNm = new String[]{"nme"};
            String[] ndFlDc = new String[]{"selr"};
            if (!pForEmpty) {
                vs.put("UomndFds", ndFlNm);
                vs.put("DbCrndFds", ndFlNm);
                vs.put("SeSelndFds", ndFlDc);
                vs.put("TxCtdpLv", 1);
                vs.put("SeSeldpLv", 3);
                vs.put("CartdpLv", 1);
            } else {
                vs.put("CartLnndFds", ndFlDe);
            }
            cart.setItems(this.getOrm().retLstCnd(pRvs, vs, CartLn.class, "where OWNR=" + cart.getBuyr().getIid()));
            vs.clear();
            for (CartLn clt : cart.getItems()) {
                clt.setOwnr(cart);
            }
            if (!pForEmpty) {
                vs.put("TaxndFds", ndFlNm);
                vs.put("SeSeldpLv", 4);
                vs.put("CartdpLv", 1);
            } else {
                vs.put("CartTxLnndFds", ndFlDe);
            }
            cart.setTaxes(this.getOrm().retLstCnd(pRvs, vs, CartTxLn.class, "where OWNR=" + cart.getBuyr().getIid()));
            vs.clear();
            for (CartTxLn ctl : cart.getTaxes()) {
                ctl.setOwnr(cart);
            }
            if (!pForEmpty) {
                vs.put("SeSeldpLv", 4);
                vs.put("CartdpLv", 1);
            } else {
                vs.put("CartTotndFds", ndFlDe);
            }
            cart.setTotals(this.getOrm().retLstCnd(pRvs, vs, CartTot.class, "where OWNR=" + cart.getBuyr().getIid()));
            vs.clear();
            for (CartTot cttl : cart.getTotals()) {
                cttl.setOwnr(cart);
            }
            cart.setBuyr(pBuyr);
        } else {
            cart = null;
        }
        return cart;
    }

    public final CartLn mkTxdLn(List<CartLn> pTxdLns, Long pTdlId, Long pCatId, Tax pTax, Double pRate, AcStg pAs) {
        CartLn txdLn = null;
        for (CartLn tdl : pTxdLns) {
            if (!tdl.getIid().equals(pTdlId)) continue;
            txdLn = tdl;
        }
        if (txdLn == null) {
            txdLn = new CartLn();
            txdLn.setIid(pTdlId);
            TxCt tc = new TxCt();
            tc.setIid(pCatId);
            tc.setTxs(new ArrayList<TxCtLn>());
            txdLn.setTxCt(tc);
            pTxdLns.add(txdLn);
        }
        TxCtLn itcl = new TxCtLn();
        itcl.setTax(pTax);
        itcl.setRate(BigDecimal.valueOf(pRate).setScale((int)pAs.getTxDp(), RoundingMode.HALF_UP));
        txdLn.getTxCt().getTxs().add(itcl);
        txdLn.getTxCt().setAgRt(txdLn.getTxCt().getAgRt().add(itcl.getRate()));
        return txdLn;
    }

    public final CartTxLn fndCreTxLn(Map<String, Object> pRvs, Cart pCart, Tax pTax, SeSel pSeller, boolean pNeedFind) throws Exception {
        CartTxLn ctl = null;
        for (CartTxLn tl : pCart.getTaxes()) {
            if (tl.getDisab().booleanValue() || !tl.getTax().getIid().equals(pTax.getIid()) || (pSeller != null || tl.getSelr() != null) && (pSeller == null || tl.getSelr() == null || !pSeller.getIid().getIid().equals(tl.getSelr().getIid().getIid()))) continue;
            if (!pNeedFind) {
                throw new Exception("Algorithm error!!!");
            }
            ctl = tl;
            break;
        }
        if (ctl == null) {
            for (CartTxLn tl : pCart.getTaxes()) {
                if (!tl.getDisab().booleanValue()) continue;
                ctl = tl;
                ctl.setDisab(false);
                ctl.setTot(BigDecimal.ZERO);
                ctl.setTxb(BigDecimal.ZERO);
                ctl.setTax(pTax);
                ctl.setSelr(pSeller);
                break;
            }
        }
        if (ctl == null) {
            ctl = new CartTxLn();
            ctl.setOwnr(pCart);
            ctl.setIsNew(true);
            ctl.setTax(pTax);
            ctl.setSelr(pSeller);
            pCart.getTaxes().add(ctl);
        }
        return ctl;
    }

    public final Buyer createBuyer(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        HashMap vs = new HashMap();
        Buyer buyer = null;
        List brs = this.getOrm().retLstCnd(pRvs, vs, Buyer.class, "where FRE=1 and PWD is null");
        if (brs.size() > 0) {
            double rd = Math.random();
            buyer = rd > 0.5 ? (Buyer)((Object)brs.get(brs.size() - 1)) : (Buyer)((Object)brs.get(0));
            buyer.setFre(false);
            this.getOrm().update(pRvs, vs, (IHasId)buyer);
        }
        if (buyer == null) {
            buyer = new Buyer();
            buyer.setIsNew(true);
            buyer.setNme("newbe" + new Date().getTime());
            this.getOrm().insIdLn(pRvs, vs, (IHasId)buyer);
        }
        return buyer;
    }

    public final String lazQuTxInvBas() throws IOException {
        if (this.quTxInvBas == null) {
            this.quTxInvBas = this.loadString("/ws/cartTxInvBas.sql");
        }
        return this.quTxInvBas;
    }

    public final String lazQuTxInvBasAggr() throws IOException {
        if (this.quTxInvBasAggr == null) {
            this.quTxInvBasAggr = this.loadString("/ws/cartTxInvBasAggr.sql");
        }
        return this.quTxInvBasAggr;
    }

    public final String lazQuTxItBas() throws IOException {
        if (this.quTxItBas == null) {
            this.quTxItBas = this.loadString("/ws/cartTxItBas.sql");
        }
        return this.quTxItBas;
    }

    public final String lazQuTxItBasAggr() throws IOException {
        if (this.quTxItBasAggr == null) {
            this.quTxItBasAggr = this.loadString("/ws/cartTxItBasAggr.sql");
        }
        return this.quTxItBasAggr;
    }

    public final String lazQuItemPrice() throws IOException {
        if (this.quItemPrice == null) {
            this.quItemPrice = this.loadString("/ws/itemPrice.sql");
        }
        return this.quItemPrice;
    }

    public final String lazQuItemSePrice() throws IOException {
        if (this.quItemSePrice == null) {
            this.quItemSePrice = this.loadString("/ws/itemSePrice.sql");
        }
        return this.quItemSePrice;
    }

    public final String lazQuItemPriceCat() throws IOException {
        if (this.quItemPriceCat == null) {
            this.quItemPriceCat = this.loadString("/ws/itemPriceCat.sql");
        }
        return this.quItemPriceCat;
    }

    public final String lazQuItemSePriceCat() throws IOException {
        if (this.quItemSePriceCat == null) {
            this.quItemSePriceCat = this.loadString("/ws/itemSePriceCat.sql");
        }
        return this.quItemSePriceCat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFiNm) throws IOException {
        URL urlFile = SrCart.class.getResource(pFiNm);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = SrCart.class.getResourceAsStream(pFiNm);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final String prn(AcStg pAs, CmnPrf pCpf, UsPrf pUpf, BigDecimal pVal) {
        return this.numStr.frmt(pVal.toString(), pCpf.getDcSpv(), pCpf.getDcGrSpv(), pAs.getPrDp(), pUpf.getDgInGr());
    }

    public final INumStr getNumStr() {
        return this.numStr;
    }

    public final void setNumStr(INumStr pNumStr) {
        this.numStr = pNumStr;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrTrStg getSrTrStg() {
        return this.srTrStg;
    }

    public final void setSrTrStg(ISrTrStg pSrTrStg) {
        this.srTrStg = pSrTrStg;
    }

    public final Class<?> getPplCl() {
        return this.pplCl;
    }

    public final void setPplCl(Class<?> pPplCl) {
        this.pplCl = pPplCl;
    }

    public final IBuySr getBuySr() {
        return this.buySr;
    }

    public final void setBuySr(IBuySr pBuySr) {
        this.buySr = pBuySr;
    }
}

