/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.hnd;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.hld.HlTyEnSr;
import org.beigesoft.acc.hld.HlTyItSr;
import org.beigesoft.acc.hld.HlTySac;
import org.beigesoft.acc.mdl.AcUpf;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.I18Acc;
import org.beigesoft.acc.mdlp.I18Curr;
import org.beigesoft.acc.srv.ISrAcStg;
import org.beigesoft.hnd.IHndRq;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdlp.UsPrf;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.ISrvDt;

public class HndAcc<RS>
implements IHndRq {
    private ILog log;
    private IRdb<RS> rdb;
    private IOrm orm;
    private HlTySac hlTySac;
    private HlTyItSr hlTyItSr;
    private HlTyEnSr hlTyEnSr;
    private ISrAcStg srAcStg;
    private ISrvDt srvDt;
    private final String[] retrNms = new String[]{"GdPriLstRet"};
    private List<I18Curr> i18Currs;
    private List<I18Acc> i18Accs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handle(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        HashMap vs = new HashMap();
        List i18AccsTmp = null;
        List i18CurrsTmp = null;
        AcStg as = null;
        HndAcc hndAcc = this;
        synchronized (hndAcc) {
            if (this.srAcStg.getAcStg() == null || this.i18Currs == null) {
                try {
                    this.rdb.setAcmt(false);
                    this.rdb.setTrIsl(IRdb.TRRUC.intValue());
                    this.rdb.begin();
                    as = this.srAcStg.lazAcStg(pRvs);
                    if (this.i18Currs == null) {
                        i18AccsTmp = this.orm.retLst(pRvs, vs, I18Acc.class);
                        this.i18Currs = i18CurrsTmp = this.orm.retLst(pRvs, vs, I18Curr.class);
                        this.i18Accs = i18AccsTmp;
                    }
                    this.rdb.commit();
                }
                catch (Exception ex) {
                    this.srAcStg.hndRlBk(pRvs);
                    if (!this.rdb.getAcmt()) {
                        this.rdb.rollBack();
                    }
                    throw ex;
                }
                finally {
                    this.rdb.release();
                }
            } else {
                as = this.srAcStg.lazAcStg(pRvs);
                i18CurrsTmp = this.i18Currs;
                i18AccsTmp = this.i18Accs;
            }
        }
        AcUpf aupf = new AcUpf();
        String opDtStr = pRqDt.getParam("opDt");
        boolean ndStCo = false;
        if (opDtStr != null) {
            aupf.setOpDt(this.srvDt.from8601Date(opDtStr));
            ndStCo = true;
        } else {
            opDtStr = pRqDt.getCookVl("opDt");
            if (opDtStr != null) {
                aupf.setOpDt(new Date(Long.parseLong(opDtStr)));
            }
        }
        if (aupf.getOpDt() == null) {
            aupf.setOpDt(new Date());
            ndStCo = true;
        }
        if (ndStCo) {
            pRqDt.setCookVl("opDt", Long.valueOf(aupf.getOpDt().getTime()).toString());
        }
        UsPrf upf = (UsPrf)pRvs.get("upf");
        for (I18Curr ic : i18CurrsTmp) {
            if (!upf.getLng().getIid().equals(ic.getLng().getIid())) continue;
            pRvs.put("i18Curr", (Object)ic);
            break;
        }
        for (I18Acc ia : i18AccsTmp) {
            if (!upf.getLng().getIid().equals(ia.getLng().getIid())) continue;
            pRvs.put("i18Acc", (Object)ia);
            break;
        }
        pRvs.put("aupf", aupf);
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        cpf.setCostDp(as.getCsDp());
        cpf.setPriDp(as.getPrDp());
        cpf.setQuanDp(as.getQuDp());
        cpf.setTxDp(as.getTxDp());
        pRqDt.setAttr("hlTySac", (Object)this.hlTySac);
        pRqDt.setAttr("hlTyItSr", (Object)this.hlTyItSr);
        pRqDt.setAttr("hlTyEnSr", (Object)this.hlTyEnSr);
        pRvs.put("retrNms", this.retrNms);
    }

    public final synchronized IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final synchronized void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final synchronized IOrm getOrm() {
        return this.orm;
    }

    public final synchronized void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final synchronized ISrAcStg getSrAcStg() {
        return this.srAcStg;
    }

    public final synchronized void setSrAcStg(ISrAcStg pSrAcStg) {
        this.srAcStg = pSrAcStg;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final HlTySac getHlTySac() {
        return this.hlTySac;
    }

    public final void setHlTySac(HlTySac pHlTySac) {
        this.hlTySac = pHlTySac;
    }

    public final HlTyItSr getHlTyItSr() {
        return this.hlTyItSr;
    }

    public final void setHlTyItSr(HlTyItSr pHlTyItSr) {
        this.hlTyItSr = pHlTyItSr;
    }

    public final HlTyEnSr getHlTyEnSr() {
        return this.hlTyEnSr;
    }

    public final void setHlTyEnSr(HlTyEnSr pHlTyEnSr) {
        this.hlTyEnSr = pHlTyEnSr;
    }

    public final ISrvDt getSrvDt() {
        return this.srvDt;
    }

    public final void setSrvDt(ISrvDt pSrvDt) {
        this.srvDt = pSrvDt;
    }
}

