/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.prc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdlp.BnStLn;
import org.beigesoft.acc.mdlp.Entr;
import org.beigesoft.acc.mdlp.PaymFr;
import org.beigesoft.acc.mdlp.PaymTo;
import org.beigesoft.acc.mdlp.PrepFr;
import org.beigesoft.acc.mdlp.PrepTo;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;

public class BnStLnGfe
implements IPrcEnt<BnStLn, Long> {
    private IOrm orm;

    public final BnStLn process(Map<String, Object> pRvs, BnStLn pEnt, IReqDt pRqDt) throws Exception {
        String amStr;
        HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
        this.orm.refrEnt(pRvs, vs, (IHasId)pEnt);
        if (pEnt.getRsAc() != null) {
            throw new ExcCode(100, "Attempt to edit completed bank statement line!");
        }
        if (pEnt.getAmnt().compareTo(BigDecimal.ZERO) > 0) {
            amStr = pEnt.getAmnt().toString();
        } else if (pEnt.getAmnt().compareTo(BigDecimal.ZERO) < 0) {
            amStr = pEnt.getAmnt().negate().toString();
        } else {
            throw new ExcCode(1003, "amount_eq_zero");
        }
        long[] startEnd = this.evalDayStartEndFor(pEnt.getDat());
        String dWhere = "where MDENR=1 and RVID is null and TOT=" + amStr + " and DAT>=" + startEnd[0] + " and DAT<=" + startEnd[1];
        Object[] ndFlDoc = new String[]{"dbOr", "idOr", "tot", "dat", "dscr"};
        Arrays.sort(ndFlDoc);
        if (pEnt.getAmnt().compareTo(BigDecimal.ZERO) > 0) {
            vs.put("PrepFrndFds", ndFlDoc);
            List prepsFr = this.getOrm().retLstCnd(pRvs, vs, PrepFr.class, dWhere);
            vs.clear();
            if (prepsFr.size() > 0) {
                pRvs.put("preps", prepsFr);
            }
            vs.put("PaymFrndFds", ndFlDoc);
            List paymsFr = this.getOrm().retLstCnd(pRvs, vs, PaymFr.class, dWhere);
            vs.clear();
            if (paymsFr.size() > 0) {
                pRvs.put("payms", paymsFr);
            }
            String eWhereD = "where RVID is null and SRTY in (1,2008) and SADTY=1003 and SADID=" + pEnt.getOwnr().getBnka().getIid() + " and DEBT=" + amStr + " and DAT>=" + startEnd[0] + " and DAT<=" + startEnd[1];
            List entriesFr = this.getOrm().retLstCnd(pRvs, vs, Entr.class, eWhereD);
            if (entriesFr.size() > 0) {
                pRvs.put("entrs", entriesFr);
            }
        } else {
            vs.put("PrepTondFds", ndFlDoc);
            List prepsTo = this.getOrm().retLstCnd(pRvs, vs, PrepTo.class, dWhere);
            vs.clear();
            if (prepsTo.size() > 0) {
                pRvs.put("preps", prepsTo);
            }
            vs.put("PaymTondFds", ndFlDoc);
            List paymsTo = this.getOrm().retLstCnd(pRvs, vs, PaymTo.class, dWhere);
            vs.clear();
            if (paymsTo.size() > 0) {
                pRvs.put("payms", paymsTo);
            }
            String eWhereC = "where RVID is null and SRTY in (1,2008) and SACTY=1003 and SACID=" + pEnt.getOwnr().getBnka().getIid() + " and CRED=" + amStr + " and DAT>=" + startEnd[0] + " and DAT<= " + startEnd[1];
            List entriesTo = this.getOrm().retLstCnd(pRvs, vs, Entr.class, eWhereC);
            if (entriesTo.size() > 0) {
                pRvs.put("entrs", entriesTo);
            }
        }
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        uvs.setEnt((IHasId)pEnt);
        return pEnt;
    }

    public final long[] evalDayStartEndFor(Date pDateFor) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(pDateFor);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long[] result = new long[2];
        result[0] = cal.getTimeInMillis();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        result[1] = cal.getTimeInMillis();
        return result;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }
}

