/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.prc;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.Entr;
import org.beigesoft.acc.mdlp.InEntr;
import org.beigesoft.acc.mdlp.Sacnt;
import org.beigesoft.acc.srv.ISrBlnc;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.II18n;

public class EntrSv<RS>
implements IPrcEnt<Entr, Long> {
    private IOrm orm;
    private IRdb<RS> rdb;
    private ISrBlnc srBlnc;
    private II18n i18n;

    public final Entr process(Map<String, Object> pRvs, Entr pEnt, IReqDt pRqDt) throws Exception {
        if (!pEnt.getIsNew().booleanValue()) {
            throw new ExcCode(100, "Edit not allowed!");
        }
        HashMap vs = new HashMap();
        InEntr doc = new InEntr();
        doc.setIid(pEnt.getSrId());
        this.orm.refrEnt(pRvs, vs, (IHasId)doc);
        if (!doc.getDbOr().equals(this.orm.getDbId())) {
            throw new ExcCode(100, "can_not_change_foreign_src");
        }
        long owVrWs = Long.parseLong(pRqDt.getParam("owVr"));
        if (owVrWs != doc.getVer()) {
            throw new ExcCode(1151, "dirty_read");
        }
        if (!pEnt.getDbOr().equals(this.orm.getDbId())) {
            throw new ExcCode(100, "can_not_change_foreign_src");
        }
        AcStg astg = (AcStg)((Object)pRvs.get("astg"));
        pEnt.setSrTy(doc.cnsTy());
        HashSet<ISrBlnc> hnsTrRlBk = (HashSet<ISrBlnc>)pRvs.get("hnsTrRlBk");
        if (hnsTrRlBk == null) {
            hnsTrRlBk = new HashSet<ISrBlnc>();
            pRvs.put("hnsTrRlBk", hnsTrRlBk);
        }
        hnsTrRlBk.add(this.srBlnc);
        if (pEnt.getRvId() != null) {
            Entr revd = new Entr();
            revd.setIid(pEnt.getRvId());
            this.orm.refrEnt(pRvs, vs, (IHasId)revd);
            if (!revd.getSrId().equals(pEnt.getSrId())) {
                throw new ExcCode(100, "different_source");
            }
            if (revd.getRvId() != null) {
                throw new ExcCode(100, "can_not_reverse_reversed");
            }
            this.mkReving(pRvs, pEnt, revd);
            this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
            this.mkReved(pRvs, pEnt, revd);
            this.orm.update(pRvs, vs, (IHasId)revd);
            pRvs.put("msgSuc", "reverse_ok");
        } else {
            Sacnt sa;
            if (pEnt.getDebt().compareTo(BigDecimal.ZERO) == 0) {
                throw new ExcCode(1003, "amount_eq_zero");
            }
            Calendar calCuMh = Calendar.getInstance();
            calCuMh.setTime(astg.getMnth());
            calCuMh.set(5, 1);
            calCuMh.set(11, 0);
            calCuMh.set(12, 0);
            calCuMh.set(13, 0);
            calCuMh.set(14, 0);
            Calendar calDoc = Calendar.getInstance();
            calDoc.setTime(pEnt.getDat());
            calDoc.set(5, 1);
            calDoc.set(11, 0);
            calDoc.set(12, 0);
            calDoc.set(13, 0);
            calDoc.set(14, 0);
            if (calCuMh.getTime().getTime() != calDoc.getTime().getTime()) {
                throw new ExcCode(1003, "wrong_acperiod");
            }
            if (pEnt.getAcDb() == null && pEnt.getAcCr() == null) {
                throw new ExcCode(1003, "account_is_null");
            }
            pEnt.setDebt(pEnt.getDebt().setScale((int)astg.getPrDp(), astg.getRndm()));
            if (pEnt.getAcCr() != null) {
                pEnt.setCred(pEnt.getDebt());
            }
            if (pEnt.getAcDb() == null) {
                pEnt.setDebt(BigDecimal.ZERO);
            } else {
                this.getOrm().refrEnt(pRvs, vs, (IHasId)pEnt.getAcDb());
                if (pEnt.getAcDb().getSaTy() != null) {
                    if (pEnt.getSadId() == null) {
                        throw new ExcCode(1003, "select_subaccount");
                    }
                    sa = (Sacnt)this.getOrm().retEntCnd(pRvs, vs, Sacnt.class, "OWNR='" + pEnt.getAcDb().getIid() + "' and SAID=" + pEnt.getSadId());
                    if (sa == null) {
                        throw new ExcCode(1003, "wrong_subaccount");
                    }
                    pEnt.setSadNm(sa.getSaNm());
                    pEnt.setSadTy(pEnt.getAcDb().getSaTy());
                }
            }
            if (pEnt.getAcCr() != null) {
                this.getOrm().refrEnt(pRvs, vs, (IHasId)pEnt.getAcCr());
                if (pEnt.getAcCr().getSaTy() != null) {
                    if (pEnt.getSacId() == null) {
                        throw new ExcCode(1003, "select_subaccount");
                    }
                    sa = (Sacnt)this.getOrm().retEntCnd(pRvs, vs, Sacnt.class, "OWNR='" + pEnt.getAcCr().getIid() + "' and SAID=" + pEnt.getSacId());
                    if (sa == null) {
                        throw new ExcCode(1003, "wrong_subaccount");
                    }
                    pEnt.setSacNm(sa.getSaNm());
                    pEnt.setSacTy(pEnt.getAcCr().getSaTy());
                }
            }
            this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
            pRvs.put("msgSuc", "insert_ok");
        }
        String qu = "select sum(DEBT) as DEBT, sum(CRED) as CRED from ENTR where RVID is null and SRTY=" + pEnt.getSrTy() + " and SRID=" + doc.getIid() + ";";
        String[] cols = new String[]{"DEBT", "CRED"};
        Double[] tots = this.getRdb().evDoubles(qu, cols);
        if (tots[0] == null) {
            tots[0] = 0.0;
        }
        if (tots[1] == null) {
            tots[1] = 0.0;
        }
        doc.setDebt(BigDecimal.valueOf(tots[0]).setScale((int)astg.getPrDp(), astg.getRndm()));
        doc.setCred(BigDecimal.valueOf(tots[1]).setScale((int)astg.getPrDp(), astg.getRndm()));
        this.getOrm().update(pRvs, vs, (IHasId)doc);
        this.getSrBlnc().hndNewEntr(pRvs, pEnt.getDat());
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        uvs.setOwnr((IHasId)doc);
        return null;
    }

    public final void mkReving(Map<String, Object> pRvs, Entr pRving, Entr pRved) {
        pRving.setRvId(pRved.getIid());
        pRving.setDat(pRved.getDat());
        pRving.setDebt(pRved.getDebt().negate());
        pRving.setCred(pRved.getCred().negate());
        pRving.setAcDb(pRved.getAcDb());
        pRving.setSadId(pRved.getSadId());
        pRving.setSadTy(pRved.getSadTy());
        pRving.setSadNm(pRved.getSadNm());
        pRving.setAcCr(pRved.getAcCr());
        pRving.setSacId(pRved.getSacId());
        pRving.setSacTy(pRved.getSacTy());
        pRving.setSacNm(pRved.getSacNm());
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        StringBuffer sb = new StringBuffer();
        if (pRving.getDscr() != null) {
            sb.append(pRving.getDscr() + ", !");
        }
        sb.append(this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
        sb.append(" #" + pRved.getDbOr() + "-" + pRved.getIid());
        pRving.setDscr(sb.toString() + "!");
    }

    public final void mkReved(Map<String, Object> pRvs, Entr pRving, Entr pRved) {
        pRved.setRvId(pRving.getIid());
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        StringBuffer dsced = new StringBuffer();
        if (pRved.getDscr() != null) {
            dsced.append(pRved.getDscr() + " !");
        }
        dsced.append(this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()));
        dsced.append(" #" + pRving.getDbOr() + "-" + pRving.getIid());
        pRved.setDscr(dsced.toString());
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final ISrBlnc getSrBlnc() {
        return this.srBlnc;
    }

    public final void setSrBlnc(ISrBlnc pSrBlnc) {
        this.srBlnc = pSrBlnc;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }
}

