/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.prc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.ItAdLn;
import org.beigesoft.acc.srv.ISrWrhEnr;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.II18n;

public class ItAdLnSv<RS>
implements IPrcEnt<ItAdLn, Long> {
    private IOrm orm;
    private ISrWrhEnr srWrhEnr;
    private II18n i18n;
    private IRdb<RS> rdb;

    public final ItAdLn process(Map<String, Object> pRvs, ItAdLn pEnt, IReqDt pRqDt) throws Exception {
        if (pEnt.getIsNew().booleanValue()) {
            Object[] upFds;
            HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
            this.orm.refrEnt(pRvs, vs, (IHasId)pEnt.getOwnr());
            long owVrWs = Long.parseLong(pRqDt.getParam("owVr"));
            if (owVrWs != pEnt.getOwnr().getVer()) {
                throw new ExcCode(1151, "dirty_read");
            }
            if (pEnt.getRvId() != null) {
                ItAdLn revd = new ItAdLn();
                revd.setIid(pEnt.getRvId());
                this.orm.refrEnt(pRvs, vs, (IHasId)revd);
                pEnt.setDbOr(this.orm.getDbId());
                pEnt.setItm(revd.getItm());
                pEnt.setUom(revd.getUom());
                pEnt.setWrhp(revd.getWrhp());
                pEnt.setQuan(revd.getQuan().negate());
                pEnt.setTot(revd.getTot().negate());
                CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
                StringBuffer sb = new StringBuffer();
                if (pEnt.getDscr() != null) {
                    sb.append(pEnt.getDscr() + " !");
                }
                sb.append(this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
                sb.append(" #" + revd.getDbOr() + "-" + revd.getIid());
                pEnt.setDscr(sb.toString());
                this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
                sb.delete(0, sb.length());
                if (revd.getDscr() != null) {
                    sb.append(revd.getDscr() + " !");
                }
                sb.append(this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()));
                sb.append(" #" + pEnt.getDbOr() + "-" + pEnt.getIid());
                revd.setDscr(sb.toString());
                revd.setRvId(pEnt.getIid());
                revd.setItLf(BigDecimal.ZERO);
                revd.setToLf(BigDecimal.ZERO);
                upFds = new String[]{"rvId", "dscr", "ver", "itLf", "toLf"};
                Arrays.sort(upFds);
                vs.put("ndFds", upFds);
                this.orm.update(pRvs, vs, (IHasId)revd);
                vs.clear();
                this.srWrhEnr.revLoad(pRvs, pEnt);
                pRvs.put("msgSuc", "reverse_ok");
            } else {
                pEnt.setItLf(pEnt.getQuan());
                pEnt.setToLf(pEnt.getTot());
                this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
                this.srWrhEnr.load(pRvs, pEnt, pEnt.getWrhp());
                pRvs.put("msgSuc", "insert_ok");
            }
            String qu = "select sum(TOT) as TOT from ITADLN where RVID is null and OWNR=" + pEnt.getOwnr().getIid() + ";";
            Double tot = this.rdb.evDouble(qu, "TOT");
            if (tot == null) {
                tot = 0.0;
            }
            AcStg as = (AcStg)((Object)pRvs.get("astg"));
            pEnt.getOwnr().setTot(BigDecimal.valueOf(tot).setScale((int)as.getPrDp(), as.getRndm()));
            upFds = new String[]{"tot", "ver"};
            Arrays.sort(upFds);
            vs.put("ndFds", upFds);
            this.getOrm().update(pRvs, vs, (IHasId)pEnt.getOwnr());
            vs.clear();
            UvdVar uvs = (UvdVar)pRvs.get("uvs");
            uvs.setOwnr((IHasId)pEnt.getOwnr());
            return null;
        }
        throw new ExcCode(100, "Attempt to update add item line!");
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrWrhEnr getSrWrhEnr() {
        return this.srWrhEnr;
    }

    public final void setSrWrhEnr(ISrWrhEnr pSrWrhEnr) {
        this.srWrhEnr = pSrWrhEnr;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }
}

