/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.prc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.MnpMcs;
import org.beigesoft.acc.srv.ISrDrItEnr;
import org.beigesoft.acc.srv.ISrWrhEnr;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.II18n;

public class MnpMcsSv<RS>
implements IPrcEnt<MnpMcs, Long> {
    private IOrm orm;
    private ISrWrhEnr srWrhEnr;
    private ISrDrItEnr srDrItEnr;
    private II18n i18n;
    private IRdb<RS> rdb;

    public final MnpMcs process(Map<String, Object> pRvs, MnpMcs pEnt, IReqDt pRqDt) throws Exception {
        if (pEnt.getIsNew().booleanValue()) {
            Object[] upFds;
            HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
            this.orm.refrEnt(pRvs, vs, (IHasId)pEnt.getOwnr());
            long owVrWs = Long.parseLong(pRqDt.getParam("owVr"));
            if (owVrWs != pEnt.getOwnr().getVer()) {
                throw new ExcCode(1151, "dirty_read");
            }
            if (pEnt.getRvId() != null) {
                MnpMcs revd = new MnpMcs();
                revd.setIid(pEnt.getRvId());
                this.orm.refrEnt(pRvs, vs, (IHasId)revd);
                pEnt.setDbOr(this.orm.getDbId());
                pEnt.setItm(revd.getItm());
                pEnt.setUom(revd.getUom());
                pEnt.setQuan(revd.getQuan().negate());
                CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
                StringBuffer sb = new StringBuffer();
                if (pEnt.getDscr() != null) {
                    sb.append(pEnt.getDscr() + " !");
                }
                sb.append(this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
                sb.append(" #" + revd.getDbOr() + "-" + revd.getIid());
                pEnt.setDscr(sb.toString());
                this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
                sb.delete(0, sb.length());
                if (revd.getDscr() != null) {
                    sb.append(revd.getDscr() + " !");
                }
                sb.append(this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()));
                sb.append(" #" + pEnt.getDbOr() + "-" + pEnt.getIid());
                revd.setDscr(sb.toString());
                revd.setRvId(pEnt.getIid());
                upFds = new String[]{"rvId", "dscr", "ver"};
                Arrays.sort(upFds);
                vs.put("ndFds", upFds);
                this.orm.update(pRvs, vs, (IHasId)revd);
                vs.clear();
                this.srDrItEnr.rvDraw(pRvs, pEnt);
                this.srWrhEnr.revDraw(pRvs, pEnt);
                pRvs.put("msgSuc", "reverse_ok");
            } else {
                this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
                this.srDrItEnr.draw(pRvs, pEnt);
                pRvs.put("msgSuc", "insert_ok");
            }
            String qu = "select sum(TOT) as TOT from DRITENR where RVID is null and DOWID=" + pEnt.getOwnr().getIid() + " and DOWTY=" + pEnt.getOwnr().cnsTy() + ";";
            Double tot = this.rdb.evDouble(qu, "TOT");
            if (tot == null) {
                tot = 0.0;
            }
            AcStg as = (AcStg)((Object)pRvs.get("astg"));
            pEnt.getOwnr().setMaCs(BigDecimal.valueOf(tot).setScale((int)as.getPrDp(), as.getRndm()));
            pEnt.getOwnr().setTot(pEnt.getOwnr().getMaCs().add(pEnt.getOwnr().getAdCs()).setScale((int)as.getPrDp(), as.getRndm()));
            pEnt.getOwnr().setToLf(pEnt.getOwnr().getTot());
            pEnt.getOwnr().setPri(pEnt.getOwnr().getTot().divide(pEnt.getOwnr().getQuan(), (int)as.getPrDp(), as.getRndm()));
            upFds = new String[]{"maCs", "tot", "pri", "toLf", "ver"};
            Arrays.sort(upFds);
            vs.put("ndFds", upFds);
            this.getOrm().update(pRvs, vs, (IHasId)pEnt.getOwnr());
            vs.clear();
            UvdVar uvs = (UvdVar)pRvs.get("uvs");
            uvs.setOwnr((IHasId)pEnt.getOwnr());
            return null;
        }
        throw new ExcCode(100, "Attempt to update use item line!");
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrWrhEnr getSrWrhEnr() {
        return this.srWrhEnr;
    }

    public final void setSrWrhEnr(ISrWrhEnr pSrWrhEnr) {
        this.srWrhEnr = pSrWrhEnr;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final ISrDrItEnr getSrDrItEnr() {
        return this.srDrItEnr;
    }

    public final void setSrDrItEnr(ISrDrItEnr pSrDrItEnr) {
        this.srDrItEnr = pSrDrItEnr;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }
}

