/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.prc;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.Map;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.TxCt;
import org.beigesoft.acc.mdlp.TxDst;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.mdl.IRecSet;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrc;
import org.beigesoft.rdb.IRdb;

public class RvTxCt<RS>
implements IPrc {
    private IRdb<RS> rdb;
    private Integer trIsl;
    private String quRvTxCt;

    public final void process(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        String itdl;
        String itm;
        String ent = pRqDt.getParam("ent");
        if ("PuInGdLn".equals(ent) || "SaInGdLn".equals(ent)) {
            itm = "ITM";
            itdl = "ITTXDL";
        } else if ("PuInSrLn".equals(ent) || "SaInSrLn".equals(ent)) {
            itm = "SRV";
            itdl = "SRTXDL";
        } else {
            throw new ExcCode(100, "Wrong request revealing tax category!");
        }
        String itmId = pRqDt.getParam("itmId");
        String txDsId = pRqDt.getParam("txDsId");
        if (itmId == null || txDsId == null) {
            throw new ExcCode(100, "Wrong request revealing tax category!");
        }
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(this.trIsl.intValue());
            this.rdb.begin();
            this.reveal(pRvs, itm, itdl, itmId, txDsId);
            pRqDt.setAttr("rnd", (Object)"rvtcj");
            this.rdb.commit();
        }
        catch (Exception ex) {
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reveal(Map<String, Object> pRvs, String pItm, String pItdl, String pItmId, String pTxDsId) throws Exception {
        String qu = this.lazQuRvTxCt().replace(":TITM", pItm);
        qu = qu.replace(":TTDL", pItdl);
        qu = qu.replace(":ITM", pItmId);
        qu = qu.replace(":TXDS", pTxDsId);
        try (IRecSet rs = null;){
            rs = this.getRdb().retRs(qu);
            if (rs.first()) {
                RoundingMode rm;
                Double agRt;
                String tcNm;
                Integer stRm = rs.getInt("STRM");
                if (stRm == null) {
                    tcNm = rs.getStr("TCONME");
                    agRt = rs.getDouble("TCOAGRT");
                } else {
                    tcNm = rs.getStr("TCDNME");
                    agRt = rs.getDouble("TCDAGRT");
                }
                if (rs.next()) {
                    throw new ExcCode(1003, "multi_tax_dest");
                }
                if (agRt == null) {
                    agRt = 0.0;
                }
                if (stRm == null) {
                    AcStg as = (AcStg)((Object)pRvs.get("astg"));
                    rm = as.getStRm();
                } else {
                    rm = ((RoundingMode[])RoundingMode.class.getEnumConstants())[stRm];
                }
                TxCt txCt = new TxCt();
                txCt.setNme(tcNm);
                txCt.setAgRt(BigDecimal.valueOf(agRt));
                pRvs.put("txCt", (Object)txCt);
                TxDst txDs = new TxDst();
                txDs.setStRm(rm);
                pRvs.put("txDs", (Object)txDs);
            }
        }
    }

    public final synchronized String lazQuRvTxCt() throws IOException {
        if (this.quRvTxCt == null) {
            this.quRvTxCt = this.loadStr("/acc/rvTxCt.sql");
        }
        return this.quRvTxCt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String loadStr(String pFlNm) throws IOException {
        URL urlFile = RvTxCt.class.getResource(pFlNm);
        if (urlFile != null) {
            try (InputStream is = null;){
                is = RvTxCt.class.getResourceAsStream(pFlNm);
                byte[] bArray = new byte[is.available()];
                is.read(bArray, 0, is.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        throw new RuntimeException("File not found: " + pFlNm);
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final Integer getTrIsl() {
        return this.trIsl;
    }

    public final void setTrIsl(Integer pTrIsl) {
        this.trIsl = pTrIsl;
    }
}

