/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.rep;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.Curr;
import org.beigesoft.acc.mdlp.I18Acc;
import org.beigesoft.acc.mdlp.I18Buyr;
import org.beigesoft.acc.mdlp.I18Curr;
import org.beigesoft.acc.mdlp.SaInGdLn;
import org.beigesoft.acc.mdlp.SaInSrLn;
import org.beigesoft.acc.mdlp.SaInTxLn;
import org.beigesoft.acc.mdlp.SalInv;
import org.beigesoft.acc.rep.IInvPdf;
import org.beigesoft.doc.model.DocPage;
import org.beigesoft.doc.model.DocTable;
import org.beigesoft.doc.model.Document;
import org.beigesoft.doc.model.EAlignHorizontal;
import org.beigesoft.doc.model.EUnitOfMeasure;
import org.beigesoft.doc.model.EWraping;
import org.beigesoft.doc.model.TableCell;
import org.beigesoft.doc.model.TableColumn;
import org.beigesoft.doc.model.TableRow;
import org.beigesoft.doc.service.IDocumentMaker;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdlp.UsPrf;
import org.beigesoft.pdf.model.PdfDocument;
import org.beigesoft.pdf.service.IPdfFactory;
import org.beigesoft.pdf.service.IPdfMaker;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.srv.II18n;
import org.beigesoft.srv.INumStr;

public class InvPdf<WI>
implements IInvPdf {
    private IPdfFactory<WI> pdfFactory;
    private II18n i18n;
    private IOrm orm;
    private INumStr numStr;
    private String saInOvrsGds;
    private String slInOvrsSrs;

    @Override
    public final void mkRep(Map<String, Object> pRvs, SalInv pInv, IReqDt pRqDt, OutputStream pOus) throws Exception {
        int k;
        int i;
        BigDecimal tot;
        BigDecimal toTx;
        BigDecimal subt;
        BigDecimal pri;
        int rowc;
        boolean isPrnCurLf;
        String curSign;
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        UsPrf upf = (UsPrf)pRvs.get("upf");
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale(upf.getLng().getIid()));
        this.refrInv(pRvs, pInv, upf.getLng().getIid(), !upf.getLng().getIid().equals(cpf.getLngDef().getIid()));
        boolean stIb = false;
        for (SaInTxLn itl : pInv.getTxLns()) {
            if (itl.getTxb().compareTo(BigDecimal.ZERO) != 1) continue;
            stIb = true;
            break;
        }
        Curr curr = pInv.getCuFr() != null ? pInv.getCuFr() : as.getCurr();
        I18Curr i18Curr = null;
        if (!upf.getLng().getIid().equals(cpf.getLngDef().getIid())) {
            HashMap vs = new HashMap();
            i18Curr = new I18Curr();
            i18Curr.setHasNm(curr);
            i18Curr.setLng(upf.getLng());
            i18Curr = (I18Curr)this.getOrm().retEnt(pRvs, vs, (IHasId)i18Curr);
        } else {
            i18Curr = (I18Curr)((Object)pRvs.get("i18Curr"));
        }
        if (i18Curr != null) {
            curSign = i18Curr.getCurs() != false ? i18Curr.getHasNm().getSgn() : " " + i18Curr.getNme() + " ";
            isPrnCurLf = i18Curr.getCurl();
        } else {
            curSign = as.getCurs() != false ? curr.getSgn() : " " + curr.getNme() + " ";
            isPrnCurLf = as.getCurl();
        }
        String priNm = pInv.getInTx() != false ? "inTx" : "pri";
        Document doc = this.pdfFactory.lazyGetFctDocument().createDoc(as.getPgSz(), as.getPgOr());
        doc.setFontSize(as.getFnSz().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginBottom(as.getMrBo().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginTop(as.getMrTo().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginLeft(as.getMrLf().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginRight(as.getMrRi().doubleValue());
        PdfDocument docPdf = this.pdfFactory.createPdfDoc(doc);
        IDocumentMaker docMaker = this.pdfFactory.lazyGetDocumentMaker();
        docPdf.getPdfInfo().setAuthor("Beigesoft (TM) EIS, " + as.getOrg());
        IPdfMaker pdfMaker = this.pdfFactory.lazyGetPdfMaker();
        if (as.getTtfb() != null) {
            pdfMaker.addFontTtf(docPdf, as.getTtfb());
        }
        pdfMaker.addFontTtf(docPdf, as.getTtff());
        double widthNdot = this.pdfFactory.lazyGetUomHelper().fromPoints(2.0, 300.0, doc.getUnitOfMeasure());
        doc.setBorder(widthNdot);
        doc.setContentPadding(0.0);
        doc.setContentPaddingBottom(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
        DocTable tblOwner = docMaker.addDocTableNoBorder(doc, 1, 1);
        I18Acc i18Acc = (I18Acc)((Object)pRvs.get("i18Acc"));
        if (i18Acc != null) {
            ((TableCell)tblOwner.getItsCells().get(0)).setItsContent(i18Acc.getOrg());
        } else {
            ((TableCell)tblOwner.getItsCells().get(0)).setItsContent(as.getOrg());
        }
        int n = 0;
        if (as.getTin() != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("tin", upf.getLng().getIid()) + ": " + as.getTin());
        }
        if (as.getZip() != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("zip", upf.getLng().getIid()) + ": " + as.getZip());
        }
        String addr = null;
        addr = i18Acc != null ? i18Acc.getAddr1() : as.getAddr1();
        if (addr != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("addr1", upf.getLng().getIid()) + ": " + addr);
        }
        if ((addr = i18Acc != null ? i18Acc.getAddr2() : as.getAddr2()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("addr2", upf.getLng().getIid()) + ": " + addr);
        }
        if ((addr = i18Acc != null ? i18Acc.getCity() : as.getCity()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("city", upf.getLng().getIid()) + ": " + addr);
        }
        if ((addr = i18Acc != null ? i18Acc.getStat() : as.getStat()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("stat", upf.getLng().getIid()) + ": " + addr);
        }
        if ((addr = i18Acc != null ? i18Acc.getCntr() : as.getCntr()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("cntr", upf.getLng().getIid()) + ": " + addr);
        }
        ((TableCell)tblOwner.getItsCells().get(0)).setFontNumber(1);
        docMaker.makeDocTableWrapping(tblOwner);
        tblOwner.setAlignHorizontal(EAlignHorizontal.RIGHT);
        DocTable tblTitle = docMaker.addDocTableNoBorder(doc, 1, 1);
        String invNm = pInv.getIdOr() != null ? pInv.getDbOr().toString() + "-" + pInv.getIdOr() : pInv.getDbOr().toString() + "-" + pInv.getIid();
        String ttl = this.i18n.getMsg("Invoice", upf.getLng().getIid()) + " #" + invNm + ", " + this.i18n.getMsg("dat", upf.getLng().getIid()) + ": " + dateFormat.format(pInv.getDat());
        ((TableCell)tblTitle.getItsCells().get(0)).setItsContent(ttl);
        ((TableCell)tblTitle.getItsCells().get(0)).setFontNumber(1);
        tblTitle.setAlignHorizontal(EAlignHorizontal.CENTER);
        doc.setContainerMarginBottom(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
        docMaker.makeDocTableWrapping(tblTitle);
        DocTable tblDbcr = docMaker.addDocTableNoBorder(doc, 1, 1);
        I18Buyr i18Buyr = null;
        if (!upf.getLng().getIid().equals(cpf.getLngDef().getIid())) {
            HashMap vs = new HashMap();
            i18Buyr = new I18Buyr();
            i18Buyr.setHasNm(pInv.getDbcr());
            i18Buyr.setLng(upf.getLng());
            i18Buyr = (I18Buyr)this.getOrm().retEnt(pRvs, vs, (IHasId)i18Buyr);
        }
        if (i18Buyr != null) {
            ((TableCell)tblDbcr.getItsCells().get(0)).setItsContent(i18Buyr.getNme());
        } else {
            ((TableCell)tblDbcr.getItsCells().get(0)).setItsContent(pInv.getDbcr().getNme());
        }
        n = 0;
        if (pInv.getDbcr().getTin() != null) {
            docMaker.addRowToDocTable(tblDbcr);
            ((TableCell)tblDbcr.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("tin", upf.getLng().getIid()) + ": " + pInv.getDbcr().getTin());
        }
        if (pInv.getDbcr().getZip() != null) {
            docMaker.addRowToDocTable(tblDbcr);
            ((TableCell)tblDbcr.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("zip", upf.getLng().getIid()) + ": " + pInv.getDbcr().getZip());
        }
        if ((addr = i18Buyr != null ? i18Buyr.getAddr1() : pInv.getDbcr().getAddr1()) != null) {
            docMaker.addRowToDocTable(tblDbcr);
            ((TableCell)tblDbcr.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("addr1", upf.getLng().getIid()) + ": " + addr);
        }
        if ((addr = i18Buyr != null ? i18Buyr.getAddr2() : pInv.getDbcr().getAddr2()) != null) {
            docMaker.addRowToDocTable(tblDbcr);
            ((TableCell)tblDbcr.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("addr2", upf.getLng().getIid()) + ": " + addr);
        }
        if ((addr = i18Buyr != null ? i18Buyr.getCity() : pInv.getDbcr().getCity()) != null) {
            docMaker.addRowToDocTable(tblDbcr);
            ((TableCell)tblDbcr.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("city", upf.getLng().getIid()) + ": " + addr);
        }
        if ((addr = i18Buyr != null ? i18Buyr.getStat() : pInv.getDbcr().getStat()) != null) {
            docMaker.addRowToDocTable(tblDbcr);
            ((TableCell)tblDbcr.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("stat", upf.getLng().getIid()) + ": " + addr);
        }
        if ((addr = i18Buyr != null ? i18Buyr.getCntr() : pInv.getDbcr().getCntr()) != null) {
            docMaker.addRowToDocTable(tblDbcr);
            ((TableCell)tblDbcr.getItsCells().get(++n)).setItsContent(this.i18n.getMsg("cntr", upf.getLng().getIid()) + ": " + addr);
        }
        ((TableCell)tblDbcr.getItsCells().get(0)).setFontNumber(1);
        if (pInv.getGdLns() != null && pInv.getGdLns().size() > 0) {
            doc.setContainerMarginBottom(this.mmToDocUom(2.0, doc.getUnitOfMeasure()));
            DocTable tblTiGoods = docMaker.addDocTableNoBorder(doc, 1, 1);
            ((TableCell)tblTiGoods.getItsCells().get(0)).setItsContent(this.i18n.getMsg(SaInGdLn.class.getSimpleName() + "s", upf.getLng().getIid()));
            ((TableCell)tblTiGoods.getItsCells().get(0)).setFontNumber(1);
            tblTiGoods.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiGoods);
            doc.setContentPadding(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
            doc.setContentPaddingBottom(this.mmToDocUom(1.5, doc.getUnitOfMeasure()));
            rowc = stIb ? 6 : (pInv.getInTx() != false ? 7 : 8);
            DocTable tbGds = docMaker.addDocTable(doc, rowc, pInv.getGdLns().size() + 1);
            tbGds.setIsRepeatHead(true);
            ((TableRow)tbGds.getItsRows().get(0)).setIsHead(true);
            ((TableCell)tbGds.getItsCells().get(0)).setItsContent(this.i18n.getMsg("Itm", upf.getLng().getIid()).replace(" ", "\n"));
            ((TableColumn)tbGds.getItsColumns().get(0)).setIsWidthFixed(true);
            ((TableColumn)tbGds.getItsColumns().get(0)).setWidthInPercentage(60.0);
            ((TableCell)tbGds.getItsCells().get(1)).setItsContent(this.i18n.getMsg("uom", upf.getLng().getIid()).replace(" ", "\n"));
            ((TableColumn)tbGds.getItsColumns().get(1)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tbGds.getItsCells().get(2)).setItsContent(this.i18n.getMsg(priNm, upf.getLng().getIid()).replace(" ", "\n"));
            ((TableColumn)tbGds.getItsColumns().get(2)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tbGds.getItsCells().get(3)).setItsContent(this.i18n.getMsg("quan", upf.getLng().getIid()).replace(" ", "\n"));
            ((TableColumn)tbGds.getItsColumns().get(3)).setWraping(EWraping.WRAP_CONTENT);
            int pos = 3;
            if (!pInv.getInTx().booleanValue()) {
                ((TableCell)tbGds.getItsCells().get(++pos)).setItsContent(this.i18n.getMsg("subt", upf.getLng().getIid()).replace(" ", "\n"));
                ((TableColumn)tbGds.getItsColumns().get(pos)).setWraping(EWraping.WRAP_CONTENT);
            } else if (stIb && pInv.getInTx().booleanValue()) {
                ((TableCell)tbGds.getItsCells().get(++pos)).setItsContent(this.i18n.getMsg("tot", upf.getLng().getIid()).replace(" ", "\n"));
                ((TableColumn)tbGds.getItsColumns().get(pos)).setWraping(EWraping.WRAP_CONTENT);
            }
            ((TableCell)tbGds.getItsCells().get(++pos)).setItsContent(this.i18n.getMsg("tdsc", upf.getLng().getIid()));
            if (!stIb) {
                ((TableCell)tbGds.getItsCells().get(++pos)).setItsContent(this.i18n.getMsg("toTx", upf.getLng().getIid()).replace(" ", "\n"));
                ((TableColumn)tbGds.getItsColumns().get(pos)).setWraping(EWraping.WRAP_CONTENT);
                ((TableCell)tbGds.getItsCells().get(++pos)).setItsContent(this.i18n.getMsg("tot", upf.getLng().getIid()).replace(" ", "\n"));
                ((TableColumn)tbGds.getItsColumns().get(pos)).setWraping(EWraping.WRAP_CONTENT);
            }
            for (int i2 = 0; i2 < rowc; ++i2) {
                ((TableCell)tbGds.getItsCells().get(i2)).setFontNumber(1);
                ((TableCell)tbGds.getItsCells().get(i2)).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            int j = 1;
            for (SaInGdLn ln : pInv.getGdLns()) {
                if (pInv.getCuFr() != null) {
                    pri = ln.getPrFc();
                    subt = ln.getSuFc();
                    toTx = ln.getTxFc();
                    tot = ln.getToFc();
                } else {
                    pri = ln.getPri();
                    subt = ln.getSubt();
                    toTx = ln.getToTx();
                    tot = ln.getTot();
                }
                int i3 = 0;
                int k2 = j * rowc + i3++;
                ((TableCell)tbGds.getItsCells().get(k2)).setItsContent(ln.getItm().getNme());
                k2 = j * rowc + i3++;
                ((TableCell)tbGds.getItsCells().get(k2)).setAlignHorizontal(EAlignHorizontal.CENTER);
                ((TableCell)tbGds.getItsCells().get(k2)).setItsContent(ln.getUom().getNme());
                k2 = j * rowc + i3++;
                ((TableCell)tbGds.getItsCells().get(k2)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tbGds.getItsCells().get(k2)).setItsContent(this.prn(as, cpf, upf, pri));
                k2 = j * rowc + i3++;
                ((TableCell)tbGds.getItsCells().get(k2)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tbGds.getItsCells().get(k2)).setItsContent(this.prn(as, cpf, upf, ln.getQuan()));
                if (!pInv.getInTx().booleanValue()) {
                    k2 = j * rowc + i3++;
                    ((TableCell)tbGds.getItsCells().get(k2)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    ((TableCell)tbGds.getItsCells().get(k2)).setItsContent(this.prn(as, cpf, upf, subt));
                } else if (stIb && pInv.getInTx().booleanValue()) {
                    k2 = j * rowc + i3++;
                    ((TableCell)tbGds.getItsCells().get(k2)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    ((TableCell)tbGds.getItsCells().get(k2)).setItsContent(this.prn(as, cpf, upf, tot));
                }
                k2 = j * rowc + i3++;
                ((TableCell)tbGds.getItsCells().get(k2)).setAlignHorizontal(EAlignHorizontal.CENTER);
                ((TableCell)tbGds.getItsCells().get(k2)).setItsContent(ln.getTdsc());
                if (!stIb) {
                    k2 = j * rowc + i3++;
                    ((TableCell)tbGds.getItsCells().get(k2)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    ((TableCell)tbGds.getItsCells().get(k2)).setItsContent(this.prn(as, cpf, upf, toTx));
                    k2 = j * rowc + i3++;
                    ((TableCell)tbGds.getItsCells().get(k2)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    ((TableCell)tbGds.getItsCells().get(k2)).setItsContent(this.prn(as, cpf, upf, tot));
                }
                ++j;
            }
        }
        if (pInv.getSrLns() != null && pInv.getSrLns().size() > 0) {
            double wd15;
            doc.setContainerMarginBottom(this.mmToDocUom(2.0, doc.getUnitOfMeasure()));
            DocTable tblTiServices = docMaker.addDocTableNoBorder(doc, 1, 1);
            ((TableCell)tblTiServices.getItsCells().get(0)).setItsContent(this.i18n.getMsg(SaInSrLn.class.getSimpleName() + "s", upf.getLng().getIid()));
            ((TableCell)tblTiServices.getItsCells().get(0)).setFontNumber(1);
            tblTiServices.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiServices);
            doc.setContentPadding(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
            doc.setContentPaddingBottom(this.mmToDocUom(1.5, doc.getUnitOfMeasure()));
            if (stIb) {
                rowc = 6;
                wd15 = 30.0;
            } else if (pInv.getInTx().booleanValue()) {
                rowc = 7;
                wd15 = 15.0;
            } else {
                rowc = 8;
                wd15 = 15.0;
            }
            DocTable tbSrs = docMaker.addDocTable(doc, rowc, pInv.getSrLns().size() + 1);
            tbSrs.setIsRepeatHead(true);
            ((TableRow)tbSrs.getItsRows().get(0)).setIsHead(true);
            ((TableCell)tbSrs.getItsCells().get(0)).setItsContent(this.i18n.getMsg("Srv", upf.getLng().getIid()));
            ((TableColumn)tbSrs.getItsColumns().get(0)).setIsWidthFixed(true);
            ((TableColumn)tbSrs.getItsColumns().get(0)).setWidthInPercentage(35.0);
            ((TableCell)tbSrs.getItsCells().get(1)).setItsContent(this.i18n.getMsg("uom", upf.getLng().getIid()).replace(" ", "\n"));
            ((TableColumn)tbSrs.getItsColumns().get(1)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tbSrs.getItsCells().get(2)).setItsContent(this.i18n.getMsg(priNm, upf.getLng().getIid()).replace(" ", "\n"));
            ((TableColumn)tbSrs.getItsColumns().get(2)).setIsWidthFixed(true);
            ((TableColumn)tbSrs.getItsColumns().get(2)).setWidthInPercentage(wd15);
            ((TableCell)tbSrs.getItsCells().get(3)).setItsContent(this.i18n.getMsg("quan", upf.getLng().getIid()).replace(" ", "\n"));
            ((TableColumn)tbSrs.getItsColumns().get(3)).setWraping(EWraping.WRAP_CONTENT);
            int pos = 3;
            if (!pInv.getInTx().booleanValue()) {
                ((TableCell)tbSrs.getItsCells().get(++pos)).setItsContent(this.i18n.getMsg("subt", upf.getLng().getIid()).replace(" ", "\n"));
                ((TableColumn)tbSrs.getItsColumns().get(pos)).setWraping(EWraping.WRAP_CONTENT);
            } else if (stIb && pInv.getInTx().booleanValue()) {
                ((TableCell)tbSrs.getItsCells().get(++pos)).setItsContent(this.i18n.getMsg("tot", upf.getLng().getIid()).replace(" ", "\n"));
                ((TableColumn)tbSrs.getItsColumns().get(pos)).setWraping(EWraping.WRAP_CONTENT);
            }
            ((TableCell)tbSrs.getItsCells().get(++pos)).setItsContent(this.i18n.getMsg("tdsc", upf.getLng().getIid()));
            if (!stIb) {
                ((TableColumn)tbSrs.getItsColumns().get(pos)).setIsWidthFixed(true);
                ((TableColumn)tbSrs.getItsColumns().get(pos)).setWidthInPercentage(20.0);
                ((TableCell)tbSrs.getItsCells().get(++pos)).setItsContent(this.i18n.getMsg("toTx", upf.getLng().getIid()));
                ((TableColumn)tbSrs.getItsColumns().get(pos)).setIsWidthFixed(true);
                ((TableColumn)tbSrs.getItsColumns().get(pos)).setWidthInPercentage(wd15);
                ((TableCell)tbSrs.getItsCells().get(++pos)).setItsContent(this.i18n.getMsg("tot", upf.getLng().getIid()));
                ((TableColumn)tbSrs.getItsColumns().get(pos)).setIsWidthFixed(true);
                ((TableColumn)tbSrs.getItsColumns().get(pos)).setWidthInPercentage(wd15);
            }
            for (int i4 = 0; i4 < rowc; ++i4) {
                ((TableCell)tbSrs.getItsCells().get(i4)).setFontNumber(1);
                ((TableCell)tbSrs.getItsCells().get(i4)).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            int j = 1;
            for (SaInSrLn ln : pInv.getSrLns()) {
                if (pInv.getCuFr() != null) {
                    pri = ln.getPrFc();
                    subt = ln.getSuFc();
                    toTx = ln.getTxFc();
                    tot = ln.getToFc();
                } else {
                    pri = ln.getPri();
                    subt = ln.getSubt();
                    toTx = ln.getToTx();
                    tot = ln.getTot();
                }
                i = 0;
                k = j * rowc + i++;
                ((TableCell)tbSrs.getItsCells().get(k)).setItsContent(ln.getItm().getNme());
                k = j * rowc + i++;
                ((TableCell)tbSrs.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.CENTER);
                ((TableCell)tbSrs.getItsCells().get(k)).setItsContent(ln.getUom().getNme());
                k = j * rowc + i++;
                ((TableCell)tbSrs.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tbSrs.getItsCells().get(k)).setItsContent(this.prn(as, cpf, upf, pri));
                k = j * rowc + i++;
                ((TableCell)tbSrs.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tbSrs.getItsCells().get(k)).setItsContent(this.prn(as, cpf, upf, ln.getQuan()));
                if (!pInv.getInTx().booleanValue()) {
                    k = j * rowc + i++;
                    ((TableCell)tbSrs.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    ((TableCell)tbSrs.getItsCells().get(k)).setItsContent(this.prn(as, cpf, upf, subt));
                } else if (stIb && pInv.getInTx().booleanValue()) {
                    k = j * rowc + i++;
                    ((TableCell)tbSrs.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    ((TableCell)tbSrs.getItsCells().get(k)).setItsContent(this.prn(as, cpf, upf, tot));
                }
                k = j * rowc + i++;
                ((TableCell)tbSrs.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.CENTER);
                ((TableCell)tbSrs.getItsCells().get(k)).setItsContent(ln.getTdsc());
                if (!stIb) {
                    k = j * rowc + i++;
                    ((TableCell)tbSrs.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    ((TableCell)tbSrs.getItsCells().get(k)).setItsContent(this.prn(as, cpf, upf, toTx));
                    k = j * rowc + i++;
                    ((TableCell)tbSrs.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    ((TableCell)tbSrs.getItsCells().get(k)).setItsContent(this.prn(as, cpf, upf, tot));
                }
                ++j;
            }
        }
        if (pInv.getTxLns() != null && pInv.getTxLns().size() > 0) {
            double rowtw;
            doc.setContainerMarginBottom(this.mmToDocUom(2.0, doc.getUnitOfMeasure()));
            DocTable tblTiTaxes = docMaker.addDocTableNoBorder(doc, 1, 1);
            tblTiTaxes.setIsRepeatHead(true);
            ((TableRow)tblTiTaxes.getItsRows().get(0)).setIsHead(true);
            ((TableCell)tblTiTaxes.getItsCells().get(0)).setItsContent(this.i18n.getMsg(SaInTxLn.class.getSimpleName() + "s", upf.getLng().getIid()));
            ((TableCell)tblTiTaxes.getItsCells().get(0)).setFontNumber(1);
            tblTiTaxes.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiTaxes);
            doc.setContentPadding(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
            doc.setContentPaddingBottom(this.mmToDocUom(1.5, doc.getUnitOfMeasure()));
            if (stIb) {
                rowc = 3;
                rowtw = 40.0;
            } else {
                rowc = 2;
                rowtw = 70.0;
            }
            DocTable tbTxs = docMaker.addDocTable(doc, rowc, pInv.getTxLns().size() + 1);
            ((TableCell)tbTxs.getItsCells().get(0)).setItsContent(this.i18n.getMsg("tax", upf.getLng().getIid()));
            ((TableColumn)tbTxs.getItsColumns().get(0)).setIsWidthFixed(true);
            ((TableColumn)tbTxs.getItsColumns().get(0)).setWidthInPercentage(rowtw);
            if (stIb) {
                ((TableCell)tbTxs.getItsCells().get(1)).setItsContent(this.i18n.getMsg("txb", upf.getLng().getIid()));
            }
            ((TableCell)tbTxs.getItsCells().get(rowc - 1)).setItsContent(this.i18n.getMsg("tot", upf.getLng().getIid()));
            for (int i5 = 0; i5 < rowc; ++i5) {
                ((TableCell)tbTxs.getItsCells().get(i5)).setFontNumber(1);
                ((TableCell)tbTxs.getItsCells().get(i5)).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            int j = 1;
            for (SaInTxLn ln : pInv.getTxLns()) {
                BigDecimal txb;
                if (pInv.getCuFr() != null) {
                    txb = ln.getTxbFc();
                    tot = ln.getToFc();
                } else {
                    txb = ln.getTxb();
                    tot = ln.getTot();
                }
                i = 0;
                ((TableCell)tbTxs.getItsCells().get(j * rowc + i++)).setItsContent(ln.getTax().getNme());
                k = j * rowc + i++;
                if (stIb) {
                    ((TableCell)tbTxs.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    ((TableCell)tbTxs.getItsCells().get(k)).setItsContent(this.prn(as, cpf, upf, txb));
                    k = j * rowc + i++;
                }
                ((TableCell)tbTxs.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tbTxs.getItsCells().get(k)).setItsContent(this.prn(as, cpf, upf, tot));
                ++j;
            }
        }
        doc.setAlignHoriCont(EAlignHorizontal.RIGHT);
        DocTable tblRez = docMaker.addDocTableNoBorder(doc, 2, 3);
        ((TableCell)tblRez.getItsCells().get(0)).setFontNumber(1);
        ((TableCell)tblRez.getItsCells().get(0)).setItsContent(this.i18n.getMsg("subt", upf.getLng().getIid()) + ": ");
        ((TableCell)tblRez.getItsCells().get(1)).setFontNumber(1);
        if (pInv.getCuFr() != null) {
            subt = pInv.getSuFc();
            toTx = pInv.getTxFc();
            tot = pInv.getToFc();
        } else {
            subt = pInv.getSubt();
            toTx = pInv.getToTx();
            tot = pInv.getTot();
        }
        String cnt = isPrnCurLf ? curSign + this.prn(as, cpf, upf, subt) : this.prn(as, cpf, upf, subt) + curSign;
        ((TableCell)tblRez.getItsCells().get(1)).setItsContent(cnt);
        ((TableCell)tblRez.getItsCells().get(2)).setFontNumber(1);
        ((TableCell)tblRez.getItsCells().get(2)).setItsContent(this.i18n.getMsg("toTx", upf.getLng().getIid()) + ": ");
        ((TableCell)tblRez.getItsCells().get(3)).setFontNumber(1);
        cnt = isPrnCurLf ? curSign + this.prn(as, cpf, upf, toTx) : this.prn(as, cpf, upf, toTx) + curSign;
        ((TableCell)tblRez.getItsCells().get(3)).setItsContent(cnt);
        ((TableCell)tblRez.getItsCells().get(4)).setFontNumber(1);
        ((TableCell)tblRez.getItsCells().get(4)).setItsContent(this.i18n.getMsg("tot", upf.getLng().getIid()) + ": ");
        ((TableCell)tblRez.getItsCells().get(5)).setFontNumber(1);
        cnt = isPrnCurLf ? curSign + this.prn(as, cpf, upf, tot) : this.prn(as, cpf, upf, tot) + curSign;
        ((TableCell)tblRez.getItsCells().get(5)).setItsContent(cnt);
        tblRez.setAlignHorizontal(EAlignHorizontal.RIGHT);
        docMaker.makeDocTableWrapping(tblRez);
        docMaker.addPagination(doc);
        docMaker.deriveElements(doc);
        pdfMaker.prepareBeforeWrite(docPdf);
        this.pdfFactory.lazyGetPdfWriter().write(null, docPdf, pOus);
    }

    public final void refrInv(Map<String, Object> pRvs, SalInv pInv, String pLng, boolean pIsOverseas) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        this.orm.refrEnt(pRvs, vs, (IHasId)pInv);
        Object[] ndFlSil = new String[]{"subt", "toTx", "tdsc", "itm", "uom", "quan", "pri", "tot", "prFr", "suFr", "txFc", "toFc"};
        Arrays.sort(ndFlSil);
        vs.put("SaInGdLnndFds", ndFlSil);
        String[] ndFlItUm = new String[]{"nme"};
        vs.put("ItmndFds", ndFlItUm);
        vs.put("UomndFds", ndFlItUm);
        if (pIsOverseas) {
            pInv.setGdLns(this.getOrm().retLstQu(pRvs, vs, SaInGdLn.class, this.evalSaInOvrsGds(pInv.getIid().toString(), pLng)));
            vs.clear();
        } else {
            pInv.setGdLns(this.getOrm().retLstCnd(pRvs, vs, SaInGdLn.class, "where RVID is null and OWNR=" + pInv.getIid()));
            vs.clear();
        }
        vs.put("SaInSrLnndFds", ndFlSil);
        vs.put("SrvndFds", ndFlItUm);
        vs.put("UomndFds", ndFlItUm);
        if (pIsOverseas) {
            pInv.setSrLns(this.getOrm().retLstQu(pRvs, vs, SaInSrLn.class, this.evalSaInOvrsSrs(pInv.getIid().toString(), pLng)));
            vs.clear();
        } else {
            pInv.setSrLns(this.getOrm().retLstCnd(pRvs, vs, SaInSrLn.class, "where RVID is null and OWNR=" + pInv.getIid()));
            vs.clear();
        }
        vs.put("SalInvdpLv", 0);
        pInv.setTxLns(this.getOrm().retLstCnd(pRvs, vs, SaInTxLn.class, "where OWNR=" + pInv.getIid()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String evalSaInOvrsSrs(String pInvId, String pLng) throws Exception {
        if (this.slInOvrsSrs == null) {
            InvPdf invPdf = this;
            synchronized (invPdf) {
                if (this.slInOvrsSrs == null) {
                    String flName = "/acc/rep/saInOvrsSrs.sql";
                    this.slInOvrsSrs = this.loadStr(flName);
                }
            }
        }
        return this.slInOvrsSrs.replace(":OWNR", pInvId).replace(":LNG", pLng);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String evalSaInOvrsGds(String pInvId, String pLng) throws Exception {
        if (this.saInOvrsGds == null) {
            InvPdf invPdf = this;
            synchronized (invPdf) {
                if (this.saInOvrsGds == null) {
                    String flName = "/acc/rep/saInOvrsGds.sql";
                    this.saInOvrsGds = this.loadStr(flName);
                }
            }
        }
        return this.saInOvrsGds.replace(":OWNR", pInvId).replace(":LNG", pLng);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadStr(String pFlNm) throws IOException {
        URL urlFile = InvPdf.class.getResource(pFlNm);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = InvPdf.class.getResourceAsStream(pFlNm);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        throw new RuntimeException("File not found: " + pFlNm);
    }

    public final String prn(AcStg pAs, CmnPrf pCpf, UsPrf pUpf, BigDecimal pVal) {
        return this.numStr.frmt(pVal.toString(), pCpf.getDcSpv(), pCpf.getDcGrSpv(), pAs.getRpDp(), pUpf.getDgInGr());
    }

    public final double mmToDocUom(double pValue, EUnitOfMeasure pUom) {
        if (pUom.equals((Object)EUnitOfMeasure.INCH)) {
            return pValue / 25.4;
        }
        return pValue;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final IPdfFactory<WI> getPdfFactory() {
        return this.pdfFactory;
    }

    public final void setPdfFactory(IPdfFactory<WI> pFactory) {
        this.pdfFactory = pFactory;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final INumStr getNumStr() {
        return this.numStr;
    }

    public final void setNumStr(INumStr pNumStr) {
        this.numStr = pNumStr;
    }
}

