/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.rep;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.acc.mdl.LdgDe;
import org.beigesoft.acc.mdl.LdgDeLn;
import org.beigesoft.acc.mdl.LdgPrv;
import org.beigesoft.acc.mdl.LdgPrvLn;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.srv.ISrBlnc;
import org.beigesoft.mdl.IRecSet;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrc;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.ISrvDt;

public class PrLdgr<RS>
implements IPrc {
    private IRdb<RS> rdb;
    private Integer trIsl;
    private ISrvDt srvDt;
    private ISrBlnc srBlnc;
    private String quDet;
    private String quPrv;

    public final synchronized void process(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        LdgPrv ldgPrv = new LdgPrv();
        LdgDe ldgDe = new LdgDe();
        Date dt1 = this.srvDt.from8601DateTime(pRqDt.getParam("dt1"));
        Date dt2 = this.srvDt.from8601DateTime(pRqDt.getParam("dt2"));
        pRvs.put("dt1", dt1);
        pRvs.put("dt2", dt2);
        pRvs.put("ldgPrv", ldgPrv);
        pRvs.put("ldgDe", ldgDe);
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(this.trIsl.intValue());
            this.rdb.begin();
            this.mkPrv(pRvs, pRqDt);
            this.mkDet(pRvs, pRqDt);
            pRqDt.setAttr("rnd", (Object)"ldgr");
            this.rdb.commit();
        }
        catch (Exception ex) {
            this.srBlnc.hndRlBk(pRvs);
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void mkPrv(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        LdgPrv ldgPrv = (LdgPrv)pRvs.get("ldgPrv");
        String accId = pRqDt.getParam("accId");
        String saId = pRqDt.getParam("saId");
        Date dt1 = (Date)pRvs.get("dt1");
        Date dtbln = this.srBlnc.evDtPrvPerSt(pRvs, vs, dt1);
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        String qu = this.lazQuPrv().replace(":ACCID", accId);
        qu = qu.replace(":DT1", String.valueOf(dt1.getTime()));
        qu = qu.replace(":DTBLN", String.valueOf(dtbln.getTime()));
        if (saId != null && !"".equals(saId)) {
            qu = qu.replace(":SUBACC", " and SAID=" + saId);
            qu = qu.replace(":SADNM", " and SADID=" + saId);
            qu = qu.replace(":SACNM", " and SACID=" + saId);
        } else {
            qu = qu.replace(":SUBACC", "");
            qu = qu.replace(":SADNM", "");
            qu = qu.replace(":SACNM", "");
        }
        Integer blTy = null;
        try (IRecSet rs = null;){
            rs = this.getRdb().retRs(qu);
            if (rs.first()) {
                do {
                    if (blTy == null) {
                        blTy = rs.getInt("BLTY");
                    }
                    String subacc = rs.getStr("SUBACC");
                    LdgPrvLn ldgPrvLn = new LdgPrvLn();
                    if (subacc != null) {
                        ldgPrv.getLnsMp().put(subacc, ldgPrvLn);
                    }
                    Double debt = rs.getDouble("DEBT");
                    Double cred = rs.getDouble("CRED");
                    ldgPrvLn.setDebt(BigDecimal.valueOf(debt).setScale((int)as.getRpDp(), as.getRndm()));
                    ldgPrvLn.setCred(BigDecimal.valueOf(cred).setScale((int)as.getRpDp(), as.getRndm()));
                    if (blTy == 0) {
                        ldgPrvLn.setBlnc(ldgPrvLn.getDebt().subtract(ldgPrvLn.getCred()));
                    } else {
                        ldgPrvLn.setBlnc(ldgPrvLn.getCred().subtract(ldgPrvLn.getDebt()));
                    }
                    ldgPrv.setDebitAcc(ldgPrv.getDebitAcc().add(ldgPrvLn.getDebt()));
                    ldgPrv.setCreditAcc(ldgPrv.getCreditAcc().add(ldgPrvLn.getCred()));
                    ldgPrv.setBalanceAcc(ldgPrv.getBalanceAcc().add(ldgPrvLn.getBlnc()));
                } while (rs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void mkDet(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        LdgPrv ldgPrv = (LdgPrv)pRvs.get("ldgPrv");
        LdgDe ldgDe = (LdgDe)pRvs.get("ldgDe");
        String accId = pRqDt.getParam("accId");
        String saId = pRqDt.getParam("saId");
        Date dt1 = (Date)pRvs.get("dt1");
        Date dt2 = (Date)pRvs.get("dt2");
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        ldgDe.setDebitAcc(ldgPrv.getDebitAcc());
        ldgDe.setCreditAcc(ldgPrv.getCreditAcc());
        ldgDe.setBalanceAcc(ldgPrv.getBalanceAcc());
        for (Map.Entry<String, LdgPrvLn> enr : ldgPrv.getLnsMp().entrySet()) {
            ldgDe.getSaDbTo().put(enr.getKey(), enr.getValue().getDebt());
            ldgDe.getSaCrTo().put(enr.getKey(), enr.getValue().getCred());
            ldgDe.getSaBlnTo().put(enr.getKey(), enr.getValue().getBlnc());
        }
        String qu = this.lazQuDet().replace(":ACCID", accId);
        qu = qu.replace(":DT1", String.valueOf(dt1.getTime()));
        qu = qu.replace(":DT2", String.valueOf(dt2.getTime()));
        if (saId != null && !"".equals(saId)) {
            qu = qu.replace(":SADNM", " and SADID=" + saId);
            qu = qu.replace(":SACNM", " and SACID=" + saId);
        } else {
            qu = qu.replace(":SADNM", "");
            qu = qu.replace(":SACNM", "");
        }
        try (IRecSet rs = null;){
            rs = this.getRdb().retRs(qu);
            Integer blTy = null;
            if (rs.first()) {
                do {
                    if (blTy == null) {
                        blTy = rs.getInt("BLTY");
                    }
                    LdgDeLn ldgDeLn = new LdgDeLn();
                    ldgDe.getLns().add(ldgDeLn);
                    String subacc = rs.getStr("SUBACC");
                    if (subacc != null) {
                        ldgDeLn.setSubacc(subacc);
                        if (ldgDe.getSaDbTo().get(subacc) == null) {
                            ldgDe.getSaDbTo().put(subacc, BigDecimal.ZERO);
                        }
                        if (ldgDe.getSaCrTo().get(subacc) == null) {
                            ldgDe.getSaCrTo().put(subacc, BigDecimal.ZERO);
                        }
                        if (ldgDe.getSaBlnTo().get(subacc) == null) {
                            ldgDe.getSaBlnTo().put(subacc, BigDecimal.ZERO);
                        }
                    }
                    ldgDeLn.setDat(new Date(rs.getLong("DAT")));
                    ldgDeLn.setCrAcNm(rs.getStr("CRACNM"));
                    ldgDeLn.setCrAcNmb(rs.getStr("CRACNMB"));
                    ldgDeLn.setCrSaNm(rs.getStr("CRSAC"));
                    ldgDeLn.setDscr(rs.getStr("DSCR"));
                    Double tot = rs.getDouble("TOT");
                    Integer isDebt = rs.getInt("ISDEBT");
                    if (isDebt == 1) {
                        ldgDeLn.setDebt(BigDecimal.valueOf(tot).setScale((int)as.getRpDp(), as.getRndm()));
                        if (blTy == 0) {
                            ldgDeLn.setBlnc(ldgDe.getBalanceAcc().add(ldgDeLn.getDebt()));
                        } else {
                            ldgDeLn.setBlnc(ldgDe.getBalanceAcc().subtract(ldgDeLn.getDebt()));
                        }
                        if (subacc != null) {
                            if (blTy == 0) {
                                ldgDeLn.setBlncSa(ldgDe.getSaBlnTo().get(subacc).add(ldgDeLn.getDebt()));
                            } else {
                                ldgDeLn.setBlncSa(ldgDe.getSaBlnTo().get(subacc).subtract(ldgDeLn.getDebt()));
                            }
                            ldgDe.getSaBlnTo().put(subacc, ldgDeLn.getBlncSa());
                            ldgDe.getSaDbTo().put(subacc, ldgDe.getSaDbTo().get(subacc).add(ldgDeLn.getDebt()));
                        }
                    } else {
                        ldgDeLn.setCred(BigDecimal.valueOf(tot).setScale((int)as.getRpDp(), as.getRndm()));
                        if (blTy == 0) {
                            ldgDeLn.setBlnc(ldgDe.getBalanceAcc().subtract(ldgDeLn.getCred()));
                        } else {
                            ldgDeLn.setBlnc(ldgDe.getBalanceAcc().add(ldgDeLn.getCred()));
                        }
                        if (subacc != null) {
                            if (blTy == 0) {
                                ldgDeLn.setBlncSa(ldgDe.getSaBlnTo().get(subacc).subtract(ldgDeLn.getCred()));
                            } else {
                                ldgDeLn.setBlncSa(ldgDe.getSaBlnTo().get(subacc).add(ldgDeLn.getCred()));
                            }
                            ldgDe.getSaBlnTo().put(subacc, ldgDeLn.getBlncSa());
                            ldgDe.getSaCrTo().put(subacc, ldgDe.getSaCrTo().get(subacc).add(ldgDeLn.getCred()));
                        }
                    }
                    ldgDe.setDebitAcc(ldgDe.getDebitAcc().add(ldgDeLn.getDebt()));
                    ldgDe.setCreditAcc(ldgDe.getCreditAcc().add(ldgDeLn.getCred()));
                    if (blTy == 0) {
                        ldgDe.setBalanceAcc(ldgDe.getBalanceAcc().add(ldgDeLn.getDebt()).subtract(ldgDeLn.getCred()));
                        continue;
                    }
                    ldgDe.setBalanceAcc(ldgDe.getBalanceAcc().subtract(ldgDeLn.getDebt()).add(ldgDeLn.getCred()));
                } while (rs.next());
            }
        }
    }

    public final synchronized String lazQuDet() throws IOException {
        if (this.quDet == null) {
            this.quDet = this.loadStr("/acc/ldgDet.sql");
        }
        return this.quDet;
    }

    public final synchronized String lazQuPrv() throws IOException {
        if (this.quPrv == null) {
            this.quPrv = this.loadStr("/acc/ldgPrv.sql");
        }
        return this.quPrv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String loadStr(String pFlNm) throws IOException {
        URL urlFile = PrLdgr.class.getResource(pFlNm);
        if (urlFile != null) {
            try (InputStream is = null;){
                is = PrLdgr.class.getResourceAsStream(pFlNm);
                byte[] bArray = new byte[is.available()];
                is.read(bArray, 0, is.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        throw new RuntimeException("File not found: " + pFlNm);
    }

    public final synchronized IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final synchronized void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final synchronized Integer getTrIsl() {
        return this.trIsl;
    }

    public final synchronized void setTrIsl(Integer pTrIsl) {
        this.trIsl = pTrIsl;
    }

    public final synchronized ISrvDt getSrvDt() {
        return this.srvDt;
    }

    public final synchronized void setSrvDt(ISrvDt pSrvDt) {
        this.srvDt = pSrvDt;
    }

    public final synchronized ISrBlnc getSrBlnc() {
        return this.srBlnc;
    }

    public final synchronized void setSrBlnc(ISrBlnc pSrBlnc) {
        this.srBlnc = pSrBlnc;
    }
}

