/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.rep;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.beigesoft.acc.mdl.BlnLn;
import org.beigesoft.acc.mdl.BlnSht;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.rep.ISrBlnSht;
import org.beigesoft.acc.srv.ISrAcStg;
import org.beigesoft.acc.srv.ISrBlnc;
import org.beigesoft.mdl.IRecSet;
import org.beigesoft.rdb.IRdb;

public class SrBlnSht<RS>
implements ISrBlnSht {
    private IRdb<RS> rdb;
    private ISrAcStg srAcStg;
    private ISrBlnc srBlnc;
    private String quBlnc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized BlnSht retBlnc(Map<String, Object> pRvs, Date pDt) throws Exception {
        ISrBlnc iSrBlnc = this.srBlnc;
        synchronized (iSrBlnc) {
            this.srBlnc.chngSacsIfNd(pRvs);
            this.srBlnc.recalcIfNd(pRvs, pDt);
        }
        AcStg as = this.srAcStg.lazAcStg(pRvs);
        BlnSht rz = new BlnSht();
        rz.setDat(pDt);
        String query = this.evQuBlnc(pRvs, pDt);
        try (IRecSet rs = null;){
            rs = this.getRdb().retRs(query);
            if (rs.first()) {
                do {
                    String accName = rs.getStr("NME");
                    Integer accType = rs.getInt("TYP");
                    String accNumber = rs.getStr("NMBR");
                    Double debit = rs.getDouble("DEBT");
                    Double credit = rs.getDouble("CRED");
                    if (debit == 0.0 && credit == 0.0) continue;
                    BlnLn bl = new BlnLn();
                    bl.setAccName(accName);
                    bl.setAccNumber(accNumber);
                    bl.setAccType(accType);
                    bl.setDebit(BigDecimal.valueOf(debit).setScale((int)as.getRpDp(), as.getRndm()));
                    bl.setCredit(BigDecimal.valueOf(credit).setScale((int)as.getRpDp(), as.getRndm()));
                    if (bl.getDebit().doubleValue() == 0.0 && bl.getCredit().doubleValue() == 0.0) continue;
                    rz.getLns().add(bl);
                    if (accType == 0) {
                        rz.setToLnAs(rz.getToLnAs() + 1);
                        rz.setTotAss(rz.getTotAss().add(bl.getDebit().subtract(bl.getCredit())));
                        continue;
                    }
                    if (accType == 1) {
                        rz.setToLnLi(rz.getToLnLi() + 1);
                        rz.setTotLia(rz.getTotLia().add(bl.getCredit().subtract(bl.getDebit())));
                        continue;
                    }
                    if (accType != 2) continue;
                    rz.setToLnOe(rz.getToLnOe() + 1);
                    rz.setTotOwe(rz.getTotOwe().add(bl.getCredit().subtract(bl.getDebit())));
                } while (rs.next());
            }
        }
        rz.setDetRc(Math.max(rz.getToLnAs(), rz.getToLnLi() + rz.getToLnOe() + 3));
        return rz;
    }

    public final synchronized String evQuBlnc(Map<String, Object> pRvs, Date pDt) throws Exception {
        if (this.quBlnc == null) {
            String flName = "/acc/blnSht.sql";
            this.quBlnc = this.loadStr(flName);
        }
        String query = this.quBlnc.replace(":DT1", String.valueOf(this.getSrBlnc().evDtStPer(pRvs, pDt).getTime()));
        query = query.replace(":DT2", String.valueOf(pDt.getTime()));
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String loadStr(String pFlNm) throws IOException {
        URL urlFile = SrBlnSht.class.getResource(pFlNm);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = SrBlnSht.class.getResourceAsStream(pFlNm);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        throw new RuntimeException("File not found: " + pFlNm);
    }

    public final synchronized IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final synchronized void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final synchronized ISrAcStg getSrAcStg() {
        return this.srAcStg;
    }

    public final synchronized void setSrAcStg(ISrAcStg pSrAcStg) {
        this.srAcStg = pSrAcStg;
    }

    public final synchronized ISrBlnc getSrBlnc() {
        return this.srBlnc;
    }

    public final synchronized void setSrBlnc(ISrBlnc pSrBlnc) {
        this.srBlnc = pSrBlnc;
    }
}

