/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.srv;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdlb.APaym;
import org.beigesoft.acc.mdlb.APrep;
import org.beigesoft.acc.mdlp.PuRtLn;
import org.beigesoft.acc.mdlp.PurRet;
import org.beigesoft.acc.srv.IRvInvLn;
import org.beigesoft.acc.srv.ISrDrItEnr;
import org.beigesoft.acc.srv.ISrWrhEnr;
import org.beigesoft.hld.HldUvd;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.II18n;

public class RvPuRtLn<RS>
implements IRvInvLn<PurRet, PuRtLn> {
    private IRdb<RS> rdb;
    private IOrm orm;
    private ISrWrhEnr srWrhEnr;
    private ISrDrItEnr srDrItEnr;
    private HldUvd hldUvd;
    private II18n i18n;

    @Override
    public final List<PuRtLn> retChkLns(Map<String, Object> pRvs, Map<String, Object> pVs, PurRet pEnt) throws Exception {
        String[] lstFds = this.hldUvd.lazLstFds(PuRtLn.class);
        Object[] ndFds = Arrays.copyOf(lstFds, lstFds.length);
        Arrays.sort(ndFds);
        pVs.put("PuRtLnndFds", ndFds);
        List lst = this.orm.retLstCnd(pRvs, pVs, PuRtLn.class, "where PURTLN.RVID is null and PURTLN.OWNR=" + pEnt.getIid());
        pVs.clear();
        return lst;
    }

    @Override
    public final void revLns(Map<String, Object> pRvs, Map<String, Object> pVs, PurRet pEnt, PuRtLn pRvng, PuRtLn pRved) throws Exception {
        this.rdb.delete("PURTLTL", "OWNR=" + pRved.getIid());
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        pRvng.setInvl(pRved.getInvl());
        StringBuffer sb = new StringBuffer();
        if (pRvng.getDscr() != null) {
            sb.append(pRvng.getDscr() + " !");
        }
        sb.append(this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
        sb.append(" #" + pRved.getDbOr() + "-" + pRved.getIid());
        pRvng.setDscr(sb.toString());
        this.orm.insIdLn(pRvs, pVs, (IHasId)pRvng);
        this.srWrhEnr.revDraw(pRvs, pRvng);
        this.srDrItEnr.rvDraw(pRvs, pRvng);
        sb.delete(0, sb.length());
        if (pRved.getDscr() != null) {
            sb.append(pRved.getDscr() + " !");
        }
        sb.append(this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()));
        sb.append(" #" + pRvng.getDbOr() + "-" + pRvng.getIid());
        pRved.setDscr(sb.toString());
        pRved.setRvId(pRvng.getIid());
        Object[] ndFds = new String[]{"dscr", "rvId", "ver"};
        Arrays.sort(ndFds);
        pVs.put("ndFds", ndFds);
        this.orm.update(pRvs, pVs, (IHasId)pRved);
        pVs.clear();
    }

    @Override
    public final Class<? extends APrep> getPrepCls() {
        throw new RuntimeException("Not allowed!");
    }

    @Override
    public final Class<? extends APaym<?>> getPaymCls() {
        throw new RuntimeException("Not allowed!");
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrWrhEnr getSrWrhEnr() {
        return this.srWrhEnr;
    }

    public final void setSrWrhEnr(ISrWrhEnr pSrWrhEnr) {
        this.srWrhEnr = pSrWrhEnr;
    }

    public final HldUvd getHldUvd() {
        return this.hldUvd;
    }

    public final void setHldUvd(HldUvd pHldUvd) {
        this.hldUvd = pHldUvd;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final ISrDrItEnr getSrDrItEnr() {
        return this.srDrItEnr;
    }

    public final void setSrDrItEnr(ISrDrItEnr pSrDrItEnr) {
        this.srDrItEnr = pSrDrItEnr;
    }
}

