/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.srv;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.acc.mdl.ECogsMth;
import org.beigesoft.acc.mdl.EDocTy;
import org.beigesoft.acc.mdlb.ADrItEnr;
import org.beigesoft.acc.mdlb.IDcDri;
import org.beigesoft.acc.mdlb.IItmSrc;
import org.beigesoft.acc.mdlb.IMkDriEnr;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.DriEnrSr;
import org.beigesoft.acc.mdlp.WrhPl;
import org.beigesoft.acc.srv.ISrDrItEnr;
import org.beigesoft.acc.srv.ISrWrhEnr;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.IHlIntCls;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.ColVals;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IRecSet;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.rdb.SrvClVl;
import org.beigesoft.srv.II18n;

public class SrDrItEnr<RS>
implements ISrDrItEnr {
    private ILog log;
    private IOrm orm;
    private IRdb<RS> rdb;
    private II18n i18n;
    private SrvClVl srvClVl;
    private IHlIntCls hlTyItSr;
    private IHlIntCls hlTyEnSr;
    private ISrWrhEnr srWrhEnr;
    private boolean isAndr;
    private Map<String, String> entrQus = new HashMap<String, String>();
    private List<DriEnrSr> entrSrcs;

    @Override
    public final synchronized void hndStgCng(Map<String, Object> pRvs) throws Exception {
        this.entrSrcs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T extends ADrItEnr> void draw(Map<String, Object> pRvs, IMkDriEnr<T> pDrer) throws Exception {
        ArrayList<IItmSrc> isrs;
        BigDecimal itq;
        block20: {
            HashMap vs = new HashMap();
            if (this.entrSrcs == null) {
                SrDrItEnr srDrItEnr = this;
                synchronized (srDrItEnr) {
                    if (this.entrSrcs == null) {
                        this.entrSrcs = this.orm.retLst(pRvs, vs, DriEnrSr.class);
                    }
                }
            }
            StringBuffer sb = new StringBuffer("select SRTY, DAT, IID, OWID, WRHP, TOLF, ITLF from(\n");
            boolean isFst = true;
            for (DriEnrSr ensr : this.entrSrcs) {
                if (!ensr.getUsed().booleanValue() || ensr.getSrsTy() != pDrer.getSrsTy()) continue;
                String qu = this.lazEntrQu(ensr.getQuFl());
                qu = qu.replace(":DBOR", this.orm.getDbId().toString());
                qu = qu.replace(":ITM", pDrer.getItm().getIid().toString());
                qu = qu.replace(":UOM", pDrer.getUom().getIid().toString());
                if (isFst) {
                    isFst = false;
                } else {
                    sb.append("\nunion all\n");
                }
                sb.append(qu);
            }
            if (isFst) {
                throw new ExcCode(1003, "dri_entr_src_no_set");
            }
            AcStg as = (AcStg)((Object)pRvs.get("astg"));
            if (as.getCogs() == ECogsMth.FIFO) {
                sb.append("\n) as ALRC order by DAT asc");
            } else if (as.getCogs() == ECogsMth.LIFO) {
                sb.append("\n) as ALRC order by DAT desc");
            } else {
                throw new ExcCode(1003, "cogs_av_not_imp");
            }
            long lim = pDrer.getQuan().longValue() + 1L;
            sb.append(" limit " + lim + ";");
            String qu = sb.toString();
            IRecSet rs = null;
            itq = BigDecimal.ZERO;
            isrs = new ArrayList<IItmSrc>();
            try {
                rs = this.getRdb().retRs(qu);
                if (!rs.first()) break block20;
                do {
                    Integer srTy = rs.getInt("SRTY");
                    IItmSrc sr = (IItmSrc)this.hlTyItSr.get(srTy).newInstance();
                    isrs.add(sr);
                    sr.setIid(rs.getLong("IID"));
                    sr.setDbOr(this.orm.getDbId());
                    sr.setOwnrId(rs.getLong("OWID"));
                    sr.setDocDt(new Date(rs.getLong("DAT")));
                    sr.setItLf(BigDecimal.valueOf(rs.getDouble("ITLF")));
                    sr.setToLf(BigDecimal.valueOf(rs.getDouble("TOLF")));
                    WrhPl wrhp = new WrhPl();
                    wrhp.setIid(rs.getLong("WRHP"));
                    sr.setWrhp(wrhp);
                    sr.setItm(pDrer.getItm());
                    sr.setUom(pDrer.getUom());
                    itq = itq.add(sr.getItLf());
                    if (itq.compareTo(pDrer.getQuan()) < 0) continue;
                    break;
                } while (rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        if (itq.compareTo(pDrer.getQuan()) == -1) {
            throw new ExcCode(1003, "THERE_IS_NO_GOODS");
        }
        itq = pDrer.getQuan();
        for (IItmSrc sr : isrs) {
            BigDecimal quan = itq.min(sr.getItLf());
            this.drawFr(pRvs, pDrer, sr, quan);
            itq = itq.subtract(quan);
        }
    }

    @Override
    public final <T extends ADrItEnr> void drawFr(Map<String, Object> pRvs, IMkDriEnr<T> pDrer, IItmSrc pSrc, BigDecimal pQuan) throws Exception {
        if (pSrc.getItLf().compareTo(pQuan) == -1) {
            throw new ExcCode(1001, "Src has no enough items! srCls/itLf/quan: " + pSrc.getClass() + "/" + pSrc.getItLf() + "/" + pQuan);
        }
        HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        DateFormat dtFr = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
        BigDecimal tot = pQuan.compareTo(pSrc.getItLf()) == 0 ? pSrc.getToLf() : pSrc.getToLf().divide(pSrc.getItLf(), 15, as.getRndm()).multiply(pQuan).setScale((int)as.getPrDp(), as.getRndm());
        pSrc.setToLf(pSrc.getToLf().subtract(tot));
        pSrc.setItLf(pSrc.getItLf().subtract(pQuan));
        if (this.isAndr) {
            Object[] ndf = new String[]{"itLf", "toLf", "ver"};
            Arrays.sort(ndf);
            vs.put("ndFds", ndf);
            this.orm.update(pRvs, vs, (IHasId)pSrc);
            vs.clear();
        } else {
            ColVals cv = new ColVals();
            this.srvClVl.put(cv, "itLf", "ITLF-" + pQuan);
            this.srvClVl.put(cv, "toLf", Double.valueOf(pSrc.getToLf().doubleValue()));
            this.srvClVl.putExpr(cv, "itLf");
            this.srvClVl.put(cv, "ver", "VER+1");
            this.srvClVl.putExpr(cv, "ver");
            try {
                this.rdb.update(pSrc.getClass(), cv, "IID=" + pSrc.getIid());
            }
            catch (Exception e) {
                this.log.error(pRvs, this.getClass(), "THERE_IS_NO_GOODS", (Throwable)e);
                throw new ExcCode(1003, "THERE_IS_NO_GOODS");
            }
        }
        ADrItEnr enr = (ADrItEnr)pDrer.getEnrCls().newInstance();
        enr.setDbOr(this.orm.getDbId());
        enr.setSrTy(pSrc.cnsTy());
        enr.setSrId((Long)pSrc.getIid());
        enr.setSowTy(pSrc.getOwnrTy());
        enr.setSowId(pSrc.getOwnrId());
        enr.setDrTy(pDrer.cnsTy());
        enr.setDrId((Long)pDrer.getIid());
        enr.setDowTy(pDrer.getOwnrTy());
        enr.setDowId(pDrer.getOwnrId());
        enr.setItm(pDrer.getItm());
        enr.setUom(pDrer.getUom());
        enr.setQuan(pQuan);
        enr.setTot(tot);
        StringBuffer sb = this.mkDscr(pRvs, pDrer, dtFr);
        sb.append(", " + this.getI18n().getMsg("from", cpf.getLngDef().getIid()) + " " + this.getI18n().getMsg(pSrc.getClass().getSimpleName() + "sht", cpf.getLngDef().getIid()));
        sb.append(" #" + pSrc.getDbOr() + "-" + pSrc.getIid());
        if (pSrc.getOwnrTy() != null) {
            sb.append(", " + this.getI18n().getMsg("in", cpf.getLngDef().getIid()) + " " + this.getI18n().getMsg(this.hlTyEnSr.get(pSrc.getOwnrTy()).getSimpleName() + "sht", cpf.getLngDef().getIid()));
            sb.append(" #" + pSrc.getDbOr() + "-" + pSrc.getOwnrId());
        }
        sb.append(", " + dtFr.format(pSrc.getDocDt()));
        enr.setDscr(sb.toString());
        this.orm.insIdLn(pRvs, vs, (IHasId)enr);
        this.srWrhEnr.draw(pRvs, pDrer, pSrc.getWrhp(), pQuan);
    }

    @Override
    public final <T extends ADrItEnr> void rvDraw(Map<String, Object> pRvs, IMkDriEnr<T> pDrer) throws Exception {
        HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
        List revds = this.orm.retLstCnd(pRvs, vs, pDrer.getEnrCls(), "where DRTY=" + pDrer.cnsTy() + " and DRID=" + pDrer.getRvId());
        if (revds.size() == 0) {
            throw new ExcCode(1001, "Can't reverse for CLS/RVID/ID/TY: " + pDrer.getClass() + "/" + pDrer.getRvId() + "/" + pDrer.getIid() + "/" + pDrer.cnsTy());
        }
        for (ADrItEnr revd : revds) {
            if (revd.getRvId() != null) {
                throw new ExcCode(1001, "Reverse reversed for CLS/RVID/ID/TY: " + pDrer.getClass() + "/" + pDrer.getRvId() + "/" + pDrer.getIid() + "/" + pDrer.cnsTy());
            }
            ADrItEnr revg = (ADrItEnr)pDrer.getEnrCls().newInstance();
            revg.setDbOr(this.orm.getDbId());
            revg.setDrTy(pDrer.cnsTy());
            revg.setDrId((Long)pDrer.getIid());
            revg.setDowTy(pDrer.getOwnrTy());
            revg.setDowId(pDrer.getOwnrId());
            revg.setSrTy(revd.getSrTy());
            revg.setSrId(revd.getSrId());
            revg.setSowTy(revd.getSowTy());
            revg.setSowId(revd.getSowId());
            revg.setRvId(revd.getIid());
            revg.setItm(revd.getItm());
            revg.setUom(revd.getUom());
            revg.setQuan(revd.getQuan().negate());
            revg.setTot(revd.getTot().negate());
            CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
            DateFormat dtFr = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
            StringBuffer sb = this.mkDscr(pRvs, pDrer, dtFr);
            sb.append(" ," + this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
            sb.append(" #" + revd.getDbOr() + "-" + revd.getIid());
            revg.setDscr(sb.toString() + "!");
            this.orm.insIdLn(pRvs, vs, (IHasId)revg);
            revd.setRvId(revg.getIid());
            revd.setDscr(revd.getDscr() + ", !" + this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()) + " #" + revg.getDbOr() + "-" + revg.getIid() + "!");
            Object[] ndFds = new String[]{"dscr", "rvId", "ver"};
            Arrays.sort(ndFds);
            vs.put("ndFds", ndFds);
            this.orm.update(pRvs, vs, (IHasId)revd);
            vs.clear();
            IItmSrc sr = (IItmSrc)this.hlTyItSr.get(revd.getSrTy()).newInstance();
            sr.setIid(revd.getSrId());
            if (this.isAndr) {
                Object[] ndf = new String[]{"itLf", "toLf", "ver"};
                Arrays.sort(ndf);
                vs.put(sr.getClass().getSimpleName() + "ndFds", ndf);
                this.orm.refrEnt(pRvs, vs, (IHasId)sr);
                vs.clear();
                sr.setItLf(sr.getItLf().add(revd.getQuan()));
                sr.setToLf(sr.getToLf().add(revd.getTot()));
                vs.put("ndFds", ndf);
                this.orm.update(pRvs, vs, (IHasId)sr);
                vs.clear();
                continue;
            }
            ColVals cv = new ColVals();
            this.srvClVl.put(cv, "itLf", "ITLF+" + revd.getQuan());
            this.srvClVl.put(cv, "toLf", "TOLF+" + revd.getTot());
            this.srvClVl.putExpr(cv, "itLf");
            this.srvClVl.putExpr(cv, "toLf");
            this.srvClVl.put(cv, "ver", "VER+1");
            this.srvClVl.putExpr(cv, "ver");
            this.rdb.update(sr.getClass(), cv, "IID=" + sr.getIid());
        }
    }

    @Override
    public final <T extends ADrItEnr> List<T> retEntrs(Map<String, Object> pRvs, IDcDri pDoc, Class<T> pEnrCls) throws Exception {
        String whe;
        if (pDoc.getDocTy() == EDocTy.DRAWLN) {
            whe = "where DOWTY=" + pDoc.cnsTy() + " and DOWID=" + pDoc.getIid();
        } else if (pDoc.getDocTy() == EDocTy.DRAWBTH) {
            whe = "where (DOWTY=" + pDoc.cnsTy() + " and DOWID=" + pDoc.getIid() + ") or (DRTY=" + pDoc.cnsTy() + " and DRID=" + pDoc.getIid() + ")";
        } else if (pDoc.getDocTy() == EDocTy.DRAW) {
            whe = "where DRTY=" + pDoc.cnsTy() + " and DRID=" + pDoc.getIid();
        } else if (pDoc.getDocTy() == EDocTy.ITSRLN) {
            whe = "where SOWTY=" + pDoc.cnsTy() + " and SOWID=" + pDoc.getIid();
        } else if (pDoc.getDocTy() == EDocTy.ITSRBTH) {
            whe = "where (SOWTY=" + pDoc.cnsTy() + " and SOWID=" + pDoc.getIid() + ") or (SRTY=" + pDoc.cnsTy() + " and SRID=" + pDoc.getIid() + ")";
        } else if (pDoc.getDocTy() == EDocTy.ITSR) {
            whe = "where SRTY=" + pDoc.cnsTy() + " and SRID=" + pDoc.getIid();
        } else if (pDoc.getDocTy() == EDocTy.ITSRDRAWLN) {
            whe = "where (SRTY=" + pDoc.cnsTy() + " and SRID=" + pDoc.getIid() + ") or (DOWTY=" + pDoc.cnsTy() + " and DOWID=" + pDoc.getIid() + ")";
        } else if (pDoc.getDocTy() == EDocTy.ITSRDRAW) {
            whe = "where (SRTY=" + pDoc.cnsTy() + " and SRID=" + pDoc.getIid() + ") or (DRTY=" + pDoc.cnsTy() + " and DRID=" + pDoc.getIid() + ")";
        } else {
            throw new Exception("Not allowed!");
        }
        HashMap vs = new HashMap();
        List rz = this.orm.retLstCnd(pRvs, vs, pEnrCls, whe);
        return rz;
    }

    public final StringBuffer mkDscr(Map<String, Object> pRvs, IMkDriEnr pDrer, DateFormat pDtFrm) throws Exception {
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        StringBuffer sb = new StringBuffer();
        sb.append(this.getI18n().getMsg("Made_at", cpf.getLngDef().getIid()) + " " + pDtFrm.format(new Date()) + " ");
        sb.append(this.getI18n().getMsg("by_who", cpf.getLngDef().getIid()) + ": ");
        sb.append(this.getI18n().getMsg(pDrer.getClass().getSimpleName() + "sht", cpf.getLngDef().getIid()) + " #" + pDrer.getDbOr() + "-" + pDrer.getIid());
        if (pDrer.getOwnrId() != null) {
            sb.append(", " + this.getI18n().getMsg("in", cpf.getLngDef().getIid()) + " " + this.getI18n().getMsg(this.hlTyEnSr.get(pDrer.getOwnrTy()).getSimpleName() + "sht", cpf.getLngDef().getIid()));
            sb.append(" #" + pDrer.getDbOr() + "-" + pDrer.getOwnrId());
        }
        sb.append(", " + pDtFrm.format(pDrer.getDocDt()));
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String lazEntrQu(String pFlNm) throws IOException {
        String rz = this.entrQus.get(pFlNm);
        if (rz == null) {
            SrDrItEnr srDrItEnr = this;
            synchronized (srDrItEnr) {
                rz = this.entrQus.get(pFlNm);
                if (rz == null) {
                    rz = this.loadStr("/acc/dri/" + pFlNm + ".sql");
                    this.entrQus.put(pFlNm, rz);
                }
            }
        }
        return rz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadStr(String pFlNm) throws IOException {
        URL urlFile = SrDrItEnr.class.getResource(pFlNm);
        if (urlFile != null) {
            try (InputStream is = null;){
                is = SrDrItEnr.class.getResourceAsStream(pFlNm);
                byte[] bArray = new byte[is.available()];
                is.read(bArray, 0, is.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        throw new RuntimeException("File not found: " + pFlNm);
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final SrvClVl getSrvClVl() {
        return this.srvClVl;
    }

    public final void setSrvClVl(SrvClVl pSrvClVl) {
        this.srvClVl = pSrvClVl;
    }

    public final boolean getIsAndr() {
        return this.isAndr;
    }

    public final void setIsAndr(boolean pIsAndr) {
        this.isAndr = pIsAndr;
    }

    public final IHlIntCls getHlTyItSr() {
        return this.hlTyItSr;
    }

    public final void setHlTyItSr(IHlIntCls pHlTyItSr) {
        this.hlTyItSr = pHlTyItSr;
    }

    public final IHlIntCls getHlTyEnSr() {
        return this.hlTyEnSr;
    }

    public final void setHlTyEnSr(IHlIntCls pHlTyEnSr) {
        this.hlTyEnSr = pHlTyEnSr;
    }

    public final ISrWrhEnr getSrWrhEnr() {
        return this.srWrhEnr;
    }

    public final void setSrWrhEnr(ISrWrhEnr pSrWrhEnr) {
        this.srWrhEnr = pSrWrhEnr;
    }
}

