/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.srv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Map;
import org.beigesoft.acc.mdlb.AInv;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.PurInv;
import org.beigesoft.acc.mdlp.SaRtLn;
import org.beigesoft.acc.mdlp.SalRet;
import org.beigesoft.acc.mdlp.TxDst;
import org.beigesoft.acc.srv.IRvInvLn;
import org.beigesoft.acc.srv.ISrInItLn;
import org.beigesoft.acc.srv.ISrWrhEnr;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.rdb.IOrm;

public class SrSaRtLn
implements ISrInItLn<SalRet, SaRtLn> {
    private IOrm orm;
    private ISrWrhEnr srWrhEnr;
    private IRvInvLn<SalRet, SaRtLn> rvInvLn;

    @Override
    public final void mkEntrs(Map<String, Object> pRvs, Map<String, Object> pVs, SaRtLn pEnt) throws Exception {
        this.srWrhEnr.load(pRvs, pEnt, pEnt.getWrhp());
    }

    @Override
    public final void prepLn(Map<String, Object> pRvs, Map<String, Object> pVs, SaRtLn pEnt, TxDst pTxRules) throws Exception {
        BigDecimal exchRt = pEnt.getOwnr().getExRt();
        if (exchRt.compareTo(BigDecimal.ZERO) == -1) {
            exchRt = BigDecimal.ONE.divide(exchRt.negate(), 15, RoundingMode.HALF_UP);
        }
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        if (pEnt.getOwnr().getCuFr() != null) {
            if (pTxRules == null || pEnt.getOwnr().getInTx().booleanValue()) {
                pEnt.setTot(pEnt.getToFc().multiply(exchRt).setScale((int)as.getPrDp(), as.getRndm()));
            } else {
                pEnt.setSubt(pEnt.getSuFc().multiply(exchRt).setScale((int)as.getPrDp(), as.getRndm()));
            }
        }
        Object[] fds = new String[]{"itm", "uom", "pri", "prFc", "txCt"};
        Arrays.sort(fds);
        pVs.put(pEnt.getInvl().getClass().getSimpleName() + "ndFds", fds);
        pVs.put(pEnt.getInvl().getClass().getSimpleName() + "dpLv", 1);
        Object[] fdstc = new String[]{"nme", "agRt"};
        Arrays.sort(fdstc);
        pVs.put("TxCtndFds", fdstc);
        pVs.put("TxCtdpLv", 1);
        this.orm.refrEnt(pRvs, pVs, (IHasId)pEnt.getInvl());
        pVs.clear();
        pEnt.getInvl().setOwnr(pEnt.getOwnr().getInv());
        String src = "*" + pEnt.getInvl().getPri() + "*";
        if (pEnt.getDscr() == null) {
            pEnt.setDscr(src);
        } else {
            pEnt.setDscr(pEnt.getDscr() + " " + src);
        }
        pEnt.setItLf(pEnt.getQuan());
    }

    @Override
    public final SaRtLn retChkRv(Map<String, Object> pRvs, Map<String, Object> pVs, SaRtLn pEnt) throws Exception {
        SaRtLn rz = new SaRtLn();
        rz.setIid(pEnt.getRvId());
        this.orm.refrEnt(pRvs, pVs, (IHasId)rz);
        pVs.clear();
        if (rz.getIid() == null) {
            throw new ExcCode(100, "Reversed not found! SaRtLn id= " + pEnt.getRvId());
        }
        if (rz.getRvId() != null) {
            throw new ExcCode(100, "Attempt reverse reversed SaRtLn id= " + pEnt.getRvId());
        }
        if (rz.getQuan().compareTo(rz.getItLf()) == 1) {
            throw new ExcCode(1003, "where_is_withdraw");
        }
        pEnt.setInvl(rz.getInvl());
        return rz;
    }

    @Override
    public final void revLns(Map<String, Object> pRvs, Map<String, Object> pVs, SaRtLn pRvng, SaRtLn pRved) throws Exception {
        this.rvInvLn.revLns(pRvs, pVs, pRvng.getOwnr(), pRvng, pRved);
    }

    @Override
    public final Class<? extends AInv> getBinvCls() {
        return PurInv.class;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrWrhEnr getSrWrhEnr() {
        return this.srWrhEnr;
    }

    public final void setSrWrhEnr(ISrWrhEnr pSrWrhEnr) {
        this.srWrhEnr = pSrWrhEnr;
    }

    public final IRvInvLn<SalRet, SaRtLn> getRvInvLn() {
        return this.rvInvLn;
    }

    public final void setRvInvLn(IRvInvLn<SalRet, SaRtLn> pRvInvLn) {
        this.rvInvLn = pRvInvLn;
    }
}

