/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.srv;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.acc.mdlb.AInv;
import org.beigesoft.acc.mdlb.APaym;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.srv.IRvInvLn;
import org.beigesoft.acc.srv.ISrToPa;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdlp.UsPrf;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.srv.II18n;
import org.beigesoft.srv.INumStr;

public class SrToPa
implements ISrToPa {
    private IOrm orm;
    private II18n i18n;
    private INumStr numStr;

    @Override
    public final <T extends AInv> void mkToPa(Map<String, Object> pRvs, T pEnt, IRvInvLn<T, ?> pRvLn) throws Exception {
        BigDecimal to;
        HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        UsPrf upf = (UsPrf)pRvs.get("upf");
        DateFormat dtFr = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
        StringBuffer sb = new StringBuffer();
        BigDecimal toPa = BigDecimal.ZERO;
        BigDecimal paFc = BigDecimal.ZERO;
        boolean isFst = true;
        Object[] fds = new String[]{"iid", "dat", "dbOr", "tot", "toFc"};
        Arrays.sort(fds);
        vs.put(pRvLn.getPrepCls().getSimpleName() + "ndFds", fds);
        if (pEnt.getPrep() != null) {
            this.orm.refrEnt(pRvs, vs, (IHasId)pEnt.getPrep());
            vs.clear();
            to = pEnt.getCuFr() == null ? pEnt.getPrep().getTot() : pEnt.getPrep().getToFc();
            sb.append(this.getI18n().getMsg(pEnt.getPrep().getClass().getSimpleName() + "sht", cpf.getLngDef().getIid()) + " #" + pEnt.getPrep().getDbOr() + "-" + pEnt.getPrep().getIid() + ", " + dtFr.format(pEnt.getPrep().getDat()) + ", " + this.prn(as, cpf, upf, to));
            isFst = false;
            toPa = toPa.add(pEnt.getPrep().getTot());
            paFc = paFc.add(pEnt.getPrep().getToFc());
        }
        if (!pEnt.getIsNew().booleanValue()) {
            vs.put(pRvLn.getPaymCls().getSimpleName() + "ndFds", fds);
            List payms = this.orm.retLstCnd(pRvs, vs, pRvLn.getPaymCls(), "where rvId is null and mdEnr=1 and inv=" + pEnt.getIid());
            vs.clear();
            for (APaym paym : payms) {
                if (isFst) {
                    isFst = false;
                } else {
                    sb.append("; ");
                }
                to = pEnt.getCuFr() == null ? paym.getTot() : paym.getToFc();
                sb.append(this.getI18n().getMsg(paym.getClass().getSimpleName() + "sht", cpf.getLngDef().getIid()) + " #" + paym.getDbOr() + "-" + paym.getIid() + ", " + dtFr.format(paym.getDat()) + ", " + this.prn(as, cpf, upf, to));
                toPa = toPa.add(paym.getTot());
                paFc = paFc.add(paym.getToFc());
            }
        }
        if (!isFst) {
            if (pEnt.getCuFr() == null) {
                sb.append(" (" + as.getCurr().getNme() + ")");
            } else {
                sb.append(" (" + pEnt.getCuFr().getNme() + ")");
            }
        }
        pEnt.setPdsc(sb.toString());
        pEnt.setToPa(toPa);
        pEnt.setPaFc(paFc);
    }

    public final String prn(AcStg pAs, CmnPrf pCpf, UsPrf pUpf, BigDecimal pVal) {
        return this.numStr.frmt(pVal.toString(), pCpf.getDcSpv(), pCpf.getDcGrSpv(), pAs.getPrDp(), pUpf.getDgInGr());
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final INumStr getNumStr() {
        return this.numStr;
    }

    public final void setNumStr(INumStr pNumStr) {
        this.numStr = pNumStr;
    }
}

