/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.srv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdl.CmprInvLnTot;
import org.beigesoft.acc.mdl.CmprTaxTot;
import org.beigesoft.acc.mdl.CmprTxCtLnRt;
import org.beigesoft.acc.mdl.ETxTy;
import org.beigesoft.acc.mdl.TaxEx;
import org.beigesoft.acc.mdlb.ADcTxLn;
import org.beigesoft.acc.mdlb.AInTxLn;
import org.beigesoft.acc.mdlb.AItm;
import org.beigesoft.acc.mdlb.ALnTxLn;
import org.beigesoft.acc.mdlb.ATxDsLn;
import org.beigesoft.acc.mdlb.IInvLn;
import org.beigesoft.acc.mdlb.IInvb;
import org.beigesoft.acc.mdlb.TxDtLn;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.Tax;
import org.beigesoft.acc.mdlp.TxCt;
import org.beigesoft.acc.mdlp.TxCtLn;
import org.beigesoft.acc.mdlp.TxDst;
import org.beigesoft.acc.srv.DataTx;
import org.beigesoft.acc.srv.IInvLnTxMeth;
import org.beigesoft.acc.srv.IInvTxMeth;
import org.beigesoft.fct.IFctRq;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IRecSet;
import org.beigesoft.mdlp.UsPrf;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.INumStr;

public class UtInLnTxToBs<RS> {
    private ILog log;
    private IRdb<RS> rdb;
    private IOrm orm;
    private INumStr numStr;

    public final TxDst revealTaxRules(IInvb pInv, AcStg pAs, Boolean pIsExtrTx) throws Exception {
        TxDst txRules = null;
        if (pIsExtrTx.booleanValue() && !pInv.getOmTx().booleanValue()) {
            if (pInv.getDbcr().getTxDs() != null) {
                txRules = pInv.getDbcr().getTxDs();
            } else {
                txRules = new TxDst();
                txRules.setStIb(pAs.getStIb());
                txRules.setStAg(pAs.getStAg());
                txRules.setStRm(pAs.getStRm());
            }
        }
        return txRules;
    }

    public final <T extends IInvb, L extends IInvLn<T, ?>, TL extends AInTxLn<T>> void makeTotals(Map<String, Object> pRvs, Map<String, Object> pVs, L pLine, AcStg pAs, TxDst pTxRules, IInvTxMeth<T, TL> pInvTxMeth) throws Exception {
        pVs.put(pInvTxMeth.getInvCl().getSimpleName() + "dpLv", 0);
        List invTxLns = this.getOrm().retLstCnd(pRvs, pVs, pInvTxMeth.getInvTxLnCl(), "where OWNR=" + ((IInvb)pLine.getOwnr()).getIid());
        pVs.clear();
        for (AInTxLn tl : invTxLns) {
            tl.setDbOr(this.orm.getDbId());
            tl.setTax(null);
            tl.setTxb(BigDecimal.ZERO);
            tl.setTxbFc(BigDecimal.ZERO);
            tl.setTot(BigDecimal.ZERO);
            tl.setToFc(BigDecimal.ZERO);
        }
        if (pTxRules != null) {
            DataTx dtTx = this.retrieveDataTx(pRvs, pLine, pAs, pTxRules, pInvTxMeth);
            if (!(pTxRules.getStAg().booleanValue() || pTxRules.getStIb().booleanValue() && ((IInvb)pLine.getOwnr()).getInTx().booleanValue())) {
                for (int i = 0; i < dtTx.getTxs().size(); ++i) {
                    Double txTotd;
                    TL tl = this.findCreateTaxLine(pRvs, (IInvb)pLine.getOwnr(), invTxLns, dtTx.getTxs().get(i), false, pInvTxMeth.getFctInvTxLn());
                    Double txTotdFc = 0.0;
                    if (!pTxRules.getStIb().booleanValue()) {
                        txTotd = dtTx.getTxTotTaxb().get(i);
                        txTotdFc = dtTx.getTxTotTaxbFc().get(i);
                    } else {
                        txTotd = dtTx.getTxTotTaxb().get(i) * dtTx.getTxPerc().get(i) / 100.0;
                        ((AInTxLn)tl).setTxb(BigDecimal.valueOf(dtTx.getTxTotTaxb().get(i)));
                        if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                            txTotdFc = dtTx.getTxTotTaxbFc().get(i) * dtTx.getTxPerc().get(i) / 100.0;
                            ((AInTxLn)tl).setTxbFc(BigDecimal.valueOf(dtTx.getTxTotTaxbFc().get(i)));
                        }
                    }
                    ((ADcTxLn)tl).setTot(BigDecimal.valueOf(txTotd).setScale((int)pAs.getPrDp(), pTxRules.getStRm()));
                    ((AInTxLn)tl).setToFc(BigDecimal.valueOf(txTotdFc).setScale((int)pAs.getPrDp(), pTxRules.getStRm()));
                    if (tl.getIsNew().booleanValue()) {
                        this.getOrm().insIdLn(pRvs, pVs, tl);
                        continue;
                    }
                    this.getOrm().update(pRvs, pVs, tl);
                }
            } else {
                BigDecimal bd100 = new BigDecimal("100.00");
                Comparator<TxCtLn> cmpr = Collections.reverseOrder(new CmprTxCtLnRt());
                for (TxDtLn txdLn : dtTx.getTxdLns()) {
                    int ti = 0;
                    BigDecimal taxAggegated = null;
                    BigDecimal taxAggrAccum = BigDecimal.ZERO;
                    BigDecimal taxAggegatedFc = BigDecimal.ZERO;
                    BigDecimal taxAggrAccumFc = BigDecimal.ZERO;
                    Collections.sort(txdLn.getTxCt().getTxs(), cmpr);
                    for (TxCtLn itcl : txdLn.getTxCt().getTxs()) {
                        ++ti;
                        if (taxAggegated == null) {
                            if (pTxRules.getStIb().booleanValue()) {
                                if (((IInvb)pLine.getOwnr()).getInTx().booleanValue()) {
                                    taxAggegated = txdLn.getTot().subtract(txdLn.getTot().divide(BigDecimal.ONE.add(txdLn.getTxCt().getAgRt().divide(bd100, 15, RoundingMode.HALF_UP)), (int)pAs.getPrDp(), pTxRules.getStRm()));
                                    if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                                        taxAggegatedFc = txdLn.getToFc().subtract(txdLn.getToFc().divide(BigDecimal.ONE.add(txdLn.getTxCt().getAgRt().divide(bd100, 15, RoundingMode.HALF_UP)), (int)pAs.getPrDp(), pTxRules.getStRm()));
                                    }
                                } else {
                                    taxAggegated = txdLn.getSubt().multiply(txdLn.getTxCt().getAgRt()).divide(bd100, (int)pAs.getPrDp(), pTxRules.getStRm());
                                    if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                                        taxAggegatedFc = txdLn.getSuFc().multiply(txdLn.getTxCt().getAgRt()).divide(bd100, (int)pAs.getPrDp(), pTxRules.getStRm());
                                    }
                                }
                            } else {
                                taxAggegated = txdLn.getToTx();
                                taxAggegatedFc = txdLn.getTxFc();
                            }
                        }
                        if (ti < txdLn.getTxCt().getTxs().size()) {
                            txdLn.setToTx(taxAggegated.multiply(itcl.getRate()).divide(txdLn.getTxCt().getAgRt(), (int)pAs.getPrDp(), pTxRules.getStRm()));
                            taxAggrAccum = taxAggrAccum.add(txdLn.getToTx());
                            if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                                txdLn.setTxFc(taxAggegatedFc.multiply(itcl.getRate()).divide(txdLn.getTxCt().getAgRt(), (int)pAs.getPrDp(), pTxRules.getStRm()));
                                taxAggrAccumFc = taxAggrAccumFc.add(txdLn.getTxFc());
                            }
                        } else {
                            txdLn.setToTx(taxAggegated.subtract(taxAggrAccum));
                            if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                                txdLn.setTxFc(taxAggegatedFc.subtract(taxAggrAccumFc));
                            }
                        }
                        TL tl = this.findCreateTaxLine(pRvs, (IInvb)pLine.getOwnr(), invTxLns, itcl.getTax(), true, pInvTxMeth.getFctInvTxLn());
                        ((ADcTxLn)tl).setTot(((ADcTxLn)tl).getTot().add(txdLn.getToTx()));
                        if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                            ((AInTxLn)tl).setToFc(((AInTxLn)tl).getToFc().add(txdLn.getTxFc()));
                        }
                        if (pTxRules.getStIb().booleanValue()) {
                            if (ti == txdLn.getTxCt().getTxs().size()) {
                                txdLn.setToTx(taxAggegated);
                                txdLn.setTxFc(taxAggegatedFc);
                            }
                            if (!((IInvb)pLine.getOwnr()).getInTx().booleanValue()) {
                                ((AInTxLn)tl).setTxb(((AInTxLn)tl).getTxb().add(txdLn.getSubt()));
                                if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                                    ((AInTxLn)tl).setTxbFc(((AInTxLn)tl).getTxbFc().add(txdLn.getSuFc()));
                                }
                            } else {
                                ((AInTxLn)tl).setTxb(((AInTxLn)tl).getTxb().add(txdLn.getTot()));
                                if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                                    ((AInTxLn)tl).setTxbFc(((AInTxLn)tl).getTxbFc().add(txdLn.getToFc()));
                                }
                            }
                        }
                        if (tl.getIsNew().booleanValue()) {
                            this.getOrm().insIdLn(pRvs, pVs, tl);
                            continue;
                        }
                        ((AInTxLn)tl).setDscr(null);
                        this.getOrm().update(pRvs, pVs, tl);
                    }
                }
            }
            if (pTxRules.getStIb().booleanValue()) {
                this.adjustInvoiceLns(pRvs, pVs, (IInvb)pLine.getOwnr(), dtTx.getTxdLns(), pAs, pInvTxMeth);
            }
        }
        for (AInTxLn tl : invTxLns) {
            if (tl.getTax() != null) continue;
            this.getOrm().del(pRvs, pVs, (IHasId)tl);
        }
        if (pTxRules != null && !pTxRules.getStAg().booleanValue() && ((IInvb)pLine.getOwnr()).getInTx().booleanValue()) {
            String watr = "TTR without aggregate! ";
            if (((IInvb)pLine.getOwnr()).getDscr() == null) {
                ((IInvb)pLine.getOwnr()).setDscr(watr);
            } else if (!((IInvb)pLine.getOwnr()).getDscr().contains(watr)) {
                ((IInvb)pLine.getOwnr()).setDscr(watr + ((IInvb)pLine.getOwnr()).getDscr());
            }
        }
        this.updInvTots(pRvs, pVs, (IInvb)pLine.getOwnr(), pAs, pInvTxMeth);
    }

    public final <T extends IInvb> void updInvTots(Map<String, Object> pRvs, Map<String, Object> pVs, T pInv, AcStg pAs, IInvTxMeth<T, ?> pInvTxMeth) throws Exception {
        String query = pInvTxMeth.lazyGetQuTotals();
        query = query.replace(":OWNR", ((Long)pInv.getIid()).toString());
        if (pInvTxMeth.getTblNmsTot().length == 5) {
            query = query.replace(":TGDLN", pInvTxMeth.getTblNmsTot()[0]);
            query = query.replace(":TSRVLN", pInvTxMeth.getTblNmsTot()[1]);
            query = query.replace(":TTAXLN", pInvTxMeth.getTblNmsTot()[2]);
        } else {
            query = query.replace(":TGDLN", pInvTxMeth.getTblNmsTot()[0]);
            query = query.replace(":TTAXLN", pInvTxMeth.getTblNmsTot()[1]);
        }
        String[] cls = new String[]{"TOT", "TOTX", "TOFC", "TXFC"};
        Double[] totals = this.getRdb().evDoubles(query, cls);
        if (totals[0] == null) {
            totals[0] = 0.0;
        }
        if (totals[1] == null) {
            totals[1] = 0.0;
        }
        if (totals[2] == null) {
            totals[2] = 0.0;
        }
        if (totals[3] == null) {
            totals[3] = 0.0;
        }
        pInv.setTot(BigDecimal.valueOf(totals[0]).setScale((int)pAs.getPrDp(), pAs.getRndm()));
        pInv.setToTx(BigDecimal.valueOf(totals[1]).setScale((int)pAs.getPrDp(), pAs.getStRm()));
        pInv.setSubt(pInv.getTot().subtract(pInv.getToTx()));
        pInv.setToFc(BigDecimal.valueOf(totals[2]).setScale((int)pAs.getPrDp(), pAs.getRndm()));
        pInv.setTxFc(BigDecimal.valueOf(totals[3]).setScale((int)pAs.getPrDp(), pAs.getStRm()));
        pInv.setSuFc(pInv.getToFc().subtract(pInv.getTxFc()));
        Object[] fdsUpd = new String[]{"subt", "suFc", "toFc", "tot", "toTx", "txFc", "ver"};
        Arrays.sort(fdsUpd);
        pVs.put("ndFds", fdsUpd);
        this.getOrm().update(pRvs, pVs, pInv);
        pVs.clear();
    }

    public final <T extends IInvb, L extends IInvLn<T, ?>, TL extends AInTxLn<T>> void adjustInvoiceLns(Map<String, Object> pRvs, Map<String, Object> pVs, T pInv, List<TxDtLn> pTxdLns, AcStg pAs, IInvTxMeth<T, TL> pInvTxMeth) throws Exception {
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 11000);
        if (dbgSh) {
            this.getLog().debug(pRvs, UtInLnTxToBs.class, "Starting adjusting invoice basis lines...");
            this.getLog().debug(pRvs, UtInLnTxToBs.class, "txdLns [tax cat.ID/subt/suFc/tot/toFc/toTx/txFc]: " + pTxdLns);
        }
        Object[] fdsSel = new String[]{"iid", "subt", "suFc", "toFc", "tot", "txCt", "ver"};
        Arrays.sort(fdsSel);
        pVs.put("TxCtdpLv", 0);
        pVs.put(pInvTxMeth.getGoodLnCl().getSimpleName() + "ndFds", fdsSel);
        List gls = this.getOrm().retLstCnd(pRvs, pVs, pInvTxMeth.getGoodLnCl(), "where TXCT is not null and RVID is null and OWNR=" + pInv.getIid());
        pVs.clear();
        List sls = null;
        if (pInvTxMeth.getServiceLnCl() != null) {
            pVs.put("TxCtdpLv", 0);
            pVs.put(pInvTxMeth.getServiceLnCl().getSimpleName() + "ndFds", fdsSel);
            sls = this.getOrm().retLstCnd(pRvs, pVs, pInvTxMeth.getServiceLnCl(), "where TXCT is not null and RVID is null and OWNR=" + pInv.getIid());
            pVs.clear();
        }
        ArrayList<IInvLn> ilsm = new ArrayList<IInvLn>();
        Comparator cmpr = Collections.reverseOrder(new CmprInvLnTot());
        Object[] fdsUpd = new String[]{"subt", "suFc", "toFc", "tot", "toTx", "txFc", "ver"};
        Arrays.sort(fdsUpd);
        pVs.put("ndFds", fdsUpd);
        for (TxDtLn txdLn : pTxdLns) {
            for (IInvLn gl : gls) {
                if (!gl.getTxCt().getIid().equals(txdLn.getTxCt().getIid())) continue;
                ilsm.add(gl);
            }
            if (sls != null) {
                for (IInvLn sl : sls) {
                    if (!sl.getTxCt().getIid().equals(txdLn.getTxCt().getIid())) continue;
                    ilsm.add(sl);
                }
            }
            Collections.sort(ilsm, cmpr);
            BigDecimal txRest = txdLn.getToTx();
            BigDecimal txRestFc = txdLn.getTxFc();
            for (int i = 0; i < ilsm.size(); ++i) {
                if (i + 1 == ilsm.size()) {
                    if (pInv.getInTx().booleanValue()) {
                        ((IInvLn)ilsm.get(i)).setSubt(((IInvLn)ilsm.get(i)).getTot().subtract(txRest));
                    } else {
                        ((IInvLn)ilsm.get(i)).setTot(((IInvLn)ilsm.get(i)).getSubt().add(txRest));
                    }
                    ((IInvLn)ilsm.get(i)).setToTx(txRest);
                    if (pInv.getCuFr() != null) {
                        if (pInv.getInTx().booleanValue()) {
                            ((IInvLn)ilsm.get(i)).setSuFc(((IInvLn)ilsm.get(i)).getToFc().subtract(txRestFc));
                        } else {
                            ((IInvLn)ilsm.get(i)).setToFc(((IInvLn)ilsm.get(i)).getSuFc().add(txRestFc));
                        }
                        ((IInvLn)ilsm.get(i)).setTxFc(txRestFc);
                    }
                } else {
                    BigDecimal taxTot;
                    if (pInv.getInTx().booleanValue()) {
                        taxTot = txdLn.getToTx().multiply(((IInvLn)ilsm.get(i)).getTot()).divide(txdLn.getTot(), (int)pAs.getPrDp(), RoundingMode.HALF_UP);
                        ((IInvLn)ilsm.get(i)).setSubt(((IInvLn)ilsm.get(i)).getTot().subtract(taxTot));
                    } else {
                        taxTot = txdLn.getToTx().multiply(((IInvLn)ilsm.get(i)).getSubt()).divide(txdLn.getSubt(), (int)pAs.getPrDp(), RoundingMode.HALF_UP);
                        ((IInvLn)ilsm.get(i)).setTot(((IInvLn)ilsm.get(i)).getSubt().add(taxTot));
                    }
                    ((IInvLn)ilsm.get(i)).setToTx(taxTot);
                    txRest = txRest.subtract(taxTot);
                    if (pInv.getCuFr() != null) {
                        BigDecimal taxTotFc;
                        if (pInv.getInTx().booleanValue()) {
                            taxTotFc = txdLn.getTxFc().multiply(((IInvLn)ilsm.get(i)).getToFc()).divide(txdLn.getToFc(), (int)pAs.getPrDp(), RoundingMode.HALF_UP);
                            ((IInvLn)ilsm.get(i)).setSuFc(((IInvLn)ilsm.get(i)).getToFc().subtract(taxTotFc));
                        } else {
                            taxTotFc = txdLn.getTxFc().multiply(((IInvLn)ilsm.get(i)).getSuFc()).divide(txdLn.getSuFc(), (int)pAs.getPrDp(), RoundingMode.HALF_UP);
                            ((IInvLn)ilsm.get(i)).setToFc(((IInvLn)ilsm.get(i)).getSuFc().add(taxTotFc));
                        }
                        ((IInvLn)ilsm.get(i)).setTxFc(taxTotFc);
                        txRestFc = txRestFc.subtract(taxTotFc);
                    }
                }
                this.getOrm().update(pRvs, pVs, (IHasId)ilsm.get(i));
            }
            ilsm.clear();
        }
        pVs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends IInvb, L extends IInvLn<T, ?>, TL extends AInTxLn<T>> ArrayList<TxDtLn> retrTxdLnsAdjInv(Map<String, Object> pRvs, T pInv, AcStg pAs, TxDst pTxRules, IInvTxMeth<T, TL> pInvTxMeth) throws Exception {
        ArrayList<TxDtLn> txdLns = new ArrayList<TxDtLn>();
        HashMap<Long, Object> tcTxs = new HashMap<Long, Object>();
        ArrayList<TaxEx> txs = new ArrayList<TaxEx>();
        String query = pInvTxMeth.lazyGetQuTxInvAdj();
        if (pInvTxMeth.getTblNmsTot().length == 5) {
            query = query.replace(":TGDLN", pInvTxMeth.getTblNmsTot()[0]);
            query = query.replace(":TSRVLN", pInvTxMeth.getTblNmsTot()[1]);
            query = query.replace(":TTAXLN", pInvTxMeth.getTblNmsTot()[2]);
        } else {
            query = query.replace(":TGDLN", pInvTxMeth.getTblNmsTot()[0]);
            query = query.replace(":TTAXLN", pInvTxMeth.getTblNmsTot()[1]);
        }
        query = query.replace(":INVID", ((Long)pInv.getIid()).toString());
        BigDecimal bd100 = new BigDecimal("100.00");
        try (IRecSet rs = null;){
            rs = this.getRdb().retRs(query);
            if (rs.first()) {
                do {
                    BigDecimal txvf;
                    BigDecimal txv;
                    Long txId = rs.getLong("TAXID");
                    String txNm = rs.getStr("TAXNME");
                    int li = txs.size() - 1;
                    if (li < 0 || !((TaxEx)txs.get(li)).getIid().equals(txId)) {
                        TaxEx taxEx = new TaxEx();
                        taxEx.setIid(txId);
                        taxEx.setNme(txNm);
                        Double totx = rs.getDouble("TOTX");
                        Double txfc = rs.getDouble("TXFC");
                        taxEx.setToTx(BigDecimal.valueOf(totx));
                        taxEx.setTxFc(BigDecimal.valueOf(txfc));
                        txs.add(taxEx);
                    }
                    Double d = rs.getDouble("RATE");
                    Long tcId = rs.getLong("TXCTID");
                    Object tctxs = null;
                    for (Map.Entry ent : tcTxs.entrySet()) {
                        if (!((Long)ent.getKey()).equals(tcId)) continue;
                        tctxs = (List)ent.getValue();
                        break;
                    }
                    if (tctxs == null) {
                        tctxs = new ArrayList();
                        tcTxs.put(tcId, tctxs);
                    }
                    TaxEx tctx = new TaxEx();
                    tctx.setIid(txId);
                    tctx.setNme(txNm);
                    tctxs.add(tctx);
                    BigDecimal prbd = BigDecimal.valueOf(d);
                    if (!pInv.getInTx().booleanValue()) {
                        Double su = rs.getDouble("SUBT");
                        Double suf = rs.getDouble("SUFC");
                        BigDecimal subd = BigDecimal.valueOf(su);
                        BigDecimal subdf = BigDecimal.valueOf(suf);
                        txv = subd.multiply(prbd).divide(bd100, (int)pAs.getPrDp(), pTxRules.getStRm());
                        txvf = subdf.multiply(prbd).divide(bd100, (int)pAs.getPrDp(), pTxRules.getStRm());
                        tctx.setTxb(subd);
                        tctx.setTxbFc(subdf);
                    } else {
                        Double tot = rs.getDouble("TOT");
                        Double totf = rs.getDouble("TOFC");
                        BigDecimal totbd = BigDecimal.valueOf(tot);
                        BigDecimal totbdf = BigDecimal.valueOf(totf);
                        txv = totbd.subtract(totbd.divide(BigDecimal.ONE.add(prbd.divide(bd100, 15, RoundingMode.HALF_UP)), (int)pAs.getPrDp(), pTxRules.getStRm()));
                        txvf = totbdf.subtract(totbdf.divide(BigDecimal.ONE.add(prbd.divide(bd100, 15, RoundingMode.HALF_UP)), (int)pAs.getPrDp(), pTxRules.getStRm()));
                        tctx.setTxb(totbd);
                        tctx.setTxbFc(totbdf);
                    }
                    tctx.setTxFc(txvf);
                    tctx.setToTx(txv);
                } while (rs.next());
            }
        }
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 11001);
        if (dbgSh) {
            this.getLog().debug(pRvs, UtInLnTxToBs.class, "Tax totals by tax category: Tax category ID -[ Tax ID/Name/taxable/taxable FC/total tax/total tax FC]: " + ((Object)tcTxs).toString());
            this.getLog().debug(pRvs, UtInLnTxToBs.class, "Tax totals by tax [ Tax ID/Name/-/-/total tax/total tax FC]: " + txs.toString());
        }
        CmprTaxTot cmpr = new CmprTaxTot();
        for (TaxEx taxEx : txs) {
            ArrayList<TaxEx> tlns = new ArrayList<TaxEx>();
            for (Map.Entry ent : tcTxs.entrySet()) {
                for (TaxEx tctx : (List)ent.getValue()) {
                    if (!tctx.getIid().equals(taxEx.getIid())) continue;
                    tlns.add(tctx);
                }
            }
            Collections.sort(tlns, cmpr);
            BigDecimal txRest = taxEx.getToTx();
            BigDecimal txRestFc = taxEx.getTxFc();
            for (int i = 0; i < tlns.size(); ++i) {
                if (i + 1 == tlns.size()) {
                    ((TaxEx)tlns.get(i)).setToTx(txRest);
                    ((TaxEx)tlns.get(i)).setTxFc(txRestFc);
                    continue;
                }
                txRest = txRest.subtract(((TaxEx)tlns.get(i)).getToTx());
                txRestFc = txRestFc.subtract(((TaxEx)tlns.get(i)).getTxFc());
            }
        }
        if (dbgSh) {
            this.getLog().debug(pRvs, UtInLnTxToBs.class, "After adjusting tax totals by tax category: Tax category ID -[Tax ID/Name/taxable/taxable FC/total tax/total tax FC]: " + ((Object)tcTxs).toString());
        }
        for (Map.Entry entry : tcTxs.entrySet()) {
            TxDtLn txdLn = new TxDtLn();
            txdLn.setIid((Long)entry.getKey());
            TxCt tc = new TxCt();
            tc.setIid((Long)entry.getKey());
            txdLn.setTxCt(tc);
            txdLns.add(txdLn);
            for (TaxEx tx : (List)entry.getValue()) {
                txdLn.setToTx(txdLn.getToTx().add(tx.getToTx()));
                txdLn.setTxFc(txdLn.getTxFc().add(tx.getTxFc()));
                if (!pInv.getInTx().booleanValue()) {
                    txdLn.setSubt(txdLn.getSubt().add(tx.getTxb()));
                    txdLn.setSuFc(txdLn.getSuFc().add(tx.getTxbFc()));
                    continue;
                }
                txdLn.setTot(txdLn.getTot().add(tx.getTxb()));
                txdLn.setToFc(txdLn.getToFc().add(tx.getTxbFc()));
            }
        }
        return txdLns;
    }

    public final <T extends IInvb, L extends IInvLn<T, ?>, TL extends AInTxLn<T>, LTL extends ALnTxLn<T, L>> void mkLnTxTo(Map<String, Object> pRvs, Map<String, Object> pVs, L pLine, AcStg pAs, TxDst pTxRules, IInvTxMeth<T, TL> pInvTxMeth, IInvLnTxMeth<T, L, LTL> pInvLnTxMeth) throws Exception {
        if (pInvLnTxMeth.getNeedMkTxCat().booleanValue()) {
            if (pTxRules != null) {
                boolean isSetOver = false;
                if (((IInvb)pLine.getOwnr()).getDbcr().getTxDs() != null) {
                    pVs.put(pInvLnTxMeth.getItmCl().getSimpleName() + "dpLv", 0);
                    List dtls = this.getOrm().retLstCnd(pRvs, pVs, pInvLnTxMeth.getDstTxItLnCl(), "where OWNR=" + pLine.getItm().getIid());
                    pVs.clear();
                    for (ATxDsLn dtl : dtls) {
                        if (!dtl.getTxDs().getIid().equals(((IInvb)pLine.getOwnr()).getDbcr().getTxDs().getIid())) continue;
                        isSetOver = true;
                        pLine.setTxCt(dtl.getTxCt());
                        break;
                    }
                }
                if (!isSetOver) {
                    Object[] fdit = new String[]{"nme", "txCt"};
                    Arrays.sort(fdit);
                    Object[] fdtc = new String[]{"nme", "agRt"};
                    Arrays.sort(fdtc);
                    pVs.put(pLine.getItm().getClass().getSimpleName() + "ndFds", fdit);
                    pVs.put("TxCtndFds", fdtc);
                    this.orm.refrEnt(pRvs, pVs, pLine.getItm());
                    pVs.clear();
                    pLine.setTxCt(((AItm)((Object)pLine.getItm())).getTxCt());
                }
            } else {
                pLine.setTxCt(null);
            }
        }
        List<LTL> itls = null;
        if (pLine.getTxCt() != null) {
            if (!pTxRules.getStIb().booleanValue()) {
                if (!pTxRules.getStAg().booleanValue()) {
                    itls = this.mkLnTxItBasNonAggr(pRvs, pVs, pLine, pAs, pTxRules, pInvTxMeth, pInvLnTxMeth);
                } else {
                    BigDecimal totTxs = BigDecimal.ZERO;
                    BigDecimal totTxsFc = BigDecimal.ZERO;
                    BigDecimal bd100 = new BigDecimal("100.00");
                    if (((IInvb)pLine.getOwnr()).getInTx().booleanValue()) {
                        totTxs = pLine.getTot().subtract(pLine.getTot().divide(BigDecimal.ONE.add(pLine.getTxCt().getAgRt().divide(bd100, 15, RoundingMode.HALF_UP)), (int)pAs.getPrDp(), pTxRules.getStRm()));
                        if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                            totTxsFc = pLine.getToFc().subtract(pLine.getToFc().divide(BigDecimal.ONE.add(pLine.getTxCt().getAgRt().divide(bd100, 15, RoundingMode.HALF_UP)), (int)pAs.getPrDp(), pTxRules.getStRm()));
                        }
                    } else {
                        totTxs = pLine.getSubt().multiply(pLine.getTxCt().getAgRt()).divide(bd100, (int)pAs.getPrDp(), pTxRules.getStRm());
                        if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                            totTxsFc = pLine.getSuFc().multiply(pLine.getTxCt().getAgRt()).divide(bd100, (int)pAs.getPrDp(), pTxRules.getStRm());
                        }
                    }
                    pLine.setTdsc(pLine.getTxCt().getNme());
                    this.mkLnFinal(pLine, totTxs, totTxsFc, pInvTxMeth.getIsTxByUser());
                }
            } else {
                pLine.setTdsc(pLine.getTxCt().getNme());
                pLine.setToTx(BigDecimal.ZERO);
                pLine.setTxFc(BigDecimal.ZERO);
            }
        } else {
            pLine.setTdsc(null);
            pLine.setToTx(BigDecimal.ZERO);
            pLine.setTxFc(BigDecimal.ZERO);
        }
        if (((IInvb)pLine.getOwnr()).getCuFr() == null) {
            pLine.setTxFc(BigDecimal.ZERO);
            pLine.setToFc(BigDecimal.ZERO);
            pLine.setSuFc(BigDecimal.ZERO);
        }
        if (pLine.getTxCt() == null || pTxRules == null || !pTxRules.getStIb().booleanValue()) {
            if (pTxRules == null || ((IInvb)pLine.getOwnr()).getInTx().booleanValue()) {
                pLine.setSubt(pLine.getTot().subtract(pLine.getToTx()));
                if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                    pLine.setSuFc(pLine.getToFc().subtract(pLine.getTxFc()));
                }
            } else {
                pLine.setTot(pLine.getSubt().add(pLine.getToTx()));
                if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                    pLine.setToFc(pLine.getSuFc().add(pLine.getTxFc()));
                }
            }
        }
        if (pLine.getIsNew().booleanValue()) {
            this.getOrm().insIdLn(pRvs, pVs, pLine);
        } else {
            this.getOrm().update(pRvs, pVs, pLine);
        }
        if (itls != null) {
            int j;
            List itlsr = null;
            if (pInvLnTxMeth.getIsMutable().booleanValue() && !pLine.getIsNew().booleanValue()) {
                pVs.put(pInvLnTxMeth.getInvLnCl().getSimpleName() + "dpLv", 0);
                pVs.put(pInvLnTxMeth.getLtlCl().getSimpleName() + "dpLv", 1);
                Object[] ndfitl = new String[]{"iid", "dbOr", "ver", "tax"};
                Arrays.sort(ndfitl);
                pVs.put(pInvLnTxMeth.getLtlCl().getSimpleName() + "ndFds", ndfitl);
                itlsr = this.getOrm().retLstCnd(pRvs, pVs, pInvLnTxMeth.getLtlCl(), "where OWNR=" + pLine.getIid());
                pVs.clear();
            }
            Object[] taxTotOwnr = new String[]{"ownr", "tax", "tot", "ver"};
            Arrays.sort(taxTotOwnr);
            for (j = 0; j < itls.size(); ++j) {
                if (itlsr != null && j < itlsr.size()) {
                    ((ALnTxLn)itlsr.get(j)).setTax(((ALnTxLn)itls.get(j)).getTax());
                    ((ALnTxLn)itlsr.get(j)).setTot(((ALnTxLn)itls.get(j)).getTot());
                    ((ALnTxLn)itlsr.get(j)).setOwnr((IHasId)pLine);
                    pVs.put("ndFds", taxTotOwnr);
                    this.getOrm().update(pRvs, pVs, (IHasId)itlsr.get(j));
                    pVs.clear();
                    continue;
                }
                ((ALnTxLn)itls.get(j)).setOwnr((IHasId)pLine);
                ((ALnTxLn)itls.get(j)).setInvId((Long)((IInvb)pLine.getOwnr()).getIid());
                this.getOrm().insIdLn(pRvs, pVs, (IHasId)itls.get(j));
            }
            if (itlsr != null) {
                for (j = itls.size(); j < itlsr.size(); ++j) {
                    this.getOrm().del(pRvs, pVs, (IHasId)itlsr.get(j));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends IInvb, L extends IInvLn<T, ?>, TL extends AInTxLn<T>> DataTx retrieveDataTx(Map<String, Object> pRvs, L pLine, AcStg pAs, TxDst pTxRules, IInvTxMeth<T, TL> pInvTxMeth) throws Exception {
        String query;
        DataTx dtTx = new DataTx();
        if (!(pTxRules.getStAg().booleanValue() || pTxRules.getStIb().booleanValue() && ((IInvb)pLine.getOwnr()).getInTx().booleanValue())) {
            dtTx.setTxs(new ArrayList<TaxEx>());
            dtTx.setTxTotTaxb(new ArrayList<Double>());
            dtTx.setTxTotTaxbFc(new ArrayList<Double>());
            if (!pTxRules.getStIb().booleanValue()) {
                query = pInvTxMeth.lazyGetQuTxItBas();
            } else {
                dtTx.setTxPerc(new ArrayList<Double>());
                query = pInvTxMeth.lazyGetQuTxInvBas();
                dtTx.setTxdLns(new ArrayList<TxDtLn>());
            }
        } else {
            dtTx.setTxdLns(new ArrayList<TxDtLn>());
            query = pTxRules.getStIb() == false ? pInvTxMeth.lazyGetQuTxItBasAggr() : pInvTxMeth.lazyGetQuTxInvBasAggr();
        }
        boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 11002);
        if (dbgSh) {
            this.getLog().debug(pRvs, UtInLnTxToBs.class, "Tax rules: aggregate/invoice basis/zip/RM = " + pTxRules.getStAg() + "/" + pTxRules.getStIb() + "/" + pTxRules.getZip() + "/" + (Object)((Object)pTxRules.getStRm()));
            String txCat = pLine.getTxCt() != null ? pLine.getTxCt().getNme() : "-";
            this.getLog().debug(pRvs, UtInLnTxToBs.class, "Item: name/tax category = " + pLine.getItm().getNme() + "/" + txCat);
            this.getLog().debug(pRvs, UtInLnTxToBs.class, "Tax query: " + query);
        }
        if (!pTxRules.getStAg().booleanValue() && !pTxRules.getStIb().booleanValue()) {
            if (pInvTxMeth.getTblNmsTot().length == 5) {
                query = query.replace(":TGDTXLN", pInvTxMeth.getTblNmsTot()[3]);
                query = query.replace(":TSRVTXLN", pInvTxMeth.getTblNmsTot()[4]);
            } else {
                query = query.replace(":TITTXLN", pInvTxMeth.getTblNmsTot()[2]);
            }
        } else if (pInvTxMeth.getTblNmsTot().length == 5) {
            query = query.replace(":TGDLN", pInvTxMeth.getTblNmsTot()[0]);
            query = query.replace(":TSRVLN", pInvTxMeth.getTblNmsTot()[1]);
        } else {
            query = query.replace(":TGDLN", pInvTxMeth.getTblNmsTot()[0]);
        }
        query = query.replace(":INVID", ((Long)((IInvb)pLine.getOwnr()).getIid()).toString());
        try (IRecSet rs = null;){
            rs = this.getRdb().retRs(query);
            if (rs.first()) {
                do {
                    Long txId = rs.getLong("TAXID");
                    String txNm = rs.getStr("TAXNME");
                    TaxEx tax = new TaxEx();
                    tax.setIid(txId);
                    tax.setNme(txNm);
                    if (!(pTxRules.getStAg().booleanValue() || pTxRules.getStIb().booleanValue() && ((IInvb)pLine.getOwnr()).getInTx().booleanValue())) {
                        if (!pTxRules.getStIb().booleanValue()) {
                            dtTx.getTxs().add(tax);
                            dtTx.getTxTotTaxb().add(rs.getDouble("TOTX"));
                            dtTx.getTxTotTaxbFc().add(rs.getDouble("TXFC"));
                            continue;
                        }
                        boolean isNew = true;
                        int li = dtTx.getTxTotTaxb().size() - 1;
                        if (li >= 0 && dtTx.getTxs().get(li).getIid().equals(tax.getIid())) {
                            isNew = false;
                        }
                        Double su = rs.getDouble("SUBT");
                        Double suf = rs.getDouble("SUFC");
                        Double pr = rs.getDouble("RATE");
                        if (isNew) {
                            dtTx.getTxs().add(tax);
                            dtTx.getTxTotTaxb().add(su);
                            dtTx.getTxTotTaxbFc().add(suf);
                            dtTx.getTxPerc().add(pr);
                        } else {
                            Double sut = su + dtTx.getTxTotTaxb().get(li);
                            dtTx.getTxTotTaxb().set(li, sut);
                            Double sutf = suf + dtTx.getTxTotTaxbFc().get(li);
                            dtTx.getTxTotTaxbFc().set(li, sutf);
                        }
                        Long tcId = rs.getLong("TXCTID");
                        this.addInvBsTxExTxc(dtTx.getTxdLns(), tcId, su, suf, pr, pAs, pTxRules);
                        continue;
                    }
                    Double percent = rs.getDouble("RATE");
                    Long tcId = rs.getLong("TXCTID");
                    if (!pTxRules.getStIb().booleanValue()) {
                        Long clId = rs.getLong("ILID");
                        TxDtLn txdLn = this.makeTxdLine(dtTx.getTxdLns(), clId, tcId, tax, percent, pAs);
                        txdLn.setToTx(BigDecimal.valueOf(rs.getDouble("TOTX")).setScale((int)pAs.getPrDp(), RoundingMode.HALF_UP));
                        txdLn.setTxFc(BigDecimal.valueOf(rs.getDouble("TXFC")).setScale((int)pAs.getPrDp(), RoundingMode.HALF_UP));
                        continue;
                    }
                    TxDtLn txdLn = this.makeTxdLine(dtTx.getTxdLns(), tcId, tcId, tax, percent, pAs);
                    txdLn.setTot(BigDecimal.valueOf(rs.getDouble("TOT")).setScale((int)pAs.getPrDp(), RoundingMode.HALF_UP));
                    txdLn.setSubt(BigDecimal.valueOf(rs.getDouble("SUBT")).setScale((int)pAs.getPrDp(), RoundingMode.HALF_UP));
                    txdLn.setToFc(BigDecimal.valueOf(rs.getDouble("TOFC")).setScale((int)pAs.getPrDp(), RoundingMode.HALF_UP));
                    txdLn.setSuFc(BigDecimal.valueOf(rs.getDouble("SUFC")).setScale((int)pAs.getPrDp(), RoundingMode.HALF_UP));
                } while (rs.next());
            }
        }
        if (dbgSh) {
            this.getLog().debug(pRvs, UtInLnTxToBs.class, "Data tax: " + dtTx);
        }
        return dtTx;
    }

    public final void addInvBsTxExTxc(List<TxDtLn> pTxdLns, Long pCatId, Double pSubt, Double pSubtFc, Double pPercent, AcStg pAs, TxDst pTxRules) {
        TxDtLn txdLn = null;
        for (TxDtLn tdl : pTxdLns) {
            if (!tdl.getIid().equals(pCatId)) continue;
            txdLn = tdl;
        }
        if (txdLn == null) {
            txdLn = new TxDtLn();
            txdLn.setIid(pCatId);
            TxCt tc = new TxCt();
            tc.setIid(pCatId);
            txdLn.setTxCt(tc);
            pTxdLns.add(txdLn);
        }
        BigDecimal bd100 = new BigDecimal("100.00");
        BigDecimal txv = BigDecimal.valueOf(pSubt).multiply(BigDecimal.valueOf(pPercent)).divide(bd100, (int)pAs.getPrDp(), pTxRules.getStRm());
        txdLn.setToTx(txdLn.getToTx().add(txv));
        BigDecimal txvf = BigDecimal.valueOf(pSubtFc).multiply(BigDecimal.valueOf(pPercent)).divide(bd100, (int)pAs.getPrDp(), pTxRules.getStRm());
        txdLn.setTxFc(txdLn.getTxFc().add(txvf));
    }

    public final TxDtLn makeTxdLine(List<TxDtLn> pTxdLns, Long pTdlId, Long pCatId, TaxEx pTax, Double pPercent, AcStg pAs) {
        TxDtLn txdLn = null;
        for (TxDtLn tdl : pTxdLns) {
            if (!tdl.getIid().equals(pTdlId)) continue;
            txdLn = tdl;
        }
        if (txdLn == null) {
            txdLn = new TxDtLn();
            txdLn.setIid(pTdlId);
            TxCt tc = new TxCt();
            tc.setIid(pCatId);
            tc.setTxs(new ArrayList<TxCtLn>());
            txdLn.setTxCt(tc);
            pTxdLns.add(txdLn);
        }
        TxCtLn itcl = new TxCtLn();
        itcl.setTax(pTax);
        itcl.setRate(BigDecimal.valueOf(pPercent).setScale((int)pAs.getTxDp(), RoundingMode.HALF_UP));
        txdLn.getTxCt().getTxs().add(itcl);
        txdLn.getTxCt().setAgRt(txdLn.getTxCt().getAgRt().add(itcl.getRate()));
        return txdLn;
    }

    public final <T extends IInvb, L extends IInvLn<T, ?>, LTL extends ALnTxLn<T, L>> List<LTL> mkLnTxItBasNonAggr(Map<String, Object> pRvs, Map<String, Object> pVs, L pLine, AcStg pAs, TxDst pTxRules, IInvTxMeth<T, ?> pInvTxMeth, IInvLnTxMeth<T, L, LTL> pInvLnTxMeth) throws Exception {
        ArrayList<ALnTxLn> itls = new ArrayList<ALnTxLn>();
        BigDecimal totTxs = BigDecimal.ZERO;
        BigDecimal totTxsFc = BigDecimal.ZERO;
        BigDecimal bd100 = new BigDecimal("100.00");
        pVs.put("TxCtdpLv", 0);
        List itcls = this.getOrm().retLstCnd(pRvs, pVs, TxCtLn.class, "where OWNR=" + pLine.getTxCt().getIid() + " order by RATE");
        pVs.clear();
        BigDecimal taxTot = null;
        BigDecimal taxRest = null;
        BigDecimal taxTotFc = null;
        BigDecimal taxRestFc = null;
        if (((IInvb)pLine.getOwnr()).getInTx().booleanValue()) {
            taxRest = taxTot = pLine.getTot().subtract(pLine.getTot().divide(BigDecimal.ONE.add(pLine.getTxCt().getAgRt().divide(bd100, 15, RoundingMode.HALF_UP)), (int)pAs.getPrDp(), pTxRules.getStRm()));
            if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                taxRestFc = taxTotFc = pLine.getToFc().subtract(pLine.getToFc().divide(BigDecimal.ONE.add(pLine.getTxCt().getAgRt().divide(bd100, 15, RoundingMode.HALF_UP)), (int)pAs.getPrDp(), pTxRules.getStRm()));
            }
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        UsPrf upf = (UsPrf)pRvs.get("upf");
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        for (TxCtLn itcl : itcls) {
            BigDecimal addTx;
            if (!ETxTy.TSALES.equals((Object)itcl.getTax().getTyp())) continue;
            if (i++ > 0) {
                sb.append(", ");
            }
            ALnTxLn itl = (ALnTxLn)pInvLnTxMeth.getFctLineTxLn().create(pRvs);
            itl.setIsNew(true);
            itl.setTax(itcl.getTax());
            itls.add(itl);
            BigDecimal addTxFc = null;
            if (((IInvb)pLine.getOwnr()).getInTx().booleanValue()) {
                if (i < itcls.size()) {
                    addTx = taxTot.multiply(itcl.getRate()).divide(pLine.getTxCt().getAgRt(), (int)pAs.getPrDp(), pTxRules.getStRm());
                    taxRest = taxRest.subtract(addTx);
                } else {
                    addTx = taxRest;
                }
                if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                    if (i < itcls.size()) {
                        addTxFc = taxTotFc.multiply(itcl.getRate()).divide(pLine.getTxCt().getAgRt(), (int)pAs.getPrDp(), pTxRules.getStRm());
                        taxRestFc = taxRestFc.subtract(addTxFc);
                    } else {
                        addTxFc = taxRestFc;
                    }
                }
            } else {
                addTx = pLine.getSubt().multiply(itcl.getRate()).divide(bd100, (int)pAs.getPrDp(), pTxRules.getStRm());
                if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                    addTxFc = pLine.getSuFc().multiply(itcl.getRate()).divide(bd100, (int)pAs.getPrDp(), pTxRules.getStRm());
                }
            }
            totTxs = totTxs.add(addTx);
            itl.setTot(addTx);
            if (((IInvb)pLine.getOwnr()).getCuFr() != null) {
                totTxsFc = totTxsFc.add(addTxFc);
                itl.setToFc(addTxFc);
            }
            sb.append(itl.getTax().getNme() + " " + this.prn(pAs, cpf, upf, addTx));
        }
        pLine.setTdsc(sb.toString());
        this.mkLnFinal(pLine, totTxs, totTxsFc, ((IInvb)pLine.getOwnr()).getInTx());
        return itls;
    }

    public final <T extends IInvb, L extends IInvLn<T, ?>> void mkLnFinal(L pLine, BigDecimal pTotTxs, BigDecimal pTotTxsFc, Boolean pIsTxByUser) {
        if (pIsTxByUser.booleanValue()) {
            if (((IInvb)pLine.getOwnr()).getCuFr() == null) {
                if (pLine.getToTx().compareTo(pTotTxs) != 0) {
                    if (pLine.getDscr() == null) {
                        pLine.setDscr(pLine.getToTx().toString() + "!=" + pTotTxs + "!");
                    } else {
                        pLine.setDscr(pLine.getDscr() + " " + pLine.getToTx().toString() + "!=" + pTotTxs + "!");
                    }
                }
            } else {
                pLine.setToTx(pTotTxs);
                if (pLine.getTxFc().compareTo(pTotTxsFc) != 0) {
                    if (pLine.getDscr() == null) {
                        pLine.setDscr(pLine.getTxFc().toString() + "!=" + pTotTxsFc + "!");
                    } else {
                        pLine.setDscr(pLine.getDscr() + " " + pLine.getTxFc().toString() + "!=" + pTotTxsFc + "!");
                    }
                }
            }
        } else {
            pLine.setToTx(pTotTxs);
            pLine.setTxFc(pTotTxsFc);
        }
    }

    public final <T extends IInvb, TL extends AInTxLn<T>> TL findCreateTaxLine(Map<String, Object> pRvs, T pInv, List<TL> pInvTxLns, Tax pTax, boolean pNeedFind, IFctRq<TL> pFctInvTxLn) throws Exception {
        AInTxLn itl = null;
        for (AInTxLn tl : pInvTxLns) {
            if (tl.getTax() == null || !tl.getTax().getIid().equals(pTax.getIid())) continue;
            if (!pNeedFind) {
                throw new Exception("Algorithm error!!!");
            }
            itl = tl;
            break;
        }
        if (itl == null) {
            for (AInTxLn tl : pInvTxLns) {
                if (tl.getTax() != null) continue;
                itl = tl;
                itl.setTax(pTax);
                break;
            }
        }
        if (itl == null) {
            itl = (AInTxLn)pFctInvTxLn.create(pRvs);
            itl.setOwnr((IHasId)pInv);
            itl.setIsNew(true);
            itl.setTax(pTax);
            pInvTxLns.add(itl);
        }
        return (TL)itl;
    }

    public final String prn(AcStg pAs, CmnPrf pCpf, UsPrf pUpf, BigDecimal pVal) {
        return this.numStr.frmt(pVal.toString(), pCpf.getDcSpv(), pCpf.getDcGrSpv(), pAs.getPrDp(), pUpf.getDgInGr());
    }

    public final INumStr getNumStr() {
        return this.numStr;
    }

    public final void setNumStr(INumStr pNumStr) {
        this.numStr = pNumStr;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }
}

