/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.prc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.Itm;
import org.beigesoft.acc.mdlp.Srv;
import org.beigesoft.acc.mdlp.Tax;
import org.beigesoft.acc.mdlp.TxDst;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrc;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.ws.fct.FcPrWs;
import org.beigesoft.ws.mdl.EItmTy;
import org.beigesoft.ws.mdl.EOrdStat;
import org.beigesoft.ws.mdl.EPaymMth;
import org.beigesoft.ws.mdl.Purch;
import org.beigesoft.ws.mdlb.ACuOrLn;
import org.beigesoft.ws.mdlb.ACuOrSeLn;
import org.beigesoft.ws.mdlb.AItmPlc;
import org.beigesoft.ws.mdlb.AOrdLn;
import org.beigesoft.ws.mdlp.Buyer;
import org.beigesoft.ws.mdlp.Cart;
import org.beigesoft.ws.mdlp.CartItTxLn;
import org.beigesoft.ws.mdlp.CartLn;
import org.beigesoft.ws.mdlp.CartTxLn;
import org.beigesoft.ws.mdlp.CuOr;
import org.beigesoft.ws.mdlp.CuOrGdLn;
import org.beigesoft.ws.mdlp.CuOrGdTxLn;
import org.beigesoft.ws.mdlp.CuOrSe;
import org.beigesoft.ws.mdlp.CuOrSeGdLn;
import org.beigesoft.ws.mdlp.CuOrSeGdTxLn;
import org.beigesoft.ws.mdlp.CuOrSeSrLn;
import org.beigesoft.ws.mdlp.CuOrSeSrTxLn;
import org.beigesoft.ws.mdlp.CuOrSeTxLn;
import org.beigesoft.ws.mdlp.CuOrSrLn;
import org.beigesoft.ws.mdlp.CuOrSrTxLn;
import org.beigesoft.ws.mdlp.CuOrTxLn;
import org.beigesoft.ws.mdlp.ItmPlc;
import org.beigesoft.ws.mdlp.PayMd;
import org.beigesoft.ws.mdlp.SeItm;
import org.beigesoft.ws.mdlp.SeItmPlc;
import org.beigesoft.ws.mdlp.SeSel;
import org.beigesoft.ws.mdlp.SeSerBus;
import org.beigesoft.ws.mdlp.SeSrv;
import org.beigesoft.ws.mdlp.SeSrvPlc;
import org.beigesoft.ws.mdlp.SerBus;
import org.beigesoft.ws.mdlp.SrvPlc;
import org.beigesoft.ws.mdlp.TrdStg;
import org.beigesoft.ws.srv.ISrCart;

public class ChkOut<RS>
implements IPrc {
    private ILog log;
    private IOrm orm;
    private ISrCart srCart;
    private FcPrWs<RS> fcPrWs;
    private IRdb<RS> rdb;
    private Integer trIsl;

    public final void process(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        boolean isCompl = true;
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(this.trIsl.intValue());
            this.rdb.begin();
            Cart cart = this.srCart.getCart(pRvs, pRqDt, false, true);
            if (cart == null) {
                isCompl = false;
                this.log.warn(pRvs, this.getClass(), "Trying to checkout without cart!");
            } else {
                HashMap<String, Object> vs = new HashMap<String, Object>();
                if (EPaymMth.PAYPAL.equals((Object)cart.getPaym())) {
                    List payMds = this.orm.retLstCnd(pRvs, vs, PayMd.class, "where NME='PAYPAL'");
                    if (payMds.size() != 1) {
                        throw new Exception("There is no properly PPL PayMd");
                    }
                    pRvs.put("pmde", ((PayMd)((Object)payMds.get(0))).getMde());
                }
                TrdStg ts = (TrdStg)((Object)pRvs.get("tstg"));
                AcStg as = (AcStg)((Object)pRvs.get("astg"));
                TxDst txRules = this.srCart.revTxRules(pRvs, cart, as);
                for (CartLn cl : cart.getItems()) {
                    if (cl.getDisab().booleanValue() || cl.getForc().booleanValue()) continue;
                    this.srCart.mkLine(pRvs, cl, as, ts, txRules, true, true);
                    this.srCart.mkCartTots(pRvs, ts, cl, as, txRules);
                }
                Purch pur = this.retNewOrds(pRvs, cart.getBuyr());
                for (CartLn cl : cart.getItems()) {
                    Class itPlCl;
                    Class itCl;
                    if (cl.getDisab().booleanValue()) continue;
                    String serBus = null;
                    if (cl.getItTyp().equals((Object)EItmTy.GOODS)) {
                        itCl = Itm.class;
                        itPlCl = ItmPlc.class;
                    } else if (cl.getItTyp().equals((Object)EItmTy.SERVICE)) {
                        itCl = Srv.class;
                        itPlCl = SrvPlc.class;
                        serBus = SerBus.class.getSimpleName();
                    } else if (cl.getItTyp().equals((Object)EItmTy.SESERVICE)) {
                        itCl = SeSrv.class;
                        itPlCl = SeSrvPlc.class;
                        serBus = SeSerBus.class.getSimpleName();
                    } else {
                        itCl = SeItm.class;
                        itPlCl = SeItmPlc.class;
                    }
                    String cond = serBus == null || cl.getDt1() == null ? "where QUAN>0 and ITM=" + cl.getItId() : "left join (select distinct SRV from " + serBus + " where SRV=" + cl.getItId() + " and FRTM>=" + cl.getDt1().getTime() + " and TITM<" + cl.getDt2().getTime() + ") as " + serBus + " on " + serBus + ".SRV=" + itPlCl.getSimpleName() + ".ITM where ITM=" + cl.getItId() + " and QUAN>0 and " + serBus + ".SRV is null";
                    vs.put("PicPlcndFds", new String[]{"nme"});
                    vs.put(itCl.getSimpleName() + "dpLv", 0);
                    List places = this.getOrm().retLstCnd(pRvs, vs, itPlCl, cond);
                    vs.clear();
                    if (places.size() > 1 && serBus != null && cl.getDt1() != null) {
                        isCompl = false;
                        String errs = "!Wrong places for item name/ID/type: " + cl.getNme() + "/" + cl.getItId() + "/" + (Object)((Object)cl.getItTyp());
                        if (cart.getDscr() == null) {
                            cart.setDscr(errs);
                        } else {
                            cart.setDscr(cart.getDscr() + errs);
                        }
                        cart.setErr(true);
                        this.getOrm().update(pRvs, vs, (IHasId)cart);
                        this.log.warn(pRvs, ChkOut.class, errs);
                        break;
                    }
                    BigDecimal avQu = BigDecimal.ZERO;
                    for (AItmPlc pl : places) {
                        avQu = avQu.add(pl.getQuan());
                    }
                    if (avQu.compareTo(cl.getQuan()) == -1) {
                        isCompl = false;
                        cl.setAvQuan(avQu);
                        String errs = "!Not available item name/ID/type/quant/avail: " + cl.getNme() + "/" + cl.getItId() + "/" + (Object)((Object)cl.getItTyp()) + "/" + cl.getQuan() + "/" + avQu;
                        this.log.warn(pRvs, ChkOut.class, errs);
                    }
                    if (isCompl && cl.getPri().compareTo(BigDecimal.ZERO) == 1) {
                        if (cl.getSelr() == null) {
                            this.makeOrdLn(pRvs, pur.getOrds(), null, cl, ts);
                            continue;
                        }
                        this.makeSeOrdLn(pRvs, pur.getSords(), cl.getSelr(), null, cl, ts);
                        continue;
                    }
                    this.getOrm().update(pRvs, vs, (IHasId)cl);
                }
                pRvs.put("cart", (Object)cart);
                if (txRules != null) {
                    pRvs.put("txRules", (Object)txRules);
                }
                if (isCompl) {
                    this.saveOrds(pRvs, pur, cart);
                    this.saveSords(pRvs, pur, cart);
                    pRvs.put("orders", pur.getOrds());
                    pRvs.put("sorders", pur.getSords());
                    pRqDt.setAttr("rnd", (Object)"wchou");
                }
            }
            this.rdb.commit();
        }
        catch (Exception ex) {
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
        if (!isCompl) {
            this.redir(pRvs, pRqDt);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveSords(Map<String, Object> pRvs, Purch pPur, Cart pCart) throws Exception {
        HashMap vs = new HashMap();
        ArrayList<CuOrSe> dels = null;
        for (CuOrSe co : pPur.getSords()) {
            void var11_18;
            Object gl2;
            if (co.getCurr() == null) {
                for (CuOrSeGdLn gl2 : co.getGoods()) {
                    for (CuOrSeGdTxLn cuOrSeGdTxLn : gl2.getItTxs()) {
                        this.getOrm().del(pRvs, vs, (IHasId)cuOrSeGdTxLn);
                    }
                    this.getOrm().del(pRvs, vs, (IHasId)gl2);
                }
                for (CuOrSeSrLn sl2 : co.getServs()) {
                    for (CuOrSeSrTxLn cuOrSeSrTxLn : sl2.getItTxs()) {
                        this.getOrm().del(pRvs, vs, (IHasId)cuOrSeSrTxLn);
                    }
                    this.getOrm().del(pRvs, vs, (IHasId)sl2);
                }
                for (CuOrSeTxLn otlt : co.getTaxes()) {
                    this.getOrm().del(pRvs, vs, (IHasId)otlt);
                }
                this.getOrm().del(pRvs, vs, (IHasId)co);
                if (dels == null) {
                    dels = new ArrayList<CuOrSe>();
                }
                dels.add(co);
                continue;
            }
            if (co.getIsNew().booleanValue()) {
                this.getOrm().insIdLn(pRvs, vs, (IHasId)co);
            }
            BigDecimal tot = BigDecimal.ZERO;
            BigDecimal subt = BigDecimal.ZERO;
            ArrayList<Object> delsGd = null;
            for (Object gl2 : co.getGoods()) {
                ((ACuOrSeLn)((Object)gl2)).setOwnr(co);
                if (gl2.getIsNew().booleanValue()) {
                    this.getOrm().insIdLn(pRvs, vs, (IHasId)gl2);
                }
                if (((CuOrSeGdLn)((Object)gl2)).getItTxs() != null && ((CuOrSeGdLn)((Object)gl2)).getItTxs().size() > 0) {
                    for (CuOrSeGdTxLn cuOrSeGdTxLn : ((CuOrSeGdLn)((Object)gl2)).getItTxs()) {
                        cuOrSeGdTxLn.setOwnr((CuOrSeGdLn)((Object)gl2));
                        if (cuOrSeGdTxLn.getIsNew().booleanValue()) {
                            this.getOrm().insIdLn(pRvs, vs, (IHasId)cuOrSeGdTxLn);
                            continue;
                        }
                        if (((CuOrSeGdLn)((Object)gl2)).getGood() == null || cuOrSeGdTxLn.getTax() == null) {
                            this.getOrm().del(pRvs, vs, (IHasId)cuOrSeGdTxLn);
                            continue;
                        }
                        this.getOrm().update(pRvs, vs, (IHasId)cuOrSeGdTxLn);
                    }
                }
                if (!gl2.getIsNew().booleanValue() && ((CuOrSeGdLn)((Object)gl2)).getGood() == null) {
                    this.getOrm().del(pRvs, vs, (IHasId)gl2);
                    if (delsGd == null) {
                        delsGd = new ArrayList<Object>();
                    }
                    delsGd.add(gl2);
                    continue;
                }
                tot = tot.add(((AOrdLn)((Object)gl2)).getTot());
                subt = subt.add(((AOrdLn)((Object)gl2)).getSubt());
                if (gl2.getIsNew().booleanValue()) continue;
                this.getOrm().update(pRvs, vs, (IHasId)gl2);
            }
            if (delsGd != null) {
                for (Object gl2 : delsGd) {
                    co.getGoods().remove(gl2);
                }
            }
            Object var11_17 = null;
            gl2 = co.getServs().iterator();
            while (gl2.hasNext()) {
                CuOrSeSrLn cuOrSeSrLn = (CuOrSeSrLn)((Object)gl2.next());
                cuOrSeSrLn.setOwnr(co);
                if (cuOrSeSrLn.getIsNew().booleanValue()) {
                    this.getOrm().insIdLn(pRvs, vs, (IHasId)cuOrSeSrLn);
                }
                if (cuOrSeSrLn.getItTxs() != null && cuOrSeSrLn.getItTxs().size() > 0) {
                    for (CuOrSeSrTxLn stl3 : cuOrSeSrLn.getItTxs()) {
                        stl3.setOwnr(cuOrSeSrLn);
                        if (stl3.getIsNew().booleanValue()) {
                            this.getOrm().insIdLn(pRvs, vs, (IHasId)stl3);
                            continue;
                        }
                        if (cuOrSeSrLn.getSrv() == null || stl3.getTax() == null) {
                            this.getOrm().del(pRvs, vs, (IHasId)stl3);
                            continue;
                        }
                        this.getOrm().update(pRvs, vs, (IHasId)stl3);
                    }
                }
                if (!cuOrSeSrLn.getIsNew().booleanValue() && cuOrSeSrLn.getSrv() == null) {
                    this.getOrm().del(pRvs, vs, (IHasId)cuOrSeSrLn);
                    if (var11_18 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var11_18.add(cuOrSeSrLn);
                    continue;
                }
                tot = tot.add(cuOrSeSrLn.getTot());
                subt = subt.add(cuOrSeSrLn.getSubt());
                if (cuOrSeSrLn.getIsNew().booleanValue()) continue;
                this.getOrm().update(pRvs, vs, (IHasId)cuOrSeSrLn);
            }
            if (var11_18 != null) {
                gl2 = var11_18.iterator();
                while (gl2.hasNext()) {
                    CuOrSeSrLn cuOrSeSrLn = (CuOrSeSrLn)((Object)gl2.next());
                    co.getServs().remove((Object)cuOrSeSrLn);
                }
            }
            BigDecimal totTx = BigDecimal.ZERO;
            for (CartTxLn cartTxLn : pCart.getTaxes()) {
                if (cartTxLn.getDisab().booleanValue() || cartTxLn.getSelr() == null || !cartTxLn.getSelr().getDbcr().getIid().equals(co.getSelr().getDbcr().getIid())) continue;
                CuOrSeTxLn otl = null;
                if (!co.getIsNew().booleanValue()) {
                    for (CuOrSeTxLn otlt : co.getTaxes()) {
                        if (otlt.getTax() != null) continue;
                        otl = otlt;
                        break;
                    }
                }
                if (otl == null) {
                    otl = new CuOrSeTxLn();
                    otl.setIsNew(true);
                    co.getTaxes().add(otl);
                }
                otl.setOwnr(co);
                Tax tx = new Tax();
                tx.setIid(cartTxLn.getTax().getIid());
                tx.setNme(cartTxLn.getTax().getNme());
                otl.setTax(tx);
                otl.setTot(cartTxLn.getTot());
                otl.setTxb(cartTxLn.getTxb());
                totTx = totTx.add(otl.getTot());
                if (otl.getIsNew().booleanValue()) {
                    this.getOrm().insIdLn(pRvs, vs, (IHasId)otl);
                    continue;
                }
                this.getOrm().update(pRvs, vs, (IHasId)otl);
            }
            if (!co.getIsNew().booleanValue()) {
                void var13_30;
                Object var13_29 = null;
                for (CuOrSeTxLn otlt : co.getTaxes()) {
                    if (otlt.getTax() != null) continue;
                    this.getOrm().del(pRvs, vs, (IHasId)otlt);
                    if (var13_30 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var13_30.add(otlt);
                }
                if (var13_30 != null) {
                    for (CuOrSeTxLn tl : var13_30) {
                        co.getTaxes().remove((Object)tl);
                    }
                }
            }
            co.setTot(tot);
            co.setSubt(subt);
            co.setToTx(totTx);
            this.getOrm().update(pRvs, vs, (IHasId)co);
        }
        if (dels != null) {
            for (CuOrSe co : dels) {
                pPur.getSords().remove(co);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveOrds(Map<String, Object> pRvs, Purch pPur, Cart pCart) throws Exception {
        HashMap vs = new HashMap();
        ArrayList<CuOr> dels = null;
        for (CuOr co : pPur.getOrds()) {
            void var11_18;
            CuOrSrLn sl;
            Object gl2;
            if (co.getCurr() == null) {
                for (CuOrGdLn gl2 : co.getGoods()) {
                    for (CuOrGdTxLn cuOrGdTxLn : gl2.getItTxs()) {
                        this.getOrm().del(pRvs, vs, (IHasId)cuOrGdTxLn);
                    }
                    this.getOrm().del(pRvs, vs, (IHasId)gl2);
                }
                for (CuOrSrLn sl2 : co.getServs()) {
                    for (CuOrSrTxLn cuOrSrTxLn : sl2.getItTxs()) {
                        this.getOrm().del(pRvs, vs, (IHasId)cuOrSrTxLn);
                    }
                    this.getOrm().del(pRvs, vs, (IHasId)sl2);
                }
                for (CuOrTxLn otlt : co.getTaxes()) {
                    this.getOrm().del(pRvs, vs, (IHasId)otlt);
                }
                this.getOrm().del(pRvs, vs, (IHasId)co);
                if (dels == null) {
                    dels = new ArrayList<CuOr>();
                }
                dels.add(co);
                continue;
            }
            if (co.getIsNew().booleanValue()) {
                this.getOrm().insIdLn(pRvs, vs, (IHasId)co);
            }
            BigDecimal tot = BigDecimal.ZERO;
            BigDecimal subt = BigDecimal.ZERO;
            ArrayList<Object> delsGd = null;
            for (Object gl2 : co.getGoods()) {
                ((ACuOrLn)((Object)gl2)).setOwnr(co);
                if (gl2.getIsNew().booleanValue()) {
                    this.getOrm().insIdLn(pRvs, vs, (IHasId)gl2);
                }
                if (((CuOrGdLn)((Object)gl2)).getItTxs() != null && ((CuOrGdLn)((Object)gl2)).getItTxs().size() > 0) {
                    for (CuOrGdTxLn gtl : ((CuOrGdLn)((Object)gl2)).getItTxs()) {
                        gtl.setOwnr((CuOrGdLn)((Object)gl2));
                        if (gtl.getIsNew().booleanValue()) {
                            this.getOrm().insIdLn(pRvs, vs, (IHasId)gtl);
                            continue;
                        }
                        if (((CuOrGdLn)((Object)gl2)).getGood() == null || gtl.getTax() == null) {
                            this.getOrm().del(pRvs, vs, (IHasId)gtl);
                            continue;
                        }
                        this.getOrm().update(pRvs, vs, (IHasId)gtl);
                    }
                }
                if (!gl2.getIsNew().booleanValue() && ((CuOrGdLn)((Object)gl2)).getGood() == null) {
                    this.getOrm().del(pRvs, vs, (IHasId)gl2);
                    if (delsGd == null) {
                        delsGd = new ArrayList<Object>();
                    }
                    delsGd.add(gl2);
                    continue;
                }
                tot = tot.add(((AOrdLn)((Object)gl2)).getTot());
                subt = subt.add(((AOrdLn)((Object)gl2)).getSubt());
                if (gl2.getIsNew().booleanValue()) continue;
                this.getOrm().update(pRvs, vs, (IHasId)gl2);
            }
            if (delsGd != null) {
                for (Object gl2 : delsGd) {
                    co.getGoods().remove(gl2);
                }
            }
            Object var11_17 = null;
            gl2 = co.getServs().iterator();
            while (gl2.hasNext()) {
                sl = (CuOrSrLn)((Object)gl2.next());
                sl.setOwnr(co);
                if (sl.getIsNew().booleanValue()) {
                    this.getOrm().insIdLn(pRvs, vs, (IHasId)sl);
                }
                if (sl.getItTxs() != null && sl.getItTxs().size() > 0) {
                    for (CuOrSrTxLn stl3 : sl.getItTxs()) {
                        stl3.setOwnr(sl);
                        if (stl3.getIsNew().booleanValue()) {
                            this.getOrm().insIdLn(pRvs, vs, (IHasId)stl3);
                            continue;
                        }
                        if (sl.getSrv() == null || stl3.getTax() == null) {
                            this.getOrm().del(pRvs, vs, (IHasId)stl3);
                            continue;
                        }
                        this.getOrm().update(pRvs, vs, (IHasId)stl3);
                    }
                }
                if (!sl.getIsNew().booleanValue() && sl.getSrv() == null) {
                    this.getOrm().del(pRvs, vs, (IHasId)sl);
                    if (var11_18 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var11_18.add(sl);
                    continue;
                }
                tot = tot.add(sl.getTot());
                subt = subt.add(sl.getSubt());
                if (sl.getIsNew().booleanValue()) continue;
                this.getOrm().update(pRvs, vs, (IHasId)sl);
            }
            if (var11_18 != null) {
                gl2 = var11_18.iterator();
                while (gl2.hasNext()) {
                    sl = (CuOrSrLn)((Object)gl2.next());
                    co.getServs().remove((Object)sl);
                }
            }
            ArrayList<CuOrTxLn> delsTx = null;
            BigDecimal totTx = BigDecimal.ZERO;
            for (CartTxLn ctl : pCart.getTaxes()) {
                if (ctl.getDisab().booleanValue() || ctl.getSelr() != null) continue;
                CuOrTxLn otl = null;
                if (!co.getIsNew().booleanValue()) {
                    for (CuOrTxLn otlt : co.getTaxes()) {
                        if (otlt.getTax() != null) continue;
                        otl = otlt;
                        break;
                    }
                }
                if (otl == null) {
                    otl = new CuOrTxLn();
                    otl.setIsNew(true);
                    co.getTaxes().add(otl);
                }
                otl.setOwnr(co);
                Tax tx = new Tax();
                tx.setIid(ctl.getTax().getIid());
                tx.setNme(ctl.getTax().getNme());
                otl.setTax(tx);
                otl.setTot(ctl.getTot());
                otl.setTxb(ctl.getTxb());
                totTx = totTx.add(otl.getTot());
                if (otl.getIsNew().booleanValue()) {
                    this.getOrm().insIdLn(pRvs, vs, (IHasId)otl);
                    continue;
                }
                this.getOrm().update(pRvs, vs, (IHasId)otl);
            }
            if (!co.getIsNew().booleanValue()) {
                for (CuOrTxLn otlt : co.getTaxes()) {
                    if (otlt.getTax() != null) continue;
                    this.getOrm().del(pRvs, vs, (IHasId)otlt);
                    if (delsTx == null) {
                        delsTx = new ArrayList<CuOrTxLn>();
                    }
                    delsTx.add(otlt);
                }
            }
            if (delsTx != null) {
                for (CuOrTxLn tl : delsTx) {
                    co.getTaxes().remove((Object)tl);
                }
            }
            co.setTot(tot);
            co.setSubt(subt);
            co.setToTx(totTx);
            this.getOrm().update(pRvs, vs, (IHasId)co);
        }
        if (dels != null) {
            for (CuOr co : dels) {
                pPur.getOrds().remove((Object)co);
            }
        }
    }

    public final Purch retNewOrds(Map<String, Object> pRvs, Buyer pBur) throws Exception {
        HashMap<String, String[]> vs = new HashMap<String, String[]>();
        String[] ndFl = new String[]{"ver"};
        vs.put("CuOrndFds", ndFl);
        List orders = this.getOrm().retLstCnd(pRvs, vs, CuOr.class, "where STAS=0 and BUYR=" + pBur.getIid());
        vs.clear();
        for (Object cuOr : orders) {
            vs.put("CuOrTxLnndFds", ndFl);
            ((CuOr)((Object)cuOr)).setTaxes(this.getOrm().retLstCnd(pRvs, vs, CuOrTxLn.class, "where OWNR=" + cuOr.getIid()));
            vs.clear();
            vs.put("CuOrGdLnndFds", ndFl);
            ((CuOr)((Object)cuOr)).setGoods(this.getOrm().retLstCnd(pRvs, vs, CuOrGdLn.class, "where OWNR=" + cuOr.getIid()));
            vs.clear();
            vs.put("CuOrSrLnndFds", ndFl);
            ((CuOr)((Object)cuOr)).setServs(this.getOrm().retLstCnd(pRvs, vs, CuOrSrLn.class, "where OWNR=" + cuOr.getIid()));
            vs.clear();
            vs.put("CuOrGdTxLnndFds", ndFl);
            for (CuOrGdLn gl : ((CuOr)((Object)cuOr)).getGoods()) {
                gl.setItTxs(this.getOrm().retLstCnd(pRvs, vs, CuOrGdTxLn.class, "where OWNR=" + gl.getIid()));
            }
            vs.clear();
            vs.put("CuOrSrTxLnndFds", ndFl);
            for (CuOrSrLn sl : ((CuOr)((Object)cuOr)).getServs()) {
                sl.setItTxs(this.getOrm().retLstCnd(pRvs, vs, CuOrSrTxLn.class, "where OWNR=" + sl.getIid()));
            }
            vs.clear();
        }
        vs.put("CuOrSendFds", ndFl);
        List sorders = this.getOrm().retLstCnd(pRvs, vs, CuOrSe.class, "where STAS=0 and BUYR=" + pBur.getIid());
        vs.clear();
        for (CuOrSe cuOr : sorders) {
            vs.put("CuOrSeTxLnndFds", ndFl);
            cuOr.setTaxes(this.getOrm().retLstCnd(pRvs, vs, CuOrSeTxLn.class, "where OWNR=" + cuOr.getIid()));
            vs.clear();
            vs.put("CuOrSeGdLnndFds", ndFl);
            cuOr.setGoods(this.getOrm().retLstCnd(pRvs, vs, CuOrSeGdLn.class, "where OWNR=" + cuOr.getIid()));
            vs.clear();
            vs.put("CuOrSeSrLnndFds", ndFl);
            cuOr.setServs(this.getOrm().retLstCnd(pRvs, vs, CuOrSeSrLn.class, "where OWNR=" + cuOr.getIid()));
            vs.clear();
            vs.put("CuOrSeGdTxLnndFds", ndFl);
            for (CuOrSeGdLn gl : cuOr.getGoods()) {
                gl.setItTxs(this.getOrm().retLstCnd(pRvs, vs, CuOrSeGdTxLn.class, "where OWNR=" + gl.getIid()));
            }
            vs.clear();
            vs.put("CuOrSeSrTxLnndFds", ndFl);
            for (CuOrSeSrLn sl : cuOr.getServs()) {
                sl.setItTxs(this.getOrm().retLstCnd(pRvs, vs, CuOrSeSrTxLn.class, "where OWNR=" + sl.getIid()));
            }
            vs.clear();
        }
        Purch pur = new Purch();
        pur.setOrds(orders);
        pur.setSords(sorders);
        return pur;
    }

    public final void makeSeOrdLn(Map<String, Object> pRvs, List<CuOrSe> pOrders, SeSel pSel, AItmPlc<?, ?> pItPl, CartLn pCartLn, TrdStg pTs) throws Exception {
        ACuOrSeLn ol;
        CuOrSe cuOr = null;
        boolean isNdOrInit = true;
        for (CuOrSe co : pOrders) {
            if (co.getCurr() == null || co.getSelr() == null || !co.getSelr().getDbcr().getIid().equals(pSel.getDbcr().getIid())) continue;
            cuOr = co;
            isNdOrInit = false;
            break;
        }
        if (cuOr == null) {
            for (CuOrSe co : pOrders) {
                if (co.getCurr() != null) continue;
                cuOr = co;
                break;
            }
        }
        if (cuOr == null) {
            cuOr = new CuOrSe();
            cuOr.setIsNew(true);
            cuOr.setTaxes(new ArrayList<CuOrSeTxLn>());
            cuOr.setGoods((List<CuOrSeGdLn>)new ArrayList<CuOrSeGdLn>());
            cuOr.setServs((List<CuOrSeSrLn>)new ArrayList<CuOrSeSrLn>());
            pOrders.add(cuOr);
        }
        if (isNdOrInit) {
            cuOr.setDat(new Date());
            cuOr.setSelr(pSel);
            cuOr.setStas(EOrdStat.NEW);
            cuOr.setDelv(pCartLn.getOwnr().getDelv());
            cuOr.setPaym(pCartLn.getOwnr().getPaym());
            cuOr.setBuyr(pCartLn.getOwnr().getBuyr());
            cuOr.setPur(pCartLn.getOwnr().getVer());
            cuOr.setCurr(pCartLn.getOwnr().getCurr());
            cuOr.setExRt(pCartLn.getOwnr().getExRt());
            cuOr.setDscr(pCartLn.getOwnr().getDscr());
        }
        HashMap<String, Integer> vs = new HashMap<String, Integer>();
        vs.put("CartLndpLv", 0);
        vs.put("TaxdpLv", 0);
        List citls = this.getOrm().retLstCnd(pRvs, vs, CartItTxLn.class, "where DISAB=0 and OWNR=" + pCartLn.getIid());
        vs.clear();
        if (pCartLn.getItTyp().equals((Object)EItmTy.SEGOODS)) {
            CuOrSeGdLn ogl = null;
            if (!cuOr.getIsNew().booleanValue()) {
                for (Object gl : cuOr.getGoods()) {
                    if (gl.getGood() != null) continue;
                    ogl = gl;
                    break;
                }
            }
            if (ogl == null) {
                ogl = new CuOrSeGdLn();
                ogl.setIsNew(true);
                cuOr.getGoods().add(ogl);
            }
            SeItm gd = new SeItm();
            gd.setSelr(pSel);
            gd.setIid(pCartLn.getItId());
            gd.setNme(pCartLn.getNme());
            ogl.setGood(gd);
            if (citls.size() > 0) {
                if (ogl.getIsNew().booleanValue()) {
                    ogl.setItTxs(new ArrayList<CuOrSeGdTxLn>());
                }
                for (CartItTxLn citl : citls) {
                    CuOrSeGdTxLn oitl = null;
                    if (!cuOr.getIsNew().booleanValue()) {
                        for (CuOrSeGdTxLn itl : ogl.getItTxs()) {
                            if (itl.getTax() != null) continue;
                            oitl = itl;
                            break;
                        }
                    }
                    if (oitl == null) {
                        oitl = new CuOrSeGdTxLn();
                        oitl.setIsNew(true);
                        ogl.getItTxs().add(oitl);
                    }
                    oitl.setOwnr(ogl);
                    Tax tx = new Tax();
                    tx.setIid(citl.getTax().getIid());
                    tx.setNme(citl.getTax().getNme());
                    oitl.setTax(tx);
                    oitl.setTot(citl.getTot());
                }
            }
            ol = ogl;
        } else {
            CuOrSeSrLn osl = null;
            if (!cuOr.getIsNew().booleanValue()) {
                for (CuOrSeSrLn sl : cuOr.getServs()) {
                    if (sl.getSrv() != null) continue;
                    osl = sl;
                    break;
                }
            }
            if (osl == null) {
                osl = new CuOrSeSrLn();
                osl.setIsNew(true);
                cuOr.getServs().add(osl);
            }
            SeSrv sr = new SeSrv();
            sr.setSelr(pSel);
            sr.setIid(pCartLn.getItId());
            sr.setNme(pCartLn.getNme());
            osl.setSrv(sr);
            osl.setDt1(pCartLn.getDt1());
            osl.setDt2(pCartLn.getDt2());
            if (citls.size() > 0) {
                if (osl.getIsNew().booleanValue()) {
                    osl.setItTxs(new ArrayList<CuOrSeSrTxLn>());
                }
                for (CartItTxLn citl : citls) {
                    CuOrSeSrTxLn oitl = null;
                    if (!cuOr.getIsNew().booleanValue()) {
                        for (CuOrSeSrTxLn itl : osl.getItTxs()) {
                            if (itl.getTax() != null) continue;
                            oitl = itl;
                            break;
                        }
                    }
                    if (oitl == null) {
                        oitl = new CuOrSeSrTxLn();
                        oitl.setIsNew(true);
                        osl.getItTxs().add(oitl);
                    }
                    oitl.setOwnr(osl);
                    Tax tx = new Tax();
                    tx.setIid(citl.getTax().getIid());
                    tx.setNme(citl.getTax().getNme());
                    oitl.setTax(tx);
                    oitl.setTot(citl.getTot());
                }
            }
            ol = osl;
        }
        ol.setDscr(pCartLn.getDscr());
        ol.setNme(pCartLn.getNme());
        ol.setUom(pCartLn.getUom());
        ol.setPri(pCartLn.getPri());
        ol.setQuan(pCartLn.getQuan());
        ol.setSubt(pCartLn.getSubt());
        ol.setTot(pCartLn.getTot());
        ol.setToTx(pCartLn.getToTx());
        ol.setTxCt(pCartLn.getTxCt());
        ol.setTdsc(pCartLn.getTdsc());
    }

    public final void makeOrdLn(Map<String, Object> pRvs, List<CuOr> pOrders, AItmPlc<?, ?> pItPl, CartLn pCartLn, TrdStg pTs) throws Exception {
        ACuOrLn ol;
        CuOr cuOr = null;
        boolean isNdOrInit = true;
        for (CuOr co : pOrders) {
            if (co.getCurr() == null) continue;
            cuOr = co;
            isNdOrInit = false;
            break;
        }
        if (cuOr == null) {
            cuOr = new CuOr();
            cuOr.setIsNew(true);
            cuOr.setTaxes(new ArrayList<CuOrTxLn>());
            cuOr.setGoods((List<CuOrGdLn>)new ArrayList<CuOrGdLn>());
            cuOr.setServs((List<CuOrSrLn>)new ArrayList<CuOrSrLn>());
            pOrders.add(cuOr);
        }
        if (isNdOrInit) {
            cuOr.setDat(new Date());
            cuOr.setStas(EOrdStat.NEW);
            cuOr.setDelv(pCartLn.getOwnr().getDelv());
            cuOr.setPaym(pCartLn.getOwnr().getPaym());
            cuOr.setBuyr(pCartLn.getOwnr().getBuyr());
            cuOr.setPur(pCartLn.getOwnr().getVer());
            cuOr.setCurr(pCartLn.getOwnr().getCurr());
            cuOr.setExRt(pCartLn.getOwnr().getExRt());
            cuOr.setDscr(pCartLn.getOwnr().getDscr());
        }
        HashMap<String, Integer> vs = new HashMap<String, Integer>();
        vs.put("CartLndpLv", 0);
        vs.put("TaxdpLv", 0);
        List citls = this.getOrm().retLstCnd(pRvs, vs, CartItTxLn.class, "where DISAB=0 and OWNR=" + pCartLn.getIid());
        vs.clear();
        if (pCartLn.getItTyp().equals((Object)EItmTy.GOODS)) {
            CuOrGdLn ogl = null;
            if (!cuOr.getIsNew().booleanValue()) {
                for (Object gl : cuOr.getGoods()) {
                    if (gl.getGood() != null) continue;
                    ogl = gl;
                    break;
                }
            }
            if (ogl == null) {
                ogl = new CuOrGdLn();
                ogl.setIsNew(true);
                cuOr.getGoods().add(ogl);
            }
            Itm gd = new Itm();
            gd.setIid(pCartLn.getItId());
            gd.setNme(pCartLn.getNme());
            ogl.setGood(gd);
            if (citls.size() > 0) {
                if (ogl.getIsNew().booleanValue()) {
                    ogl.setItTxs(new ArrayList<CuOrGdTxLn>());
                }
                for (CartItTxLn citl : citls) {
                    CuOrGdTxLn oitl = null;
                    if (!cuOr.getIsNew().booleanValue()) {
                        for (CuOrGdTxLn itl : ogl.getItTxs()) {
                            if (itl.getTax() != null) continue;
                            oitl = itl;
                            break;
                        }
                    }
                    if (oitl == null) {
                        oitl = new CuOrGdTxLn();
                        oitl.setIsNew(true);
                        ogl.getItTxs().add(oitl);
                    }
                    oitl.setOwnr(ogl);
                    Tax tx = new Tax();
                    tx.setIid(citl.getTax().getIid());
                    tx.setNme(citl.getTax().getNme());
                    oitl.setTax(tx);
                    oitl.setTot(citl.getTot());
                }
            }
            ol = ogl;
        } else {
            CuOrSrLn osl = null;
            if (!cuOr.getIsNew().booleanValue()) {
                for (CuOrSrLn sl : cuOr.getServs()) {
                    if (sl.getSrv() != null) continue;
                    osl = sl;
                    break;
                }
            }
            if (osl == null) {
                osl = new CuOrSrLn();
                osl.setIsNew(true);
                cuOr.getServs().add(osl);
            }
            Srv sr = new Srv();
            sr.setIid(pCartLn.getItId());
            sr.setNme(pCartLn.getNme());
            osl.setSrv(sr);
            osl.setDt1(pCartLn.getDt1());
            osl.setDt2(pCartLn.getDt2());
            if (citls.size() > 0) {
                if (osl.getIsNew().booleanValue()) {
                    osl.setItTxs(new ArrayList<CuOrSrTxLn>());
                }
                for (CartItTxLn citl : citls) {
                    CuOrSrTxLn oitl = null;
                    if (!cuOr.getIsNew().booleanValue()) {
                        for (CuOrSrTxLn itl : osl.getItTxs()) {
                            if (itl.getTax() != null) continue;
                            oitl = itl;
                            break;
                        }
                    }
                    if (oitl == null) {
                        oitl = new CuOrSrTxLn();
                        oitl.setIsNew(true);
                        osl.getItTxs().add(oitl);
                    }
                    oitl.setOwnr(osl);
                    Tax tx = new Tax();
                    tx.setIid(citl.getTax().getIid());
                    tx.setNme(citl.getTax().getNme());
                    oitl.setTax(tx);
                    oitl.setTot(citl.getTot());
                }
            }
            ol = osl;
        }
        ol.setDscr(pCartLn.getDscr());
        ol.setNme(pCartLn.getNme());
        ol.setUom(pCartLn.getUom());
        ol.setPri(pCartLn.getPri());
        ol.setQuan(pCartLn.getQuan());
        ol.setSubt(pCartLn.getSubt());
        ol.setTot(pCartLn.getTot());
        ol.setToTx(pCartLn.getToTx());
        ol.setTxCt(pCartLn.getTxCt());
        ol.setTdsc(pCartLn.getTdsc());
    }

    public final void redir(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        String procNm = pRqDt.getParam("prcRed");
        if (this.getClass().getSimpleName().equals(procNm)) {
            throw new ExcCode(100, "Danger! Stupid scam!!!");
        }
        IPrc proc = this.fcPrWs.laz(pRvs, procNm);
        proc.process(pRvs, pRqDt);
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final Integer getTrIsl() {
        return this.trIsl;
    }

    public final void setTrIsl(Integer pTrIsl) {
        this.trIsl = pTrIsl;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrCart getSrCart() {
        return this.srCart;
    }

    public final void setSrCart(ISrCart pSrCart) {
        this.srCart = pSrCart;
    }

    public final FcPrWs<RS> getFcPrWs() {
        return this.fcPrWs;
    }

    public final void setFcPrWs(FcPrWs<RS> pFcPrWs) {
        this.fcPrWs = pFcPrWs;
    }
}

