/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.prc;

import java.math.BigDecimal;
import java.util.Map;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.TxDst;
import org.beigesoft.acc.mdlp.Uom;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrc;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.ws.fct.FcPrWs;
import org.beigesoft.ws.mdl.EItmTy;
import org.beigesoft.ws.mdlp.Cart;
import org.beigesoft.ws.mdlp.CartLn;
import org.beigesoft.ws.mdlp.TrdStg;
import org.beigesoft.ws.srv.ISrCart;

public class ItmCart<RS>
implements IPrc {
    private ILog log;
    private ISrCart srCart;
    private FcPrWs<RS> fcPrWs;
    private IRdb<RS> rdb;
    private Integer trIsl;

    public final void process(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(this.trIsl.intValue());
            this.rdb.begin();
            TrdStg ts = (TrdStg)((Object)pRvs.get("tstg"));
            AcStg as = (AcStg)((Object)pRvs.get("astg"));
            TxDst txRules = null;
            String act = pRqDt.getParam("act");
            if ("del".equals(act)) {
                Cart cart = this.srCart.getCart(pRvs, pRqDt, false, false);
                if (cart != null) {
                    txRules = this.srCart.revTxRules(pRvs, cart, as);
                    String lnIdStr = pRqDt.getParam("lnId");
                    if (lnIdStr != null) {
                        Long lnId = Long.valueOf(lnIdStr);
                        CartLn cartLn = null;
                        for (CartLn ci : cart.getItems()) {
                            if (!ci.getIid().equals(lnId)) continue;
                            if (ci.getDisab().booleanValue()) {
                                throw new ExcCode(100, "requested item disabled!");
                            }
                            cartLn = ci;
                            break;
                        }
                        if (cartLn == null) {
                            throw new ExcCode(100, "Requested item not found!");
                        }
                        if (cartLn.getForc().booleanValue()) {
                            throw new ExcCode(100, "Requested item forced");
                        }
                        this.srCart.delLine(pRvs, cartLn, txRules);
                        this.srCart.mkCartTots(pRvs, ts, cartLn, as, txRules);
                        this.srCart.hndCartChg(pRvs, cart, txRules);
                    }
                }
            } else {
                BigDecimal avQuan;
                BigDecimal quan;
                Cart cart = this.srCart.getCart(pRvs, pRqDt, true, false);
                txRules = this.srCart.revTxRules(pRvs, cart, as);
                CartLn cartLn = null;
                String lnIdStr = pRqDt.getParam("lnId");
                String quanStr = pRqDt.getParam("quan");
                String avQuanStr = pRqDt.getParam("avQuan");
                String unStStr = pRqDt.getParam("unSt");
                CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
                String dgsep = cpf.getDcGrSpv();
                if (dgsep != null) {
                    quanStr = quanStr.replace(dgsep, "");
                    if ("\u00a0".equals(dgsep)) {
                        quanStr = quanStr.replace("\u00c2", "");
                    }
                }
                if (!"".equals(cpf.getDcSpv()) && !".".equals(cpf.getDcSpv())) {
                    quanStr = quanStr.replace(cpf.getDcSpv(), ".");
                }
                if ((quan = new BigDecimal(quanStr)).compareTo(avQuan = new BigDecimal(avQuanStr)) == 1) {
                    quan = avQuan;
                }
                BigDecimal unSt = new BigDecimal(unStStr);
                String itIdStr = pRqDt.getParam("itId");
                String itTypStr = pRqDt.getParam("itTyp");
                Long itId = Long.valueOf(itIdStr);
                EItmTy itTyp = ((EItmTy[])EItmTy.class.getEnumConstants())[Integer.parseInt(itTypStr)];
                boolean redoPr = false;
                if (lnIdStr != null) {
                    Long lnId = Long.valueOf(lnIdStr);
                    cartLn = this.fndCartItmById(cart, lnId);
                } else {
                    redoPr = true;
                    String uomIdStr = pRqDt.getParam("uomId");
                    Long uomId = Long.valueOf(uomIdStr);
                    for (CartLn ci : cart.getItems()) {
                        if (ci.getDisab().booleanValue() || !ci.getItTyp().equals((Object)itTyp) || !ci.getItId().equals(itId)) continue;
                        cartLn = ci;
                        break;
                    }
                    if (cartLn == null) {
                        for (CartLn ci : cart.getItems()) {
                            if (!ci.getDisab().booleanValue()) continue;
                            cartLn = ci;
                            cartLn.setDisab(false);
                            cartLn.setForc(false);
                            cartLn.setSelr(null);
                            cartLn.setTxCt(null);
                            cartLn.setTdsc(null);
                            break;
                        }
                    }
                    if (cartLn == null) {
                        cartLn = this.creCartItm(cart);
                    }
                    Uom uom = new Uom();
                    uom.setIid(uomId);
                    cartLn.setUom(uom);
                    cartLn.setItId(itId);
                    cartLn.setItTyp(itTyp);
                }
                if (!cartLn.getForc().booleanValue()) {
                    cartLn.setAvQuan(avQuan);
                    cartLn.setQuan(quan);
                    cartLn.setUnSt(unSt);
                    BigDecimal amount = cartLn.getPri().multiply(cartLn.getQuan()).setScale((int)as.getPrDp(), as.getRndm());
                    if (ts.getTxExcl().booleanValue()) {
                        cartLn.setSubt(amount);
                    } else {
                        cartLn.setTot(amount);
                    }
                    this.srCart.mkLine(pRvs, cartLn, as, ts, txRules, redoPr, true);
                    this.srCart.mkCartTots(pRvs, ts, cartLn, as, txRules);
                    this.srCart.hndCartChg(pRvs, cart, txRules);
                }
            }
            if (txRules != null) {
                pRvs.put("txRules", (Object)txRules);
            }
            this.rdb.commit();
        }
        catch (Exception ex) {
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
        this.redir(pRvs, pRqDt);
    }

    public final void redir(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        String procNm = pRqDt.getParam("prcRed");
        if (this.getClass().getSimpleName().equals(procNm)) {
            throw new ExcCode(100, "Danger! Stupid scam!!!");
        }
        IPrc proc = this.fcPrWs.laz(pRvs, procNm);
        proc.process(pRvs, pRqDt);
    }

    public final CartLn fndCartItmById(Cart pCart, Long pCrItId) throws Exception {
        CartLn cartLn = null;
        for (CartLn ci : pCart.getItems()) {
            if (!ci.getIid().equals(pCrItId)) continue;
            if (ci.getDisab().booleanValue()) {
                throw new ExcCode(1001, "requested_item_disabled");
            }
            cartLn = ci;
            break;
        }
        if (cartLn == null) {
            throw new ExcCode(1001, "requested_item_not_found");
        }
        return cartLn;
    }

    public final CartLn creCartItm(Cart pCart) {
        CartLn cartLn = new CartLn();
        cartLn.setIsNew(true);
        cartLn.setDisab(false);
        cartLn.setForc(false);
        cartLn.setOwnr(pCart);
        pCart.getItems().add(cartLn);
        return cartLn;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final Integer getTrIsl() {
        return this.trIsl;
    }

    public final void setTrIsl(Integer pTrIsl) {
        this.trIsl = pTrIsl;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final ISrCart getSrCart() {
        return this.srCart;
    }

    public final void setSrCart(ISrCart pSrCart) {
        this.srCart = pSrCart;
    }

    public final FcPrWs<RS> getFcPrWs() {
        return this.fcPrWs;
    }

    public final void setFcPrWs(FcPrWs<RS> pFcPrWs) {
        this.fcPrWs = pFcPrWs;
    }
}

