/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.prc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrc;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.ws.fct.FcPrWs;
import org.beigesoft.ws.mdl.Purch;
import org.beigesoft.ws.mdlb.ACuOrLn;
import org.beigesoft.ws.mdlb.ACuOrSeLn;
import org.beigesoft.ws.mdlp.Buyer;
import org.beigesoft.ws.mdlp.CuOr;
import org.beigesoft.ws.mdlp.CuOrGdLn;
import org.beigesoft.ws.mdlp.CuOrSe;
import org.beigesoft.ws.mdlp.CuOrSeGdLn;
import org.beigesoft.ws.mdlp.CuOrSeSrLn;
import org.beigesoft.ws.mdlp.CuOrSrLn;
import org.beigesoft.ws.srv.IBuySr;

public class PrBur<RS>
implements IPrc {
    private ILog log;
    private IRdb<RS> rdb;
    private IOrm orm;
    private IBuySr buySr;
    private FcPrWs<RS> fcPrWs;
    private Integer trIsl;

    public final void process(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        Buyer buyer = null;
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(this.trIsl.intValue());
            this.rdb.begin();
            buyer = this.buySr.getAuthBuyr(pRvs, pRqDt);
            if (buyer != null) {
                HashMap<String, Object> vs = new HashMap<String, Object>();
                String purIdStr = pRqDt.getParam("pur");
                Long.parseLong(purIdStr);
                String whePuBr = "where PUR=" + purIdStr + " and BUYR=" + buyer.getIid();
                String[] ndFlNm = new String[]{"nme"};
                vs.put("PicPlcndFds", ndFlNm);
                vs.put("BuyerdpLv", 0);
                List ords = this.orm.retLstCnd(pRvs, vs, CuOr.class, whePuBr);
                vs.clear();
                vs.put("DbCrndFds", ndFlNm);
                vs.put("SeSelndFds", new String[]{"dbcr"});
                vs.put("SeSeldpLv", 2);
                vs.put("BuyerdpLv", 0);
                List sords = this.orm.retLstCnd(pRvs, vs, CuOrSe.class, whePuBr);
                vs.clear();
                this.retLines(pRvs, buyer, ords, sords);
                Purch pur = new Purch();
                pur.setOrds(ords);
                pur.setSords(sords);
                pRvs.put("pur", pur);
                pRqDt.setAttr("rnd", (Object)"waor");
            }
            this.rdb.commit();
        }
        catch (Exception ex) {
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
        if (buyer == null) {
            this.log.warn(pRvs, this.getClass(), "Trying to view purchase without buyer!");
            this.redir(pRvs, pRqDt);
            return;
        }
    }

    public final void retLines(Map<String, Object> pRvs, Buyer pBur, List<CuOr> pOrds, List<CuOrSe> pSords) throws Exception {
        Object il;
        Object allGds;
        StringBuffer ordIds = null;
        for (CuOr co : pOrds) {
            co.setGoods((List<CuOrGdLn>)new ArrayList<CuOrGdLn>());
            co.setServs((List<CuOrSrLn>)new ArrayList<CuOrSrLn>());
            if (ordIds == null) {
                ordIds = new StringBuffer();
                ordIds.append(co.getIid().toString());
                continue;
            }
            ordIds.append("," + co.getIid());
        }
        HashMap<String, Object> vs = new HashMap<String, Object>();
        String[] ndFlNm = new String[]{"nme"};
        Object[] ndFl = new String[]{"ownr", "nme", "uom", "quan", "pri", "tot", "toTx"};
        Arrays.sort(ndFl);
        if (ordIds != null) {
            vs.put("CuOrGdLnndFds", ndFl);
            vs.put("CuOrdpLv", 1);
            vs.put("UomndFds", ndFlNm);
            allGds = this.orm.retLstCnd(pRvs, vs, CuOrGdLn.class, "where OWNR in (" + ordIds + ")");
            vs.clear();
            Iterator iterator = allGds.iterator();
            block1: while (iterator.hasNext()) {
                il = (CuOrGdLn)((Object)iterator.next());
                for (CuOr cuOr : pOrds) {
                    if (!cuOr.getIid().equals(((ACuOrLn)((Object)il)).getOwnr().getIid())) continue;
                    cuOr.getGoods().add((CuOrGdLn)((Object)il));
                    continue block1;
                }
            }
            vs.put("CuOrSrLnndFds", ndFl);
            vs.put("CuOrdpLv", 1);
            vs.put("UomndFds", ndFlNm);
            List list = this.orm.retLstCnd(pRvs, vs, CuOrSrLn.class, "where OWNR in (" + ordIds + ")");
            vs.clear();
            block3: for (Object il2 : list) {
                for (CuOr cuOr : pOrds) {
                    if (!cuOr.getIid().equals(((ACuOrLn)((Object)il2)).getOwnr().getIid())) continue;
                    cuOr.getServs().add((CuOrSrLn)((Object)il2));
                    continue block3;
                }
            }
        }
        ordIds = null;
        for (CuOrSe cuOrSe : pSords) {
            cuOrSe.setGoods((List<CuOrSeGdLn>)new ArrayList<CuOrSeGdLn>());
            cuOrSe.setServs((List<CuOrSeSrLn>)new ArrayList<CuOrSeSrLn>());
            if (ordIds == null) {
                ordIds = new StringBuffer();
                ordIds.append(cuOrSe.getIid().toString());
                continue;
            }
            ordIds.append("," + cuOrSe.getIid());
        }
        if (ordIds != null) {
            vs.put("CuOrSeGdLnndFds", ndFl);
            vs.put("CuOrSedpLv", 1);
            vs.put("UomndFds", ndFlNm);
            allGds = this.orm.retLstCnd(pRvs, vs, CuOrSeGdLn.class, "where OWNR in (" + ordIds + ")");
            vs.clear();
            Iterator iterator = allGds.iterator();
            block6: while (iterator.hasNext()) {
                il = (CuOrSeGdLn)((Object)iterator.next());
                for (CuOrSe cuOrSe : pSords) {
                    if (!cuOrSe.getIid().equals(((ACuOrSeLn)((Object)il)).getOwnr().getIid())) continue;
                    cuOrSe.getGoods().add((CuOrSeGdLn)((Object)il));
                    continue block6;
                }
            }
            vs.put("CuOrSeSrLnndFds", ndFl);
            vs.put("CuOrSedpLv", 0);
            vs.put("UomndFds", ndFlNm);
            List list = this.orm.retLstCnd(pRvs, vs, CuOrSeSrLn.class, "where OWNR in (" + ordIds + ")");
            vs.clear();
            block8: for (CuOrSeSrLn il2 : list) {
                for (CuOrSe cuOrSe : pSords) {
                    if (!cuOrSe.getIid().equals(il2.getOwnr().getIid())) continue;
                    cuOrSe.getServs().add(il2);
                    continue block8;
                }
            }
        }
    }

    public final void redir(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        String procNm = pRqDt.getParam("prcRed");
        if (this.getClass().getSimpleName().equals(procNm)) {
            throw new ExcCode(100, "Danger! Stupid scam!!!");
        }
        IPrc proc = this.fcPrWs.laz(pRvs, procNm);
        proc.process(pRvs, pRqDt);
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final Integer getTrIsl() {
        return this.trIsl;
    }

    public final void setTrIsl(Integer pTrIsl) {
        this.trIsl = pTrIsl;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final IBuySr getBuySr() {
        return this.buySr;
    }

    public final void setBuySr(IBuySr pBuySr) {
        this.buySr = pBuySr;
    }

    public final FcPrWs<RS> getFcPrWs() {
        return this.fcPrWs;
    }

    public final void setFcPrWs(FcPrWs<RS> pFcPrWs) {
        this.fcPrWs = pFcPrWs;
    }
}

