/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ws.prc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.TxDst;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrc;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.ws.fct.FcPrWs;
import org.beigesoft.ws.mdl.EDeliv;
import org.beigesoft.ws.mdl.EPaymMth;
import org.beigesoft.ws.mdlp.Cart;
import org.beigesoft.ws.srv.ISrCart;

public class PrCart<RS>
implements IPrc {
    private ILog log;
    private IOrm orm;
    private ISrCart srCart;
    private FcPrWs<RS> fcPrWs;
    private IRdb<RS> rdb;
    private Integer trIsl;

    public final void process(Map<String, Object> pRvs, IReqDt pRqDt) throws Exception {
        try {
            this.rdb.setAcmt(false);
            this.rdb.setTrIsl(this.trIsl.intValue());
            this.rdb.begin();
            Cart cart = this.srCart.getCart(pRvs, pRqDt, false, false);
            if (cart != null) {
                HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
                String dlvStr = pRqDt.getParam("delv");
                String paymStr = pRqDt.getParam("paym");
                EDeliv dlv = ((EDeliv[])EDeliv.class.getEnumConstants())[Integer.parseInt(dlvStr)];
                EPaymMth paym = ((EPaymMth[])EPaymMth.class.getEnumConstants())[Integer.parseInt(paymStr)];
                if (dlv != cart.getDelv() || paym != cart.getPaym()) {
                    EDeliv dlvOld = cart.getDelv();
                    cart.setDelv(dlv);
                    cart.setPaym(paym);
                    Object[] ndFds = new String[]{"ver", "paym", "delv"};
                    Arrays.sort(ndFds);
                    vs.put("ndFds", ndFds);
                    this.orm.update(pRvs, vs, (IHasId)cart);
                    if (dlv != dlvOld) {
                        AcStg as = (AcStg)((Object)pRvs.get("astg"));
                        TxDst txRules = this.srCart.revTxRules(pRvs, cart, as);
                        if (txRules != null) {
                            pRvs.put("txRules", (Object)txRules);
                        }
                        this.srCart.hndCartChg(pRvs, cart, txRules);
                    }
                }
            } else {
                throw new ExcCode(100, "There is no cart!");
            }
            this.rdb.commit();
        }
        catch (Exception ex) {
            if (!this.rdb.getAcmt()) {
                this.rdb.rollBack();
            }
            throw ex;
        }
        finally {
            this.rdb.release();
        }
        String procNm = pRqDt.getParam("prcRed");
        if (this.getClass().getSimpleName().equals(procNm)) {
            throw new ExcCode(100, "Danger! stupid scam!!!");
        }
        IPrc proc = this.fcPrWs.laz(pRvs, procNm);
        proc.process(pRvs, pRqDt);
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final Integer getTrIsl() {
        return this.trIsl;
    }

    public final void setTrIsl(Integer pTrIsl) {
        this.trIsl = pTrIsl;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrCart getSrCart() {
        return this.srCart;
    }

    public final void setSrCart(ISrCart pSrCart) {
        this.srCart = pSrCart;
    }

    public final FcPrWs<RS> getFcPrWs() {
        return this.fcPrWs;
    }

    public final void setFcPrWs(FcPrWs<RS> pFcPrWs) {
        this.fcPrWs = pFcPrWs;
    }
}

