/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.android.log;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.log.ILogger;

public class Logger
implements ILogger {
    private boolean isShowDebugMessage;
    private final Map<Class<?>, Boolean> mapShowDebugMsgForClass = new HashMap();

    public final void debug(Class<?> pClazz, String pMsg) {
        if (this.isShowDebugMessage && this.getIsShowDebugMessages(pClazz)) {
            Log.d((String)pClazz.getSimpleName(), (String)pMsg);
        }
    }

    public final void info(Class<?> pClazz, String pMsg) {
        Log.i((String)pClazz.getSimpleName(), (String)pMsg);
    }

    public final void error(Class<?> pClazz, String pMsg) {
        Log.e((String)pClazz.getSimpleName(), (String)pMsg);
    }

    public final void warn(Class<?> pClazz, String pMsg) {
        Log.w((String)pClazz.getSimpleName(), (String)pMsg);
    }

    public final void setIsShowDebugMessages(boolean pIsShowDebugMessage) {
        this.isShowDebugMessage = pIsShowDebugMessage;
    }

    public final boolean getIsShowDebugMessages() {
        return this.isShowDebugMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIsShowDebugMessages(Class<?> pClazz, boolean pIsShowDebugMessage) {
        Map<Class<?>, Boolean> map = this.mapShowDebugMsgForClass;
        synchronized (map) {
            if (this.mapShowDebugMsgForClass.get(pClazz) == null || this.mapShowDebugMsgForClass.get(pClazz) != pIsShowDebugMessage) {
                this.mapShowDebugMsgForClass.put(pClazz, pIsShowDebugMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getIsShowDebugMessages(Class<?> pClazz) {
        Map<Class<?>, Boolean> map = this.mapShowDebugMsgForClass;
        synchronized (map) {
            if (this.mapShowDebugMsgForClass.get(pClazz) == null) {
                this.mapShowDebugMsgForClass.put(pClazz, true);
            }
            return this.mapShowDebugMsgForClass.get(pClazz);
        }
    }
}

