/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.android.sqlite.service;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.util.Map;
import org.beigesoft.android.sqlite.model.RecordSetAndroid;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.orm.model.ColumnsValues;
import org.beigesoft.orm.model.IRecordSet;
import org.beigesoft.orm.service.ASrvDatabase;

public class SrvDatabase
extends ASrvDatabase<Cursor> {
    private SQLiteDatabase sqliteDatabase;
    private boolean isAutocommit;

    public final boolean getIsAutocommit() throws Exception {
        return this.isAutocommit;
    }

    public final void setIsAutocommit(boolean pIsAutocommit) throws Exception {
        this.isAutocommit = pIsAutocommit;
    }

    public final void setTransactionIsolation(int pLevel) throws Exception {
    }

    public final int getTransactionIsolation() throws Exception {
        return TRANSACTION_SERIALIZABLE;
    }

    public final void createSavepoint(String pSavepointName) throws Exception {
        this.executeQuery("SAVEPOINT " + pSavepointName + ";");
    }

    public final void releaseSavepoint(String pSavepointName) throws Exception {
        this.executeQuery("RELEASE " + pSavepointName + ";");
    }

    public final void rollBackTransaction(String pSavepointName) throws Exception {
        this.getLogger().debug(SrvDatabase.class, "try to rollback to savepoint: " + pSavepointName);
        this.executeQuery(";ROLLBACK TRANSACTION TO SAVEPOINT " + pSavepointName + ";");
    }

    public final void beginTransaction() throws Exception {
        this.executeQuery("BEGIN TRANSACTION;");
        this.setIsAutocommit(false);
    }

    public final void commitTransaction() throws Exception {
        this.executeQuery("COMMIT TRANSACTION;");
        this.setIsAutocommit(true);
    }

    public final void rollBackTransaction() throws Exception {
        this.executeQuery("ROLLBACK TRANSACTION;");
        this.setIsAutocommit(true);
    }

    public final void releaseResources() throws Exception {
        if (this.sqliteDatabase != null) {
            SrvDatabase srvDatabase = this;
            srvDatabase.sqliteDatabase.releaseMemory();
        }
    }

    public final IRecordSet<Cursor> retrieveRecords(String pSelect) throws ExceptionWithCode {
        try {
            this.getLogger().debug(SrvDatabase.class, "try to retrieve records: " + pSelect);
            Cursor rs = this.sqliteDatabase.rawQuery(pSelect, null);
            RecordSetAndroid rsa = new RecordSetAndroid(rs);
            this.getLogger().debug(SrvDatabase.class, "Recordset: " + rsa);
            return rsa;
        }
        catch (Exception ex) {
            String msg = ex.getMessage() + ", query:\n" + pSelect;
            ExceptionWithCode ewc = new ExceptionWithCode(1154, msg);
            ewc.setStackTrace(ex.getStackTrace());
            throw ewc;
        }
    }

    public final void executeQuery(String pQuery) throws Exception {
        try {
            this.getLogger().debug(SrvDatabase.class, "try to execute query: " + pQuery);
            this.sqliteDatabase.execSQL(pQuery);
        }
        catch (Exception ex) {
            String msg = ex.getMessage() + ", query:\n" + pQuery;
            ExceptionWithCode ewc = new ExceptionWithCode(1154, msg);
            ewc.setStackTrace(ex.getStackTrace());
            throw ewc;
        }
    }

    public final int executeUpdate(String pTable, ColumnsValues pColumnsVals, String pWhere) throws Exception {
        try {
            this.getLogger().debug(SrvDatabase.class, "try to update t: " + pTable + " where: " + pWhere + " cv: " + pColumnsVals);
            ContentValues contentValues = this.convertToContentValues(pColumnsVals);
            return this.sqliteDatabase.update(pTable, contentValues, pWhere, null);
        }
        catch (Exception ex) {
            String msg = ex.getMessage() + ", table: " + pTable + ", values: " + pColumnsVals.toString() + ", where: " + pWhere;
            ExceptionWithCode ewc = new ExceptionWithCode(1154, msg);
            ewc.setStackTrace(ex.getStackTrace());
            throw ewc;
        }
    }

    public final long executeInsert(String pTable, ColumnsValues pColumnsVals) throws Exception {
        try {
            this.getLogger().debug(SrvDatabase.class, "try to insert t: " + pTable + " cv: " + pColumnsVals);
            ContentValues contentValues = this.convertToContentValues(pColumnsVals);
            long result = this.sqliteDatabase.insert(pTable, null, contentValues);
            this.getLogger().debug(SrvDatabase.class, "result insert:" + result);
            if (result == -1L) {
                throw new Exception("Result = -1!");
            }
            return result;
        }
        catch (Exception ex) {
            String msg = ex.getMessage() + ", table: " + pTable + ", values: " + pColumnsVals.toString();
            ExceptionWithCode ewc = new ExceptionWithCode(1154, msg);
            ewc.setStackTrace(ex.getStackTrace());
            throw ewc;
        }
    }

    public final int executeDelete(String pTable, String pWhere) throws Exception {
        try {
            this.getLogger().debug(SrvDatabase.class, "try to delete t: " + pTable + " where: " + pWhere);
            return this.sqliteDatabase.delete(pTable, pWhere, null);
        }
        catch (Exception ex) {
            String msg = ex.getMessage() + ", table: " + pTable + ", where: " + pWhere;
            ExceptionWithCode ewc = new ExceptionWithCode(1154, msg);
            ewc.setStackTrace(ex.getStackTrace());
            throw ewc;
        }
    }

    protected final void finalize() {
        if (this.sqliteDatabase != null) {
            this.sqliteDatabase.close();
        }
    }

    public final ContentValues convertToContentValues(ColumnsValues pColumnsVals) {
        ContentValues contentValues = new ContentValues();
        for (Map.Entry entry : pColumnsVals.getIntegersMap().entrySet()) {
            contentValues.put(((String)entry.getKey()).toUpperCase(), (Integer)entry.getValue());
        }
        for (Map.Entry entry : pColumnsVals.getIntegersMap().entrySet()) {
            contentValues.put(((String)entry.getKey()).toUpperCase(), (Integer)entry.getValue());
        }
        for (Map.Entry entry : pColumnsVals.getLongsMap().entrySet()) {
            contentValues.put(((String)entry.getKey()).toUpperCase(), (Long)entry.getValue());
        }
        for (Map.Entry entry : pColumnsVals.getFloatsMap().entrySet()) {
            contentValues.put(((String)entry.getKey()).toUpperCase(), (Float)entry.getValue());
        }
        for (Map.Entry entry : pColumnsVals.getDoublesMap().entrySet()) {
            contentValues.put(((String)entry.getKey()).toUpperCase(), (Double)entry.getValue());
        }
        for (Map.Entry entry : pColumnsVals.getStringsMap().entrySet()) {
            contentValues.put(((String)entry.getKey()).toUpperCase(), (String)entry.getValue());
        }
        return contentValues;
    }

    public final SQLiteDatabase getSqliteDatabase() {
        return this.sqliteDatabase;
    }

    public final void setSqliteDatabase(SQLiteDatabase pSqliteDatabase) {
        this.sqliteDatabase = pSqliteDatabase;
    }
}

