package org.beigesoft.doc.model;

/*
 * Copyright (c) 2017 Beigesoft ™
 *
 * Licensed under the GNU General Public License (GPL), Version 2.0
 * (the "License");
 * you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at
 *
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html
 */

/**
 * <p>Page size constants model.</p>
 *
 * @author Yury Demidenko
 */
public enum EPageSize {

  /**
   * <p>8.5 by 11.0 inches (215.9 by 279.4 mm).</p>
   **/
  LETTER,

  /**
   * <p>148 × 210 mm.</p>
   **/
  A5,

  /**
   * <p>210 × 297 mm.</p>
   **/
  A4,

  /**
   * <p>297 × 420 mm.</p>
   **/
  A3,

  /**
   * <p>420 × 594 mm.</p>
   **/
  A2;
}
