/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.jdbc.service;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.jdbc.model.RecordSetJdbc;
import org.beigesoft.orm.model.ColumnsValues;
import org.beigesoft.orm.model.IRecordSet;
import org.beigesoft.orm.service.ASrvDatabase;
import org.beigesoft.orm.service.HlpInsertUpdate;

public class SrvDatabase
extends ASrvDatabase<ResultSet> {
    private final ThreadLocal<Connection> threadConnection = new ThreadLocal<Connection>(){};
    private DataSource dataSource;
    private HlpInsertUpdate hlpInsertUpdate;
    private final Map<String, Savepoint> savepointsMap = new HashMap<String, Savepoint>();

    public final boolean getIsAutocommit() throws Exception {
        return this.getOrEstablishConnection().getAutoCommit();
    }

    public final void setIsAutocommit(boolean pIsAutocommit) throws Exception {
        this.getOrEstablishConnection().setAutoCommit(pIsAutocommit);
    }

    public final void setTransactionIsolation(int pLevel) throws Exception {
        this.getOrEstablishConnection();
        if (pLevel == ASrvDatabase.TRANSACTION_READ_UNCOMMITTED) {
            this.threadConnection.get().setTransactionIsolation(1);
        } else if (pLevel == ASrvDatabase.TRANSACTION_READ_COMMITTED) {
            this.threadConnection.get().setTransactionIsolation(2);
        } else if (pLevel == ASrvDatabase.TRANSACTION_REPEATABLE_READ) {
            this.threadConnection.get().setTransactionIsolation(4);
        } else if (pLevel == ASrvDatabase.TRANSACTION_SERIALIZABLE) {
            this.threadConnection.get().setTransactionIsolation(8);
        } else if (pLevel == ASrvDatabase.TRANSACTION_NONE) {
            this.threadConnection.get().setTransactionIsolation(0);
        } else {
            throw new ExceptionWithCode(1153, "Unknown isolation level parameter!");
        }
    }

    public final int getTransactionIsolation() throws Exception {
        int level = this.getOrEstablishConnection().getTransactionIsolation();
        if (level == 1) {
            return ASrvDatabase.TRANSACTION_READ_UNCOMMITTED;
        }
        if (level == 2) {
            return ASrvDatabase.TRANSACTION_READ_COMMITTED;
        }
        if (level == 4) {
            return ASrvDatabase.TRANSACTION_REPEATABLE_READ;
        }
        if (level == 8) {
            return ASrvDatabase.TRANSACTION_SERIALIZABLE;
        }
        if (level == 0) {
            return ASrvDatabase.TRANSACTION_NONE;
        }
        throw new ExceptionWithCode(1153, "Unknown JDBC isolation level!");
    }

    public final void createSavepoint(String pSavepointName) throws Exception {
        Savepoint savepoint = this.threadConnection.get().setSavepoint(pSavepointName);
        this.savepointsMap.put(pSavepointName, savepoint);
    }

    public final void releaseSavepoint(String pSavepointName) throws Exception {
        this.threadConnection.get().releaseSavepoint(this.savepointsMap.get(pSavepointName));
        this.savepointsMap.remove(pSavepointName);
    }

    public final void rollBackTransaction(String pSavepointName) throws Exception {
        this.getLogger().debug(SrvDatabase.class, "try to rollback to savepoint: " + pSavepointName);
        this.threadConnection.get().rollback(this.savepointsMap.get(pSavepointName));
        this.savepointsMap.remove(pSavepointName);
    }

    public final void beginTransaction() throws Exception {
        this.getOrEstablishConnection();
    }

    public final void commitTransaction() throws Exception {
        this.threadConnection.get().commit();
    }

    public final void rollBackTransaction() throws Exception {
        this.threadConnection.get().rollback();
    }

    public final void releaseResources() throws Exception {
        if (this.threadConnection.get() != null) {
            this.threadConnection.get().setAutoCommit(true);
            this.threadConnection.get().close();
            this.threadConnection.set(null);
        }
    }

    public final IRecordSet<ResultSet> retrieveRecords(String pSelect) throws Exception {
        try {
            this.getLogger().debug(SrvDatabase.class, "Thread ID=" + Thread.currentThread().getId() + ", try to retrieve records: " + pSelect);
            Statement stmt = this.getOrEstablishConnection().createStatement();
            ResultSet rs = stmt.executeQuery(pSelect);
            return new RecordSetJdbc(rs, stmt);
        }
        catch (SQLException sqle) {
            String msg = sqle.getMessage() + ", RDBMS error code " + sqle.getErrorCode() + ", query:\n" + pSelect;
            throw new ExceptionWithCode(1154, msg);
        }
    }

    public final void executeQuery(String pQuery) throws Exception {
        try (Statement stmt = null;){
            this.getLogger().debug(SrvDatabase.class, "Thread ID=" + Thread.currentThread().getId() + ", try to execute query: " + pQuery);
            stmt = this.getOrEstablishConnection().createStatement();
            stmt.executeUpdate(pQuery);
        }
    }

    public final int executeUpdate(String pTable, ColumnsValues pColumnsVals, String pWhere) throws Exception {
        String query = this.getHlpInsertUpdate().evalSqlUpdate(pTable, pColumnsVals, pWhere);
        try (Statement stmt = null;){
            this.getLogger().debug(SrvDatabase.class, "Thread ID=" + Thread.currentThread().getId() + ", try to execute update: " + query);
            stmt = this.getOrEstablishConnection().createStatement();
            int n = stmt.executeUpdate(query);
            return n;
        }
    }

    public final long executeInsert(String pTable, ColumnsValues pColumnsVals) throws Exception {
        String query = this.getHlpInsertUpdate().evalSqlInsert(pTable, pColumnsVals);
        try (Statement stmt = null;){
            this.getLogger().debug(SrvDatabase.class, "Thread ID=" + Thread.currentThread().getId() + ", try to execute insert: " + query);
            stmt = this.getOrEstablishConnection().createStatement();
            long l = stmt.executeUpdate(query);
            return l;
        }
    }

    public final int executeDelete(String pTable, String pWhere) throws Exception {
        Statement stmt = null;
        String strWhere = "";
        if (pWhere != null) {
            strWhere = " where " + pWhere;
        }
        String query = "delete from " + pTable + strWhere + ";";
        try {
            this.getLogger().debug(SrvDatabase.class, "Thread ID=" + Thread.currentThread().getId() + ", try to execute delete: " + query);
            stmt = this.getOrEstablishConnection().createStatement();
            int n = stmt.executeUpdate(query);
            return n;
        }
        catch (SQLException sqle) {
            String msg = sqle.getMessage() + ", RDBMS error code " + sqle.getErrorCode() + ", query:\n" + query;
            throw new ExceptionWithCode(1154, msg);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public final Connection getOrEstablishConnection() throws Exception {
        Connection con = this.threadConnection.get();
        if (con == null) {
            con = this.dataSource.getConnection();
            this.threadConnection.set(con);
        }
        return con;
    }

    public final Connection getCurrentConnection() throws Exception {
        return this.threadConnection.get();
    }

    public final ThreadLocal<Connection> getThreadConnection() {
        return this.threadConnection;
    }

    public final DataSource getDataSource() {
        return this.dataSource;
    }

    public final void setDataSource(DataSource pDataSource) {
        this.dataSource = pDataSource;
    }

    public final HlpInsertUpdate getHlpInsertUpdate() {
        return this.hlpInsertUpdate;
    }

    public final void setHlpInsertUpdate(HlpInsertUpdate pHlpInsertUpdate) {
        this.hlpInsertUpdate = pHlpInsertUpdate;
    }

    public final Map<String, Savepoint> getSavepointsMap() {
        return this.savepointsMap;
    }
}

