/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.uml.service.swing;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.commons.io.nonstatic.SrvFile;
import org.beigesoft.graphic.pojo.SettingsDraw;
import org.beigesoft.uml.app.model.ProjectUml;
import org.beigesoft.uml.app.swing.GuiMainUmlUninteractive;
import org.beigesoft.uml.assembly.AsmElementUml;
import org.beigesoft.uml.assembly.ClassFull;
import org.beigesoft.uml.assembly.ClassRelationFull;
import org.beigesoft.uml.assembly.IShapeFullUml;
import org.beigesoft.uml.diagram.pojo.DiagramClass;
import org.beigesoft.uml.model.EClassKind;
import org.beigesoft.uml.model.ERelationshipEndType;
import org.beigesoft.uml.model.ERelationshipKind;
import org.beigesoft.uml.model.EVisibilityKind;
import org.beigesoft.uml.pojo.AttributeClass;
import org.beigesoft.uml.pojo.ClassUml;
import org.beigesoft.uml.pojo.MethodClass;
import org.beigesoft.uml.pojo.ParameterMethod;
import org.beigesoft.uml.pojo.RectangleRelationship;
import org.beigesoft.uml.pojo.RelationshipBinary;
import org.beigesoft.uml.service.UtilsUml;
import org.beigesoft.uml.service.persist.xmllight.FileAndWriter;

public class CreatorDoclet {
    private static final String JAVADOC_CONTENT_FOR_INSERT = "<div class=\"description\">";
    public static final String OPTION_PATH_UML_PROJECT = "-umlprojectpath";
    private static String pathUmlProject;
    private static String pathMavenProject;
    private static String pathJavaDoc;
    private static ProjectUml umlProject;
    private static GuiMainUmlUninteractive mainGui;
    protected static final SrvFile srvFile;

    public static boolean start(RootDoc root) throws Exception {
        umlProject = null;
        mainGui = null;
        Standard.start((RootDoc)root);
        CreatorDoclet.setOptions(root);
        CreatorDoclet.openOrCreateUmlProject(root);
        CreatorDoclet.generateUml(root);
        return true;
    }

    public static int optionLength(String option) {
        int result = Standard.optionLength((String)option);
        if (result == 0 && option.equals(OPTION_PATH_UML_PROJECT)) {
            result = 2;
        }
        return result;
    }

    public static LanguageVersion languageVersion() {
        return Standard.languageVersion();
    }

    protected static void generateUml(RootDoc root) throws Exception {
        mainGui.getFactoryGuiMain().getFrameMain().setVisible(true);
        for (ClassDoc classDoc : root.classes()) {
            CreatorDoclet.alterHtmlForClass(classDoc, root);
        }
        mainGui.getFactoryGuiMain().getFrameMain().setVisible(false);
        mainGui.getFactoryGuiMain().getFrameMain().dispose();
    }

    protected static void alterHtmlForClass(ClassDoc classDoc, RootDoc root) throws Exception {
        String line;
        String classFileName = classDoc.containingPackage().name().replace(".", "/") + File.separator + classDoc.name();
        File diagramPictureInUmlProject = new File(pathUmlProject, classFileName + ".png");
        File umlDiagramFile = new File(pathUmlProject, classFileName + "." + "dcl.xml");
        FileAndWriter pi = new FileAndWriter();
        pi.setFile(umlDiagramFile);
        if (umlDiagramFile.exists()) {
            mainGui.getFactoryAppUml().getAsmDiagramClass().openDiagram((Object)pi);
        } else {
            File dir = umlDiagramFile.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
        }
        if (((DiagramClass)mainGui.getFactoryAppUml().getAsmDiagramClass().getDiagramUml()).getIsAbleToChangeByDoclet() || !diagramPictureInUmlProject.exists()) {
            mainGui.getFactoryAppUml().getAsmDiagramClass().newDiagramUml((Object)pi);
            EClassKind classKind = classDoc.isEnum() ? EClassKind.ENUM : (classDoc.isInterface() ? EClassKind.INTERFACE : EClassKind.CLASS);
            AsmElementUml<ClassFull<ClassUml>, Graphics2D, SettingsDraw, FileAndWriter> mainAsmClassUml = mainGui.getFactoryAppUml().getFactoryAsmClassFull().createAsmElementUml();
            ((ClassUml)((ClassFull)mainAsmClassUml.getElementUml()).getShape()).setClassKind(classKind);
            ((ClassUml)((ClassFull)mainAsmClassUml.getElementUml()).getShape()).setIsMain(true);
            CreatorDoclet.fillUmlClass(classDoc, (ClassFull<ClassUml>)((ClassFull)mainAsmClassUml.getElementUml()));
            mainGui.getFactoryAppUml().getAsmDiagramClass().getAsmListAsmClassesFull().addElementUml(mainAsmClassUml);
            if (classDoc.superclass() != null) {
                CreatorDoclet.addRelatedClass((ClassFull<ClassUml>)((ClassFull)mainAsmClassUml.getElementUml()), classDoc.superclass(), ERelationshipKind.GENERALIZATION, false);
            }
            if (classDoc.interfaces() != null) {
                for (ClassDoc docletInterface : classDoc.interfaces()) {
                    CreatorDoclet.addRelatedClass((ClassFull<ClassUml>)((ClassFull)mainAsmClassUml.getElementUml()), docletInterface, ERelationshipKind.INTERFACE_REALIZATION, false);
                }
            }
            CreatorDoclet.fillSubclasses((ClassFull<ClassUml>)((ClassFull)mainAsmClassUml.getElementUml()), classDoc, root);
            mainGui.getFactoryAppUml().getAsmDiagramClass().rearrange();
            mainGui.getPaneDrawing().repaintForced();
            mainGui.getFactoryAppUml().getAsmDiagramClass().saveDiagram();
        }
        File diagramPictureInDoclet = new File(pathJavaDoc, classFileName + ".png");
        srvFile.copyFile(diagramPictureInUmlProject, diagramPictureInDoclet);
        File original = new File(pathJavaDoc, classFileName + ".html");
        File altered = new File(pathJavaDoc, classFileName + ".alt");
        BufferedReader readerOriginal = new BufferedReader(new InputStreamReader(new FileInputStream(original)));
        BufferedWriter writerAltered = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(altered)));
        boolean itWasAltered = false;
        File umlDiagramMapFile = new File(pathUmlProject, classFileName + ".map");
        while ((line = readerOriginal.readLine()) != null) {
            writerAltered.write(line);
            writerAltered.newLine();
            if (!line.contains(JAVADOC_CONTENT_FOR_INSERT)) continue;
            if (umlDiagramMapFile.exists()) {
                CreatorDoclet.insertUmlDiagramMap(writerAltered, umlDiagramMapFile);
            }
            String strPicture = "<p align=\"center\"><img src=\"" + diagramPictureInDoclet.getName() + "\" usemap=\"#umlclassmap\" /></p>";
            writerAltered.write(strPicture);
            writerAltered.newLine();
            itWasAltered = true;
        }
        readerOriginal.close();
        writerAltered.close();
        original.delete();
        altered.renameTo(original);
        if (!itWasAltered) {
            throw new Exception("Can't alter javadoc! Can't find entry <div class=\"description\">");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void insertUmlDiagramMap(BufferedWriter writerAltered, File umlDiagramMapFile) throws Exception {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(umlDiagramMapFile)));
            while ((line = reader.readLine()) != null) {
                writerAltered.write(line);
                writerAltered.newLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected static void fillSubclasses(ClassFull<ClassUml> mainClass, ClassDoc classDoc, RootDoc root) {
        block0: for (ClassDoc docletClass : root.classes()) {
            if (docletClass.superclass() == classDoc) {
                CreatorDoclet.addRelatedClass(mainClass, docletClass, ERelationshipKind.GENERALIZATION, true);
                continue;
            }
            if (docletClass.interfaces() == null) continue;
            for (ClassDoc docletInterface : docletClass.interfaces()) {
                if (docletInterface != classDoc) continue;
                CreatorDoclet.addRelatedClass(mainClass, docletClass, ERelationshipKind.INTERFACE_REALIZATION, true);
                continue block0;
            }
        }
    }

    protected static void addRelatedClass(ClassFull<ClassUml> mainAsmClassUml, ClassDoc relatedClassDoc, ERelationshipKind relationKind, boolean isMainClassEnd) {
        EClassKind classKind = relatedClassDoc.isEnum() ? EClassKind.ENUM : (relatedClassDoc.isInterface() ? EClassKind.INTERFACE : EClassKind.CLASS);
        AsmElementUml<ClassFull<ClassUml>, Graphics2D, SettingsDraw, FileAndWriter> relatedAsmClassUml = mainGui.getFactoryAppUml().getFactoryAsmClassFull().createAsmElementUml();
        ((ClassUml)((ClassFull)relatedAsmClassUml.getElementUml()).getShape()).setClassKind(classKind);
        CreatorDoclet.fillUmlClass(relatedClassDoc, (ClassFull<ClassUml>)((ClassFull)relatedAsmClassUml.getElementUml()));
        mainGui.getFactoryAppUml().getAsmDiagramClass().getAsmListAsmClassesFull().addElementUml(relatedAsmClassUml);
        AsmElementUml<RelationshipBinary<RectangleRelationship<ClassFull<ClassUml>, ClassUml>, ClassFull<ClassUml>, ClassUml>, Graphics2D, SettingsDraw, FileAndWriter> asmRelationUml = mainGui.getFactoryAppUml().getFactoryAsmRelationshipBinaryClass().createAsmElementUml();
        ((RelationshipBinary)asmRelationUml.getElementUml()).setKind(relationKind);
        ((RectangleRelationship)((RelationshipBinary)asmRelationUml.getElementUml()).getShapeRelationshipStart()).setShapeFull(mainAsmClassUml);
        if (isMainClassEnd) {
            ((RectangleRelationship)((RelationshipBinary)asmRelationUml.getElementUml()).getShapeRelationshipStart()).setEndType(ERelationshipEndType.END);
        }
        mainAsmClassUml.getRelationshipsBinary().add(new ClassRelationFull((RectangleRelationship)((RelationshipBinary)asmRelationUml.getElementUml()).getShapeRelationshipStart(), (RelationshipBinary)asmRelationUml.getElementUml()));
        ((RectangleRelationship)((RelationshipBinary)asmRelationUml.getElementUml()).getShapeRelationshipEnd()).setShapeFull((IShapeFullUml)relatedAsmClassUml.getElementUml());
        if (!isMainClassEnd) {
            ((RectangleRelationship)((RelationshipBinary)asmRelationUml.getElementUml()).getShapeRelationshipEnd()).setEndType(ERelationshipEndType.END);
        }
        ((ClassFull)relatedAsmClassUml.getElementUml()).getRelationshipsBinary().add(new ClassRelationFull((RectangleRelationship)((RelationshipBinary)asmRelationUml.getElementUml()).getShapeRelationshipEnd(), (RelationshipBinary)asmRelationUml.getElementUml()));
        mainGui.getFactoryAppUml().getAsmDiagramClass().getAsmListAsmRelationshipsBinaryClass().addElementUml(asmRelationUml);
        UtilsUml.evalJointPoints(mainAsmClassUml);
        UtilsUml.evalJointPoints((ClassFull)((ClassFull)relatedAsmClassUml.getElementUml()));
    }

    protected static void fillUmlClass(ClassDoc classDoc, ClassFull<ClassUml> classUml) {
        AttributeClass attributeClass;
        ((ClassUml)classUml.getShape()).setItsName(classDoc.name());
        ((ClassUml)classUml.getShape()).setNamePackage(classDoc.containingPackage().name());
        if (classDoc.isEnum()) {
            for (FieldDoc fieldDoc : classDoc.enumConstants()) {
                attributeClass = new AttributeClass();
                attributeClass.setItsName(fieldDoc.name());
                attributeClass.setVisibilityKind(EVisibilityKind.PACKAGE);
                ((ClassUml)classUml.getShape()).getAttributes().add(attributeClass);
            }
        }
        for (FieldDoc fieldDoc : classDoc.fields()) {
            attributeClass = new AttributeClass();
            attributeClass.setItsName(fieldDoc.name());
            attributeClass.setItsType(fieldDoc.type().typeName());
            attributeClass.setVisibilityKind(UtilsUml.evalVisibilityKindByModifier((int)fieldDoc.modifierSpecifier()));
            ((ClassUml)classUml.getShape()).getAttributes().add(attributeClass);
        }
        for (FieldDoc fieldDoc : classDoc.methods()) {
            MethodClass oper = new MethodClass();
            oper.setItsName(fieldDoc.name());
            oper.setItsType(CreatorDoclet.toGoodTypeName(fieldDoc.returnType().toString()));
            oper.setVisibilityKind(UtilsUml.evalVisibilityKindByModifier((int)fieldDoc.modifierSpecifier()));
            if (fieldDoc.parameters() != null) {
                for (Parameter paramDoc : fieldDoc.parameters()) {
                    ParameterMethod param = new ParameterMethod();
                    param.setItsName(paramDoc.name());
                    param.setItsType(CreatorDoclet.toGoodTypeName(paramDoc.type().toString()));
                    oper.getParameters().add(param);
                }
            }
            ((ClassUml)classUml.getShape()).getMethods().add(oper);
        }
    }

    protected static String toGoodTypeName(String typeName) {
        int lastDotPosition = typeName.lastIndexOf(".");
        if (lastDotPosition == -1) {
            return typeName;
        }
        return typeName.substring(lastDotPosition + 1);
    }

    protected static void openOrCreateUmlProject(RootDoc root) throws Exception {
        File umlProjectDir = new File(pathUmlProject);
        if (!umlProjectDir.exists()) {
            umlProjectDir.mkdirs();
        }
        if (!umlProjectDir.exists()) {
            throw new Exception("Can not create UML project dir " + umlProjectDir.getAbsolutePath());
        }
        mainGui = new GuiMainUmlUninteractive();
        umlProject = new ProjectUml(mainGui.getSettingsGraphicUml(), umlProjectDir.getAbsolutePath().replace(File.separator + umlProjectDir.getName(), ""), umlProjectDir.getName());
        mainGui.getAsmProjectUml().setProjectUml(umlProject);
        if (umlProject.getIsNew()) {
            mainGui.getAsmProjectUml().persist();
        } else {
            mainGui.getAsmProjectUml().restore();
        }
    }

    protected static void setOptions(RootDoc root) throws Exception {
        File file;
        pathUmlProject = null;
        pathMavenProject = null;
        pathJavaDoc = null;
        for (String[] option : root.options()) {
            if (option[0].equals(OPTION_PATH_UML_PROJECT) && option.length == 2) {
                pathUmlProject = option[1].trim();
                root.printNotice("Uml project path is " + pathUmlProject);
            } else if (option[0].equals("-d") && option.length == 2) {
                pathJavaDoc = option[1].trim();
                root.printNotice("Javadoc path is " + pathJavaDoc);
            } else if (option[0].equals("-sourcepath") && option.length == 2) {
                String pathJavaSource = option[1].trim();
                int firstSeparator = pathJavaSource.indexOf(File.pathSeparatorChar);
                if (firstSeparator != -1) {
                    pathJavaSource = pathJavaSource.substring(0, firstSeparator).trim();
                }
                root.printNotice("Firts java source path is " + pathJavaSource);
                int mvnSrcIdx = pathJavaSource.indexOf("/src/test/");
                if (mvnSrcIdx == -1) {
                    mvnSrcIdx = pathJavaSource.indexOf("/src/main/");
                }
                if (mvnSrcIdx != -1) {
                    pathMavenProject = pathJavaSource.substring(0, mvnSrcIdx) + File.separator + "src";
                    root.printNotice("Maven project path is " + pathMavenProject);
                }
            }
            if (pathUmlProject != null && pathMavenProject != null && pathJavaDoc != null) break;
        }
        if (pathJavaDoc == null) {
            root.printError("Can not find javadoc path!");
        }
        if (pathUmlProject == null) {
            if (pathMavenProject != null) {
                pathUmlProject = pathMavenProject + File.separator + "uml";
                root.printNotice("Uml project path is " + pathUmlProject);
            } else {
                root.printError("Doclet UML project path option: [-umlprojectpath] must be settled!");
            }
        }
        if (pathUmlProject != null && !(file = new File(pathUmlProject)).isAbsolute()) {
            throw new Exception("Doclet UML project path option: [-umlprojectpath] must be settled as absolute path or nothing (assume path is [mvnproject]/src/uml)!");
        }
    }

    public static String getPathUmlProject() {
        return pathUmlProject;
    }

    public static String getPathMavenProject() {
        return pathMavenProject;
    }

    public static String getPathJavaDoc() {
        return pathJavaDoc;
    }

    public static ProjectUml getUmlProject() {
        return umlProject;
    }

    public static GuiMainUmlUninteractive getMainGui() {
        return mainGui;
    }

    static {
        srvFile = new SrvFile();
    }
}

