/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.uml.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.beigesoft.graphic.SettingsGraphic;
import org.beigesoft.graphic.swing.PaneDrawingSwing;
import org.beigesoft.ui.IEventMotion;
import org.beigesoft.ui.awt.EventClick;
import org.beigesoft.uml.controller.IControllerDiagramUml;

public class PaneDiagramSwing
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -3312812559594358206L;
    protected final SettingsGraphic graphicSettings;
    protected final PaneDrawingSwing drawingPane;
    protected final JScrollPane scrollPane;
    protected JPanel actionPropertiesPane;
    protected IControllerDiagramUml<?, ?> activeControllerDiagramUml;
    protected boolean isZoomPalletteAdded;
    protected Component currentPaletteDiagram;

    public PaneDiagramSwing(PaneDrawingSwing drawingPane, SettingsGraphic graphicSettings) {
        super(new BorderLayout());
        this.drawingPane = drawingPane;
        this.graphicSettings = graphicSettings;
        drawingPane.addMouseListener((MouseListener)this);
        drawingPane.addMouseMotionListener((MouseMotionListener)this);
        this.scrollPane = new JScrollPane((Component)drawingPane);
        this.scrollPane.setPreferredSize(new Dimension(graphicSettings.getScreenWidthPixels() / 2, graphicSettings.getScreenHeightPixels() / 2));
        this.add((Component)this.scrollPane, "Center");
        this.actionPropertiesPane = new JPanel();
        this.actionPropertiesPane.setLayout(new BorderLayout());
        this.add((Component)this.actionPropertiesPane, "After");
    }

    public void setDiagramControllerAndPalettes(IControllerDiagramUml<?, ?> controllerDiagramUml, Component palletteDiagram, Component palletteZoom) {
        this.activeControllerDiagramUml = controllerDiagramUml;
        if (this.currentPaletteDiagram != null) {
            this.actionPropertiesPane.remove(this.currentPaletteDiagram);
        }
        this.actionPropertiesPane.add(palletteDiagram, "Center");
        this.currentPaletteDiagram = palletteDiagram;
        if (!this.isZoomPalletteAdded) {
            this.actionPropertiesPane.add(palletteZoom, "South");
            this.isZoomPalletteAdded = true;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        EventClick te = new EventClick(e);
        this.activeControllerDiagramUml.pressedAt((IEventMotion)te);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        EventClick te = new EventClick(e);
        this.activeControllerDiagramUml.releasedAt((IEventMotion)te);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        EventClick te = new EventClick(e);
        this.activeControllerDiagramUml.dragged((IEventMotion)te);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

