/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.uml.app.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.beigesoft.delegate.IDelegateSimple;
import org.beigesoft.graphic.IPaneDrawing;
import org.beigesoft.graphic.SettingsGraphic;
import org.beigesoft.graphic.pojo.SettingsDraw;
import org.beigesoft.graphic.service.ISrvDraw;
import org.beigesoft.graphic.service.ISrvZoom;
import org.beigesoft.handler.IHandlerConfirm;
import org.beigesoft.handler.IHandlerModelChanged;
import org.beigesoft.handler.IObserverRepaint;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.SrvI18n;
import org.beigesoft.service.swing.SrvDialog;
import org.beigesoft.ui.container.ContainerGuiSrvs;
import org.beigesoft.ui.container.IContainerSrvsGui;
import org.beigesoft.ui.pojo.NodeJavaClass;
import org.beigesoft.ui.service.ISrvDialog;
import org.beigesoft.ui.service.UtilsGui;
import org.beigesoft.ui.widget.swing.ChooserTree;
import org.beigesoft.uml.app.assembly.AsmProjectUml;
import org.beigesoft.uml.app.model.ProjectUml;
import org.beigesoft.uml.app.model.SettingsGraphicUml;
import org.beigesoft.uml.app.swing.FactoryGuiMainUml;
import org.beigesoft.uml.controller.IControllerDiagramClass;
import org.beigesoft.uml.controller.IControllerDiagramUml;
import org.beigesoft.uml.factory.awt.FactoryDiagramClassInteractiveLight;
import org.beigesoft.uml.factory.awt.FactoryDiagramObject;
import org.beigesoft.uml.factory.awt.FactoryDiagramPackage;
import org.beigesoft.uml.factory.awt.FactoryDiagramSequence;
import org.beigesoft.uml.factory.awt.FactoryDiagramUseCaseLight;
import org.beigesoft.uml.service.edit.SrvEditProject;
import org.beigesoft.uml.service.persist.xmllight.FileAndWriter;
import org.beigesoft.uml.ui.AGuiMainUmlInteractive;
import org.beigesoft.uml.ui.EditorProject;
import org.beigesoft.uml.ui.IGuiMainUml;
import org.beigesoft.uml.ui.IPaneProjectUml;
import org.beigesoft.uml.ui.swing.Menu;
import org.beigesoft.uml.ui.swing.PaletteZoom;
import org.beigesoft.uml.ui.swing.PaneDiagramSwing;
import org.beigesoft.uml.ui.swing.PaneProjectLight;

public class GuiMainUmlInteractive
extends AGuiMainUmlInteractive<Graphics2D, SettingsDraw, Image, FileAndWriter, Frame> {
    protected PaneProjectLight paneProjectUml;
    protected ChooserTree<UUID, NodeJavaClass> javaClassChooser;
    protected ISrvI18n srvI18n;
    protected ISrvDialog<Frame> srvDialog;
    protected PaneDiagramSwing paneDiagramUml;
    protected JPanel contentEditorPanel;
    private FactoryDiagramClassInteractiveLight factoryDiagramClass;
    private FactoryDiagramUseCaseLight factoryDiagramUseCaseFull;
    protected final PaletteZoom paletteZoom;
    protected final FactoryGuiMainUml factoryGuiMain;
    private FactoryDiagramPackage factoryDiagramPackage;
    private FactoryDiagramObject factoryDiagramObject;
    private FactoryDiagramSequence factoryDiagramSequence;
    protected WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            if (GuiMainUmlInteractive.this.getActiveControllerDiagramUml() != null && GuiMainUmlInteractive.this.getActiveControllerDiagramUml().getAsmDiagramUml() != null && GuiMainUmlInteractive.this.getActiveControllerDiagramUml().getAsmDiagramUml().getIsChanged()) {
                GuiMainUmlInteractive.this.getGuiSrvs().getSrvDialog().confirm((Object)GuiMainUmlInteractive.this.getFrameMain(), GuiMainUmlInteractive.this.getGuiSrvs().getSrvI18n().getMsg("changes_will_be_lost_msg"), GuiMainUmlInteractive.this.getGuiSrvs().getSrvI18n().getMsg("are_you_shure"), new IHandlerConfirm(){

                    public void handleConfirm(boolean isConfirmed) {
                        if (isConfirmed) {
                            GuiMainUmlInteractive.this.getFrameMain().setVisible(false);
                            GuiMainUmlInteractive.this.getFrameMain().dispose();
                            System.exit(0);
                        }
                    }
                });
            } else {
                GuiMainUmlInteractive.this.getFrameMain().setVisible(false);
                GuiMainUmlInteractive.this.getFrameMain().dispose();
                System.exit(0);
            }
        }
    };

    public GuiMainUmlInteractive() {
        this.factoryGuiMain = new FactoryGuiMainUml();
        this.paletteZoom = new PaletteZoom((IGuiMainUml<?, ?, ?, ?, Frame>)this);
        this.factoryGuiMain.getPaneDrawing().addObserverRepaint((IObserverRepaint)this.paletteZoom);
        this.srvI18n = new SrvI18n();
        this.srvDialog = new SrvDialog();
        this.setGuiSrvs((IContainerSrvsGui)new ContainerGuiSrvs(this.srvDialog, this.srvI18n, (SettingsGraphic)this.getSettingsGraphicUml()));
        Menu mainMenu = new Menu((IGuiMainUml<?, ?, ?, ?, Frame>)this);
        this.setMainMenu(mainMenu);
        this.getFrameMain().setDefaultCloseOperation(0);
        this.getFrameMain().addWindowListener(this.windowListener);
        this.contentEditorPanel = new JPanel(new GridLayout(1, 1));
        this.lazyGetPaneProjectUml();
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.paneProjectUml), this.contentEditorPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(150);
        this.getFrameMain().setContentPane(splitPane);
        this.getFrameMain().setJMenuBar(mainMenu);
        this.getFrameMain().setPreferredSize(new Dimension(this.getSettingsGraphicUml().getScreenWidthPixels() / 4 * 3, this.getSettingsGraphicUml().getScreenHeightPixels() / 4 * 3));
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/img/favicon.png");
        ImageIcon icon = new ImageIcon(iconURL);
        this.getFrameMain().setIconImage(icon.getImage());
        this.getFrameMain().setTitle(this.getGuiSrvs().getSrvI18n().getMsg("title"));
        this.getFrameMain().pack();
        this.getFrameMain().setLocationRelativeTo(null);
        this.paneProjectUml.refreshGui();
        this.refreshGui();
    }

    public static void main(String[] args) {
        final String[] argsCopy = args == null ? null : Arrays.copyOf(args, args.length);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String projectDescriptorPath;
                File projectDescriptorFile;
                GuiMainUmlInteractive mainGui = new GuiMainUmlInteractive();
                mainGui.getFrameMain().setVisible(true);
                if (argsCopy != null && argsCopy.length > 0 && (projectDescriptorFile = new File(projectDescriptorPath = argsCopy[0])).exists() && projectDescriptorFile.getName().equals("bs-uml.xml")) {
                    mainGui.getPaneProjectUml().openProjectUml(projectDescriptorFile);
                }
            }
        });
    }

    public synchronized ChooserTree<UUID, NodeJavaClass> lazyGetAndPrepareJavaClassChooser() {
        File javaSource;
        if (this.javaClassChooser == null) {
            this.javaClassChooser = new ChooserTree((Frame)this.getFrameMain(), this.getGuiSrvs(), this.srvI18n.getMsg("title_java_class_chooser"));
        }
        if (!(javaSource = new File(this.getAsmProjectUml().getProjectUml().getJavaSourceFilePath())).getName().equals(this.javaClassChooser.getRootNodeDescription())) {
            List classTree = UtilsGui.getTreeClassesOfZip((File)javaSource);
            this.javaClassChooser.setRootNodeDescription(javaSource.getName());
            this.javaClassChooser.refillDataSource((Collection)classTree);
        }
        return this.javaClassChooser;
    }

    public IControllerDiagramClass<?, FileAndWriter> getControllerDiagramClass() {
        return this.lazyGetFactoryDiagramClass().getControllerDiagramClass();
    }

    public Frame getDialogInstrument() {
        return this.getFrameMain();
    }

    public void setTitle(String title) {
        this.getFrameMain().setTitle(title);
    }

    public boolean evalIsCurrentDiagramHasNeverSaved() {
        return ((FileAndWriter)this.getActiveControllerDiagramUml().getAsmDiagramUml().getPersistInstrument()).getFile() == null;
    }

    public void refreshProjectTreeAndShowFile(File diagramFile) {
        this.lazyGetPaneProjectUml().refreshGuiAndShowFile(diagramFile);
    }

    public String getSelectedFolderPathProjectTree() {
        return this.lazyGetPaneProjectUml().getSelectedFolderPath();
    }

    public void addFileIntoSelectedFolderProjectTree(File file) {
        this.lazyGetPaneProjectUml().addFileIntoSelectedFolder(file);
    }

    public void newProjectUml() {
        this.closeCarefullyChangedDiagramIfExistAndMake(new IDelegateSimple(){

            public void make() {
                GuiMainUmlInteractive.this.lazyGetPaneProjectUml().newProjectUml();
            }
        });
    }

    public void openProjectUml() {
        this.closeCarefullyChangedDiagramIfExistAndMake(new IDelegateSimple(){

            public void make() {
                GuiMainUmlInteractive.this.lazyGetPaneProjectUml().openProjectUml();
            }
        });
    }

    public void addFolderIntoSelectedFolderProjectTree() {
        this.lazyGetPaneProjectUml().addFolderIntoSelectedFolder();
    }

    public AsmProjectUml getAsmProjectUml() {
        return this.factoryGuiMain.getAsmProjectUml();
    }

    public IPaneDrawing<Graphics2D> getPaneDrawing() {
        return this.factoryGuiMain.getPaneDrawing();
    }

    public SettingsGraphicUml getSettingsGraphicUml() {
        return this.factoryGuiMain.getSettingsGraphicUml();
    }

    public ISrvDraw<Graphics2D, SettingsDraw, Image> getSrvDraw() {
        return this.factoryGuiMain.getSrvDraw();
    }

    public ISrvZoom getSrvZoom() {
        return this.factoryGuiMain.getSrvZoom();
    }

    public IControllerDiagramUml<?, FileAndWriter> getControllerDiagramUseCase() {
        return this.lazyGetFactoryDiagramUseCaseFull().getControllerDiagramUseCase();
    }

    protected void clearContentEditorPane() {
        if (this.contentEditorPanel.getComponentCount() > 0) {
            this.contentEditorPanel.removeAll();
        }
        this.getFrameMain().setTitle(this.getGuiSrvs().getSrvI18n().getMsg("title"));
        this.contentEditorPanel.validate();
        this.contentEditorPanel.repaint();
    }

    protected void prepareForClassDiagram() {
        if (this.getActiveControllerDiagramUml() != this.lazyGetFactoryDiagramClass().getControllerDiagramClass()) {
            this.lazyGetPaneDiagramUml().setDiagramControllerAndPalettes((IControllerDiagramUml<?, ?>)this.lazyGetFactoryDiagramClass().getControllerDiagramClass(), this.lazyGetFactoryDiagramClass().getPaletteDiagramClass(), this.paletteZoom);
            this.setActiveControllerDiagramUml((IControllerDiagramUml)this.lazyGetFactoryDiagramClass().getControllerDiagramClass());
            this.addToContentEditorPane(this.lazyGetPaneDiagramUml());
        }
    }

    protected void prepareForUseCaseDiagram() {
        if (this.getActiveControllerDiagramUml() != this.lazyGetFactoryDiagramUseCaseFull().getControllerDiagramUseCase()) {
            this.lazyGetPaneDiagramUml().setDiagramControllerAndPalettes((IControllerDiagramUml<?, ?>)this.lazyGetFactoryDiagramUseCaseFull().getControllerDiagramUseCase(), this.lazyGetFactoryDiagramUseCaseFull().getPaletteDiagram(), this.paletteZoom);
            this.setActiveControllerDiagramUml((IControllerDiagramUml)this.lazyGetFactoryDiagramUseCaseFull().getControllerDiagramUseCase());
            this.addToContentEditorPane(this.lazyGetPaneDiagramUml());
        }
    }

    public IControllerDiagramUml<?, FileAndWriter> getControllerDiagramPackage() {
        return this.lazyGetFactoryDiagramPackage().getControllerDiagramPackage();
    }

    public IControllerDiagramUml<?, FileAndWriter> getControllerDiagramObject() {
        return this.lazyGetFactoryDiagramObject().getControllerDiagramObject();
    }

    protected void prepareForObjectDiagram() {
        if (this.getActiveControllerDiagramUml() != this.lazyGetFactoryDiagramObject().getControllerDiagramObject()) {
            this.lazyGetPaneDiagramUml().setDiagramControllerAndPalettes((IControllerDiagramUml<?, ?>)this.lazyGetFactoryDiagramObject().getControllerDiagramObject(), this.lazyGetFactoryDiagramObject().getPaletteDiagramObject(), this.paletteZoom);
            this.setActiveControllerDiagramUml((IControllerDiagramUml)this.lazyGetFactoryDiagramObject().getControllerDiagramObject());
            this.addToContentEditorPane(this.lazyGetPaneDiagramUml());
        }
    }

    public IControllerDiagramUml<?, FileAndWriter> getControllerDiagramSequence() {
        return this.lazyGetFactoryDiagramSequence().getControllerDiagramSequence();
    }

    protected void prepareForSequenceDiagram() {
        if (this.getActiveControllerDiagramUml() != this.lazyGetFactoryDiagramSequence().getControllerDiagramSequence()) {
            this.lazyGetPaneDiagramUml().setDiagramControllerAndPalettes((IControllerDiagramUml<?, ?>)this.lazyGetFactoryDiagramSequence().getControllerDiagramSequence(), this.lazyGetFactoryDiagramSequence().getPaletteDiagramSequence(), this.paletteZoom);
            this.setActiveControllerDiagramUml((IControllerDiagramUml)this.lazyGetFactoryDiagramSequence().getControllerDiagramSequence());
            this.addToContentEditorPane(this.lazyGetPaneDiagramUml());
        }
    }

    protected void prepareForPackageDiagram() {
        if (this.getActiveControllerDiagramUml() != this.lazyGetFactoryDiagramPackage().getControllerDiagramPackage()) {
            this.lazyGetPaneDiagramUml().setDiagramControllerAndPalettes((IControllerDiagramUml<?, ?>)this.lazyGetFactoryDiagramPackage().getControllerDiagramPackage(), this.lazyGetFactoryDiagramPackage().getPaletteDiagramPackage(), this.paletteZoom);
            this.setActiveControllerDiagramUml((IControllerDiagramUml)this.lazyGetFactoryDiagramPackage().getControllerDiagramPackage());
            this.addToContentEditorPane(this.lazyGetPaneDiagramUml());
        }
    }

    public PaneDiagramSwing lazyGetPaneDiagramUml() {
        if (this.paneDiagramUml == null) {
            this.paneDiagramUml = new PaneDiagramSwing(this.factoryGuiMain.getPaneDrawing(), (SettingsGraphic)this.getSettingsGraphicUml());
        }
        return this.paneDiagramUml;
    }

    public JFrame getFrameMain() {
        return this.factoryGuiMain.getFrameMain();
    }

    public synchronized FactoryDiagramClassInteractiveLight lazyGetFactoryDiagramClass() {
        if (this.factoryDiagramClass == null) {
            this.factoryDiagramClass = new FactoryDiagramClassInteractiveLight(this.getFrameMain(), (IGuiMainUml<Graphics2D, SettingsDraw, Image, FileAndWriter, Frame>)this);
        }
        return this.factoryDiagramClass;
    }

    public synchronized FactoryDiagramPackage lazyGetFactoryDiagramPackage() {
        if (this.factoryDiagramPackage == null) {
            this.factoryDiagramPackage = new FactoryDiagramPackage(this.getFrameMain(), (IGuiMainUml<Graphics2D, SettingsDraw, Image, FileAndWriter, Frame>)this);
        }
        return this.factoryDiagramPackage;
    }

    public synchronized FactoryDiagramObject lazyGetFactoryDiagramObject() {
        if (this.factoryDiagramObject == null) {
            this.factoryDiagramObject = new FactoryDiagramObject(this.getFrameMain(), (IGuiMainUml<Graphics2D, SettingsDraw, Image, FileAndWriter, Frame>)this);
        }
        return this.factoryDiagramObject;
    }

    public synchronized FactoryDiagramSequence lazyGetFactoryDiagramSequence() {
        if (this.factoryDiagramSequence == null) {
            this.factoryDiagramSequence = new FactoryDiagramSequence(this.getFrameMain(), (IGuiMainUml<Graphics2D, SettingsDraw, Image, FileAndWriter, Frame>)this);
        }
        return this.factoryDiagramSequence;
    }

    public synchronized FactoryDiagramUseCaseLight lazyGetFactoryDiagramUseCaseFull() {
        if (this.factoryDiagramUseCaseFull == null) {
            this.factoryDiagramUseCaseFull = new FactoryDiagramUseCaseLight((IGuiMainUml<Graphics2D, SettingsDraw, Image, FileAndWriter, Frame>)this, this.getFrameMain());
        }
        return this.factoryDiagramUseCaseFull;
    }

    public synchronized IPaneProjectUml lazyGetPaneProjectUml() {
        if (this.paneProjectUml == null) {
            SrvEditProject srvEditProject = new SrvEditProject(this.srvI18n, this.srvDialog, this.getSettingsGraphicUml());
            this.paneProjectUml = new PaneProjectLight(this.getFrameMain(), (IGuiMainUml<?, ?, ?, FileAndWriter, Frame>)this, (SrvEditProject<ProjectUml, Frame>)srvEditProject);
            ((EditorProject)this.paneProjectUml.getEditorProject().getEditor()).addObserverSettingsUmlChanged((IHandlerModelChanged)this);
        }
        return this.paneProjectUml;
    }

    protected void addToContentEditorPane(Component component) {
        if (this.contentEditorPanel.getComponentCount() > 0) {
            this.contentEditorPanel.removeAll();
        }
        this.contentEditorPanel.add(component);
        this.contentEditorPanel.validate();
        this.contentEditorPanel.repaint();
    }

    public PaneProjectLight getPaneProjectUml() {
        return this.paneProjectUml;
    }

    public FactoryGuiMainUml getFactoryGuiMain() {
        return this.factoryGuiMain;
    }
}

