/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.uml.ui.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.beigesoft.model.IFilterFileWithChooseMode;
import org.beigesoft.ui.container.IContainerSrvsGui;
import org.beigesoft.ui.pojo.IOpenable;
import org.beigesoft.ui.widget.swing.FileFilterNameIs;
import org.beigesoft.ui.widget.swing.FilterFileExtentionIsAndChooseModeAdapter;
import org.beigesoft.ui.widget.swing.FilterFileIsDirectoryAndChooseModeAdapter;
import org.beigesoft.uml.app.assembly.AsmProjectUml;
import org.beigesoft.uml.app.model.NodeDescriptorProject;
import org.beigesoft.uml.app.model.NodeDiagramClassLight;
import org.beigesoft.uml.app.model.NodeDiagramObject;
import org.beigesoft.uml.app.model.NodeDiagramPackage;
import org.beigesoft.uml.app.model.NodeDiagramSequence;
import org.beigesoft.uml.app.model.NodeDiagramUseCaseLight;
import org.beigesoft.uml.app.model.NodeFolderProject;
import org.beigesoft.uml.app.model.NodeRootProject;
import org.beigesoft.uml.app.model.ProjectUml;
import org.beigesoft.uml.app.model.SettingsGraphicUml;
import org.beigesoft.uml.service.edit.SrvEditProject;
import org.beigesoft.uml.service.persist.xmllight.FileAndWriter;
import org.beigesoft.uml.ui.EditorProject;
import org.beigesoft.uml.ui.IGuiMainUml;
import org.beigesoft.uml.ui.IPaneProjectUml;
import org.beigesoft.uml.ui.swing.AsmEditorProject;

public class PaneProjectLight
extends JTree
implements IPaneProjectUml {
    private static final long serialVersionUID = 2605703214134749974L;
    protected final AsmEditorProject<ProjectUml, EditorProject<ProjectUml, Frame, ActionEvent>> asmEditorProject;
    protected final DefaultMutableTreeNode rootNode;
    protected final DefaultTreeModel treeModel;
    protected final JFileChooser fileChooser;
    protected final IContainerSrvsGui<Frame> guiSrvs;
    protected final IGuiMainUml<?, ?, ?, FileAndWriter, Frame> guiMain;
    protected final Frame frameMain;
    protected final DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer(){
        private static final long serialVersionUID = -7838974243078343035L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Icon iconFolder;
            DefaultMutableTreeNode node;
            IOpenable nodeVal;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value != null && (nodeVal = (IOpenable)(node = (DefaultMutableTreeNode)value).getUserObject()).getClass() == NodeFolderProject.class && (iconFolder = UIManager.getIcon("FileView.directoryIcon")) != null) {
                this.setIcon(iconFolder);
            }
            return this;
        }
    };
    protected final MouseListener mouselistener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2 && !e.isConsumed()) {
                e.consume();
                TreePath selPath = PaneProjectLight.this.getPathForLocation(e.getX(), e.getY());
                if (selPath != null) {
                    IOpenable selectedNode = (IOpenable)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
                    selectedNode.open();
                }
                return;
            }
        }
    };

    public PaneProjectLight(Frame frame, IGuiMainUml<?, ?, ?, FileAndWriter, Frame> guiMain, SrvEditProject<ProjectUml, Frame> editProjectUmlSrv) {
        this.guiSrvs = editProjectUmlSrv;
        this.frameMain = frame;
        this.guiMain = guiMain;
        String currDir = null;
        try {
            currDir = PaneProjectLight.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fileChooser = currDir != null ? new JFileChooser(currDir) : new JFileChooser();
        FilterFileIsDirectoryAndChooseModeAdapter filterAnyDirectory = new FilterFileIsDirectoryAndChooseModeAdapter();
        FilterFileExtentionIsAndChooseModeAdapter filterJarOrWar = new FilterFileExtentionIsAndChooseModeAdapter(new String[]{"jar", "war"});
        EditorProject editorProject = new EditorProject((Object)frame, editProjectUmlSrv, editProjectUmlSrv.getSrvI18n().getMsg("project"), guiMain, (IFilterFileWithChooseMode)filterAnyDirectory, (IFilterFileWithChooseMode)filterJarOrWar);
        this.asmEditorProject = new AsmEditorProject(frame, editorProject);
        this.asmEditorProject.doPostConstruct();
        this.rootNode = new DefaultMutableTreeNode(new NodeRootProject((IPaneProjectUml)this));
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.setModel(this.treeModel);
        this.addMouseListener(this.mouselistener);
        this.setCellRenderer(this.cellRenderer);
    }

    public void newProjectUml() {
        ProjectUml projectUml = new ProjectUml((SettingsGraphicUml)this.guiSrvs.getSettingsGraphic());
        this.guiMain.getAsmProjectUml().setProjectUml(projectUml);
        this.asmEditorProject.startEdit(this.guiMain.getAsmProjectUml().getProjectUml());
        HashSet result = new HashSet();
        ((EditorProject)this.asmEditorProject.getEditor()).getSrvEdit().validate((Object)this.guiMain.getAsmProjectUml().getProjectUml(), result);
        if (result.size() > 0) {
            this.guiMain.getAsmProjectUml().setProjectUml(null);
        }
        this.refreshGui();
        this.guiMain.refreshGui();
    }

    public void openProjectUml() {
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setFileFilter((FileFilter)new FileFilterNameIs("bs-uml.xml"));
        int retVal = this.fileChooser.showOpenDialog(this.frameMain);
        if (retVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.openProjectUml(file);
        }
    }

    public void openProjectUml(File file) {
        String projectPath = file.getAbsolutePath().replace(File.separatorChar + "bs-uml.xml", "");
        if (this.guiMain.getAsmProjectUml().getProjectUml() != null && this.guiMain.getAsmProjectUml().getProjectUml().getProjectPath().equals(projectPath)) {
            return;
        }
        String projectName = projectPath.substring(projectPath.lastIndexOf(File.separatorChar) + 1);
        int idxPn = projectPath.lastIndexOf(projectName);
        String pathPre = projectPath.substring(0, idxPn - 1);
        ProjectUml anotherProject = new ProjectUml(this.guiMain.getSettingsGraphicUml(), pathPre, projectName);
        this.guiMain.getAsmProjectUml().setProjectUml(anotherProject);
        try {
            this.guiMain.getAsmProjectUml().restore();
        }
        catch (Exception e) {
            this.guiMain.getAsmProjectUml().setProjectUml(null);
            this.guiSrvs.getSrvDialog().errorMessage(this.guiMain.getDialogInstrument(), e.getMessage(), "Open project error!");
            e.printStackTrace();
        }
        this.setProjectUmlAndRefreshGui(anotherProject);
    }

    public void addFileIntoSelectedFolder(File file) {
        DefaultMutableTreeNode parentNode = this.getSelectedTreeNode();
        DefaultMutableTreeNode childNode = null;
        if (file.getName().endsWith("dcl.xml")) {
            childNode = new DefaultMutableTreeNode(new NodeDiagramClassLight(file.getAbsolutePath(), file.getName(), this.guiMain));
        } else if (file.getName().endsWith("duc.xml")) {
            childNode = new DefaultMutableTreeNode(new NodeDiagramUseCaseLight(file.getAbsolutePath(), file.getName(), this.guiMain));
        } else if (file.getName().endsWith("dpk.xml")) {
            childNode = new DefaultMutableTreeNode(new NodeDiagramPackage(file.getAbsolutePath(), file.getName(), this.guiMain));
        } else if (file.getName().endsWith("dob.xml")) {
            childNode = new DefaultMutableTreeNode(new NodeDiagramObject(file.getAbsolutePath(), file.getName(), this.guiMain));
        } else if (file.getName().endsWith("dsq.xml")) {
            childNode = new DefaultMutableTreeNode(new NodeDiagramSequence(file.getAbsolutePath(), file.getName(), this.guiMain));
        }
        this.treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
        this.scrollPathToVisible(new TreePath(childNode.getPath()));
    }

    public void addFolderIntoSelectedFolder() {
        DefaultMutableTreeNode parentNode = this.getSelectedTreeNode();
        String path = this.getSelectedFolderPath();
        if (path == null) {
            this.guiSrvs.getSrvDialog().errorMessage((Object)this.frameMain, this.guiSrvs.getSrvI18n().getMsg("please_choose_folder_first_msg"), this.guiSrvs.getSrvI18n().getMsg("error"));
            return;
        }
        String folderName = JOptionPane.showInputDialog(this.frameMain, (Object)this.guiSrvs.getSrvI18n().getMsg("enter_folder_name"));
        if (folderName == null || folderName.trim().length() == 0) {
            return;
        }
        File folder = new File(path = path + folderName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new NodeFolderProject(folder.getAbsolutePath(), folder.getName()));
        this.treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
        this.scrollPathToVisible(new TreePath(childNode.getPath()));
    }

    public String getSelectedFolderPath() {
        DefaultMutableTreeNode parentNode = this.getSelectedTreeNode();
        IOpenable selNode = null;
        if (parentNode != null) {
            selNode = (IOpenable)parentNode.getUserObject();
        }
        if (parentNode != null && selNode.getClass() == NodeFolderProject.class) {
            return ((NodeFolderProject)selNode).getPath() + File.separator;
        }
        if (parentNode != null && selNode.getClass() == NodeRootProject.class) {
            return this.guiMain.getAsmProjectUml().getProjectUml().getProjectPath() + File.separator;
        }
        return null;
    }

    public void openProjectUmlEditor() {
        if (this.asmEditorProject.isActive()) {
            return;
        }
        this.asmEditorProject.startEdit(this.guiMain.getAsmProjectUml().getProjectUml());
    }

    public void refreshGuiAndShowFile(File file) {
        if (this.rootNode.getChildCount() > 0) {
            this.rootNode.removeAllChildren();
            this.treeModel.reload();
        }
        if (this.guiMain.getAsmProjectUml().getProjectUml() != null) {
            this.addTreeNodes(file);
            this.guiMain.getMenuMain().setVisibleProjectMenu(true);
        } else {
            this.guiMain.getMenuMain().setVisibleProjectMenu(false);
        }
    }

    public void refreshGui() {
        this.refreshGuiAndShowFile(null);
    }

    protected void addTreeNodes(File file) {
        String uriStr = null;
        try {
            String projPath = this.guiMain.getAsmProjectUml().getProjectUml().getProjectPath();
            uriStr = projPath.contains("\\") ? "file:/" + projPath.replace('\\', '/') : "file:" + projPath;
            URI uri = new URI(uriStr);
            File dir = new File(uri);
            this.addToTreeNode(dir, this.rootNode, file);
        }
        catch (Exception e) {
            System.out.println(uriStr);
            e.printStackTrace();
        }
    }

    protected void addToTreeNode(File dir, DefaultMutableTreeNode parentNode, File file) throws IOException {
        String[] files;
        for (String fileName : files = dir.list()) {
            File fileOrDir = new File(dir.getPath() + File.separator + fileName);
            DefaultMutableTreeNode childNode = null;
            if (fileOrDir.isDirectory()) {
                childNode = new DefaultMutableTreeNode(new NodeFolderProject(fileOrDir.getAbsolutePath(), fileOrDir.getName()));
                this.treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
                this.addToTreeNode(fileOrDir, childNode, file);
                continue;
            }
            if (fileOrDir.getName().equals("bs-uml.xml")) {
                childNode = new DefaultMutableTreeNode(new NodeDescriptorProject((IPaneProjectUml)this));
                this.treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
                this.scrollPathToVisible(new TreePath(childNode.getPath()));
                continue;
            }
            if (fileOrDir.getName().endsWith("dcl.xml")) {
                childNode = new DefaultMutableTreeNode(new NodeDiagramClassLight(fileOrDir.getAbsolutePath(), fileOrDir.getName(), this.guiMain));
                this.treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
                if (!fileOrDir.equals(file)) continue;
                this.scrollPathToVisible(new TreePath(childNode.getPath()));
                continue;
            }
            if (fileOrDir.getName().endsWith("duc.xml")) {
                childNode = new DefaultMutableTreeNode(new NodeDiagramUseCaseLight(fileOrDir.getAbsolutePath(), fileOrDir.getName(), this.guiMain));
                this.treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
                if (!fileOrDir.equals(file)) continue;
                this.scrollPathToVisible(new TreePath(childNode.getPath()));
                continue;
            }
            if (fileOrDir.getName().endsWith("dpk.xml")) {
                childNode = new DefaultMutableTreeNode(new NodeDiagramPackage(fileOrDir.getAbsolutePath(), fileOrDir.getName(), this.guiMain));
                this.treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
                if (!fileOrDir.equals(file)) continue;
                this.scrollPathToVisible(new TreePath(childNode.getPath()));
                continue;
            }
            if (fileOrDir.getName().endsWith("dob.xml")) {
                childNode = new DefaultMutableTreeNode(new NodeDiagramObject(fileOrDir.getAbsolutePath(), fileOrDir.getName(), this.guiMain));
                this.treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
                if (!fileOrDir.equals(file)) continue;
                this.scrollPathToVisible(new TreePath(childNode.getPath()));
                continue;
            }
            if (!fileOrDir.getName().endsWith("dsq.xml")) continue;
            childNode = new DefaultMutableTreeNode(new NodeDiagramSequence(fileOrDir.getAbsolutePath(), fileOrDir.getName(), this.guiMain));
            this.treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
            if (!fileOrDir.equals(file)) continue;
            this.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
    }

    public void setProjectUmlAndRefreshGui(ProjectUml umlProject) {
        this.guiMain.getAsmProjectUml().setProjectUml(umlProject);
        this.refreshGui();
        this.guiMain.refreshGui();
    }

    public IOpenable getSelectedTreePath() {
        IOpenable selectedNode = null;
        DefaultMutableTreeNode selectedTreeNode = this.getSelectedTreeNode();
        if (selectedTreeNode != null) {
            selectedNode = (IOpenable)selectedTreeNode.getUserObject();
        }
        return selectedNode;
    }

    protected DefaultMutableTreeNode getSelectedTreeNode() {
        DefaultMutableTreeNode selectedNode = null;
        TreePath selectedPath = this.getSelectionPath();
        if (selectedPath != null) {
            selectedNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
        }
        return selectedNode;
    }

    public AsmProjectUml getAsmProjectUml() {
        return this.guiMain.getAsmProjectUml();
    }

    public AsmEditorProject<ProjectUml, EditorProject<ProjectUml, Frame, ActionEvent>> getEditorProject() {
        return this.asmEditorProject;
    }
}

