select TAX as TAXID,  sum(SUBTOTAL * ITSPERCENTAGE / 100) as TOTALTAX
from
(
  select INVITEM.TAXCATEGORY as TAXCATEGORY, SUBTOTAL
  from SALESINVOICELINE 
  join INVITEM on INVITEM.ITSID = SALESINVOICELINE.INVITEM
  where SALESINVOICELINE.REVERSEDID is null and SALESINVOICELINE.ITSOWNER = :ITSOWNER

  union all

  select SERVICETOSALE.TAXCATEGORY as TAXCATEGORY, ITSPRICE as SUBTOTAL
  from SALESINVOICESERVICELINE 
  join SERVICETOSALE on SERVICETOSALE.ITSID = SALESINVOICESERVICELINE.SERVICE
  where SALESINVOICESERVICELINE.ITSOWNER = :ITSOWNER
) as ALL_LINES
join INVITEMTAXCATEGORY on INVITEMTAXCATEGORY.ITSID = TAXCATEGORY
join INVITEMTAXCATEGORYLINE on INVITEMTAXCATEGORYLINE.ITSOWNER = INVITEMTAXCATEGORY.ITSID
group by TAX;
