<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="shortcut icon" href="../static/img/favicon.png">
  <script type="text/javascript" src="../static/js/beige.form.js"></script>
  <script type="text/javascript" src="../static/js/beige.i18n.en.js"></script>
  <link rel="stylesheet" href="../static/css/beige.common.css">
  <title>${srvI18n.getMsg("mngDatabase")}</title>
</head>
<body>
  <br>
  <a class="btn" href="../" style="margin: 1rem;">${srvI18n.getMsg("home")}</a>
  <c:if test="${not empty ourPublicKeyStr && not empty foreignPublicKeyStr}">
    <div style="text-align: center; margin: 1rem;">
      <a class="btn" href="?nmRnd=mngDatabaseExt&nameAction=encryptLogs" onclick="confirmHref(this, 'Encrypt log files?'); return false;">${srvI18n.getMsg("encrypt_log_files")}</a>
      <br><br>
      <a class="btn" href="?nmRnd=mngDatabaseExt&nameAction=decryptLogs" onclick="confirmHref(this, 'Decrypt log files?'); return false;">${srvI18n.getMsg("decrypt_log_files")}</a>
    </div>
  </c:if>
  <div style="text-align: center; margin-top: 1rem; margin-bottom: 1rem;">
    <h4>${srvI18n.getMsg("curr_db")}: ${currDb}</h4>
      <table>
      <tr>
        <th style="padding: .4rem;">${srvI18n.getMsg("database")}</th>
        <th style="padding: .4rem; width: 40%;">${srvI18n.getMsg("actions")}</th>
      </tr>
      <c:forEach var="database" items="${databases}">
        <tr>
          <td style="padding: .4rem;">
            ${database}.sqlite
          </td>
          <td style="padding: 1rem;">
            <a class="btn" href="?nmRnd=mngDatabaseExt&nameAction=change&nameDatabase=${database}" onclick="confirmHref(this, 'Change?'); return false;">${srvI18n.getMsg("change_db_curr")}</a>
            <br><br>
            <c:if test="${not empty ourPublicKeyStr && not empty foreignPublicKeyStr}">
              <a class="btn" href="?nmRnd=mngDatabaseExt&nameAction=backup&nameDatabase=${database}" onclick="confirmHref(this, 'Backup?'); return false;">${srvI18n.getMsg("backup")}</a>
              <br><br>
            </c:if>
            <a class="btn" href="?nmRnd=mngDatabaseExt&nameAction=delete&nameDatabase=${database}" onclick="confirmHref(this, 'Delete?'); return false;">${srvI18n.getMsg("Delete")}</a>
          </td>
        </tr>
      </c:forEach>
    </table>
  </div>

  <div style="text-align: center; margin-bottom: 1rem;">
    <h4>${srvI18n.getMsg("backuped_db")} in ${backupDir}:</h4>
      <table>
      <tr>
        <th style="padding: .4rem;">${srvI18n.getMsg("database")}</th>
        <th style="padding: .4rem;">${srvI18n.getMsg("actions")}</th>
      </tr>
      <c:forEach var="database" items="${bkDatabases}">
        <tr>
          <td style="padding: .4rem;">
            ${database}.sqlten
          </td>
          <c:if test="${not empty ourPublicKeyStr && not empty foreignPublicKeyStr}">
            <td style="padding: 1rem;">
              <a class="btn" href="?nmRnd=mngDatabaseExt&nameAction=restore&nameDatabase=${database}" onclick="confirmHref(this, 'Restore?'); return false;">${srvI18n.getMsg("restore")}</a>
            </td>
          </c:if>
        </tr>
      </c:forEach>
    </table>
  </div>

  <div style="border: solid 1px;">
    <div class="dialog-title">
      ${srvI18n.getMsg("create_db_curr")}
    </div>
    <form method="post">
      <input type="hidden" name="nameAction" value="create">
      <input type="hidden" name="nmRnd" value="mngDatabaseExt">
      <table class="tbl-fieldset">
        <tr>
          <td>
            <label>${srvI18n.getMsg("create_label")}:</label>
          </td>
          <td>
            <div style="display: flex;">
              <input name="nameDatabase" value="dbmy">.sqlite
            </div>
          </td>
        </tr>
        <tr>
          <td>
            <label>${srvI18n.getMsg("idDatabase")}:</label>
          </td>
          <td>
            <div style="display: flex;">
              <input type="number" name="idDatabase" value="2">
            </div>
          </td>
        </tr>
      </table>
      <div style="text-align: center;">
        <input class="btn" type="submit" onclick="confirmSubmit(this, 'Create?'); return false;"/>
      </div>
    </form>
  </div>

  <div style="margin: 1rem;">
    <c:if test="${not empty ourPublicKeyStr}">
      ${srvI18n.getMsg("ourPublicKey")}:
      <br>
      <div class="pubKeyStr">
        ${ourPublicKeyStr}
      </div>
    </c:if>
  </div>
  <div style="margin: 1rem;">
    <c:if test="${not empty foreignPublicKeyStr}">
      ${srvI18n.getMsg("foreignPublicKey")}:
      <br>
      <div class="pubKeyStr">
        ${foreignPublicKeyStr}
      </div>
    </c:if>
  </div>

  <dialog id="dlgConfirm" class="dlg dlg-alert">
      <div class="confirm">
        <div class="dialog-title confirm-title">
          Conformation.
          <button onclick="document.getElementById('dlgConfirm').close();" class="btn-close btn-confirm">x</button>
        </div>
        <div id="confirmPlace" class="msg-place">
        </div>
        <div class="dlg-actions">
          <button id="confirmYes" class="btn btn-act btn-confirm">${srvI18n.getMsg("Yes")}</button>
          <button onclick="document.getElementById('dlgConfirm').close();" class="btn btn-act btn-confirm">${srvI18n.getMsg("No")}</button>
        </div>
     </div>
  </dialog>

</body>
</html>

