<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="shortcut icon" href="../static/img/favicon.png">
  <script type="text/javascript" src="../static/js/beige.form.js"></script>
  <script type="text/javascript" src="../static/js/beige.i18n.en.js"></script>
  <link rel="stylesheet" href="../static/css/beige.common.css">
  <title>${srvI18n.getMsg("mngSoftware")}</title>
</head>
<body style="padding: 20px;" >

  <a class="btn" href="../">${srvI18n.getMsg("home")}</a>

  <c:if test="${not empty logDet30000}">
    <div class="alert-20">${logDet30000}</div>
  </c:if>

  <div class="form-std form-70-33">
    <div class="dialog-title">
      ${srvI18n.getMsg("mngSoftware")}
    </div>
    <form method="post">
      <input type="hidden" name="nmRnd" value="mngSoftware">
      <table class="tbl-fieldset">
        <tr>
          <td>
            <label>${srvI18n.getMsg("isShowDebugMessages")}:</label>
          </td>
          <td>
            <div style="display: flex;">
              <select name="isShowDebugMessages" onchange="inputHasBeenChanged(this);">
                <c:if test="${mngSoftware.isShowDebugMessages}"> <c:set var="selT" value="selected"/> </c:if>
                <option value="true" ${selT}>${srvI18n.getMsg("Yes")}</option>
                <c:if test="${!mngSoftware.isShowDebugMessages}"> <c:set var="selF" value="selected"/> </c:if>
                <option value="false" ${selF}>${srvI18n.getMsg("No")}</option>
              </select>
            </div>
          </td>
        </tr>
        <tr>
          <td>
            <label>${srvI18n.getMsg("detailLevel")}:</label>
          </td>
          <td>
            <div style="display: flex;">
              <input name="detailLevel" type="number" value="${mngSoftware.detailLevel}" onchange="inputHasBeenChanged(this);">
            </div>
          </td>
        </tr>
      </table>
      <c:set var="apply" value="${srvI18n.getMsg('Apply')}"/>
      <div class="form-actions">
        <button onclick="if (formHasBeenChanged(this.form)) confirmSubmit(this, '${apply}?'); return false;" class="btn">${apply}</button>
      </div>
    </form>
  </div>

  <dialog id="dlgConfirm" class="dlg dlg-alert">
      <div class="confirm">
        <div class="dialog-title confirm-title">
          Conformation.
          <button onclick="document.getElementById('dlgConfirm').close();" class="btn-close btn-confirm">x</button>
        </div>
        <div id="confirmPlace" class="msg-place">
        </div>
        <div class="dlg-actions">
          <button id="confirmYes" class="btn btn-act btn-confirm">${srvI18n.getMsg("Yes")}</button>
          <button onclick="document.getElementById('dlgConfirm').close();" class="btn btn-act btn-confirm">${srvI18n.getMsg("No")}</button>
        </div>
     </div>
  </dialog>

</body>
</html>

