<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setLocale value="${reqVars.localeCurrent}" scope="request"/>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <link rel="stylesheet" type="text/css" media="print" href="../../static/css/beige.print-a4.css" />
  <link rel="stylesheet" type="text/css" href="../../static/css/beige.reports.css" />
  <link rel="icon" type="image/png" href="../../static/img/favicon.png">
  <title>${srvI18n.getMsg("balance_sheet", reqVars.lang)} <fmt:formatDate value="${balanceSheet.itsDate}" type="date" dateStyle="LONG"/></title>
</head>
<body>
  <div style="text-align: center;">
    <h4>
      ${accSettings.organization} <br>
      ${srvI18n.getMsg("balance_sheet", reqVars.lang)} <br>
      <fmt:formatDate value="${balanceSheet.itsDate}" type="date" dateStyle="LONG"/>
     </h4>
  </div>
  <table>
    <tr>
      <td colspan="2"><b>${srvI18n.getMsg("AssetsTitle", reqVars.lang)}</b></th>
      <td colspan="2"><b>${srvI18n.getMsg("LiabilitiesTitle", reqVars.lang)}</b></th>
    </tr>
    <c:forEach var="currIdx" begin="1" end="${balanceSheet.detailRowsCount}">
      <tr>
        <c:if test="${currIdx le balanceSheet.totalLinesAssets}">
          <td>
            ${balanceSheet.itsLines.get(currIdx - 1).accName}
          </td>
          <td align="right">
            <c:if test="${balanceSheet.itsLines.get(currIdx - 1).debit.doubleValue() != 0}">
              ${utlJsp.printNumber(balanceSheet.itsLines.get(currIdx - 1).debit.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}
            </c:if>
            <c:if test="${balanceSheet.itsLines.get(currIdx - 1).credit.doubleValue() != 0}">
              (${utlJsp.printNumber(balanceSheet.itsLines.get(currIdx - 1).credit.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)})
            </c:if>
          </td>
        </c:if>
        <c:if test="${currIdx gt balanceSheet.totalLinesAssets}">
          <td></td>
          <td></td>
        </c:if>

        <c:if test="${currIdx le balanceSheet.totalLinesLiabilities}">
          <td>
            ${balanceSheet.itsLines.get(balanceSheet.totalLinesAssets + currIdx - 1).accName}
          </td>
          <td align="right">
            <c:if test="${balanceSheet.itsLines.get(balanceSheet.totalLinesAssets + currIdx - 1).credit.doubleValue() != 0}">
              ${utlJsp.printNumber(balanceSheet.itsLines.get(balanceSheet.totalLinesAssets + currIdx - 1).credit.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}
            </c:if>
            <c:if test="${balanceSheet.itsLines.get(balanceSheet.totalLinesAssets + currIdx - 1).debit.doubleValue() != 0}">
              (${utlJsp.printNumber(balanceSheet.itsLines.get(balanceSheet.totalLinesAssets + currIdx - 1).debit.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)})
            </c:if>
          </td>
        </c:if>
        <c:if test="${currIdx == balanceSheet.totalLinesLiabilities + 1}">
          <td align="center"><b>${srvI18n.getMsg("total_l", reqVars.lang)}</b></td>
          <td align="right"><b>${utlJsp.printNumber(balanceSheet.totalLiabilities.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</b></td>
        </c:if>
        <c:if test="${currIdx == balanceSheet.totalLinesLiabilities + 2}">
          <td colspan="2"><b>${srvI18n.getMsg("OwnersEquityTitle", reqVars.lang)}</b></td>
        </c:if>
        <c:if test="${(currIdx gt balanceSheet.totalLinesLiabilities + 2) && (currIdx lt balanceSheet.totalLinesLiabilities + balanceSheet.totalLinesOwnersEquity + 3)}">
          <td>
            ${balanceSheet.itsLines.get(balanceSheet.totalLinesAssets + currIdx - 3).accName}
          </td>
          <td align="right">
            <c:if test="${balanceSheet.itsLines.get(balanceSheet.totalLinesAssets + currIdx - 3).credit.doubleValue() != 0}">
              ${utlJsp.printNumber(balanceSheet.itsLines.get(balanceSheet.totalLinesAssets + currIdx - 3).credit.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}
            </c:if>
            <c:if test="${balanceSheet.itsLines.get(balanceSheet.totalLinesAssets + currIdx - 3).debit.doubleValue() != 0}">
              (${utlJsp.printNumber(balanceSheet.itsLines.get(balanceSheet.totalLinesAssets + currIdx - 3).debit.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)})
            </c:if>
          </td>
        </c:if>
        <c:if test="${currIdx == balanceSheet.totalLinesLiabilities + balanceSheet.totalLinesOwnersEquity + 3}">
          <td align="center"><b>${srvI18n.getMsg("total_oe", reqVars.lang)}</b></td>
          <td align="right"><b>${utlJsp.printNumber(balanceSheet.totalOwnersEquity.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</b></td>
        </c:if>
        <c:if test="${currIdx gt balanceSheet.totalLinesLiabilities + balanceSheet.totalLinesOwnersEquity + 3}">
          <td></td>
          <td></td>
        </c:if>
      </tr>
    </c:forEach>
    <tr>
      <td align="center"><b>${srvI18n.getMsg("total_assets", reqVars.lang)}</b></td>
      <td align="right"><b>${utlJsp.printNumber(balanceSheet.totalAssets.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)} ${accSettings.currency.itsName}</b></td>
      <td align="center"><b>${srvI18n.getMsg("total_l_oe", reqVars.lang)}</b></td>
      <td align="right"><b>${utlJsp.printNumber(balanceSheet.totalLiabilities.add(balanceSheet.totalOwnersEquity).toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)} ${accSettings.currency.itsName}</b></td>
    </tr>
  </table>
</body>
</html>
