<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsCost">
      ${srvI18n.getMsg("itsCost", reqVars.lang)}
      <c:if test="${reqVars.isIncludedSalesTaxPurchases != null && !reqVars.isIncludedSalesTaxPurchases}">
        ${srvI18n.getMsg("without_taxes", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" ${autofocus} class='autoNum${reqVars.costPrecision}' data-a-sep='${reqVars.dgseparatorv}' data-a-dec='${reqVars.dseparatorv}' required id="${entity.getClass().simpleName}itsCost" name="${entity.getClass().simpleName}.itsCost" value="${entity.itsCost}" onchange="inputHasBeenChanged(this); calculateTotalForCost('${entity.getClass().simpleName}', ${reqVars.costPrecision}, ${reqVars.pricePrecision}, '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}');"/> 
      <c:set var="autofocus" value="" scope="request"/>
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsQuantity">${srvI18n.getMsg("itsQuantity", reqVars.lang)}</label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class='autoNum${reqVars.quantityPrecision}' data-a-sep='${reqVars.dgseparatorv}' data-a-dec='${reqVars.dseparatorv}' required id="${entity.getClass().simpleName}itsQuantity" name="${entity.getClass().simpleName}.itsQuantity" value="${entity['itsQuantity']}" onchange="inputHasBeenChanged(this); calculateTotalForCost('${entity.getClass().simpleName}', ${reqVars.costPrecision}, ${reqVars.pricePrecision}, '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}');"/> 
    </div>
  </td>
</tr>
<tr>
  <c:if test="${reqVars.isIncludedSalesTaxPurchases == null || reqVars.isIncludedSalesTaxPurchases}">
    <td>
      <label for="${entity.getClass().simpleName}.itsTotal">
        ${srvI18n.getMsg("itsTotal", reqVars.lang)}
        ${srvI18n.getMsg("include_taxes", reqVars.lang)}
      </label>
    </td>
    <td>
      <div class="input-line">
        <input type="text" class='autoNum${reqVars.pricePrecision}' data-a-sep='${reqVars.dgseparatorv}' data-a-dec='${reqVars.dseparatorv}' id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.itsTotal" value="${entity['itsTotal']}" onchange="inputHasBeenChanged(this); calculateCost('${entity.getClass().simpleName}', ${reqVars.costPrecision}, ${reqVars.pricePrecision}, '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}');"/> 
      </div>
    </td>
  </c:if>
  <c:if test="${reqVars.isIncludedSalesTaxPurchases != null && !reqVars.isIncludedSalesTaxPurchases}">
    <td>
      <label for="${entity.getClass().simpleName}.itsTotal">
        ${srvI18n.getMsg("subtotal", reqVars.lang)}
      </label>
    </td>
    <td>
      <div class="input-line">
        <input type="text" class='autoNum${reqVars.pricePrecision}' data-a-sep='${reqVars.dgseparatorv}' data-a-dec='${reqVars.dseparatorv}' id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.subtotal" value="${entity.subtotal}" onchange="inputHasBeenChanged(this); calculateCost('${entity.getClass().simpleName}', ${reqVars.costPrecision}, ${reqVars.pricePrecision}, '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}');"/> 
      </div>
    </td>
  </c:if>
</tr>
