<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsPrice">
      ${srvI18n.getMsg("itsPrice", reqVars.lang)}
      <c:if test="${reqVars.isIncludedSalesTaxSales != null && !reqVars.isIncludedSalesTaxSales}">
        ${srvI18n.getMsg("without_taxes", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" required id="${entity.getClass().simpleName}itsPrice" name="${entity.getClass().simpleName}.itsPrice" value="${entity['itsPrice']}" onchange="inputHasBeenChanged(this); calculateTotalForPrice('${entity.getClass().simpleName}', ${reqVars.pricePrecision}, ${reqVars.pricePrecision}, '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}');"/> 
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsQuantity">${srvI18n.getMsg("itsQuantity", reqVars.lang)}</label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class="autoNum${reqVars.quantityPrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" required id="${entity.getClass().simpleName}itsQuantity" name="${entity.getClass().simpleName}.itsQuantity" value="${entity['itsQuantity']}" onchange="inputHasBeenChanged(this); calculateTotalForPrice('${entity.getClass().simpleName}', ${reqVars.pricePrecision}, ${reqVars.pricePrecision}, '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}');"/> 
    </div>
  </td>
</tr>
<tr>
  <c:if test="${reqVars.isIncludedSalesTaxSales == null || reqVars.isIncludedSalesTaxSales}">
    <td>
      <label for="${entity.getClass().simpleName}.itsTotal">
        ${srvI18n.getMsg("itsTotal", reqVars.lang)}
        ${srvI18n.getMsg("include_taxes", reqVars.lang)}
      </label>
    </td>
    <td>
      <div class="input-line">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.itsTotal" value="${entity['itsTotal']}" onchange="inputHasBeenChanged(this); calculatePrice('${entity.getClass().simpleName}', ${reqVars.pricePrecision}, ${reqVars.pricePrecision}, '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}');"/> 
      </div>
    </td>
  </c:if>
  <c:if test="${reqVars.isIncludedSalesTaxSales != null && !reqVars.isIncludedSalesTaxSales}">
    <td>
      <label for="${entity.getClass().simpleName}.itsTotal">
        ${srvI18n.getMsg("subtotal", reqVars.lang)}
      </label>
    </td>
    <td>
      <div class="input-line">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.subtotal" value="${entity.subtotal}" onchange="inputHasBeenChanged(this); calculatePrice('${entity.getClass().simpleName}', ${reqVars.pricePrecision}, ${reqVars.pricePrecision}, '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}');"/> 
      </div>
    </td>
  </c:if>
</tr>
