<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setLocale value="${reqVars.localeCurrent}" scope="request"/>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <link rel="stylesheet" type="text/css" media="print" href="../../static/css/beige.print-a4.css" />
  <link rel="stylesheet" type="text/css" href="../../static/css/beige.reports.css" />
  <link rel="icon" type="image/png" href="../../static/img/favicon.png">
  <title>${srvI18n.getMsg("ledger", reqVars.lang)}</title>
</head>
<body>
  <div style="text-align: center;">
    <h4>
      ${srvI18n.getMsg("ledger", reqVars.lang)} ${srvI18n.getMsg("from", reqVars.lang)} <fmt:formatDate value="${date1}"/>
      ${srvI18n.getMsg("to", reqVars.lang)} <fmt:formatDate value="${date2}"/> <br>
      ${accSettings.organization} <br>
      ${srvI18n.getMsg("account", reqVars.lang)}: ${account.itsName}
      <c:if test="${not empty subaccName}">
        , <c:out value="${subaccName}"/>
      </c:if>
    </h4>
  </div>
  <table>
    <tr>
      <th>${srvI18n.getMsg("itsDate", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("description", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("coracc", reqVars.lang)}</th>
      <th class="debit-credit-th">${srvI18n.getMsg("Debit", reqVars.lang)}</th>
      <th class="debit-credit-th">${srvI18n.getMsg("Credit", reqVars.lang)}</th>
      <th class="debit-credit-th">${srvI18n.getMsg("Balance", reqVars.lang)}</th>
    </tr>
    <c:if test="${subaccName == null && account.subaccType != null}">
      <c:forEach var="entry" items="${ledgerPrevious.linesMap}">
        <tr>
          <td colspan="3" class="total">${entry.key}:</td>
          <td class="total">${utlJsp.printNumber(entry.value.debit.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</td>
          <td class="total">${utlJsp.printNumber(entry.value.credit.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</td>
          <td class="total">${utlJsp.printNumber(entry.value.balance.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</td>
        </tr>
      </c:forEach>
    </c:if>
    <tr>
      <td colspan="3" class="total"><b>${srvI18n.getMsg("Previous", reqVars.lang)}:</b></td>
      <td class="total"><b>${utlJsp.printNumber(ledgerPrevious.debitAcc.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</b></td>
      <td class="total"><b>${utlJsp.printNumber(ledgerPrevious.creditAcc.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</b></td>
      <td class="total"><b>${utlJsp.printNumber(ledgerPrevious.balanceAcc.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</b></td>
    </tr>
    <c:forEach var="ledgerLine" items="${ledgerDetail.itsLines}">
      <c:set var="subAccAppear" value=""/>
      <c:if test="${subaccName == null && account.subaccType != null}">
        <c:set var="subAccAppear" value="${ledgerLine.subaccName}, ${ledgerLine.balanceSubacc.add(ledgerPrevious.linesMap[ledgerLine.subaccName].balance)},"/>
      </c:if>
      <tr>
        <td><fmt:formatDate value="${ledgerLine.itsDate}" type="both" timeStyle="short"/></td>
        <td>${subAccAppear} ${ledgerLine.description}</td>
        <td>${ledgerLine.corrAccName}
          <c:if test="${not empty ledgerLine.corrSubaccName}">
            - ${ledgerLine.corrSubaccName}
          </c:if>
        </td>
        <td class="debit-credit">${utlJsp.printNumber(ledgerLine.debit.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</td>
        <td class="debit-credit">${utlJsp.printNumber(ledgerLine.credit.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</td>
        <td class="debit-credit">${utlJsp.printNumber(ledgerLine.balance.add(ledgerPrevious.balanceAcc).toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</td>
      </tr>
    </c:forEach>
    <c:if test="${subaccName == null && account.subaccType != null}">
      <c:forEach var="entry" items="${ledgerPrevious.linesMap}">
        <tr>
          <td colspan="3" class="total">${entry.key}:</td>
          <td class="total">${utlJsp.printNumber(entry.value.debit.add(ledgerDetail.subaccDebitTotal[entry.key]).toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</td>
          <td class="total">${utlJsp.printNumber(entry.value.credit.add(ledgerDetail.subaccCreditTotal[entry.key]).toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</td>
          <td class="total">${utlJsp.printNumber(entry.value.balance.add(ledgerDetail.subaccBalanceTotal[entry.key]).toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)}</td>
        </tr>
      </c:forEach>
    </c:if>
    <tr>
      <td colspan="3" class="total"><b>${srvI18n.getMsg("itsTotal", reqVars.lang)}:</b></td>
      <td class="total"><b>${utlJsp.printNumber(ledgerPrevious.debitAcc.add(ledgerDetail.debitAcc).toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)} ${accSettings.currency.itsName}</b></td>
      <td class="total"><b>${utlJsp.printNumber(ledgerPrevious.creditAcc.add(ledgerDetail.creditAcc).toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)} ${accSettings.currency.itsName}</b></td>
      <td class="total"><b>${utlJsp.printNumber(ledgerPrevious.balanceAcc.add(ledgerDetail.balanceAcc).toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.balancePrecision, reqVars.digitsInGroup)} ${accSettings.currency.itsName}</b></td>
    </tr>
  </table>
</body>
</html>
