<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <script type="text/javascript" src="../static/js/beige.ajax.js"></script>
  <script type="text/javascript" src="../static/js/beige.form.js"></script>
  <script type="text/javascript" src="../static/js/beige.accounting.js"></script>
  <script type="text/javascript" src="../static/js/beige.i18n.${reqVars.lang}.js"></script>
  <script type="text/javascript" src="../static/js/jquery-3.3.1.min.js"></script>
  <script type="text/javascript" src="../static/js/autoNumeric.js"></script>
  <link rel="icon" type="image/png" href="../static/img/favicon.png">
  <link rel="stylesheet" href="../static/css/beige.common.css" />
  <title>Beigesoft ™ Accounting</title>
</head>
<body>

  <div class="navbar">
    <div class="dropdown">
      <a href="#" class="dropdown-btn">${srvI18n.getMsg("Work", reqVars.lang)}</a>
      <div class="dropdown-content">
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=DebtorCreditorCategory&page=1&mobile=mobile/');">${srvI18n.getMsg("DebtorCreditorCategorys", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=DebtorCreditor&page=1&mobile=mobile/');">${srvI18n.getMsg("DebtorCreditors", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=I18nBuyer&page=1&mobile=mobile/');">${srvI18n.getMsg("I18nBuyers", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=ServicePurchasedCategory&page=1&mobile=mobile/');">${srvI18n.getMsg("ServicePurchasedCategorys", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=ServicePurchased&page=1&mobile=mobile/');">${srvI18n.getMsg("ServicePurchaseds", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=PrepaymentTo&page=1&mobile=mobile/');">${srvI18n.getMsg("PrepaymentTos", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=PurchaseInvoice&page=1&mobile=mobile/');">${srvI18n.getMsg("PurchaseInvoices", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=PaymentTo&page=1&mobile=mobile/');">${srvI18n.getMsg("PaymentTos", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=PurchaseReturn&page=1&mobile=mobile/');">${srvI18n.getMsg("PurchaseReturns", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=PrepaymentFrom&page=1&mobile=mobile/');">${srvI18n.getMsg("PrepaymentFroms", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=ServiceToSaleCategory&page=1&mobile=mobile/');">${srvI18n.getMsg("ServiceToSaleCategorys", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=ServiceToSale&page=1&mobile=mobile/');">${srvI18n.getMsg("ServiceToSales", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=I18nServiceToSale&page=1&mobile=mobile/');">${srvI18n.getMsg("I18nServiceToSales", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=SalesInvoice&page=1&mobile=mobile/');">${srvI18n.getMsg("SalesInvoices", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=PaymentFrom&page=1&mobile=mobile/');">${srvI18n.getMsg("PaymentFroms", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=SalesReturn&page=1&mobile=mobile/');">${srvI18n.getMsg("SalesReturns", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=ManufacturingProcess&page=1&mobile=mobile/');">${srvI18n.getMsg("ManufacturingProcesss", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=Manufacture&page=1&mobile=mobile/');">${srvI18n.getMsg("Manufactures", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=EmployeeCategory&page=1&mobile=mobile/');">${srvI18n.getMsg("EmployeeCategorys", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=Employee&page=1&mobile=mobile/');">${srvI18n.getMsg("Employees", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=WageType&page=1&mobile=mobile/');">${srvI18n.getMsg("WageTypes", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=WageTaxTable&page=1&mobile=mobile/');">${srvI18n.getMsg("WageTaxTables", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=Wage&page=1&mobile=mobile/');">${srvI18n.getMsg("Wages", reqVars.lang)}</a>
      </div>
    </div>
    <div class="dropdown">
      <a href="#" class="dropdown-btn">${srvI18n.getMsg("Warehouse", reqVars.lang)}</a>
      <div class="dropdown-content">
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=Warehouse&page=1&mobile=mobile/');">${srvI18n.getMsg("Warehouses", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=WarehouseSite&page=1&mobile=mobile/');">${srvI18n.getMsg("WarehouseSites", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=InvItemType&page=1&mobile=mobile/');">${srvI18n.getMsg("InvItemTypes", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=InvItemCategory&page=1&mobile=mobile/');">${srvI18n.getMsg("InvItemCategorys", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=InvItemTaxCategory&page=1&mobile=mobile/');">${srvI18n.getMsg("InvItemTaxCategorys", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=InvItem&page=1&mobile=mobile/');">${srvI18n.getMsg("InvItems", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=I18nInvItem&page=1&mobile=mobile/');">${srvI18n.getMsg("I18nInvItems", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=BeginningInventory&page=1&mobile=mobile/');">${srvI18n.getMsg("BeginningInventorys", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=GoodsLoss&page=1&mobile=mobile/');">${srvI18n.getMsg("GoodsLosss", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=MoveItems&page=1&mobile=mobile/');">${srvI18n.getMsg("MoveItemss", reqVars.lang)}</a>
         <a href="warehouseRests/?nmRnd=warehouseRests" target="_blank">${srvI18n.getMsg("warehouse_rests", reqVars.lang)}</a>
         <a href="warehouseSiteRests/?nmRnd=warehouseSiteRests" target="_blank">${srvI18n.getMsg("warehouse_site_rests", reqVars.lang)}</a>
      </div>
    </div>
    <div class="dropdown">
      <a href="#" class="dropdown-btn">${srvI18n.getMsg("Accounting", reqVars.lang)}</a>
      <div class="dropdown-content">
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=AccSettings&page=1&mobile=mobile/');">${srvI18n.getMsg("AccSettings", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=I18nAccounting&page=1&mobile=mobile/');">${srvI18n.getMsg("I18nAccountings", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=Expense&page=1&mobile=mobile/');">${srvI18n.getMsg("Expenses", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=BankAccount&page=1&mobile=mobile/');">${srvI18n.getMsg("BankAccounts", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=Property&page=1&mobile=mobile/');">${srvI18n.getMsg("Propertys", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=UnitOfMeasure&page=1&mobile=mobile/');">${srvI18n.getMsg("UnitOfMeasures", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=I18nUnitOfMeasure&page=1&mobile=mobile/');">${srvI18n.getMsg("I18nUnitOfMeasures", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=Tax&page=1&mobile=mobile/');">${srvI18n.getMsg("Taxs", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=Currency&page=1&mobile=mobile/');">${srvI18n.getMsg("Currencys", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=I18nCurrency&page=1&mobile=mobile/');">${srvI18n.getMsg("I18nCurrencys", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=Account&page=1&mobile=mobile/');">${srvI18n.getMsg("Accounts", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=AccountingEntries&page=1&mobile=mobile/');">${srvI18n.getMsg("AccountingEntriess", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=ReplicationAccMethod&page=1&mobile=mobile/');">${srvI18n.getMsg("ReplicationAccMethods", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listAccEntriesWholeJson&nmEnt=AccountingEntry&page=1&mobile=mobile/');">${srvI18n.getMsg("AccountingEntrys", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'report/?nmRnd=replicateAccFormJson');">${srvI18n.getMsg("Import_acc_entries", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'report/?nmRnd=ledgerFormJson&mobile=mobile/');">${srvI18n.getMsg("Ledger", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'report/?nmRnd=balanceFormJson');">${srvI18n.getMsg("TrialBalance", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'report/?nmRnd=balanceSheetFormJson');">${srvI18n.getMsg("balance_sheet", reqVars.lang)}</a>
      </div>
    </div>
    <div class="dropdown">
      <a href="#" class="dropdown-btn">...</a>
      <div class="dropdown-content">
        <a href="jspd?nmRnd=mainMobile">${srvI18n.getMsg("Refresh", reqVars.lang)}</a>
        <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=Languages&page=1&mobile=mobile/');">${srvI18n.getMsg("Languagess", reqVars.lang)}</a>
        <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=Countries&page=1&mobile=mobile/');">${srvI18n.getMsg("Countriess", reqVars.lang)}</a>
        <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=DecimalSeparator&page=1&mobile=mobile/');">${srvI18n.getMsg("DecimalSeparators", reqVars.lang)}</a>
        <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=DecimalGroupSeparator&page=1&mobile=mobile/');">${srvI18n.getMsg("DecimalGroupSeparators", reqVars.lang)}</a>
        <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmHnd=handlerEntityRequest&nmsAct=list&nmRnd=listWholeJson&nmEnt=LangPreferences&page=1&mobile=mobile/');">${srvI18n.getMsg("LangPreferencess", reqVars.lang)}</a>
        <a href="../">${srvI18n.getMsg("exit", reqVars.lang)}</a>
        <a href="#" onclick="openDlg('dlgI18n');">${srvI18n.getMsg("changeLangPreferences", reqVars.lang)}</a>
        <a href="service?nmHnd=hndTrdSmpReq&nmRnd=refreshedHndlI18n&nmPrc=PrcRefreshHndlI18n" target="_blank">${srvI18n.getMsg("RefreshHndlI18n", reqVars.lang)}</a>
        <a href="#" onclick="getHtmlByAjax('GET', 'service/?nmRnd=aboutJson&nmHnd=hndAbout');">${srvI18n.getMsg("About", reqVars.lang)}</a>
        <c:if test="${not empty pageContext['request'].userPrincipal}">
          <a href="jspd?nmRnd=changePasswdFirstUser">${srvI18n.getMsg("change_passwd", reqVars.lang)}</a>
          <a href="../?logoff=true">${pageContext['request'].userPrincipal.name} ${srvI18n.getMsg("logout", reqVars.lang)}</a>
        </c:if>
      </div>
    </div>
  </div>  

  <div id="lstMainPlace">
  </div>
  
  <div id="frmMainPlace">
  </div>

  <div id="frmSubPlace">
  </div>

  <div id="frmReport">
  </div>

  <div id="frmReplicate">
  </div>

  <div id="pickersPlace">
  </div>

  <div id="pickersPlaceDub">
  </div>

  <div id="targetInfo">
  </div>

  <dialog id="dlgConfirm" class="dlg dlg-alert">
      <div class="confirm">
        <div class="dialog-title confirm-title">
          ${srvI18n.getMsg("Conformation", reqVars.lang)}.
          <button onclick="document.getElementById('dlgConfirm').close();" class="btn-close btn-confirm">x</button>
        </div>
        <div id="confirmPlace" class="msg-place">
        </div>
        <div class="dlg-actions">
          <button id="confirmYes" class="btn btn-act btn-confirm">${srvI18n.getMsg("Yes", reqVars.lang)}</button>
          <button onclick="document.getElementById('dlgConfirm').close();" class="btn btn-act btn-confirm">${srvI18n.getMsg("No", reqVars.lang)}</button>
        </div>
     </div>
  </dialog>

  <dialog id="dlgI18n" class="dlg dlg-alert">
      <div class="confirm">
        <div class="dialog-title confirm-title">
          ${srvI18n.getMsg("changeLangPreferences", reqVars.lang)}
          <button onclick="document.getElementById('dlgI18n').close();" class="btn-close btn-confirm">x</button>
        </div>
        <form id="lngPrefFrm" action="jspd?nmRnd=mainMobile" method="POST">
          <div>
            <table class="tbl-fieldset">
              <tbody>
                <tr>
                  <td>
                    <label>${srvI18n.getMsg("lang", reqVars.lang)}</label>
                  </td>
                  <td>
                    <div class="input-line">
                      <select name="lang" onchange="inputHasBeenChanged(this);">
                        <c:forEach var="it" items="${reqVars.languages}">
                          <c:set var="itmSel" value=""/>
                          <c:if test="${reqVars.lang  eq it.itsId}">
                            <c:set var="itmSel" value="selected"/>
                          </c:if>
                          <option value="${it.itsId}" ${itmSel}>${it.itsName}</option>
                        </c:forEach>
                      </select>
                    </div>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label>${srvI18n.getMsg("decimalSep", reqVars.lang)}</label>
                  </td>
                  <td>
                    <div class="input-line">
                      <select name="dseparator" onchange="inputHasBeenChanged(this);">
                        <c:forEach var="it" items="${reqVars.decimalSeparators}">
                          <c:set var="itmSel" value=""/>
                          <c:if test="${reqVars.dseparator eq it.itsId}">
                            <c:set var="itmSel" value="selected"/>
                          </c:if>
                          <option value="${it.itsId}" ${itmSel}>${srvI18n.getMsg(it.itsName, reqVars.lang)}</option>
                        </c:forEach>
                      </select>
                    </div>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label>${srvI18n.getMsg("decimalGroupSep", reqVars.lang)}</label>
                  </td>
                  <td>
                    <div class="input-line">
                      <select name="dgseparator" onchange="inputHasBeenChanged(this);">
                        <c:forEach var="it" items="${reqVars.decimalGroupSeparators}">
                          <c:set var="itmSel" value=""/>
                          <c:if test="${reqVars.dgseparator eq it.itsId}">
                            <c:set var="itmSel" value="selected"/>
                          </c:if>
                          <option value="${it.itsId}" ${itmSel}>${srvI18n.getMsg(it.itsName, reqVars.lang)}</option>
                        </c:forEach>
                      </select>
                    </div>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label>${srvI18n.getMsg("digitsInGroup", reqVars.lang)}</label>
                  </td>
                  <td>
                    <div class="input-line">
                      <select name="digitsInGroup" onchange="inputHasBeenChanged(this);">
                        <c:set var="itmSel" value=""/>
                        <c:if test="${reqVars.digitsInGroup == 2}">
                          <c:set var="itmSel" value="selected"/>
                        </c:if>
                        <option value="2" ${itmSel}>2 ${srvI18n.getMsg("Indian", reqVars.lang)}</option>
                        <c:set var="itmSel" value=""/>
                        <c:if test="${reqVars.digitsInGroup == 3}">
                          <c:set var="itmSel" value="selected"/>
                        </c:if>
                        <option value="3" ${itmSel}>3</option>
                        <c:set var="itmSel" value=""/>
                        <c:if test="${reqVars.digitsInGroup == 4}">
                          <c:set var="itmSel" value="selected"/>
                        </c:if>
                        <option value="4" ${itmSel}>4</option>
                      </select>
                    </div>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
          <div class="dlg-actions">
            <input style="display: none" id="lngPrefFrmFakeSubmit" type="submit">
            <button type="submit" class="btn btn-act btn-confirm" onclick="return checkForm(this.form, true);">${srvI18n.getMsg("Apply", reqVars.lang)}</button>
            <button type="button" onclick="document.getElementById('dlgI18n').close(); return false;" class="btn btn-act btn-confirm">${srvI18n.getMsg("Close", reqVars.lang)}</button>
          </div>
        </form>
     </div>
  </dialog>

  <dialog id="dlgError" class="dlg dlg-alert">
    <div class="error">
      <div class="dialog-title error-title">
        ${srvI18n.getMsg("Error", reqVars.lang)}!
        <button onclick="document.getElementById('dlgError').close()" class="btn-close btn-error">x</button>
      </div>
      <div id="errorPlace" class="msg-place">
      </div>
   </div>
  </dialog>

  <dialog id="dlgWarning" class="dlg dlg-alert">
    <div class="warning">
      <div class="dialog-title warning-title">
        ${srvI18n.getMsg("Warning", reqVars.lang)}!
        <button onclick="document.getElementById('dlgWarning').close()" class="btn-close btn-warning">x</button>
      </div>
      <div id="warningPlace" class="msg-place">
      </div>
   </div>
  </dialog>

  <div id="dlgSuccess" class="dlg-notifier">
    <div class="success">
      <div class="dialog-title success-title">
        ${srvI18n.getMsg("Success", reqVars.lang)}!
        <button onclick="document.getElementById('dlgSuccess').close()" class="btn-close btn-success">x</button>
      </div>
      <div id="successPlace" class="msg-place">
      </div>
   </div>
  </div>

</body>
</html>
