<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<jsp:include page="webstoreStart.jsp"/>

<c:set var="filterUrl" value="" scope="request"/>
<c:if test="${not empty filterCatalog && not empty filterCatalog.operator}">
  <c:set var="filterUrl" value="&fltCtOp=${filterCatalog.operator}" scope="request"/>
  <c:forEach var="flCtVl" items="${filterCatalog.items}">
    <c:set var="filterUrl" value="${filterUrl}&fltCtVal=${flCtVl.itsId}" scope="request"/>
  </c:forEach>
</c:if>
<c:if test="${not empty filtersSpecifics}">
  <c:forEach var="fltSpec" items="${filtersSpecifics}">
    <c:if test="${not empty fltSpec.filter.operator}">
      <c:set var="parPref" value="fltSp${fltSpec.catSpec.specifics.itsId}"/>
      <c:set var="filterUrl" value="${filterUrl}&${parPref}Op=${fltSpec.filter.operator}" scope="request"/>
      <c:if test="${fltSpec.filter.getClass().simpleName eq 'FilterItems'}">
        <c:forEach var="flSpVl" items="${fltSpec.filter.items}">
          <c:set var="filterUrl" value="${filterUrl}&${parPref}Val=${flSpVl.itsId}" scope="request"/>
        </c:forEach>
      </c:if>
      <c:if test="${fltSpec.filter.getClass().simpleName ne 'FilterItems'}">
        <c:set var="filterUrl" value="${filterUrl}&${parPref}Val1=${fltSpec.filter.value1}" scope="request"/>
        <c:if test="${fltSpec.filter.operator eq 'BETWEEN_INCLUDE'}">
          <c:set var="filterUrl" value="${filterUrl}&${parPref}Val2=${fltSpec.filter.value2}" scope="request"/>
        </c:if>
      </c:if>
    </c:if>
  </c:forEach>
</c:if>
<c:if test="${not empty filterPrice && not empty filterPrice.operator}">
  <c:set var="filterUrl" value="${filterUrl}&fltPriOp=${filterPrice.operator}&fltPriVal1=${filterPrice.value1}" scope="request"/>
  <c:if test="${not empty filterPrice.value2}">
    <c:set var="filterUrl" value="${filterUrl}&fltPriVal2=${filterPrice.value1}" scope="request"/>
  </c:if>
</c:if>
<c:set var="filterUrlFrm" value="" scope="request"/>
<c:if test="${not empty filterUrl}">
  <c:set var="filterUrlFrm" value="${filterUrl.replaceFirst('&', '?')}" scope="request"/>
</c:if>

<div class="card cat-name">
  <div class="card-header">
    <c:set var="delim" value=""/>
    <c:if test="${empty filterCatalog || empty filterCatalog.operator}">
      ${catalog.itsName}
      <c:set var="delim" value="/"/>
    </c:if>
    <c:if test="${not empty filterCatalog && not empty filterCatalog.operator}">
      <c:forEach var="cat" items="${filterCatalog.items}">
        ${delim}
        ${cat.itsName}
        <c:set var="delim" value="/"/>
      </c:forEach>
    </c:if>
    <c:if test="${not empty filterPrice && not empty filterPrice.operator}">
      ${delim}
      ${srvI18n.getMsg("itsPrice", reqVars.lang)} ${srvI18n.getMsg(filterPrice.operator, reqVars.lang)} ${filterPrice.value1}
      <c:if test="${not empty filterPrice.value2}">
        ${srvI18n.getMsg("and", reqVars.lang)}
        ${filterPrice.value2}
      </c:if>
    </c:if>
    <c:if test="${not empty filtersSpecifics}">
      <c:forEach var="fltSpec" items="${filtersSpecifics}">
        <c:if test="${not empty fltSpec.filter.operator}">
          ${delim}
          ${fltSpec.catSpec.specifics.itsName} ${srvI18n.getMsg(fltSpec.filter.operator, reqVars.lang)}
          <c:set var="delim" value="/"/>
          <c:set var="filterUrl" value="${filterUrl}&${parPref}Op=${fltSpec.filter.operator}" scope="request"/>
          <c:if test="${fltSpec.filter.getClass().simpleName eq 'FilterItems'}">
            (
            <c:forEach var="flSpVl" items="${fltSpec.filter.items}">
              ${flSpVl.itsName}
            </c:forEach>
            )
          </c:if>
          <c:if test="${fltSpec.filter.getClass().simpleName ne 'FilterItems'}">
            ${fltSpec.filter.value1}
            <c:if test="${fltSpec.filter.operator eq 'BETWEEN_INCLUDE'}">
              ${srvI18n.getMsg("and", reqVars.lang)}
              ${fltSpec.filter.value2}
            </c:if>
          </c:if>
        </c:if>
      </c:forEach>
    </c:if>
  </div>
</div>

<c:set var="divImg">
   <div class="col-12 col-md-4">  
</c:set>
<c:set var="divDscr">
  <div class="col-12 col-md-8">
</c:set>
<c:set var="divDscrOnly">
  <div class="col-12">
</c:set>
<c:if test="${tradingSettings.columnsCount != 1}">
  <c:set var="divImg">
     <div class="col-12 col-md-4 col-lg-2">  
  </c:set>
  <c:set var="divDscr">
    <div class="col-12 col-md-8 col-lg-4">
  </c:set>
  <c:set var="divDscrOnly">
    <div class="col-12 col-lg-6">
  </c:set>
</c:if>
<c:forEach var="item" items="${itemsList}" varStatus="status">
  <c:set var="itsQuantity" value="1"/>
  <c:set var="cartItemItsId" value="null"/>
  <c:set var="orderedQuantity" value=""/>
  <c:if test="${not empty cartMap && not empty cartMap[item.itsType][item.itemId]}">
    <c:set var="itsQuantity" value="${cartMap[item.itsType][item.itemId].itsQuantity}"/>
    <c:set var="cartItemItsId" value="${cartMap[item.itsType][item.itemId].itsId}"/>
    <c:set target="${cartMap[item.itsType][item.itemId]}" property="availableQuantity" value="${item.availableQuantity}"/>
    <c:set var="orderedQuantity">
      <span class="badge badge-primary">${cartMap[item.itsType][item.itemId].itsQuantity}</span>
    </c:set>
  </c:if>
  <c:if test="${tradingSettings.columnsCount == 1 || (status.index mod 2) == 0}">
    <div class="row">
  </c:if>
  <c:if test="${not empty item.imageUrl}">
    ${divImg}
      <img class="card-img-top" src="${item.imageUrl}">
    </div>
    ${divDscr}
  </c:if>
  <c:if test="${empty item.imageUrl}">
    ${divDscrOnly}
  </c:if>
    <h5><b><span class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}">${item.itsPrice}</span></b>
      <c:if test="${not empty item.detailsMethod}">
        <c:set var="detailPage" value="webstoreGoods"/>
        <c:if test="${item.itsType eq 'SERVICE'}">
          <c:set var="detailPage" value="webstoreService"/>
        </c:if>
        <c:if test="${item.itsType eq 'SEGOODS'}">
          <c:set var="detailPage" value="webstoreSeGoods"/>
        </c:if>
        <c:if test="${item.itsType eq 'SESERVICE'}">
          <c:set var="detailPage" value="webstoreSeService"/>
        </c:if>
        <a href="servicePublic?nmRnd=${detailPage}&nmHnd=hndPubWebStrTr&nmPrc=PrcDetailPage&itemId=${item.itemId}&itemType=${item.itsType}&catalogId=${catalog.itsId}">${item.itsName}</a>
      </c:if>
      <c:if test="${empty item.detailsMethod}">
        ${item.itsName}
      </c:if>
      <a href="#" onclick="setCartItem(${item.itsType.ordinal()}, ${item.itemId}, '${item.itsName}', ${item.itsPrice}, ${itsQuantity}, ${item.availableQuantity}, ${cartItemItsId})"><span class="oi oi-cart" title="cart" aria-hidden="true"></span>${orderedQuantity}</a>
    </h5>
    <p>${item.specificInList}</p>
  </div>
  <c:if test="${tradingSettings.columnsCount == 1 || (status.index mod 2) != 0}">
    </div>
  </c:if>
</c:forEach>
<c:if test="${tradingSettings.columnsCount != 1 && itemsList.size() mod 2 != 0}">
  </div>
</c:if>

<c:if test="${not empty pages}">
  <nav aria-label="Page navigation">
    <ul class="pagination justify-content-center">
      <c:forEach var="pg" items="${pages}">
        <c:if test="${pg.isCurrent}">
          <li class="page-item active"><a class="page-link" href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId=${catalog.itsId}&page=${pg.value}${filterUrl}">${pg.value}</a></li>
        </c:if>
        <c:if test="${!pg.isCurrent}">
          <li class="page-item"><a class="page-link" href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId=${catalog.itsId}&page=${pg.value}${filterUrl}">${pg.value}</a></li>
        </c:if>
      </c:forEach>
    </ul>
  </nav>
</c:if>

<!-- Modal filter -->
<div class="modal fade" id="filterMdl" tabindex="-1" role="dialog" aria-labelledby="filterMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="filterMdlLabel"><span class="oi oi-sort-ascending" aria-hidden="true"></span> ${param.catalogName}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <form action="servicePublic" method="GET">
          <input type="hidden" name="nmRnd" value="webstore">
          <input type="hidden" name="nmPrc" value="PrcWebstorePage">
          <input type="hidden" name="nmHnd" value="hndPubWebStrTr">
          <input type="hidden" name="catalogId" value="${catalog.itsId}">
          <c:if test="${empty filterCatalog || empty filterCatalog.operator}">
            <c:set var="dispRowFltCat" value=""/>
            <c:set var="disFltCtVal" value="disabled"/>
          </c:if>
          <c:if test="${not empty filterCatalog && not empty filterCatalog.operator}">
            <c:set var="dispRowFltCat" value=" dimmed"/>
            <c:set var="disFltCtVal" value=""/>
          </c:if>
          <div id="rowFltCat" class="row${dispRowFltCat}">
            <div class="col-12 col-md-4 mb-3">
              <label>${srvI18n.getMsg("itsCatalog", reqVars.lang)}:</label>
            </div>
            <div class="col-12 col-md-8 mb-3">
              <input class="form-control" disabled value="${catalog.itsName}">
            </div>
          </div>
          <c:if test="${not empty filterCatalog}">
            <div class="row">
              <div class="col-12 col-md-3 mb-3">
                <label>${srvI18n.getMsg("filterCatalog", reqVars.lang)}:</label>
              </div>
              <div class="col-12 col-md-3 mb-3">
                <select id="fltCtOp" name="fltCtOp" onchange="onCatalogOperChanged(this, 'fltCtVal', 'rowFltCat');" class="form-control">
                  <c:if test="${filterCatalog.operator ne 'NOT_IN'}"> <c:set var="selNotIn" value=""/> </c:if>
                  <c:if test="${filterCatalog.operator eq 'NOT_IN'}"> <c:set var="selNotIn" value="selected"/> </c:if>
                  <c:if test="${filterCatalog.operator ne 'IN'}"> <c:set var="selIn" value=""/> </c:if>
                  <c:if test="${filterCatalog.operator eq 'IN'}"> <c:set var="selIn" value="selected"/> </c:if>
                  <c:if test="${empty selIn && empty selNotIn}"> <c:set var="selNon" value=""/> </c:if>
                  <c:if test="${!(empty selIn && empty selNotIn)}"> <c:set var="selNon" value="selected"/> </c:if>
                  <option value="" ${selNon}>-</option>
                  <option value="IN" ${selIn}>${srvI18n.getMsg("IN", reqVars.lang)}</option>
                  <option value="NOT_IN" ${selNotIn}>${srvI18n.getMsg("NOT_IN", reqVars.lang)}</option>
                </select>
              </div>
              <div class="col-12 col-md-6 mb-3">
                <select multiple id="fltCtVal" ${disFltCtVal} name="fltCtVal" onchange="onCatalogValChanged(this, 'fltCtOp', 'rowFltCat');" class="form-control">
                  <c:forEach var="cata" items="${filterCatalog.itemsAll}">
                    <c:set var="catSel" value=""/>
                    <c:forEach var="catc" items="${filterCatalog.items}">
                      <c:if test="${catc.itsId eq cata.itsId}">
                        <c:set var="catSel" value="selected"/>
                      </c:if>
                    </c:forEach>
                    <option value="${cata.itsId}" ${catSel}>${cata.itsName}</option>
                  </c:forEach>
                </select>
              </div>
            </div>
          </c:if>
          <c:if test="${not empty filterPrice}">
            <c:set var="fltnm" value="wsFilterPrice"/>
            <c:if test="${not empty catalog.filterPriceId}">
              <c:set var="fltnm" value="${fltnm}${catalog.filterPriceId}"/>
            </c:if>
            <jsp:include page="filters/${fltnm}.jsp"/>
          </c:if>
          <c:forEach var="fltSpc" items="${filtersSpecifics}">
            <c:set var="filterSpecifics" value="${fltSpc}" scope="request"/>
            <c:set var="fltnm" value="Specifics${fltSpc.filter.getClass().simpleName}"/>
            <c:if test="${not empty fltSpc.catSpec.filterId}">
              <c:set var="fltnm" value="${fltnm}${fltSpc.catSpec.filterId}"/>
            </c:if>
            <jsp:include page="filters/${fltnm}.jsp"/>
          </c:forEach>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
            <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Apply", reqVars.lang)}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!--Modal I18N preferences-->
<div class="modal fade" id="i18nMdl" tabindex="-1" role="dialog" aria-labelledby="i18nMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="i18nMdlLabel"><span class="oi oi-sort-ascending" aria-hidden="true"></span> ${srvI18n.getMsg("changeLangPreferences", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <form action="servicePublic${filterUrlFrm}" method="GET">
          <input type="hidden" name="nmRnd" value="webstore">
          <input type="hidden" name="nmPrc" value="PrcWebstorePage">
          <input type="hidden" name="nmHnd" value="hndPubWebStrTr">
          <input type="hidden" name="catalogId" value="${catalog.itsId}">
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("lang", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="lang" class="form-control">
                <c:forEach var="it" items="${reqVars.languages}">
                  <c:set var="itmSel" value=""/>
                  <c:if test="${reqVars.lang eq it.itsId}">
                    <c:set var="itmSel" value="selected"/>
                  </c:if>
                  <option value="${it.itsId}" ${itmSel}>${it.itsName}</option>
                </c:forEach>
              </select>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("decimalSep", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="dseparator"  class="form-control">
                <c:forEach var="it" items="${reqVars.decimalSeparators}">
                  <c:set var="itmSel" value=""/>
                  <c:if test="${reqVars.dseparator eq it.itsId}">
                    <c:set var="itmSel" value="selected"/>
                  </c:if>
                  <option value="${it.itsId}" ${itmSel}>${srvI18n.getMsg(it.itsName, reqVars.lang)}</option>
                </c:forEach>
              </select>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("decimalGroupSep", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="dgseparator"  class="form-control">
                <c:forEach var="it" items="${reqVars.decimalGroupSeparators}">
                  <c:set var="itmSel" value=""/>
                  <c:if test="${reqVars.dgseparator eq it.itsId}">
                    <c:set var="itmSel" value="selected"/>
                  </c:if>
                  <option value="${it.itsId}" ${itmSel}>${srvI18n.getMsg(it.itsName, reqVars.lang)}</option>
                </c:forEach>
              </select>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("digitsInGroup", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="digitsInGroup"  class="form-control">
                <c:set var="itmSel" value=""/>
                <c:if test="${reqVars.digitsInGroup == 2}">
                  <c:set var="itmSel" value="selected"/>
                </c:if>
                <option value="2" ${itmSel}>2 ${srvI18n.getMsg("Indian", reqVars.lang)}</option>
                <c:set var="itmSel" value=""/>
                <c:if test="${reqVars.digitsInGroup == 3}">
                  <c:set var="itmSel" value="selected"/>
                </c:if>
                <option value="3" ${itmSel}>3</option>
                <c:set var="itmSel" value=""/>
                <c:if test="${reqVars.digitsInGroup == 4}">
                  <c:set var="itmSel" value="selected"/>
                </c:if>
                <option value="4" ${itmSel}>4</option>
              </select>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
            <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Apply", reqVars.lang)}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Modal subcatalogs -->
<c:forEach var="cat1l" items="${catalogs}">
  <c:forEach var="cat2l" items="${cat1l.subcatalogs}">
    <c:if test="${cat2l.subcatalogs.size() gt 0}">
      <div class="modal fade" id="subcatalogsMdl${cat2l.catalog.itsId}" tabindex="-1" role="dialog" aria-labelledby="subcatalogsMdl${cat2l.catalog.itsId}Label">
        <div class="modal-dialog" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="subcatalogsMdl${cat2l.catalog.itsId}Label">${cat2l.catalog.itsName}</h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
              <h5><a href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId=${cat2l.catalog.itsId}">${cat2l.catalog.itsName}</a></h5>
              <ul><c:forEach var="cat3l" items="${cat2l.subcatalogs}">
                <li><a href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId=${cat3l.catalog.itsId}">${cat3l.catalog.itsName}</a>
                <c:if test="${cat3l.subcatalogs.size() gt 0}">
                  <ul><c:forEach var="cat4l" items="${cat3l.subcatalogs}">
                    <li><a href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId=${cat4l.catalog.itsId}">${cat4l.catalog.itsName}</a>
                      <c:if test="${cat4l.subcatalogs.size() gt 0}">
                        <ul><c:forEach var="cat5l" items="${cat4l.subcatalogs}">
                          <li><a href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId=${cat5l.catalog.itsId}">${cat5l.catalog.itsName}</a>
                            <c:if test="${cat5l.subcatalogs.size() gt 0}">
                              <ul><c:forEach var="cat6l" items="${cat5l.subcatalogs}">
                                <li><a href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId=${cat6l.catalog.itsId}">${cat6l.catalog.itsName}</a></li>
                              </c:forEach></ul>
                            </c:if>
                          </li>
                        </c:forEach></ul>
                      </c:if>
                    </li>
                  </c:forEach></ul>
                </c:if></li>
              </c:forEach></ul>
            </div>
          </div>
        </div>
      </div>
    </c:if>
  </c:forEach>
</c:forEach>

<jsp:include page="webstoreCart.jsp"/>

<jsp:include page="webstoreEnd.jsp"/>
