<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<!-- Modal cart item adder -->
<div class="modal fade" id="cartAddMdl" tabindex="-1" role="dialog" aria-labelledby="cartAddMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="cartAddMdlLabel"><span class="oi oi-cart" aria-hidden="true"></span>${srvI18n.getMsg("add_item_to_cart", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <form action="servicePublic${filterUrlFrm}" method="POST">
          <input type="hidden" name="nmRnd" value="${param.nmRnd}">
          <input type="hidden" name="nmPrcRedirect" value="${param.nmPrc}">
          <input type="hidden" name="nmHnd" value="hndPubWebStrTr">
          <input type="hidden" name="nmPrc" value="PrcItemInCart">
          <input type="hidden" name="catalogId" value="${catalog.itsId}">
          <div class="form-group">
            <label>${srvI18n.getMsg("item", reqVars.lang)}:</label>
            <textarea id="cartItemName" readonly class="form-control">
            </textarea>
            <label>${srvI18n.getMsg("itsPrice", reqVars.lang)}:</label>
            <input id="cartItemPrice" readonly class="form-control">
            <label>${srvI18n.getMsg("itsQuantity", reqVars.lang)}:</label>
            <input type="number" step="1" min="1" id="cartItemQuantity" name="cartItemQuantity" class="form-control" onchange="refreshCartItemTotal('');">
            <label>${srvI18n.getMsg("itsTotal", reqVars.lang)}:</label>
            <input id="cartItemTotal" readonly class="form-control">
            <input type="hidden" id="cartItemAvailableQuantity" name="cartItemAvailableQuantity">
            <input type="hidden" id="cartItemType" name="cartItemType">
            <input type="hidden" id="cartItemId" name="cartItemId">
          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Save", reqVars.lang)}</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Modal cart item edit -->
<div class="modal fade" id="cartEditMdl" tabindex="-1" role="dialog" aria-labelledby="cartEditMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="cartEditMdlLabel"><span class="oi oi-cart" aria-hidden="true"></span>${srvI18n.getMsg("item_change_quantity", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" onclick="$('#cartMdl').modal('show');" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <form action="servicePublic${filterUrlFrm}" method="POST">
          <input type="hidden" name="nmRnd" value="${param.nmRnd}">
          <input type="hidden" name="nmPrcRedirect" value="${param.nmPrc}">
          <input type="hidden" name="nmHnd" value="hndPubWebStrTr">
          <input type="hidden" name="nmPrc" value="PrcItemInCart">
          <input type="hidden" name="catalogId" value="${catalog.itsId}">
          <div class="form-group">
            <label>${srvI18n.getMsg("item", reqVars.lang)}:</label>
            <textarea id="cartItemNameEdit" readonly class="form-control">
            </textarea>
            <label>Price:</label>
            <input id="cartItemPriceEdit" readonly class="form-control">
            <label>${srvI18n.getMsg("itsQuantity", reqVars.lang)}:</label>
            <input type="number" step="1" min="1" id="cartItemQuantityEdit" name="cartItemQuantity" class="form-control" onchange="refreshCartItemTotal('Edit');">
            <label>${srvI18n.getMsg("itsTotal", reqVars.lang)}:</label>
            <input id="cartItemTotalEdit" readonly class="form-control">
            <input type="hidden" id="cartItemAvailableQuantityEdit" name="cartItemAvailableQuantity">
            <input type="hidden" id="cartItemTypeEdit" name="cartItemType">
            <input type="hidden" id="cartItemIdEdit" name="cartItemId">
            <input type="hidden" id="cartItemItsIdEdit" name="cartItemItsId">
          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Save", reqVars.lang)}</button>
            <button type="button" class="btn btn-default" data-dismiss="modal" onclick="$('#cartMdl').modal('show');">${srvI18n.getMsg("Close", reqVars.lang)}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Modal cart item remove -->
<div class="modal fade" id="cartDelMdl" tabindex="-1" role="dialog" aria-labelledby="cartDelMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="cartDelMdlLabel"><span class="oi oi-cart" aria-hidden="true"></span>${srvI18n.getMsg("item_remove", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" onclick="$('#cartMdl').modal('show');" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <form action="servicePublic${filterUrlFrm}" method="POST">
          <input type="hidden" name="nmRnd" value="${param.nmRnd}">
          <input type="hidden" name="nmPrcRedirect" value="${param.nmPrc}">
          <input type="hidden" name="nmHnd" value="hndPubWebStrTr">
          <input type="hidden" name="nmPrc" value="PrcDelItemFromCart">
          <input type="hidden" name="catalogId" value="${catalog.itsId}">
          <div class="form-group">
            <label>${srvI18n.getMsg("item", reqVars.lang)}:</label>
            <textarea id="cartItemNameDel" readonly class="form-control">
            </textarea>
            <label>Price:</label>
            <input id="cartItemPriceDel" readonly class="form-control">
            <label>${srvI18n.getMsg("itsQuantity", reqVars.lang)}:</label>
            <input readonly id="cartItemQuantityDel" class="form-control">
            <label>${srvI18n.getMsg("itsTotal", reqVars.lang)}:</label>
            <input id="cartItemTotalDel" readonly class="form-control">
            <input type="hidden" id="cartItemItsIdDel" name="cartItemItsId">
          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Delete", reqVars.lang)}</button>
            <button type="button" class="btn btn-default" data-dismiss="modal" onclick="$('#cartMdl').modal('show');">${srvI18n.getMsg("Close", reqVars.lang)}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Modal cart -->
<div class="modal fade" id="cartMdl" tabindex="-1" role="dialog" aria-labelledby="cartMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="cartMdlLabel"><span class="oi oi-cart" aria-hidden="true"></span>${srvI18n.getMsg("shopping_cart", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <c:forEach var="cartItem" items="${shoppingCart.itsItems}">
          <c:if test="${!cartItem.isDisabled}">
            <div class="row">
              <div class="col-4">
                <b>${srvI18n.getMsg("item", reqVars.lang)}:</b>
              </div>
              <div class="col-8">
                <b>${cartItem.itsName}</b>
              </div>
            </div>
            <div class="row">
              <div class="col-4">
                Price:
              </div>
              <div class="col-8">
                ${cartItem.itsPrice}
              </div>
            </div>
            <div class="row">
              <div class="col-4">
                ${srvI18n.getMsg("itsQuantity", reqVars.lang)}:
              </div>
              <div class="col-4">
                ${cartItem.itsQuantity}
              </div>
              <div class="col-2">
                <a href="#" data-dismiss="modal" onclick="setCartItem(${cartItem.itemType.ordinal()}, ${cartItem.itemId}, '${cartItem.itsName}', ${cartItem.itsPrice}, ${cartItem.itsQuantity}, ${cartMap[cartItem.itemType][cartItem.itemId].availableQuantity}, ${cartItem.itsId});"><span class="oi oi-pencil" title="${srvI18n.getMsg('edit', reqVars.lang)}" aria-hidden="true"></span></a>
              </div>
              <div class="col-2">
                <a href="#" data-dismiss="modal" onclick="$('#cartDelMdl').modal({keyboard: false, backdrop: false}); delCartItem(${cartItem.itemType.ordinal()}, ${cartItem.itemId}, '${cartItem.itsName}', ${cartItem.itsPrice}, ${cartItem.itsQuantity}, ${cartItem.itsId});"><span class="oi oi-x" title="${srvI18n.getMsg('delete', reqVars.lang)}" aria-hidden="true"></span></a>
              </div>
            </div>
            <div class="row">
              <div class="col-4">
                ${srvI18n.getMsg("itsTotal", reqVars.lang)}:
              </div>
              <div class="col-8">
                ${cartItem.itsTotal}
              </div>
            </div>
          </c:if>
        </c:forEach>
        <div class="row">
          <div class="col-6">
            <b>${srvI18n.getMsg("totalItems", reqVars.lang)}:</b>
          </div>
          <div class="col-6">
            <b>${shoppingCart.totalItems}</b>
          </div>
        </div>
        <div class="row">
          <div class="col-6">
            <b>${srvI18n.getMsg("itsTotal", reqVars.lang)}:</b>
          </div>
          <div class="col-6">
            <b>${shoppingCart.itsTotal}</b>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
        <a href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcCartCheckOut" type="button" class="btn btn-primary">${srvI18n.getMsg("check_out", reqVars.lang)}</a>
      </div>
    </div>
  </div>
</div>
