<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<jsp:include page="webstoreStart.jsp"/>

<div class="py-3 bg-light first-cont">
  <div class="row">
    <c:if test="${not empty gsMainImage}">
      <div class="col-12 col-md-6 col-lg-4">
        <img class="img-fluid" src="${gsMainImage.stringValue1}">
      </div>
    </c:if>
    <c:if test="${not empty gsMainImage}">
      <div class="col-12 col-md-6 col-lg-8">
    </c:if>
    <c:if test="${empty gsMainImage}">
      <div class="col-12">
    </c:if>
      <h5>
        <c:if test="${not empty goodsPrice}">
          <b><span class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}">${goodsPrice.itsPrice}</span> ${accSettings.currency.itsName}</b>
        </c:if>
        ${gsList.get(0).goods.itsName}
      </h5>
      <p>
        <c:forEach var="gs" items="${gsList}">
          <c:if test="${gs.specifics.isShowInList}">
            <c:if test="${gs.specifics.itsType eq 'TEXT'}">
              <b>${gs.specifics.itsName}: </b>
              ${gs.stringValue1}
            </c:if>
            <c:if test="${gs.specifics.itsType eq 'BIGDECIMAL'}">
              <b>${gs.specifics.itsName}: </b>
              ${gs.numericValue1}
              <c:if test="${not empty gs.stringValue1}">
                ${gs.stringValue1}
              </c:if>
            </c:if>
            <c:if test="${gs.specifics.itsType eq 'INTEGER'}">
              <b>${gs.specifics.itsName}: </b>
              ${gs.longValue1}
              <c:if test="${not empty gs.stringValue1}">
                ${gs.stringValue1}
              </c:if>
            </c:if>
            <c:if test="${not empty gs.specifics.chooseableSpecificsType}">
              <b>${gs.stringValue2}: </b>
              ${gs.stringValue1}
            </c:if>
          </c:if>
        </c:forEach>
      </p>
    </div>
  </div>
</div>

<div class="py-1 text-center bg-light">
  <c:if test="${empty cartItem && not empty goodsPrice}">
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#cartAddMdl" onclick="setCartItem(0, ${goodsPrice.goods.itsId}, ${goodsPrice.goods.itsName}, ${goodsPrice.itsPrice}, 1)">Buy it</button>
  </c:if>
  <c:if test="${not empty cartItem}">
    <button type="button" class="btn btn-primary" onclick="$('#cartMdl').modal('toggle');">${srvI18n.getMsg("open_cart", reqVars.lang)} <span class="badge badge-secondary">${shoppingCart.totalItems}</span></button>
  </c:if>
</div>

<div class="py-3 bg-light">
  <div class="text-center text-muted">
    <h4>${srvI18n.getMsg("item_specifics", reqVars.lang)}</h4>
  </div>
  <div class="specifics">
    <div class="row">
      <c:forEach var="gs" items="${gsList}">
        <c:if test="${gs.specifics.itsType eq 'TEXT'}">
          <div class="col-12 col-md-5">
            <b>${gs.specifics.itsName}: </b>
          </div>
          <div class="col-12 col-md-7">
            ${gs.stringValue1}
          </div>
        </c:if>
        <c:if test="${gs.specifics.itsType eq 'BIGDECIMAL'}">
          <div class="col-12 col-md-5">
            <b>${gs.specifics.itsName}: </b>
          </div>
          <div class="col-12 col-md-7">
            ${gs.numericValue1}
            <c:if test="${not empty gs.stringValue1}">
              ${gs.stringValue1}
            </c:if>
          </div>
        </c:if>
        <c:if test="${gs.specifics.itsType eq 'INTEGER'}">
          <div class="col-12 col-md-5">
            <b>${gs.specifics.itsName}: </b>
          </div>
          <div class="col-12 col-md-7">
            ${gs.longValue1}
            <c:if test="${not empty gs.stringValue1}">
              ${gs.stringValue1}
            </c:if>
          </div>
        </c:if>
        <c:if test="${not empty gs.specifics.chooseableSpecificsType}">
          <div class="col-12 col-md-5">
            <b>${gs.stringValue2}: </b>
          </div>
          <div class="col-12 col-md-7">
            ${gs.stringValue1}
          </div>
        </c:if>
      </c:forEach>
    </div>
  </div>
</div>

<c:forEach var="gs" items="${gsList}">
  <c:if test="${gs.specifics.itsType eq 'FILE_EMBEDDED' && gs.stringValue1.endsWith('html')}">
    <c:set var="embhtmlnm" value="${utlJsp.evalFileNameWithoutExtension(gs.stringValue1)}"/>
    <div id="${embhtmlnm}" class="py-3 bg-light embed-html">
    </div>
    <script> $( "#${embhtmlnm}" ).load( "${gs.stringValue1} #container" ); </script>
  </c:if>
</c:forEach>

<c:set var="currGroup" value=""/>
<c:forEach var="gs" items="${gsList}">
  <c:if test="${gs.specifics.itsType eq 'IMAGE_IN_SET' && not empty gs.specifics.itsGroop}">
    <c:if test="${empty currGroup || gs.specifics.itsGroop.itsId ne currGroup.itsId}">
      <c:if test="${not empty currGroup}">
          </div>
        </div>
      </c:if>
      <c:set var="currGroup" value="${gs.specifics.itsGroop}"/>
      <div class="album py-3 bg-light">
      <c:if test="${not empty gs.stringValue4}">
        <div class="text-center text-muted">
          <h4>${gs.stringValue4}</h4>
        </div>
      </c:if>
      <div class="row">
    </c:if>
    <div class="col-12 col-md-6 col-lg-4">
      <div class="card mb-4 box-shadow">
        <img class="card-img-top" src="${gs.stringValue1}" alt="Card image cap">
        <c:if test="${not empty gs.stringValue3}">
          <div class="card-body">
            <p class="card-text">${gs.stringValue3}</p>
          </div>
        </c:if>
      </div>
    </div>
  </c:if>
  <c:if test="${gs.specifics.itsType ne 'IMAGE_IN_SET' || empty gs.specifics.itsGroop}">
    <c:if test="${not empty currGroup}">
        </div>
      </div>
    </c:if>
    <c:set var="currGroup" value=""/>
  </c:if>
</c:forEach>
<c:if test="${not empty currGroup}">
    </div>
  </div>
  <c:set var="currGroup" value=""/>
</c:if>

<c:forEach var="gs" items="${gsList}">
  <c:if test="${gs.specifics.itsType eq 'FILE' && not empty gs.specifics.itsGroop}">
    <c:if test="${empty currGroup || gs.specifics.itsGroop.itsId ne currGroup.itsId}">
      <c:if test="${not empty currGroup}">
        </div>
      </c:if>
      <c:set var="currGroup" value="${gs.specifics.itsGroop}"/>
      <div class="py-3 bg-light text-center text-muted">
      <c:if test="${not empty gs.stringValue4}">
        <h4>${gs.stringValue4}</h4>
      </c:if>
    </c:if>
    <h6><a href="${gs.stringValue1}">${gs.stringValue3}</a></h6>
  </c:if>
  <c:if test="${gs.specifics.itsType ne 'FILE' || empty gs.specifics.itsGroop}">
    <c:if test="${not empty currGroup}">
      </div>
    </c:if>
    <c:set var="currGroup" value=""/>
  </c:if>
</c:forEach>
<c:if test="${not empty currGroup}">
  </div>
  <c:set var="currGroup" value=""/>
</c:if>

<jsp:include page="webstoreCart.jsp"/>

<jsp:include page="webstoreEnd.jsp"/>
