<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setLocale value="${reqVars.localeCurrent}" scope="request"/>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <link rel="stylesheet" type="text/css" media="print" href="../../static/css/beige.print-a4.css" />
  <link rel="stylesheet" type="text/css" href="../../static/css/beige.reports.css" />
  <link rel="icon" type="image/png" href="../../static/img/favicon.png">
  <title>${srvI18n.getMsg("chartOfAccounts", reqVars.lang)}</title>
</head>
<body>
  <div style="text-align: center;">
    <h4>
      ${srvI18n.getMsg("chartOfAccounts", reqVars.lang)} <br></br>
      ${reqVars.accSettings.organization}
    </h4>
  </div>
  <table>
    <tr>
      <th>${srvI18n.getMsg("itsId", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("itsNumber", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("itsName", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("subaccount", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("normalBalanceType", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("itsType", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("description", reqVars.lang)}</th>
    </tr>
    <c:forEach var="account" items="${accounts}">
      <tr>
        <td>
          ${account.itsId}
        </td>
        <td>
          ${account.itsNumber}
        </td>
        <td>
          ${account.itsName}
        </td>
        <td>
          ${account.subacc}
        </td>
        <td>
          <c:if test="${not empty account.normalBalanceType}">
            ${srvI18n.getMsg(account.normalBalanceType, reqVars.lang)}
          </c:if>
        </td>
        <td>
          <c:if test="${not empty account.itsType}">
            ${srvI18n.getMsg(account.itsType, reqVars.lang)}
          </c:if>
        </td>
        <td>
          ${account.description}
        </td>
      </tr>
    </c:forEach>
  </table>
</body>
</html>
