<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="shortcut icon" href="static/img/favicon.png">
  <link rel="stylesheet" href="static/css/beige.common.css" />
  <title>Beigesoft™ Accounting All In One</title>
</head>
<body>

<div class="navbar">
  <div class="dropdown">
    <a href="#" class="dropdown-btn">${srvI18n.getMsg("Appearance", reqVars.lang)}</a>
    <div class="dropdown-content">
      <a href="secure/jspd?nmRnd=main">${srvI18n.getMsg("Standard", reqVars.lang)}</a>
      <a href="secure/jspd?nmRnd=mainMobile">${srvI18n.getMsg("Mobile", reqVars.lang)}</a>
      <a href="privacypolicy-${reqVars.lang}.html" target="_blank">${srvI18n.getMsg("privacy_policy", reqVars.lang)}</a>
    </div>
  </div>
  <div class="dropdown">
    <a href="#" class="dropdown-btn">${srvI18n.getMsg("Admin", reqVars.lang)}</a>
    <div class="dropdown-content">
      <a href="secure/jspd?nmRnd=getDatabaseCopyForm">${srvI18n.getMsg("ImportDatabase", reqVars.lang)}</a>
      <a href="secure/jspd?nmRnd=webStoreAdmin">${srvI18n.getMsg("WEBStoreAdmin", reqVars.lang)}</a>
      <a href="seseller/service">${srvI18n.getMsg("SeSeller", reqVars.lang)}</a>
      <c:if test="${pageContext.servletContext.getInitParameter('webAppFor') eq 'AJetty' || pageContext.servletContext.getInitParameter('webAppFor') eq 'Android'}">
        <a href="mngDatabase/?nmRnd=mngDatabaseExt">${srvI18n.getMsg("Databases", reqVars.lang)}</a>
      </c:if>
      <a href="mngSoftware/?nmRnd=mngSoftware">${srvI18n.getMsg("SoftwareManagement", reqVars.lang)}</a>
      <a href="servicePublic?nmHnd=hndPubWebStrTr&nmRnd=webstore&nmPrc=PrcWebstorePage" target="_blank">${srvI18n.getMsg("Webstore", reqVars.lang)}</a>
    </div>
  </div>
  <div class="nav-right">
    <a href="https://sites.google.com/site/beigesoftware" target="_blank">Beigesoft ™</a>
  </div>
</div>  

</body>
</html>
