<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:if test="${isTaxable && isItemBasis && isAggrOnlyRate}">
  <c:set var="calcTotalFnNm" value="calculateTotalAndTaxForPrice"/>
  <c:set var="calcPriceFnNm" value="calculatePriceTax"/>
  <c:set var="taxIncludedPar" value=",${entity.itsOwner.priceIncTax}"/>
</c:if>
<c:if test="${!(isTaxable && isItemBasis && isAggrOnlyRate)}">
  <c:set var="calcTotalFnNm" value="calculateTotalForPrice"/>
  <c:set var="calcPriceFnNm" value="calculatePrice"/>
  <c:set var="taxIncludedPar" value=""/>
</c:if>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsPrice">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignPrice", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("itsPrice", reqVars.lang)}
      </c:if>
      <c:if test="${isTaxable && entity.itsOwner.priceIncTax}">
        ${srvI18n.getMsg("include_taxes", reqVars.lang)}
      </c:if>
      <c:if test="${isTaxable && !entity.itsOwner.priceIncTax}">
        ${srvI18n.getMsg("without_taxes", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" required id="${entity.getClass().simpleName}itsPrice" name="${entity.getClass().simpleName}.foreignPrice" value="${entity.foreignPrice}" onchange="inputHasBeenChanged(this); ${calcTotalFnNm}('${entity.getClass().simpleName}', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" required id="${entity.getClass().simpleName}itsPrice" name="${entity.getClass().simpleName}.itsPrice" value="${entity.itsPrice}" onchange="inputHasBeenChanged(this); ${calcTotalFnNm}('${entity.getClass().simpleName}', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
      </c:if>
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsQuantity">${srvI18n.getMsg("itsQuantity", reqVars.lang)}</label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class="autoNum${reqVars.quantityPrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" required id="${entity.getClass().simpleName}itsQuantity" name="${entity.getClass().simpleName}.itsQuantity" value="${entity.itsQuantity}" onchange="inputHasBeenChanged(this); ${calcTotalFnNm}('${entity.getClass().simpleName}', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
    </div>
  </td>
</tr>
<c:if test="${!isTaxable || entity.itsOwner.priceIncTax}">
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsTotal">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignTotal", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("itsTotal", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.foreignTotal" value="${entity.foreignTotal}" onchange="inputHasBeenChanged(this); ${calcPriceFnNm}('${entity.getClass().simpleName}', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.itsTotal" value="${entity.itsTotal}" onchange="inputHasBeenChanged(this); ${calcPriceFnNm}('${entity.getClass().simpleName}', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
      </c:if>
    </div>
  </td>
</tr>
</c:if>
<c:if test="${!(!isTaxable || entity.itsOwner.priceIncTax)}">
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsTotal">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignSubtotal", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("subtotal", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.foreignSubtotal" value="${entity.foreignSubtotal}" onchange="inputHasBeenChanged(this); ${calcPriceFnNm}('${entity.getClass().simpleName}', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.subtotal" value="${entity.subtotal}" onchange="inputHasBeenChanged(this); ${calcPriceFnNm}('${entity.getClass().simpleName}', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
      </c:if>
    </div>
  </td>
</tr>
</c:if>
<c:if test="${isTaxable}">
  <tr>
    <td>
      <label>
         ${srvI18n.getMsg("taxCategory", reqVars.lang)}
        <c:if test="${empty entity.taxCategory && not empty entity.itsOwner.customer.taxDestination}">
          <button type="button" id="${entity.getClass().simpleName}btnTaxDestination" class="btn" onclick="if (document.getElementById('${invoiceLnItemId}').value != '') { getHtmlByAjax('GET', 'service/?nmHnd=srhAccSecure&nmPrc=PrcRevealTaxCat&nmRnd=revealTaxCatJson&nmEnt=${entity.getClass().simpleName}&taxDestId=${entity.itsOwner.customer.taxDestination.itsId}&itemId=' + document.getElementById('${invoiceLnItemId}').value + '');}">${srvI18n.getMsg("reveal", reqVars.lang)}</button>
        </c:if>
      </label>
    </td>
    <td>
      <div class="input-line">
        <input type="text" disabled id="${entity.getClass().simpleName}taxCategory" value="${entity.taxCategory.itsName}" onchange="inputHasBeenChanged(this);"/> 
      </div>
    </td>
  </tr>
  <c:if test="${isItemBasis && isAggrOnlyRate}">
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("itsPercentage", reqVars.lang)}
        </label>
      </td>
      <td>
        <div class="input-line">
          <c:set var="aggrOnlyPercent" value="0.0"/>
          <c:if test="${not empty entity.taxCategory}">
            <c:set var="aggrOnlyPercent" value="${entity.taxCategory.aggrOnlyPercent}"/>
          </c:if>
          <input type="text" disabled id="${entity.getClass().simpleName}itsPercentage" value="${aggrOnlyPercent}" class="autoNumSalTax" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" onchange="inputHasBeenChanged(this);calcTaxOchRate('${entity.getClass().simpleName}', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("totalTaxes", reqVars.lang)}
        </label>
      </td>
      <td>
        <div class="input-line">
          <input type="text" disabled id="${entity.getClass().simpleName}totalTaxes" class="autoNumSalTaxTot" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" value="${entity.totalTaxes}" onchange="inputHasBeenChanged(this);"/> 
        </div>
      </td>
    </tr>      
  </c:if>
</c:if>
