<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:set var="isTaxable" value="${reqVars.accSettings.isExtractSalesTaxFromSales && !entity.itsOwner.omitTaxes && !entity.itsOwner.customer.isForeigner}" scope="request"/>
<c:set var="isItemBasis" value="${!reqVars.accSettings.salTaxIsInvoiceBase}" scope="request"/>
<c:set var="isAggrOnlyRate" value="${reqVars.accSettings.salTaxUseAggregItBas}" scope="request"/>
<c:if test="${entity.itsOwner.customer.taxDestination != null}">
  <c:set var="isItemBasis" value="${!entity.itsOwner.customer.taxDestination.salTaxIsInvoiceBase}" scope="request"/>
  <c:set var="isAggrOnlyRate" value="${entity.itsOwner.customer.taxDestination.salTaxUseAggregItBas}" scope="request"/>
</c:if>
<tr>
  <td>
    <label for="SalesReturnLine.invItemAppearanceVisible">${srvI18n.getMsg('invItem', reqVars.lang)}</label>
  </td>
  <td>
    <c:set var="invoiceLnItemId" value="SalesReturnLineinvItemId" scope="request"/>
    <div class="input-line">
      <input class="picked-appearence" id="SalesReturnLineinvItemAppearanceVisible" disabled="disabled" type="text" value="${entity.invItem.itsName}" onchange="inputHasBeenChanged(this);">
      <input id="SalesReturnLineinvItemId" required type="hidden" name="SalesReturnLine.invItem" value="${entity.invItem.itsId}">
      <c:if test="${isTaxable && isItemBasis}">
        <button type="button" autofocus class="btn" onclick="openEntityPicker('InvItem','SalesReturnLine', 'invItem','&nmHnd=${param.nmHnd}&wdgPick=pickItemUomTax&mobile=${param.mobile}');">...</button>
      </c:if>
      <c:if test="${!(isTaxable && isItemBasis)}">
        <button type="button" autofocus class="btn" onclick="openEntityPicker('InvItem','SalesReturnLine', 'invItem','&nmHnd=${param.nmHnd}&mobile=${param.mobile}');">...</button>
      </c:if>
      <button type="button" class="btn" onclick="clearSelectedEntity('SalesReturnLineinvItem');">X</button>
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="SalesReturnLine.unitOfMeasureAppearanceVisible">${srvI18n.getMsg('unitOfMeasure', reqVars.lang)}</label>
  </td>
  <td>
    <div class="input-line">
      <input class="picked-appearence" id="SalesReturnLineunitOfMeasureAppearanceVisible" disabled="disabled" type="text" value="${entity.unitOfMeasure.itsName}" onchange="inputHasBeenChanged(this);">
      <input id="SalesReturnLineunitOfMeasureId" required type="hidden" name="SalesReturnLine.unitOfMeasure" value="${entity.unitOfMeasure.itsId}">
      <button type="button" class="btn" onclick="openEntityPicker('UnitOfMeasure','SalesReturnLine', 'unitOfMeasure','&nmHnd=${param.nmHnd}&mobile=${param.mobile}');">...</button>
      <button type="button" class="btn" onclick="clearSelectedEntity('SalesReturnLineunitOfMeasure');">X</button>
    </div>
  </td>
</tr>
<c:if test="${isTaxable && isItemBasis && isAggrOnlyRate}">
  <c:set var="calcTotalFnNm" value="calculateTotalAndTaxForPrice"/>
  <c:set var="calcPriceFnNm" value="calculatePriceTax"/>
  <c:set var="taxIncludedPar" value=",false"/>
</c:if>
<c:if test="${!(isTaxable && isItemBasis && isAggrOnlyRate)}">
  <c:set var="calcTotalFnNm" value="calculateTotalForPrice"/>
  <c:set var="calcPriceFnNm" value="calculatePrice"/>
  <c:set var="taxIncludedPar" value=""/>
</c:if>
<tr>
  <td>
    <label for="SalesReturnLine.itsCost">
      ${srvI18n.getMsg("itsCost", reqVars.lang)}
      <c:if test="${isTaxable}">
        ${srvI18n.getMsg("without_taxes", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class="autoNum${reqVars.costPrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" required id="SalesReturnLineitsCost" name="SalesReturnLine.itsCost" value="${entity.itsCost}" onchange="inputHasBeenChanged(this);"/> 
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="SalesReturnLine.itsPrice">
      ${srvI18n.getMsg("itsPrice", reqVars.lang)}
      <c:if test="${isTaxable}">
        ${srvI18n.getMsg("without_taxes", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" required id="SalesReturnLineitsPrice" name="SalesReturnLine.itsPrice" value="${entity.itsPrice}" onchange="inputHasBeenChanged(this); ${calcTotalFnNm}('SalesReturnLine', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="SalesReturnLine.itsQuantity">${srvI18n.getMsg("itsQuantity", reqVars.lang)}</label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class="autoNum${reqVars.quantityPrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" required id="SalesReturnLineitsQuantity" name="SalesReturnLine.itsQuantity" value="${entity.itsQuantity}" onchange="inputHasBeenChanged(this); ${calcTotalFnNm}('SalesReturnLine', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="SalesReturnLine.itsTotal">
      ${srvI18n.getMsg("subtotal", reqVars.lang)}
    </label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" id="SalesReturnLineitsTotal" name="SalesReturnLine.subtotal" value="${entity.subtotal}" onchange="inputHasBeenChanged(this); ${calcPriceFnNm}('SalesReturnLine', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
    </div>
  </td>
</tr>
<c:if test="${isTaxable}">
  <tr>
    <td>
      <label>
         ${srvI18n.getMsg("taxCategory", reqVars.lang)}
        <c:if test="${empty entity.taxCategory && not empty entity.itsOwner.customer.taxDestination}">
          <button type="button" id="SalesReturnLinebtnTaxDestination" class="btn" onclick="if (document.getElementById('${invoiceLnItemId}').value != '') { getHtmlByAjax('GET', 'service/?nmHnd=srhAccSecure&nmPrc=PrcRevealTaxCat&nmRnd=revealTaxCatJson&nmEnt=SalesReturnLine&taxDestId=${entity.itsOwner.customer.taxDestination.itsId}&itemId=' + document.getElementById('${invoiceLnItemId}').value + '');}">${srvI18n.getMsg("reveal", reqVars.lang)}</button>
        </c:if>
      </label>
    </td>
    <td>
      <div class="input-line">
        <input type="text" disabled id="SalesReturnLinetaxCategory" value="${entity.taxCategory.itsName}" onchange="inputHasBeenChanged(this);"/> 
      </div>
    </td>
  </tr>
  <c:if test="${isItemBasis && isAggrOnlyRate}">
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("itsPercentage", reqVars.lang)}
        </label>
      </td>
      <td>
        <div class="input-line">
          <c:set var="aggrOnlyPercent" value="0.0"/>
          <c:if test="${not empty entity.taxCategory}">
            <c:set var="aggrOnlyPercent" value="${entity.taxCategory.aggrOnlyPercent}"/>
          </c:if>
          <input type="text" disabled id="SalesReturnLineitsPercentage" value="${aggrOnlyPercent}" class="autoNumSalTax" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" onchange="inputHasBeenChanged(this);calcTaxOchRate('SalesReturnLine', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("totalTaxes", reqVars.lang)}
        </label>
      </td>
      <td>
        <div class="input-line">
          <input type="text" required id="SalesReturnLinetotalTaxes" name="SalesReturnLine.totalTaxes" class="autoNumSalTaxTot" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" value="${entity.totalTaxes}" onchange="inputHasBeenChanged(this);"/> 
        </div>
      </td>
    </tr> 
  </c:if>
</c:if>
