<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<c:set var="isTaxable" value="${reqVars.accSettings.isExtractSalesTaxFromSales && !entity.omitTaxes && (entity.customer == null || entity.customer != null && !entity.customer.isForeigner)}" scope="request"/>
<c:set var="isItemBasis" value="${!reqVars.accSettings.salTaxIsInvoiceBase}" scope="request"/>
<c:set var="isAggrOnlyRate" value="${reqVars.accSettings.salTaxUseAggregItBas}" scope="request"/>
<c:if test="${reqVars.accSettings.isExtractSalesTaxFromSales && (entity.customer == null || entity.customer != null && !entity.customer.isForeigner)}">
  <c:if test="${entity.customer != null && entity.customer.taxDestination != null}">
    <c:set var="taxDestination" value="${entity.customer.taxDestination}" scope="request"/>
    <c:set var="isItemBasis" value="${!entity.customer.taxDestination.salTaxIsInvoiceBase}" scope="request"/>
    <c:set var="isAggrOnlyRate" value="${entity.customer.taxDestination.salTaxUseAggregItBas}" scope="request"/>
  </c:if>
  <c:if test="${entity.itsTotal.doubleValue() == 0}">
    <tr>
      <td>
        <label>${srvI18n.getMsg("omitTaxes", reqVars.lang)}</label>
      </td>
      <td>
        <div class="input-line">
          <select name="${entity.getClass().simpleName}.omitTaxes" onchange="inputHasBeenChanged(this);">
            <c:set var="selTrue" value=""/>
            <c:if test="${entity.omitTaxes}"> <c:set var="selTrue" value="selected"/> </c:if>
            <option value="true" ${selTrue}>${srvI18n.getMsg("Yes", reqVars.lang)}</option>
            <c:set var="selF" value=""/>
            <c:if test="${!entity.omitTaxes}"> <c:set var="selF" value="selected"/> </c:if>
            <option value="false" ${selF}>${srvI18n.getMsg("No", reqVars.lang)}</option>
          </select>
        </div>
      </td>
    </tr>
  </c:if>
  <c:if test="${entity.itsTotal.doubleValue() != 0}">
    <tr>
      <td>
        <label>${srvI18n.getMsg("omitTaxes", reqVars.lang)}
        </label>
      </td>
      <td>
        <div class="input-line">
          <input disabled value="${srvI18n.getMsg(entity.omitTaxes, reqVars.lang)}"/> 
          <input type="hidden" name="${entity.getClass().simpleName}.omitTaxes" value="${entity.omitTaxes}"/> 
        </div>
      </td>
    </tr>
  </c:if>
</c:if>
